
CREATE OR REPLACE FUNCTION fcat(text) returns integer as $$
    DECLARE
        key ALIAS FOR $1;
        cat record;
        re  text;
    BEGIN
        FOR cat IN SELECT * from fcat_typ LOOP
            IF key ~ cat.re THEN
                RETURN cat.id;
            END IF;
        END LOOP;
        RETURN Null;
    END;
$$  language 'plpgsql';






CREATE OR REPLACE FUNCTION null2interval(interval) returns interval as $$
    DECLARE
    BEGIN
        IF $1 IS NULL THEN
            RETURN INTERVAL '0';
        ELSE
            RETURN $1;
        END IF;
    END;
$$  language 'plpgsql';


CREATE OR REPLACE FUNCTION null2int(bigint) returns bigint as $$
    DECLARE
    BEGIN
        IF $1 IS NULL THEN
            RETURN 0;
        ELSE
            RETURN $1;
        END IF;
    END;
$$  language 'plpgsql';




CREATE OR REPLACE FUNCTION daysf(interval) returns double precision as $$
    DECLARE
    BEGIN
        RETURN (EXTRACT(years from $1) * 365.25 + EXTRACT(days from $1)) + (EXTRACT(hours from $1) + EXTRACT(minutes from $1) / 60 + EXTRACT(seconds from $1) / 3600) / 24 ;
    END;
$$  language 'plpgsql';

CREATE OR REPLACE FUNCTION days(interval) returns integer as $$
    DECLARE
    BEGIN
        RETURN round(daysf($1));
    END;
$$  language 'plpgsql';


CREATE OR REPLACE FUNCTION hours(interval) returns integer as $$
    DECLARE
    BEGIN
        RETURN round(daysf($1) * 24);
    END;
$$  language 'plpgsql';

CREATE OR REPLACE FUNCTION hoursf(interval) returns double precision as $$
    DECLARE
    BEGIN
        RETURN daysf($1) * 24;
    END;
$$  language 'plpgsql';


CREATE OR REPLACE FUNCTION minutes(interval) returns integer as $$
    DECLARE
    BEGIN
        RETURN round(daysf($1) * 24 * 60);
    END;
$$  language 'plpgsql';

CREATE OR REPLACE FUNCTION minutesf(interval) returns double precision as $$
    DECLARE
    BEGIN
        RETURN daysf($1) * 24 * 60;
    END;
$$  language 'plpgsql';


CREATE OR REPLACE FUNCTION weeks(interval) returns integer as $$
    DECLARE
    BEGIN
        RETURN round(daysf($1) / 7);
    END;
$$  language 'plpgsql';

CREATE OR REPLACE FUNCTION weeksf(interval) returns double precision as $$
    DECLARE
    BEGIN
        RETURN daysf($1) / 7;
    END;
$$  language 'plpgsql';



CREATE OR REPLACE FUNCTION months(interval) returns integer as $$
    DECLARE
    BEGIN
        RETURN round(daysf($1) / 30.44);
    END;
$$  language 'plpgsql';

CREATE OR REPLACE FUNCTION monthsf(interval) returns double precision as $$
    DECLARE
    BEGIN
        RETURN daysf($1) / 30.44;
    END;
$$  language 'plpgsql';


CREATE OR REPLACE FUNCTION years(interval) returns integer as $$
    DECLARE
    BEGIN
        RETURN round(daysf($1) / 365.25);
    END;
$$  language 'plpgsql';

CREATE OR REPLACE FUNCTION yearsf(interval) returns double precision as $$
    DECLARE
    BEGIN
        RETURN daysf($1) / 365.25;
    END;
$$  language 'plpgsql';



--Diese Funktion löscht eine Datensatz-ID aus allen Tabellen
CREATE OR REPLACE FUNCTION delete_all_with_datensatz_id(integer) returns int4 AS $$
    DECLARE
        d_id    ALIAS FOR $1;
        tables  record;
        obj  record;
        num  integer;
    BEGIN
        num:=0;
        FOR tables IN SELECT tablename FROM pg_tables 
                WHERE schemaname = 'public' 
                    AND tablename NOT LIKE '%_typ' 
                    AND tablename != 'truefalse'
                    AND tablename != 'klinik'
                    AND tablename != 'datensatz'
        LOOP
            RAISE NOTICE 'Tabelle: %', tables.tablename;
            EXECUTE 'DELETE FROM ' || quote_ident(tables.tablename) || ' WHERE id = ' || text(d_id);
            --DELETE FROM text(tables.tablename) WHERE datensatz = d_id;
            num := num + 1;
        END LOOP;
        DELETE FROM datensatz WHERE id = d_id;
        RETURN num;
    END;
$$ language 'plpgsql';


--Diese Funktion löscht eine Datensatz-ID aus allen Tabellen
CREATE OR REPLACE FUNCTION delete_all_with_datei_id(text) returns int4 AS $$
    DECLARE
        d_id    ALIAS FOR $1;
        tables  record;
        obj  record;
        num  integer;
    BEGIN
        num:=0;
        FOR tables IN SELECT tablename FROM pg_tables 
                WHERE schemaname = 'public' 
                    AND tablename NOT LIKE '%_typ' 
                    AND tablename != 'truefalse'
                    AND tablename != 'datensatz'
                    AND tablename != 'klinik'
        LOOP
            RAISE NOTICE 'Tabelle: %', tables.tablename;
            EXECUTE 'DELETE FROM ' || quote_ident(tables.tablename) 
                || ' WHERE id in (SELECT id from datensatz WHERE datei_id = ' || text(d_id) || ')';
            --DELETE FROM text(tables.tablename) WHERE datensatz = d_id;
            num := num + 1;
        END LOOP;
        DELETE FROM datensatz WHERE datei_id = d_id;
        RETURN num;
    END;
$$ language 'plpgsql';


CREATE OR REPLACE FUNCTION commacat(acc text, instr text)
  RETURNS text AS
$BODY$
        BEGIN
                --IF acc IS NULL OR acc = '' THEN
                --RETURN instr;
                --ELSE
                RETURN acc || ', ' || instr;
                --END IF;
        END;
$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100;
ALTER FUNCTION commacat(text, text) OWNER TO postgres;

DROP AGGREGATE IF EXISTS textcat_all( text);

CREATE AGGREGATE textcat_all(
  basetype    = text,
  sfunc       = commacat,
  stype       = text,
  initcond    = ''
);

CREATE OR REPLACE FUNCTION pipecat(acc text, instr text)
  RETURNS text AS
$BODY$
        BEGIN
				IF acc IS NULL OR acc = '' THEN
                RETURN instr;
                ELSE
                RETURN acc || '| ' || instr;
				END IF;
        END;
$BODY$
  LANGUAGE 'plpgsql' VOLATILE
  COST 100;
ALTER FUNCTION pipecat(text, text) OWNER TO postgres;

DROP AGGREGATE IF EXISTS pipecat_all( text);

CREATE AGGREGATE pipecat_all(
  basetype    = text,
  sfunc       = pipecat,
  stype       = text,
  initcond    = ''
);

COMMIT;
