
CREATE TABLE behandler_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);


CREATE TABLE datensatz (
    id                  SERIAL PRIMARY KEY,
    insert_time         TIMESTAMP,
    daten_jahr          INTEGER NOT NULL CHECK (2000 < daten_jahr AND daten_jahr < 2100),
    behandler_nr        INTEGER,
    sub_behandler_nr    text,
    patienten_nr        text,
    datei_id            text,
	vorname				text,
	nachname			text
);

CREATE INDEX datensatz_behandler_nr ON datensatz(behandler_nr);
CREATE INDEX datensatz_patienten_nr ON datensatz(patienten_nr);
CREATE INDEX datensatz_vorname ON datensatz(vorname);
CREATE INDEX datensatz_nachname ON datensatz(nachname);

-- Hilfstabellen
CREATE table truefalse (
    name        text,
    bool        BOOLEAN
);

CREATE table leicht_mittel_schwer_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);


-- Tabellen mit Meta-Werten 

CREATE TABLE validity_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);

CREATE TABLE sicher_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);


-- Typ-Tabellen, die mehrfach verwendet werden:
CREATE TABLE ja_nein_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);

CREATE TABLE diagnose_typ (
    id          SERIAL PRIMARY KEY,
    key         text,
    name        text,
    psychisch   BOOLEAN,
    somatisch   BOOLEAN
);
CREATE INDEX diagnose_typ_key ON diagnose_typ(key);

CREATE TABLE ktl2007_typ (
    id          SERIAL PRIMARY KEY,
    key         text,
    name        text
);
CREATE INDEX ktl2007_typ_key ON ktl2007_typ(key);

CREATE TABLE ktl2007_dauer_typ (
    id          SERIAL PRIMARY KEY,
    key         text,
    dauer       interval
);

CREATE TABLE fcat_typ (
    id          SERIAL PRIMARY KEY,
    name        text,
    re          text
);

CREATE TABLE aenderung_7_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);

CREATE TABLE aenderung_8_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);

CREATE TABLE mediaktion_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);

CREATE TABLE durchfuehrung_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);

CREATE TABLE garf_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);

CREATE TABLE gaf_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);

CREATE TABLE gaf_schweregrad_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);


-- Restliche Tabellen


-- Therapeut aufnahme

--       Versorgungsbereich 
CREATE TABLE versorgungsbereich_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);

CREATE TABLE  versorgungsbereich(
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES versorgungsbereich_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX versorgungsbereich_id on versorgungsbereich(id);

--       Aufnahmedatum
CREATE TABLE  aufnahmedatum(
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    datum       TIMESTAMP,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX aufnahmedatum_id on aufnahmedatum(id);

--      Kostenträger 
CREATE TABLE kostentraeger_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);
CREATE TABLE kostentraeger (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES kostentraeger_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX kostentraeger_id on kostentraeger(id);

--      Abrechnungsart
CREATE TABLE abrechnungsart_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);
CREATE TABLE abrechnungsart (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES abrechnungsart_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX abrechnungsart_id on abrechnungsart(id);

--       Einweiser
CREATE TABLE einweiser_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE einweiser (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES einweiser_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX einweiser_id on einweiser(id);

--       Barriere
CREATE TABLE barriere_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE barriere (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES barriere_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX barriere_id on barriere(id);

--       rentenbegehren
CREATE TABLE rentenbegehren_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE rentenbegehren (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES rentenbegehren_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX rentenbegehren_id on rentenbegehren(id);

--       suizidversuch
CREATE TABLE suizidversuch_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE suizidversuch (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES suizidversuch_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX suizidversuch_id on suizidversuch(id);

--       Anzahl Suizidversuche
CREATE TABLE suizidversuch_anzahl (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    anzahl      INTEGER,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX suizidversuch_anzahl_id on suizidversuch_anzahl(id);


--       Motivation
CREATE TABLE motivation_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE motivation (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES motivation_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX motivation_id on motivation(id);

--       Anamnese gesamt
CREATE TABLE anamnese_gesamt_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE anamnese_gesamt (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES anamnese_gesamt_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX anamnese_gesamt_id on anamnese_gesamt(id);

--       Anamnese aktuell
CREATE TABLE anamnese_aktuell_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE anamnese_aktuell (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES anamnese_aktuell_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX anamnese_aktuell_id on anamnese_aktuell(id);

--       Hauptdiagnose
CREATE TABLE hauptdiagnose_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE hauptdiagnose (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES hauptdiagnose_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX hauptdiagnose_id on hauptdiagnose(id);

-- -      psych. ICD-10-Diagnosen
CREATE TABLE psychische_diagnose (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES diagnose_typ,
    valid       INTEGER REFERENCES validity_typ,
    sicher      INTEGER REFERENCES sicher_typ,
    seq_nr      INTEGER
);
CREATE INDEX psychische_diagnose_seq_nr ON psychische_diagnose(seq_nr);
CREATE INDEX psychische_diagnose_id ON psychische_diagnose(id);
CREATE INDEX psychische_diagnose_sicher ON psychische_diagnose(sicher);
CREATE INDEX psychische_diagnose_valid ON psychische_diagnose(valid);
CREATE INDEX psychische_diagnose_typ ON psychische_diagnose(typ);

-- -, -      somat. ICD-10-Diagnosen
CREATE TABLE somatische_diagnose (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES diagnose_typ,
    valid       INTEGER REFERENCES validity_typ,
    sicher      INTEGER REFERENCES sicher_typ,
    seq_nr      INTEGER
);
CREATE INDEX somatische_diagnose_seq_nr ON somatische_diagnose(seq_nr);
CREATE INDEX somatische_diagnose_id ON somatische_diagnose(id);
CREATE INDEX somatische_diagnose_sicher ON somatische_diagnose(sicher);
CREATE INDEX somatische_diagnose_valid ON somatische_diagnose(valid);
CREATE INDEX somatische_diagnose_typ ON somatische_diagnose(typ);

--       GAF
CREATE TABLE gaf_a (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES gaf_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX gaf_a_id on gaf_a(id);

--       GARF
CREATE TABLE garf_a (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES garf_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX garf_a_id on garf_a(id);

-- Patient aufnahme

--      Behandlungsempfehlung
CREATE TABLE behandlungsempfehlung_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);
CREATE TABLE behandlungsempfehlung (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES behandlungsempfehlung_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX behandlungsempfehlung_id on behandlungsempfehlung(id);

--      Geschlecht
CREATE TABLE geschlecht_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);
CREATE TABLE geschlecht (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES geschlecht_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX geschlecht_id on geschlecht(id);

--       Geburtsdatum
CREATE TABLE geburtsdatum (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    datum       TIMESTAMP,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX geburtsdatum_id on geburtsdatum(id);
--       Nationalität 
CREATE TABLE nation_typ (
    id          SERIAL PRIMARY KEY,
    key         text,
    name        text
);

CREATE INDEX nation_typ_keytyp ON nation_typ(key);

CREATE TABLE nation (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES nation_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX nation_typ_typ ON nation(typ);
CREATE INDEX nation_pkey ON nation(id);

--       Haushalt
CREATE TABLE haushalt_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE haushalt (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES haushalt_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX haushalt_id on haushalt(id);

--       Partnersituation
CREATE TABLE partnersituation_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE partnersituation (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES partnersituation_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX partnersituation_id on partnersituation(id);
--       Familienstand 
CREATE TABLE familienstand_typ (
    id          INTEGER PRIMARY KEY,
    name        text
);
CREATE TABLE familienstand (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES familienstand_typ,
    valid       INTEGER REFERENCES validity_typ
);
 CREATE INDEX familienstand_id on familienstand(id);
--       Anzahl Kinder
CREATE TABLE anzahl_kinder (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    anzahl      INTEGER,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX anzahl_kinder_id on anzahl_kinder(id);
--       Schulabschluss
CREATE TABLE schulabschluss_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE schulabschluss (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES schulabschluss_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX schulabschluss_id on schulabschluss(id);
--       Berufsabschluss 
CREATE TABLE berufsabschluss_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE berufsabschluss (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES berufsabschluss_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX berufsabschluss_id on berufsabschluss(id);
--      Berufstaetigkeit
CREATE TABLE berufstaetigkeit_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE berufstaetigkeit (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES berufstaetigkeit_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX berufstaetigkeit_id on berufstaetigkeit(id);
--       Erwerbstätigkeit
CREATE TABLE erwerbstaetigkeit_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE erwerbstaetigkeit (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES erwerbstaetigkeit_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX erwerbstaetigkeit_id on erwerbstaetigkeit(id);
--       Haupteinkommen
CREATE TABLE haupteinkommen_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE haupteinkommen (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES haupteinkommen_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX haupteinkommen_id on haupteinkommen(id);



--       AU bei Aufnahme
CREATE TABLE au_aufnahme (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX au_aufnahme_id on au_aufnahme(id);
--       AU gesamt
CREATE TABLE au_gesamt (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX au_gesamt_id on au_gesamt(id);
--       Rentenverfahren
CREATE TABLE rentenverfahren_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE rentenverfahren (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES rentenverfahren_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX rentenverfahren_id on rentenverfahren(id);

--       stat. Vorbehandlungen Anzahl
CREATE TABLE stat_vorbeh_anzahl (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    anzahl      INTEGER,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX stat_vorbeh_anzahl_id on stat_vorbeh_anzahl(id);

--       stat. Vorbehandlungen Dauer
CREATE TABLE stat_vorbeh_dauer (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX stat_vorbeh_dauer_id on stat_vorbeh_dauer(id);
--       teilstat. Vorbeh. Anzahl 
CREATE TABLE teilstat_vorbeh_anzahl (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    anzahl      INTEGER,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX teilstat_vorbeh_anzahl_id on teilstat_vorbeh_anzahl(id);

--       teilstat. Vorbeh. Dauer
CREATE TABLE teilstat_vorbeh_dauer (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX teilstat_vorbeh_dauer_id on teilstat_vorbeh_dauer(id);

--       Amb. Vorbehandler anzahl
CREATE TABLE amb_vorbeh_anzahl (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    anzahl      INTEGER,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX amb_vorbeh_anzahl_id on amb_vorbeh_anzahl(id);

--       Amb. Vorbehandlungen dauer
CREATE TABLE amb_vorbeh_dauer_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE amb_vorbeh_dauer (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES amb_vorbeh_dauer_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX amb_vorbeh_dauer_id on amb_vorbeh_dauer(id);

--       Amb. Vorbehandler vor Aufnahme
CREATE TABLE amb_vorbeh_aufnahme_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE amb_vorbeh_aufnahme (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES amb_vorbeh_aufnahme_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX amb_vorbeh_aufnahme_id on amb_vorbeh_aufnahme(id);

--       Pharma vor Aufnahme
CREATE TABLE pharma_aufnahme_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE pharma_aufnahme (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES pharma_aufnahme_typ,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX pharma_aufnahme_id on pharma_aufnahme(id);


-- Therapeut Entlassung

--      Entlassungsdatum
CREATE TABLE  entlassungsdatum(
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    datum       TIMESTAMP,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX entlassungsdatum_id on entlassungsdatum(id);
--       Behandlungsdauer in Tagen
CREATE TABLE behandlungsdauer (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX behandlungsdauer_id on behandlungsdauer(id);
--       Anzahl Sitzungen
CREATE TABLE anzahl_sitzungen (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    anzahl      INTEGER,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX anzahl_sitzungen_id on anzahl_sitzungen(id);
--       Art der Beendigung
CREATE TABLE beendigungsart_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE beendigungsart (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES beendigungsart_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX beendigungsart_id on beendigungsart(id);
--       AF bei Entlassung
CREATE TABLE af_entlassung_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE af_entlassung (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES af_entlassung_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX af_entlassung_id on af_entlassung(id);
--       Alltagspflichten (therapeut)
CREATE TABLE alltagspflichten_therapeut (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES ja_nein_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX alltagspflichten_therapeut_id on alltagspflichten_therapeut(id);
--       Änderung körperl. Befinden (Therapeut)
CREATE TABLE aenderung_koerperlich_therapeut (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES aenderung_8_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX aenderung_koerperlich_therapeut_id on aenderung_koerperlich_therapeut(id);

--       Änderung psych. Befinden (Therapeut)
CREATE TABLE aenderung_psychisch_therapeut (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES aenderung_8_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX aenderung_psychisch_therapeut_id on aenderung_psychisch_therapeut(id);
--       GAF Aufnahme
CREATE TABLE gaf_e (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES gaf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gaf_e_id on gaf_e(id);
--       GARF Aufnahme
CREATE TABLE garf_e (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES garf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX garf_e_id on garf_e(id);
--       VEV-K
CREATE TABLE  vev_k(
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    anzahl      INTEGER,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX vev_k_id on vev_k(id);
--       Medikation: Antidepressiva
CREATE TABLE medikation_antidepressiva (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mediaktion_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX medikation_antidepressiva_id on medikation_antidepressiva(id);
--       Medikation: Anxiolytika
CREATE TABLE medikation_anxiolytika (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mediaktion_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX medikation_anxiolytika_id on medikation_anxiolytika(id);

--       Medikation: Neuroleptika
CREATE TABLE medikation_neuroleptika (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mediaktion_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX medikation_neuroleptika_id on medikation_neuroleptika(id);
--       Medikation: Analgetika
CREATE TABLE medikation_analgetika (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mediaktion_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX medikation_analgetika_id on medikation_analgetika(id);

--       Weiterbehandlung
CREATE TABLE weiterbehandlung_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);
CREATE TABLE weiterbehandlung (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES weiterbehandlung_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX weiterbehandlung_id on weiterbehandlung(id);






-- Patient Entlassung

--       Alltagspflichten (patient)
CREATE TABLE alltagspflichten_patient (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES ja_nein_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX alltagspflichten_patient_id on alltagspflichten_patient(id);
--       zuf fragen
CREATE TABLE zuf_fragen_1_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);

CREATE TABLE zuf_fragen_2_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);

CREATE TABLE zuf_fragen_3_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);

CREATE TABLE zuf_fragen_4_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);

CREATE TABLE zuf_fragen_5_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);

CREATE TABLE zuf_fragen_6_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);

CREATE TABLE zuf_fragen_7_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);


--       ZUF 1
CREATE TABLE zuf_1 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES zuf_fragen_1_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX zuf_1_id on zuf_1(id);
--       ZUF 2
CREATE TABLE zuf_2 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES zuf_fragen_2_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX zuf_2_id on zuf_2(id);
--       ZUF 3
CREATE TABLE zuf_3 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES zuf_fragen_3_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX _zuf_3id on zuf_3(id);
--       ZUF 4
CREATE TABLE zuf_4 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES zuf_fragen_4_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX zuf_4_id on zuf_4(id);
--       ZUF 5
CREATE TABLE zuf_5 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES zuf_fragen_5_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX zuf_5_id on zuf_5(id);
--       ZUF 6
CREATE TABLE zuf_6 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES zuf_fragen_6_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX zuf_6_id on zuf_6(id);
--       ZUF 7
CREATE TABLE zuf_7 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES zuf_fragen_7_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX zuf_7_id on zuf_7(id);
--       ZUF 8
CREATE TABLE zuf_8 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES zuf_fragen_4_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX zuf_8_id on zuf_8(id);
--       Änderung körperlich (Patient)
CREATE TABLE aenderung_koerperlich_patient (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES aenderung_7_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX aenderung_koerperlich_patient_id on aenderung_koerperlich_patient(id);
--       Änderung psychisch (Patient)
CREATE TABLE aenderung_psychisch_patient (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES aenderung_7_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX aenderung_psychisch_patient_id on aenderung_psychisch_patient(id);
--       Selbstwerterleben
CREATE TABLE aenderung_selbstwerterleben (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES aenderung_7_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX aenderung_selbstwerterleben_id on aenderung_selbstwerterleben(id);
--       Änderung sozial
CREATE TABLE aenderung_sozial (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES aenderung_7_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX aenderung_sozial_id on aenderung_sozial(id);
--       Änderung privat
CREATE TABLE aenderung_privat (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES aenderung_7_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX aenderung_privat_id on aenderung_privat(id);
--       Änderung beruflich
CREATE TABLE aenderung_beruflich (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES aenderung_7_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX aenderung_beruflich_id on aenderung_beruflich(id);
--       Eigenaktivität
CREATE TABLE aenderung_eigenaktivitaet (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES aenderung_7_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX aenderung_eigenaktivitaet_id on aenderung_eigenaktivitaet(id);
--       Krankheitsverständnis
CREATE TABLE aenderung_krankheitsverstaendnis (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES aenderung_7_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX aenderung_krankheitsverstaendnis_id on aenderung_krankheitsverstaendnis(id);
--       Einstellung Zukunft
CREATE TABLE aenderung_zukunft (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES aenderung_7_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX aenderung_zukunft_id on aenderung_zukunft(id);
--       seel. Wohlbefinden
CREATE TABLE aenderung_befinden (
id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
typ         INTEGER REFERENCES aenderung_7_typ,
valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX aenderung_befinden_id on aenderung_befinden(id);
--       Änderung Alltag
CREATE TABLE aenderung_alltag (
id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
typ         INTEGER REFERENCES aenderung_7_typ,
valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX aenderung_alltag_id on aenderung_alltag(id);
-- Index 5: ISR




---------- ISR

CREATE TABLE isr_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);

CREATE TABLE isr_schweregrad_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);


CREATE TABLE isr_datensatz (
    eintrag_id      SERIAL PRIMARY KEY,
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    datum       TIMESTAMP,
    valid       INTEGER REFERENCES validity_typ
);

CREATE INDEX isr_datensatz_id ON isr_datensatz(id);
CREATE INDEX isr_datensatz_datum ON isr_datensatz(datum);


-- 	ISR-D01
CREATE TABLE isr_d01 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_d01_id on isr_d01(id);
CREATE INDEX isr_d01_eintrag_id ON isr_d01(eintrag_id);
CREATE INDEX isr_d01_typ ON isr_d01(typ);

-- 	ISR-D02
CREATE TABLE isr_d02 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_d02_id on isr_d02(id);
CREATE INDEX isr_d02_eintrag_id ON isr_d02(eintrag_id);
CREATE INDEX isr_d02_typ ON isr_d02(typ);

-- 	ISR-D03
CREATE TABLE isr_d03 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_d03_id on isr_d03(id);
CREATE INDEX isr_d03_eintrag_id ON isr_d03(eintrag_id);
CREATE INDEX isr_d03_typ ON isr_d03(typ);

-- 	ISR-D05
CREATE TABLE isr_d05 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_d05_id on isr_d05(id);
CREATE INDEX isr_d05_eintrag_id ON isr_d05(eintrag_id);
CREATE INDEX isr_d05_typ ON isr_d05(typ);

-- 	ISR-A01
CREATE TABLE isr_a01 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_a01_id on isr_a01(id);
CREATE INDEX isr_a01_eintrag_id ON isr_a01(eintrag_id);
CREATE INDEX isr_a01_typ ON isr_a01(typ);

-- 	ISR-A02
CREATE TABLE isr_a02 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_a02_id on isr_a02(id);
CREATE INDEX isr_a02_eintrag_id ON isr_a02(eintrag_id);
CREATE INDEX isr_a02_typ ON isr_a02(typ);

-- 	ISR-A03
CREATE TABLE isr_a03 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_a03_id on isr_a03(id);
CREATE INDEX isr_a03_eintrag_id ON isr_a03(eintrag_id);
CREATE INDEX isr_a03_typ ON isr_a03(typ);

-- 	ISR-A04
CREATE TABLE isr_a04 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_a04_id on isr_a04(id);
CREATE INDEX isr_a04_eintrag_id ON isr_a04(eintrag_id);
CREATE INDEX isr_a04_typ ON isr_a04(typ);

-- 	ISR-Z01
CREATE TABLE isr_z01 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_z01_id on isr_z01(id);
CREATE INDEX isr_z01_eintrag_id ON isr_z01(eintrag_id);
CREATE INDEX isr_z01_typ ON isr_z01(typ);

-- 	ISR-Z02
CREATE TABLE isr_z02 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_z02_id on isr_z02(id);
CREATE INDEX isr_z02_eintrag_id ON isr_z02(eintrag_id);
CREATE INDEX isr_z02_typ ON isr_z02(typ);

-- 	ISR-Z03
CREATE TABLE isr_z03 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_z03_id on isr_z03(id);
CREATE INDEX isr_z03_eintrag_id ON isr_z03(eintrag_id);
CREATE INDEX isr_z03_typ ON isr_z03(typ);

-- 	ISR-S01
CREATE TABLE isr_s01 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_s01_id on isr_s01(id);
CREATE INDEX isr_s01_eintrag_id ON isr_s01(eintrag_id);
CREATE INDEX isr_s01_typ ON isr_s01(typ);

-- 	ISR-S02
CREATE TABLE isr_s02 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_s02_id on isr_s02(id);
CREATE INDEX isr_s02_eintrag_id ON isr_s02(eintrag_id);
CREATE INDEX isr_s02_typ ON isr_s02(typ);

-- 	ISR-S03
CREATE TABLE isr_s03 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_s03_id on isr_s03(id);
CREATE INDEX isr_s03_eintrag_id ON isr_s03(eintrag_id);
CREATE INDEX isr_s03_typ ON isr_s03(typ);

-- 	ISR-E01
CREATE TABLE isr_e01 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_e01_id on isr_e01(id);
CREATE INDEX isr_e01_eintrag_id ON isr_e01(eintrag_id);
CREATE INDEX isr_e01_typ ON isr_e01(typ);

-- 	ISR-E02
CREATE TABLE isr_e02 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_e02_id on isr_e02(id);
CREATE INDEX isr_e02_eintrag_id ON isr_e02(eintrag_id);
CREATE INDEX isr_e02_typ ON isr_e02(typ);

-- 	ISR-E03
CREATE TABLE isr_e03 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_e03_id on isr_e03(id);
CREATE INDEX isr_e03_eintrag_id ON isr_e03(eintrag_id);
CREATE INDEX isr_e03_typ ON isr_e03(typ);

-- 	ISR-D04
CREATE TABLE isr_d04 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_d04_id on isr_d04(id);
CREATE INDEX isr_d04_eintrag_id ON isr_d04(eintrag_id);
CREATE INDEX isr_d04_typ ON isr_d04(typ);

-- 	ISR-D10
CREATE TABLE isr_d10 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_d10_id on isr_d10(id);
CREATE INDEX isr_d10_eintrag_id ON isr_d10(eintrag_id);
CREATE INDEX isr_d10_typ ON isr_d10(typ);

-- 	ISR-D11
CREATE TABLE isr_d11 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_d11_id on isr_d11(id);
CREATE INDEX isr_d11_eintrag_id ON isr_d11(eintrag_id);
CREATE INDEX isr_d11_typ ON isr_d11(typ);

-- 	ISR-D12
CREATE TABLE isr_d12 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_d12_id on isr_d12(id);
CREATE INDEX isr_d12_eintrag_id ON isr_d12(eintrag_id);
CREATE INDEX isr_d12_typ ON isr_d12(typ);

-- 	ISR-W01
CREATE TABLE isr_w01 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_w01_id on isr_w01(id);
CREATE INDEX isr_w01_eintrag_id ON isr_w01(eintrag_id);
CREATE INDEX isr_w01_typ ON isr_w01(typ);

-- 	ISR-W02
CREATE TABLE isr_w02 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_w02_id on isr_w02(id);
CREATE INDEX isr_w02_eintrag_id ON isr_w02(eintrag_id);
CREATE INDEX isr_w02_typ ON isr_w02(typ);

-- 	ISR-W03
CREATE TABLE isr_w03 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_w03_id on isr_w03(id);
CREATE INDEX isr_w03_eintrag_id ON isr_w03(eintrag_id);
CREATE INDEX isr_w03_typ ON isr_w03(typ);

-- 	ISR-W05
CREATE TABLE isr_w05 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_w05_id on isr_w05(id);
CREATE INDEX isr_w05_eintrag_id ON isr_w05(eintrag_id);
CREATE INDEX isr_w05_typ ON isr_w05(typ);

-- 	ISR-W06
CREATE TABLE isr_w06 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_w06_id on isr_w06(id);
CREATE INDEX isr_w06_eintrag_id ON isr_w06(eintrag_id);
CREATE INDEX isr_w06_typ ON isr_w06(typ);

-- 	ISR-W07
CREATE TABLE isr_w07 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_w07_id on isr_w07(id);
CREATE INDEX isr_w07_eintrag_id ON isr_w07(eintrag_id);
CREATE INDEX isr_w07_typ ON isr_w07(typ);

-- 	ISR-W08
CREATE TABLE isr_w08 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_w08_id on isr_w08(id);
CREATE INDEX isr_w08_eintrag_id ON isr_w08(eintrag_id);
CREATE INDEX isr_w08_typ ON isr_w08(typ);

-- 	ISR-W09
CREATE TABLE isr_w09 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id      INTEGER REFERENCES isr_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES isr_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX isr_w09_id on isr_w09(id);
CREATE INDEX isr_w09_eintrag_id ON isr_w09(eintrag_id);
CREATE INDEX isr_w09_typ ON isr_w09(typ);


-- Index 6: Mini-ICF
CREATE TABLE mini_icf_typ (
    id          INTEGER PRIMARY KEY, 
    name        text
);  

CREATE TABLE mini_icf_datensatz (
    eintrag_id SERIAL PRIMARY KEY,
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    datum       TIMESTAMP,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX mini_icf_datensatz_id ON mini_icf_datensatz(id);
CREATE INDEX mini_icf_datensatz_datum ON mini_icf_datensatz(datum);
-- 	Mini ICF 01
CREATE TABLE mini_icf_01 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id INTEGER REFERENCES mini_icf_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mini_icf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX _mini_icf_01id on mini_icf_01(id);
CREATE INDEX mini_icf_01_eintrag_id ON mini_icf_01(eintrag_id);
CREATE INDEX mini_icf_01_typ ON mini_icf_01(typ);
-- 	Mini ICF 02
CREATE TABLE mini_icf_02 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id INTEGER REFERENCES mini_icf_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mini_icf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX mini_icf_02_id on mini_icf_02(id);
CREATE INDEX mini_icf_02_eintrag_id ON mini_icf_02(eintrag_id);
CREATE INDEX mini_icf_02_typ ON mini_icf_02(typ);
-- 	Mini ICF 03
CREATE TABLE mini_icf_03 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id INTEGER REFERENCES mini_icf_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mini_icf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX mini_icf_03_id on mini_icf_03(id);
CREATE INDEX mini_icf_03_eintrag_id ON mini_icf_03(eintrag_id);
CREATE INDEX mini_icf_03_typ ON mini_icf_03(typ);
-- 	Mini ICF 04
CREATE TABLE mini_icf_04 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id INTEGER REFERENCES mini_icf_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mini_icf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX mini_icf_04_id on mini_icf_04(id);
CREATE INDEX mini_icf_04_eintrag_id ON mini_icf_04(eintrag_id);
CREATE INDEX mini_icf_04_typ ON mini_icf_04(typ);
-- 	Mini ICF 05
CREATE TABLE mini_icf_05 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id INTEGER REFERENCES mini_icf_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mini_icf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX mini_icf_05_id on mini_icf_05(id);
CREATE INDEX mini_icf_05_eintrag_id ON mini_icf_05(eintrag_id);
CREATE INDEX mini_icf_05_typ ON mini_icf_05(typ);
-- 	Mini ICF 06
CREATE TABLE mini_icf_06 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id INTEGER REFERENCES mini_icf_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mini_icf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX mini_icf_06_id on mini_icf_06(id);
CREATE INDEX mini_icf_06_eintrag_id ON mini_icf_06(eintrag_id);
CREATE INDEX mini_icf_06_typ ON mini_icf_06(typ);
-- 	Mini ICF 07
CREATE TABLE mini_icf_07 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id INTEGER REFERENCES mini_icf_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mini_icf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX mini_icf_07_id on mini_icf_07(id);
CREATE INDEX mini_icf_07_eintrag_id ON mini_icf_07(eintrag_id);
CREATE INDEX mini_icf_07_typ ON mini_icf_07(typ);
-- 	Mini ICF 08
CREATE TABLE mini_icf_08 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id INTEGER REFERENCES mini_icf_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mini_icf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX mini_icf_08_id on mini_icf_08(id);
CREATE INDEX mini_icf_08_eintrag_id ON mini_icf_08(eintrag_id);
CREATE INDEX mini_icf_08_typ ON mini_icf_08(typ);
-- 	Mini ICF 09
CREATE TABLE mini_icf_09 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id INTEGER REFERENCES mini_icf_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mini_icf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX mini_icf_09_id on mini_icf_09(id);
CREATE INDEX mini_icf_09_eintrag_id ON mini_icf_09(eintrag_id);
CREATE INDEX mini_icf_09_typ ON mini_icf_09(typ);
-- 	Mini ICF 10
CREATE TABLE mini_icf_10 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id INTEGER REFERENCES mini_icf_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mini_icf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX mini_icf_10_id on mini_icf_10(id);
CREATE INDEX mini_icf_10_eintrag_id ON mini_icf_10(eintrag_id);
CREATE INDEX mini_icf_10_typ ON mini_icf_10(typ);
-- 	Mini ICF 11
CREATE TABLE mini_icf_11 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id INTEGER REFERENCES mini_icf_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mini_icf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX mini_icf_11_id on mini_icf_11(id);
CREATE INDEX mini_icf_11_eintrag_id ON mini_icf_11(eintrag_id);
CREATE INDEX mini_icf_11_typ ON mini_icf_11(typ);
-- 	Mini ICF 12
CREATE TABLE mini_icf_12 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id INTEGER REFERENCES mini_icf_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mini_icf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX mini_icf_12_id on mini_icf_12(id);
CREATE INDEX mini_icf_12_eintrag_id ON mini_icf_12(eintrag_id);
CREATE INDEX mini_icf_12_typ ON mini_icf_12(typ);
-- 	Mini ICF 13
CREATE TABLE mini_icf_13 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id INTEGER REFERENCES mini_icf_datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES mini_icf_typ,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX mini_icf_13_id on mini_icf_13(id);
CREATE INDEX mini_icf_13_eintrag_id ON mini_icf_13(eintrag_id);
CREATE INDEX mini_icf_13_typ ON mini_icf_13(typ);
-- 	Mini ICF Gesamt
CREATE TABLE mini_icf_gesamt (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id INTEGER REFERENCES mini_icf_datensatz ON DELETE CASCADE,
    grad        REAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX mini_icf_gesamt_id on mini_icf_gesamt(id);
CREATE INDEX mini_icf_gesamt_eintrag_id ON mini_icf_gesamt(eintrag_id);



-- Index 7: SCL 90

--      SCL Datensatz
CREATE TABLE scl90_datensatz (
    eintrag_id    SERIAL PRIMARY KEY,
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    datum       TIMESTAMP,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX scl90_datensatz_id ON scl90_datensatz(id);
CREATE INDEX scl90_datensatz_datum ON scl90_datensatz(datum);
--       SCL-90-R (1): Somatisierung
CREATE TABLE scl90_somatisierung (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id    INTEGER REFERENCES scl90_datensatz ON DELETE CASCADE,
    grad        REAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX scl90_somatisierung_id on scl90_somatisierung(id);
CREATE INDEX scl90_somatisierung_eintrag_id ON scl90_somatisierung(eintrag_id);


--       SCL-90-R (2): Zwanghaftigkeit
CREATE TABLE scl90_zwanghaftigkeit (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id    INTEGER REFERENCES scl90_datensatz ON DELETE CASCADE,
    grad        REAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX scl90_zwanghaftigkeit_id on scl90_zwanghaftigkeit(id);
CREATE INDEX scl90_zwanghaftigkeit_eintrag_id ON scl90_zwanghaftigkeit(eintrag_id);


--       SCL-90-R (3): Sozialkontakt
CREATE TABLE scl90_sozialkontakt (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id    INTEGER REFERENCES scl90_datensatz ON DELETE CASCADE,
    grad        REAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX scl90_sozialkontakt_id on scl90_sozialkontakt(id);
CREATE INDEX scl90_sozialkontakt_eintrag_id ON scl90_sozialkontakt(eintrag_id);


--       SCL-90-R (4): Depressivität
CREATE TABLE scl90_depressivitaet (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id    INTEGER REFERENCES scl90_datensatz ON DELETE CASCADE,
    grad        REAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX scl90_depressivitaet_id on scl90_depressivitaet(id);
CREATE INDEX scl90_depressivitaet_eintrag_id ON scl90_depressivitaet(eintrag_id);


--       SCL-90-R (5): Ängstlichkeit
CREATE TABLE scl90_aengstlichkeit (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id    INTEGER REFERENCES scl90_datensatz ON DELETE CASCADE,
    grad        REAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX scl90_aengstlichkeit_id on scl90_aengstlichkeit(id);
CREATE INDEX scl90_aengstlichkeit_eintrag_id ON scl90_aengstlichkeit(eintrag_id);


--       SCL-90-R (6): Aggressivität
CREATE TABLE scl90_aggressivitaet (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id    INTEGER REFERENCES scl90_datensatz ON DELETE CASCADE,
    grad        REAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX scl90_aggressivitaet_id on scl90_aggressivitaet(id);
CREATE INDEX scl90_aggressivitaet_eintrag_id ON scl90_aggressivitaet(eintrag_id);


--       SCL-90-R (7): Phobische Angst
CREATE TABLE scl90_phobische_angst (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id    INTEGER REFERENCES scl90_datensatz ON DELETE CASCADE,
    grad        REAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX scl90_phobische_angst_id on scl90_phobische_angst(id);
CREATE INDEX scl90_phobische_angst_eintrag_id ON scl90_phobische_angst(eintrag_id);


--       SCL-90-R (8): Paranoides Denken
CREATE TABLE scl90_paranoides_denken (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id    INTEGER REFERENCES scl90_datensatz ON DELETE CASCADE,
    grad        REAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX scl90_paranoides_denken_id on scl90_paranoides_denken(id);
CREATE INDEX scl90_paranoides_denken_eintrag_id ON scl90_paranoides_denken(eintrag_id);


--       SCL-90-R (9): Psychotizismus
CREATE TABLE scl90_psychotizismus (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id    INTEGER REFERENCES scl90_datensatz ON DELETE CASCADE,
    grad        REAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX scl90_psychotizismus_id on scl90_psychotizismus(id);
CREATE INDEX scl90_psychotizismus_eintrag_id ON scl90_psychotizismus(eintrag_id);


--       SCL-90-R (10): GSI
CREATE TABLE scl90_gsi (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    eintrag_id    INTEGER REFERENCES scl90_datensatz ON DELETE CASCADE,
    grad        REAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX scl90_gsi_id on scl90_gsi(id);
CREATE INDEX scl90_gsi_eintrag_id ON scl90_gsi(eintrag_id);

-- Index 8: KTL Krankenhaus

--       Visiten
CREATE TABLE visiten (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX visiten_id on visiten(id);
--       Ko-therapeutische Kontakte
CREATE TABLE kontakte_kotherapeutisch (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX kontakte_kotherapeutisch_id on kontakte_kotherapeutisch(id);
--       Pat.-bezogene Besprechung
CREATE TABLE besprechung_patientenbezogen (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX besprechung_patientenbezogen_id on besprechung_patientenbezogen(id);
--       Gruppe: tiefenpsychologisch bis 10
CREATE TABLE gruppe_tiefenpsychologisch_bis10 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_tiefenpsychologisch_bis10_id on gruppe_tiefenpsychologisch_bis10(id);
--       Gruppe: tiefenpsychologisch ab 11
CREATE TABLE gruppe_tiefenpsychologisch_ab11 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_tiefenpsychologisch_ab11_id on gruppe_tiefenpsychologisch_ab11(id);
--       Gruppe: verhaltenstherapeutisch bis 10
CREATE TABLE gruppe_verhaltenstherapeutisch_bis10 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_verhaltenstherapeutisch_bis10_id on gruppe_verhaltenstherapeutisch_bis10(id);
--       Gruppe: verhaltenstherapeutisch ab 11
CREATE TABLE gruppe_verhaltenstherapeutisch_ab11 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_verhaltenstherapeutisch_ab11_id on gruppe_verhaltenstherapeutisch_ab11(id);
--       Gruppe: andere verbale bis 10
CREATE TABLE gruppe_andere_verbale_bis10 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_andere_verbale_bis10_id on gruppe_andere_verbale_bis10(id);
--       Gruppe: andere verbale ab 11
CREATE TABLE gruppe_andere_verbale_ab11 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_andere_verbale_ab11_id on gruppe_andere_verbale_ab11(id);
--       Gruppe: Kunst
CREATE TABLE gruppe_kunst (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_kunst_id on gruppe_kunst(id);
--       Gruppe: Musik
CREATE TABLE gruppe_musik (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_musik_id on gruppe_musik(id);
--       Gruppe: Körper
CREATE TABLE gruppe_koerper (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_koerper_id on gruppe_koerper(id);
--       Gruppe: Soziale Interaktion
CREATE TABLE gruppe_soziale_interaktion (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_soziale_interaktion_id on gruppe_soziale_interaktion(id);
--       Gruppe: Entspannung
CREATE TABLE gruppe_entspannung (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_entspannung_id on gruppe_entspannung(id);
--       Gruppe: Meditation
CREATE TABLE gruppe_meditation (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_meditation_id on gruppe_meditation(id);
--       Gruppe: Themenzentriert
CREATE TABLE gruppe_themenzentriert (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_themenzentriert_id on gruppe_themenzentriert(id);
--       Indikationsgruppe
CREATE TABLE gruppe_indikation (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_indikation_id on gruppe_indikation(id);
--       andere Gruppe
CREATE TABLE gruppe_andere (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_andere_id on gruppe_andere(id);
--       Milieu-Gruppe: Klinik-Versammlung
CREATE TABLE gruppe_milieu_versammlung (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_milieu_versammlung_id on gruppe_milieu_versammlung(id);
--       Milieu-Gruppe: themenzentriert
CREATE TABLE gruppe_milieu_themenzentriert (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_milieu_themenzentriert_id on gruppe_milieu_themenzentriert(id);
--       Milieu-Gruppe: andere
CREATE TABLE gruppe_milieu_andere (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_milieu_andere_id on gruppe_milieu_andere(id);
--       Einzel: tiefenpsychologisch
CREATE TABLE einzel_tiefenpsychologisch (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX einzel_tiefenpsychologisch_id on einzel_tiefenpsychologisch(id);
--       Einzel: verhaltenstherapeutisch
CREATE TABLE einzel_verhaltenstherapeutisch (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX einzel_verhaltenstherapeutisch_id on einzel_verhaltenstherapeutisch(id);
--       Einzel: andere verbale Therapie
CREATE TABLE einzel_andere_verbale (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX einzel_andere_verbale_id on einzel_andere_verbale(id);
--       Einzel: Paar/Familie
CREATE TABLE einzel_paar (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX einzel_paar_id on einzel_paar(id);
--       Einzel: Kunst
CREATE TABLE einzel_kunst (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX einzel_kunst_id on einzel_kunst(id);
--       Einzel: Musik
CREATE TABLE einzel_musik (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX einzel_musik_id on einzel_musik(id);
--       Einzel: Körper
CREATE TABLE einzel_koerper (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX einzel_koerper_id on einzel_koerper(id);
--       Einzel: Entspannung
CREATE TABLE einzel_entspannung (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX einzel_entspannung_id on einzel_entspannung(id);
--       Einzel: Meditation
CREATE TABLE einzel_meditation (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX einzel_meditation_id on einzel_meditation(id);
--       Einzel: Themenzentriert
CREATE TABLE einzel_themenzentriert (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX einzel_themenzentriert_id on einzel_themenzentriert(id);
--       Einzel: andere Sonstige
CREATE TABLE einzel_andere_sonstige (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX einzel_andere_sonstige_id on einzel_andere_sonstige(id);
--       Milieu-Einzel: Soziotherapie
CREATE TABLE einzel_milieu_sozio (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX einzel_milieu_sozio_id on einzel_milieu_sozio(id);
--       Milieu-Einzel: andere
CREATE TABLE einzel_milieu_andere (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX einzel_milieu_andere_id on einzel_milieu_andere(id);
--       Soma-Gruppe
CREATE TABLE gruppe_soma (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_soma_id on gruppe_soma(id);
--       Soma-Einzel
CREATE TABLE einzel_soma (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX einzel_soma_id on einzel_soma(id);
--       Balneo
CREATE TABLE balneotherapie (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX balneotherapie_id on balneotherapie(id);
-- Index 9: KTL Reha

--       Gruppe: tiefenpsychologisch bis 12
CREATE TABLE gruppe_tiefenpsychologisch_bis12 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_tiefenpsychologisch_bis12_id on gruppe_tiefenpsychologisch_bis12(id);
--       Gruppe: tiefenpsychologisch ab 13
CREATE TABLE gruppe_tiefenpsychologisch_ab13 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_tiefenpsychologisch_ab13_id on gruppe_tiefenpsychologisch_ab13(id);
--       Gruppe: verhaltenstherapeutisch bis 12
CREATE TABLE gruppe_verhaltenstherapeutisch_bis12 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_verhaltenstherapeutisch_bis12_id on gruppe_verhaltenstherapeutisch_bis12(id);
--       Gruppe: verhaltenstherapeutisch ab 13
CREATE TABLE gruppe_verhaltenstherapeutisch_ab13 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_verhaltenstherapeutisch_ab13_id on gruppe_verhaltenstherapeutisch_ab13(id);
--       Gruppe: andere verbale bis 12
CREATE TABLE gruppe_andere_verbale_bis12 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_andere_verbale_bis12_id on gruppe_andere_verbale_bis12(id);
--       Gruppe: andere verbale ab 13
CREATE TABLE gruppe_andere_verbale_ab13 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    dauer       INTERVAL,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX gruppe_andere_verbale_ab13_id on gruppe_andere_verbale_ab13(id);
-- -      psych. ICD-10-Diagnosen
CREATE TABLE ktl2007 (
    id          INTEGER REFERENCES datensatz ON DELETE CASCADE,
    typ         INTEGER REFERENCES ktl2007_typ,
    ktl2007_dauer INTEGER REFERENCES ktl2007_dauer_typ,
    anzahl      INTEGER,
    valid       INTEGER REFERENCES validity_typ
);
CREATE INDEX ktl2007_id on ktl2007(id);
