#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#bado_therapeut.py: main program for starting the bado-gui V4 with full access
#Copyright (C) 2008 qualitas GmbH
#Author: S�nke von Heymann <svheymann@iqp-online.de>
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

import sys, os
os.chdir(os.path.dirname(os.path.abspath(sys.argv[0])))
from bado_start import BadoStart
from PyQt4 import QtCore, QtGui

import argparse

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='PsyBADO Datenerfassungstool')
    parser.add_argument('-patnr', help='Patientennummer')
    parser.add_argument('-nname', help='Nachname Patient')
    parser.add_argument('-vname', help='Vorname Patient')
    args = parser.parse_args()
    app = QtGui.QApplication(sys.argv)
    app.setStyle(QtGui.QStyleFactory.create('Plastique'))
    pixmap = QtGui.QPixmap('./images/splash.png')
    splash = QtGui.QLabel(flags=QtCore.Qt.FramelessWindowHint|QtCore.Qt.WindowStaysOnTopHint)
    splash.setAttribute(QtCore.Qt.WA_TranslucentBackground)
    splash.setPixmap(pixmap)
    splash.show()

    app.processEvents() 
    import time
    time.sleep(2)
    splash.close()
    mainWindow = BadoStart(guiType = 1, args = args)
    
    mainWindow.show()
    
    sys.exit(app.exec_())
