#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#db_helperlib.py: helper functions for database operations
#Copyright (C) 2008 qualitas GmbH
#Author: S�nke von Heymann <svheymann@iqp-online.de>
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

import psycopg2
import psycopg2.psycopg1
import re
import qualiconfV4
import mx.DateTime 
from mx.DateTime import DateTime, TimeDelta, oneDay, strptime, Date
import time
import types
from itertools import *
config = qualiconfV4.check

psycopg2.extensions.register_type(psycopg2.extensions.UNICODE)
psycopg2.extensions.register_type(psycopg2.extensions.UNICODEARRAY)
DEC2FLOAT = psycopg2.extensions.new_type(
    psycopg2.extensions.DECIMAL.values,
    'DEC2FLOAT',
    lambda value, curs: float(value) if value is not None else None)
psycopg2.extensions.register_type(DEC2FLOAT)



db_conn = []
db_curs = []

def connectToDb(dbname='badoV4', user='bado-gui', host='localhost', port='5432', password=''):
    login = "dbname=%s user=%s host=%s port=%s password='%s'" %(dbname,user,host,port,password)
    global db_conn 
    global db_curs 
    #print 'CONNECT', db_conn
    #print db_curs
    if db_curs == []:
        try:
            db_conn = psycopg2.psycopg1.connect(login)
        except psycopg2.OperationalError:
            return False
        db_curs = db_conn.cursor()
        #print 'CONNECTED', db_conn
        #print db_curs
        return True
    
def checkpasswd(dbname='badoV4', user='bado-gui', host='localhost', port='5432', password=''):
    login = "dbname=%s user=%s host=%s port=%s password='%s'" %(dbname,user,host,port,password)
    try:
        db_conn = psycopg2.psycopg1.connect(login)
    except psycopg2.OperationalError:
        return False
    return True
    
def disconnectFromDb():
    global db_conn 
    global db_curs 
    if not db_curs == []:
        db_curs.close()
        db_conn.close()
    db_conn = []
    db_curs = []
    #print 'DICONNECTED',db_conn
    #print db_curs

def query_seq(query, params=None):
    db_curs.execute(query, params)
    return db_curs.fetchall()

def query_one(query, params={}):
    try:
        db_curs.execute(query)
        #db_curs.execute(query, params)
        erg = db_curs.fetchone()
    except Exception, err:
        #print query, params
        raise err
    if erg and len(erg) > 0:
        return erg[0]
    else:
        return []

def query_dict(query, params={}):
    db_curs.execute(query)
    #db_curs.execute(query, params)
    return db_curs.dictfetchall()

def query_execute(query, params={}):
    try:
        db_curs.execute(query)
        db_conn.commit()
    except Exception, err:
        raise err
    return

def dropDb(databasename):
    db_conn.set_isolation_level(0)
    #print databasename
    query = """DROP DATABASE IF EXISTS "%s" """ % databasename
    #print query
    db_curs.execute(query)
    db_conn.commit()
    db_conn.set_isolation_level(psycopg2.extensions.ISOLATION_LEVEL_READ_COMMITTED)
    
def createDb(databasename):
    db_conn.set_isolation_level(0)
    query = """CREATE DATABASE "%s" ENCODING 'UTF8'""" % databasename
    db_curs.execute(query)
    db_conn.commit()
    #db_conn.set_isolation_level(psycopg2.extensions.ISOLATION_LEVEL_READ_COMMITTED)

def getLock(behandler_nr=None, patienten_nr=None, id=None):
    if behandler_nr and patienten_nr:
        #print 'LOCK:',behandler_nr, patienten_nr
        query = "SELECT pg_try_advisory_lock(id), id FROM datensatz WHERE behandler_nr = '%s' AND patienten_nr = '%s' " % (behandler_nr, patienten_nr)
    elif id:
        #print 'LOCK:',id
        query = "SELECT pg_try_advisory_lock(%s)" % id
    return query_one(query)


def releaseLock(behandler_nr=None, patienten_nr=None, id=None):
    #print behandler_nr, patienten_nr, id
    if behandler_nr and patienten_nr:
        #print 'UNLOCK:',behandler_nr, patienten_nr
        query = "SELECT pg_advisory_unlock(id), id FROM datensatz WHERE behandler_nr = '%s' AND patienten_nr = '%s' " % (behandler_nr, patienten_nr)
    elif id:
        #print 'UNLOCK:',id
        #query = "SELECT pg_advisory_unlock(id), id FROM datensatz WHERE id = %s " % id
        query = "SELECT pg_advisory_unlock(%s)" % id
    ret = query_one(query)
    # release multiple locks
    iRepeat = 0
    while ret == True and iRepeat < 10:
        #print 'UNLOCK:', patienten_nr, id, ret
        ret = query_one(query)
        iRepeat = iRepeat + 1
    #print ret
    return ret

    
def getUserListe():
    query = "SELECT rolname, rolsuper, rolpassword FROM pg_authid where not rolname = 'guiusers'" 
    dataList = query_seq(query)
    return dataList


    

def insertUser(username, password):
    #print 'CREATE USER:', username, password
    query = """CREATE ROLE "%s" WITH LOGIN ENCRYPTED PASSWORD '%s' VALID UNTIL 'infinity'""" % (username, password)
    db_curs.execute(query)
    query = """GRANT guiusers TO "%s" """ % (username)
    db_curs.execute(query)
    db_conn.commit()

def changePassword(username, password):
    #print 'CHANGE PASSWORD:', username, password
    query = """ALTER ROLE "%s" WITH ENCRYPTED PASSWORD '%s'""" % (username, password)
    db_curs.execute(query)
    db_conn.commit()
    
def deleteUser(username):
    #print 'DELETE USER:', username
    query = """DROP ROLE "%s" """ % (username)
    db_curs.execute(query)
    db_conn.commit()
    
def toggleSuperUser(username):
    #print 'TOGGLE SUPERUSER:', username
    query = """SELECT rolsuper FROM pg_authid where rolname='%s' """ % username
    erg = query_one(query)
    #print erg
    if erg == True:
        query = """ALTER ROLE "%s" NOSUPERUSER """ % (username)
    elif erg == False:
        query = """ALTER ROLE "%s" SUPERUSER """ % (username)
    else:
        return
    db_curs.execute(query)
    db_conn.commit()
    
def checkSuperUser(username):
    #print 'CHECK SUPERUSER:', username
    query = """SELECT rolsuper FROM pg_authid where rolname='%s' """ % username
    return query_one(query)

def getPatientenlisteFromDatabase(behandler_nr):
    query = "SELECT patienten_nr, vorname, nachname FROM datensatz WHERE behandler_nr = %s" % behandler_nr
    dataList = query_seq(query)
    return dataList

def getJahrgangsExport(behandler_nr, jahrgang):
    query = """SELECT d.patienten_nr, i1.indexes, i2.indexes_v
            FROM datensatz d
             LEFT JOIN aufnahmedatum a ON d.id = a.id 
             LEFT JOIN entlassungsdatum e ON d.id = e.id
             LEFT JOIN behandlungsdauer b ON d.id = b.id
             LEFT JOIN index_all i1 ON d.id = i1.id
             LEFT JOIN index_all_v i2 ON d.id = i2.id
             WHERE d.behandler_nr = %s AND (
                   extract(year from e.datum) = %s 
                   OR (e.datum IS NULL AND extract(year from b.dauer + a.datum) = %s) 
                   OR (e.datum IS NULL AND b.dauer IS NULL AND extract(year from a.datum) = %s))""" % (behandler_nr, jahrgang, jahrgang, jahrgang)
    #print query
    dataList = query_seq(query)
    
    #rint 'dataList', dataList
    return dataList

def getDbExport():
    query = """SELECT d.patienten_nr, i1.indexes, i2.indexes_v
            FROM datensatz d
             LEFT JOIN index_all i1 ON d.id = i1.id
             LEFT JOIN index_all_v i2 ON d.id = i2.id """
    #print query
    dataList = query_seq(query)
    
    #print 'dataList', dataList
    return dataList

def getdbDictFromDatabase(behandler_nr, patienten_nr, returnvalids = True):
    dataLine = u''
    validLine = u''
    
    query = """SELECT 'indexes' AS label, array_to_string(array[
NULLIF((select index1 from index1 i1 where i1.behandler_nr = %(behandler_nr)s AND i1.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index2 from index2 i2 where i2.behandler_nr = %(behandler_nr)s AND i2.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index3 from index3 i3 where i3.behandler_nr = %(behandler_nr)s AND i3.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index4 from index4 i4 where i4.behandler_nr = %(behandler_nr)s AND i4.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index5 from index5 i5 where i5.behandler_nr = %(behandler_nr)s AND i5.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index6 from index6 i6 where i6.behandler_nr = %(behandler_nr)s AND i6.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index7 from index7 i7 where i7.behandler_nr = %(behandler_nr)s AND i7.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index8 from index8 i8 where i8.behandler_nr = %(behandler_nr)s AND i8.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index9 from index9 i9 where i9.behandler_nr = %(behandler_nr)s AND i9.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index10 from index10 i10 where i10.behandler_nr = %(behandler_nr)s AND i10.patienten_nr = '%(patienten_nr)s') ,'')
],'|') AS indexes
UNION SELECT 'indexes_v', array_to_string(array[
NULLIF((select index1 from index1_v i1 where i1.behandler_nr = %(behandler_nr)s AND i1.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index2 from index2_v i2 where i2.behandler_nr = %(behandler_nr)s AND i2.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index3 from index3_v i3 where i3.behandler_nr = %(behandler_nr)s AND i3.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index4 from index4_v i4 where i4.behandler_nr = %(behandler_nr)s AND i4.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index5 from index5_v i5 where i5.behandler_nr = %(behandler_nr)s AND i5.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index6 from index6_v i6 where i6.behandler_nr = %(behandler_nr)s AND i6.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index7 from index7_v i7 where i7.behandler_nr = %(behandler_nr)s AND i7.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index8 from index8_v i8 where i8.behandler_nr = %(behandler_nr)s AND i8.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index9 from index9_v i9 where i9.behandler_nr = %(behandler_nr)s AND i9.patienten_nr = '%(patienten_nr)s') ,''),
NULLIF((select index10 from index10_v i10 where i10.behandler_nr = %(behandler_nr)s AND i10.patienten_nr = '%(patienten_nr)s') ,'')
],'|')""" % {'behandler_nr':behandler_nr, 'patienten_nr':patienten_nr}
    #print query
    dataList = query_seq(query)
    
    #print 'dataList', dataList
    return dataList


def getDatensatzId(behandler_nr, patienten_nr):
    query = u"""SELECT id FROM datensatz WHERE behandler_nr = %s and patienten_nr = '%s' """ % (behandler_nr, patienten_nr)
    id = query_one(query)
    return id
    
def deleteDatensatz(behandler_nr=None, patienten_nr=None, id=None):
    if behandler_nr and patienten_nr:
        query = u"""DELETE FROM datensatz WHERE behandler_nr = %s and patienten_nr = '%s' """ % (behandler_nr, patienten_nr)
        query_execute(query)
    elif id:
        query = u"""DELETE FROM datensatz WHERE id = %s """ % (id)
        query_execute(query)

def writeDictToDatabse(daten, datei_id, daten_jahr, verbose=False, vorname = 'NULL', nachname = 'NULL', behandler_nr = '1'):
    for behandler in daten.keys():
        for patient in daten[behandler].keys():
            datensatz = daten[behandler][patient]
            #print datensatz
            #print type(datensatz)
            #behandler_nr = datensatz['behandler_nr']['wert']
            if type(datensatz.items()[0][1]) == types.ListType:
                patienten_nr = patient
                sub_behandler_nr = datensatz.items()[0][1][0]['sub_behandler_nr']['wert']
            else:
                patienten_nr = patient
                sub_behandler_nr = datensatz['sub_behandler_nr']['wert']
            if verbose:
                print "Klinik: %s \tPatient: %s" % (behandler_nr, patienten_nr)
            # Den Datensatz anlegen:
            #print type(daten_jahr), type(patienten_nr), type(behandler_nr), type(datei_id), type(vorname), type(nachname)
            query = "INSERT INTO datensatz (insert_time, daten_jahr, patienten_nr, behandler_nr, sub_behandler_nr, datei_id, vorname, nachname) VALUES ('now', %d, '%s', %d, '%s', '%s', '%s', '%s' )" % (int(daten_jahr), patienten_nr, int(behandler_nr), sub_behandler_nr, datei_id, vorname, nachname)
            #print query
            db_curs.execute(query)
            # Ueber alle Felder iterieren:
            
            for spalten_name, wert in datensatz.items():
                # diagnosen werden separat abgehandelt
                sql = {}
                sql['insert'] = ''
                sql['values'] = ''
                #print spalten_name, wert
                if type(wert) == types.ListType:
                    try:
                        for wert_item in wert:
                            for multi_name, multi_wert in wert_item.items():
                                #print 'multi-name', multi_name, multi_wert
                                # datensatz-eintrÃ¤ge wie ISR, SCL, etc brauchen zuerst den isr_datensatz-eintrag
                                if config[multi_name].has_key('db_has_pkey'):
                                    if type(multi_wert['wert']) == types.NoneType:
                                        raise StopIteration()
                                    query = """ INSERT INTO %(db_tabelle)s (id, %(db_spalte)s, valid)""" % config[multi_name]
                                    query += """ VALUES (currval('datensatz_id_seq'), '%s', %d)""" % (multi_wert['wert'],multi_wert['validity'])
                                    #print query
                                    db_curs.execute(query)
                                    break
                            for multi_name, multi_wert in wert_item.items():
                                # datensatz-eintrag wurde schon in der schleife vorher gesetzt
                                if config[multi_name].has_key('db_has_pkey'):
                                    continue
                                if config[multi_name].has_key('db_datensatz'):
                                    sql['insert'] = ', eintrag_id ' 
                                    sql['values'] = ", currval('" + config[multi_name]['db_datensatz'] + "_eintrag_id_seq') "
                                writeItem(multi_name, multi_wert, sql)
                    except StopIteration:
                        pass
                elif config[spalten_name]['db_tabelle'] in ['psychische_diagnose', 'somatische_diagnose']:
                    continue
                else:
                    writeItem(spalten_name, wert, sql)
    
            # Sonderfall diagnosen
            for diag_type in ['psychische_diagnose','somatische_diagnose']:
                if not datensatz.has_key(diag_type):
                    continue
                #print datensatz[diag_type]
                diag = datensatz[diag_type]
                sicher_type = diag_type + '_sicherheit'
                sicher = datensatz[sicher_type]
                #if not datensatz.has_key(diag_type):
                #    datensatz[sicher_type] = {}
                #    datensatz[sicher_type] = None
                #print 'sicher ',sicher
                seq_nr = 0
                # Falscheingaben abfangen
                if not type(diag['wert']) == types.ListType:
                    diag['wert'] = [diag['wert']]
                    diag['validity'] = [diag['validity']]
                if type(sicher['wert']) == types.NoneType:
                    sicher['wert'] = []
                elif not type(sicher['wert']) == types.ListType:
                    sicher['wert'] = [sicher['wert']]
                    
                #print diag['wert']
                #print 'sicher', sicher
                #if not sicher['wert']
                for item_nr in range(len(diag['wert'])):
                    query = u"INSERT INTO %s (id, typ, valid, sicher, seq_nr)" % diag_type
                    query += u" VALUES (currval('datensatz_id_seq'), "
                    query += u" (SELECT id FROM diagnose_typ WHERE key = '%s'), %d, %s, %d)"
                    #print patienten_nr, sicher['wert'], type(sicher['wert'])
                    if not len(sicher['wert']) == item_nr+1:
                        sicher['wert'].append(None)
                    if diag['wert'][item_nr] == None:
                        diag_wert_str = 'NULL'
                    else:
                        diag_wert_str = diag['wert'][item_nr]
                    if sicher['wert'][item_nr] == None:
                        sicher_wert_str = 'NULL'
                    else:
                        sicher_wert_str = sicher['wert'][item_nr]
                    param = (diag_wert_str, diag['validity'][item_nr], sicher_wert_str, seq_nr)
                    #print (query, param)
                    
                    query = query % param
                    #print 'query
                    db_curs.execute(query)
                    seq_nr += 1
     
    
            # nur die angegebene davon in die DB fallen lassen:
            # (die erste Diagnose == Hauptdiagnose muss aber immer in die DB, da der Datensatz 
            #  durch deren Abwesenheit der ganze Datensatz ungÃ¼ltig wird)
    if verbose: print "Datenbank COMMIT... ",
    # Commit erst nach allen Datensaetzen:
    db_conn.commit()
    if verbose: print "done."


def writeItem(spalten_name, wert, sql):
    #print spalten_name, wert
    # Sonderfall multi-enums
    if config[spalten_name]['typ'] == 'enum_multi':
        #print type(wert)
        if type(wert['wert']) == types.ListType:
            #print 'enum_multi', wert
            for item_nr in range(len(wert['wert'])):
                current_wert = {'wert': wert['wert'][item_nr], 'validity':wert['validity'][item_nr]}
                wert_str = "%(wert)s"
                if wert['wert'][item_nr] is None:
                    wert_str = "NULL"
                query = u"""INSERT INTO "%(db_tabelle)s" (id, "%(db_spalte)s", valid """ % config[spalten_name]
                query += """%s )""" % sql['insert']
                query += "VALUES (currval('datensatz_id_seq'), " + wert_str + ", %(validity)s " + sql['values'] + ")"
                query = query % current_wert
                #print 'writeItem', query
                db_curs.execute(query)
                #print wert['validity'][item_nr], wert['wert'][item_nr], query
            return
    elif config[spalten_name]['typ'] == 'enum_ktl_multi':
        if not type(wert['wert']) == types.ListType:
            wert['wert'] = [wert['wert']]
            wert['validity'] = [wert['validity']]
        for item_nr in range(len(wert['wert'])):
            current_wert = {'wert': wert['wert'][item_nr], 'validity':wert['validity'][item_nr]}
            if wert['wert'][item_nr] is None:
                wert_str = "NULL, NULL, NULL"
            else:
                wert_split = re.findall('[A-Z,a-z]\d+',current_wert['wert'])
                #print wert_split, current_wert['wert']
                typ = wert_split[0]
                dauer = re.findall('[A-Z,a-z]',wert_split[1])[0]
                anzahl = int(re.findall('\d+',wert_split[1])[0])
                #print typ, dauer, anzahl
                wert_str = "(SELECT id FROM %%(db_tabelle)s_typ WHERE key = '%s'), (SELECT id FROM ktl2007_dauer_typ WHERE key = '%s'), %d" % (typ, dauer, anzahl)
                wert_str = wert_str % config[spalten_name]
            query = u"""INSERT INTO "%(db_tabelle)s" (id, "%(db_spalte)s", ktl2007_dauer, anzahl, valid """ % config[spalten_name]
            query += u"""%s )""" % sql['insert']
            query += u"VALUES (currval('datensatz_id_seq'), " + wert_str + ", %(validity)s " + sql['values'] + ")" 
            query = query % current_wert
            #print 'writeItem2', query
            db_curs.execute(query)
            #print wert['validity'][item_nr], wert['wert'][item_nr], query
        return
    # Weitere Sonderfaelle:
    elif config[spalten_name]['db_tabelle'] in ('datensatz'):
        return
    # Eintragen
    wert_str = {'enum':     u"%(wert)s", 
                'enum_multi':     u"%(wert)s", 
                'enum_s':   u"(SELECT id FROM %(db_tabelle)s_typ WHERE key = '%%(wert)s')" % config[spalten_name],
                'interval': u"interval '%(wert)s'",
                'integer':  u"%(wert)d",
                'alpha':    u"%(wert)s",
                'datum':    u"'%(wert)s'",
                'float':    u"%(wert)f"
               }[config[spalten_name]['typ']]
    if wert['wert'] is None:
        wert_str = "NULL"
    if type(wert['wert']).__name__ == 'DateTimeDelta': 
        wertDays = str(wert['wert']).split(':')
        wert['wert']=wert['wert'].strftime('%H:%M:%S')
        if len(wertDays) > 3:
            wert['wert'] = wertDays[0] + ',' + wert['wert']
    query = u"""INSERT INTO "%(db_tabelle)s" (id, "%(db_spalte)s", valid """ % config[spalten_name]
    query += u"""%s )""" % sql['insert']
    query += u"VALUES (currval('datensatz_id_seq'), " + wert_str + ", %(validity)d " + sql['values'] + ")"
    #print wert
    #print "DEBUG: %s" % query
    query = query % wert
    #print "DEBUG: ", query
    db_curs.execute(query)
    
def rangecheck_element(value, spalten_config, config):
    wert = unicode(value).strip()
    if   spalten_config['typ'] == 'enum':
        ret = rangecheck_enum(value=wert, spalten_config=spalten_config)
    elif spalten_config['typ'] == 'enum_s':
        ret = rangecheck_enum(value=wert, spalten_config=spalten_config)
        #print ret
    elif spalten_config['typ'] == 'enum_diag':
        ret = rangecheck_enum_diag(value=wert, spalten_config=spalten_config)
    elif spalten_config['typ'] == 'enum_multi':
        ret = rangecheck_enum_multi(value=wert, spalten_config=spalten_config)
    elif spalten_config['typ'] == 'enum_diag_multi':
        ret = rangecheck_enum_diag_multi(value=wert, spalten_config=spalten_config)
    elif spalten_config['typ'] == 'enum_ktl':
        ret = rangecheck_enum_ktl(value=wert, spalten_config=spalten_config)
    elif spalten_config['typ'] == 'enum_ktl_multi':
        ret = rangecheck_enum_ktl_multi(value=wert, spalten_config=spalten_config)
    elif spalten_config['typ'] == 'integer':
        ret = rangecheck_integer(value=wert, spalten_config=spalten_config)
    elif spalten_config['typ'] == 'interval':
        ret = rangecheck_interval(value=wert, spalten_config=spalten_config)
    elif spalten_config['typ'] == 'datum':
        ret = rangecheck_datum(value=wert, spalten_config=spalten_config)
    elif spalten_config['typ'] == 'float':
        ret = rangecheck_float(value=wert, spalten_config=spalten_config)
    elif spalten_config['typ'] == 'alpha':
        ret = rangecheck_alpha(value=wert, spalten_config=spalten_config)
    else:
        raise ValueError, "Datentyp %s nicht bekannt" % spalten_config['typ'] 
    #if not ret:
    #    print spalten_config
    if not ret.has_key('err') and ret['validity'] <= -10:
        ret['err'] = qualiconfV4.validity[ret['validity']]

    return ret
    
def rangecheck_enum_multi(value, spalten_config):
    if not value:
        return {'wert':None, 'validity':-10}
    #print 'multi: ',value, value.find(','), spalten_config
    if value.find(',') > 0:
        erg = {'wert':[], 'validity':[]}
        for item in value.split(','):
            if not item:
                continue
            #print item
            retval = rangecheck_enum(item, spalten_config)
            erg['wert'].append(retval['wert'])
            erg['validity'].append(retval['validity'])
        #print erg
        return erg
    else:
        return rangecheck_enum(value, spalten_config)

def rangecheck_enum(value, spalten_config):
    # Wert vorhanden?
    #print value, spalten_config
    if not value:
        return {'wert':None, 'validity':-10}
    # Datentyp konvertieren
    try:
        if spalten_config['typ'] == 'enum' or spalten_config['typ'] == 'enum_multi':
            wert = int(value)
        elif spalten_config['typ'] == 'enum_s':
            wert = value.upper()
            wert = re.sub('[^\w]', '', wert)
        else:
            raise ValueError, "Fehler in qualiconf"
    except ValueError:
        return {'wert':None, 'validity':-11}
    # Gibts den Wert?
    werte = [x[0] for x in spalten_config['werte']]
    if wert in werte:
        return {'wert':wert, 'validity':1}
    elif spalten_config.has_key('fehler') and wert in spalten_config['fehler']:
        #print 'Fehler-Bereich: ', wert, spalten_config['fehler']
        return {'wert':None, 'validity':spalten_config['fehler'][wert]}
    else:
        return {'wert':None, 'validity':-14}

def rangecheck_enum_diag_multi(value, spalten_config):
    #print 'RANGECHECK', value, spalten_config['db_tabelle']
    if not value:
        return {'wert':None, 'validity':-10}
    if value.find(',') > 0:
        erg = {'wert':[], 'validity':[]}
        for item in value.split(','):
            if not item:
                continue
            retval = rangecheck_enum_diag(item, spalten_config)
            #print retval
            erg['wert'].append(retval['wert'])
            erg['validity'].append(retval['validity'])
            #if retval['validity'] < 0:
            #    print spalten_config['db_tabelle'],erg['validity'], erg['wert'], value
        #print erg
        return erg
    else:
        return rangecheck_enum_diag(value, spalten_config)


def rangecheck_enum_diag(value, spalten_config):
    # Wert vorhanden?
    
    if not value:
        return {'wert':None, 'validity':-10}
    # Datentyp konvertieren
    try:
        wert = value.upper()
        # Alles, was kein Buchstabe oder Zahl ist, wegwerfen
        wert = re.sub('[^\w]', '', wert)
    except ValueError:
        # Wenn das nicht mÃ¶glich ist --> falscher Datentyp
        return {'wert':None, 'validity':-11}
    # Gibts den Wert?
    werte = [x[0] for x in spalten_config['werte']]
    if wert in werte:
        return {'wert':wert, 'validity':1}
    elif spalten_config.has_key('fehler') and spalten_config['fehler'].has_key(wert):
        return {'wert':wert, 'validity':spalten_config['fehler'][wert]}
    # Mache 4(3)-Stelligen Diagnosen gibt es nicht mehr / gibt es noch nicht,
    # Daher werden die 3(2)-stelligen eingetragen.
    elif wert not in werte and (len(wert) == 5 or len(wert) == 4) and wert[:-1] in werte:
        wert = wert[:-1]
        return {'wert':wert, 'validity':1}
    # das gleiche mit 4 nach 2-stelligen diagnosen
    elif wert not in werte and len(wert) == 5 and wert[:-2] in werte:
        wert = wert[:-2]
        return {'wert':wert, 'validity':1}
    # Wenn leer --> nicht angegeben
    elif wert == '':
        return {'wert':None, 'validity':-10}
    else:
        return {'wert':None, 'validity':-14}

def rangecheck_enum_ktl_multi(value, spalten_config):
    #print value
    if not value:
        return {'wert':None, 'validity':-10}
    if value.find(',') > 0:
        erg = {'wert':[], 'validity':[]}
        erg['orig_wert'] = []
        for item in value.split(','):
            if not item:
                continue
            retval = rangecheck_enum_ktl(item, spalten_config)
            #print retval
            erg['wert'].append(retval['wert'])
            erg['validity'].append(retval['validity'])
            erg['orig_wert'].append(item)
            #if retval['validity'] < 0:
            #    print spalten_config['db_tabelle'],erg['validity'], erg['wert'], value
        erritems = [(d,s) for d, s in izip(erg['orig_wert'], erg['validity']) if s<0]
        if erritems:
            erg['err'] = []
            for i in range(len(erg['validity'])):
                errtext = ''
                if erg['validity'][i] < 0:
                    errtext = qualiconfV4.validity[erg['validity'][i]]
                    errtext += ': '
                    if erg['orig_wert'][i]:
                        errtext += erg['orig_wert'][i]
                    else:
                        errtext += ''
                erg['err'].append(errtext)
            #print erg
        return erg
    else:
        return rangecheck_enum_ktl(value, spalten_config)


def rangecheck_enum_ktl(value, spalten_config):
    # Wert vorhanden?
    #print value
    if not value:
        return {'wert':None, 'validity':-10}
    # Datentyp konvertieren
    try:
        wert = value.upper()
        # Alles, was kein Buchstabe oder Zahl ist, wegwerfen
        wert = re.sub('[^\w]', '', wert)
    except ValueError:
        # Wenn das nicht mÃ¶glich ist --> falscher Datentyp
        return {'wert':None, 'validity':-11}
    # Gibts den Wert?
    try:
        wert_split = re.findall('[A-Z,a-z]\d+',wert) 
        typ = wert_split[0]
        dauer = wert_split[1]
    except:
        return {'wert':None, 'validity':-14}
    werte = [x[0] for x in spalten_config['werte']]
    dauer_werte = [x[0] for x in qualiconfV4.db['ktl2007_dauer']]
    #print wert_split[0], wert_split[1][0]
    if wert_split[0] in werte and wert_split[1][0] in dauer_werte:
        return {'wert':wert, 'validity':1}
    elif spalten_config.has_key('fehler') and spalten_config['fehler'].has_key(wert):
        return {'wert':None, 'validity':spalten_config['fehler'][wert]}
    # Wenn leer --> nicht angegeben
    elif wert_split[0] == '' or wert_split[1] == '':
        return {'wert':None, 'validity':-10}
    else:
        return {'wert':None, 'validity':-14}



def rangecheck_integer(value, spalten_config):
    #print value, spalten_config['db_tabelle']
    if not value:
        return {'wert':None, 'validity':-10}
    try:
        iwert = int(value)
    except ValueError:
        return {'wert':None, 'validity':-11}
    if spalten_config['min'] <= int(value) <= spalten_config['max']:
        return {'wert':iwert, 'validity':1}
    elif spalten_config.has_key('fehler') and int(value) in spalten_config['fehler']:
        return {'wert':iwert, 'validity':spalten_config['fehler'][iwert]}
    else:
        return {'wert':iwert, 'validity':-12}


def rangecheck_interval(value, spalten_config):
    if not value:
        return {'wert':None, 'validity':-10}
    # Nach Float konvertieren:
    try:
        fwert = float(re.sub(',', '.', value))
    except ValueError:
        return {'wert':None, 'validity':-11}
    # Im definierten Fehler-Bereich?
    #print value
    if spalten_config.has_key('fehler'):
        if type(spalten_config['fehler']) == type({}) and int(fwert) in spalten_config['fehler']:
            return {'wert':None, 'validity':spalten_config['fehler'][int(fwert)]}
        elif type(spalten_config['fehler']) == type([]):
            for i in range(len(spalten_config['fehler'])):
                if spalten_config['fehler'][i][0] < fwert < spalten_config['fehler'][i][1]:
                    return {'wert':fwert, 'validity':spalten_config['fehler'][i][2]}
    # Negative Intervalle gibt es nicht:
    if fwert < 0:
        return {'wert':None, 'validity':-14}
    # Ein Jahr hat per Definition nur 52 Wochen, 53 werden in 52 umgewandelt
    if spalten_config.has_key('Jahrpfusch') and fwert == 53:
        fwert = 52
    # Nach DateTime konvertieren:
    unit = spalten_config['unit']
    if unit == 'years':
        dwert = oneDay * 365.24 * fwert
    elif unit == 'months':
        dwert = oneDay * 30 * fwert
    elif unit == 'weeks':
        dwert = oneDay * 7 * fwert
    elif unit == 'days':
        dwert = oneDay * 1 * fwert
    elif unit in ('hours', 'minutes', 'seconds'):
        dwert = mx.DateTime.TimeDelta(**{unit:fwert})
    else:
        return {'wert':None, 'validity':-11}
    # Ausserhalb des  Wertebereich?
    if fwert < spalten_config['min']:
        return {'wert':dwert, 'validity':-12}
    elif fwert > spalten_config['max']:
        return {'wert':dwert, 'validity':-12}
    # Ansonsten alles OK:
    return {'wert':dwert, 'validity':1}

def rangecheck_datum(value, spalten_config):
    if not value:
        return {'wert':None, 'validity':-10}
    # Regexp-Check:
    if not re.match('\s*\d{1,2}\.\d{1,2}\.\d{4}\s*',value):
        return {'wert':None, 'validity':-11, 'err':'Datum muss das Format "tt.mm.jjjj" haben'}
    # Konvertieren nach datetime-Objekt
    try:
        dwert = strptime(value, '%d.%m.%Y')
    except:
        return {'wert':None, 'validity':-11}
    # Zwischen 1800 und 2100 ?
    if Date(1800) > dwert:
        return {'wert':dwert, 'validity':-12, 'err':'Datum vor Jahr 1800 nicht erlaubt'}
    if dwert > Date(2100):
        return {'wert':dwert, 'validity':-12, 'err':'Datum nach Jahr 2100 nicht erlaubt'}
    # Else:
    return {'wert':dwert, 'validity':1}
        



def rangecheck_float(value, spalten_config):
    # Wert vorhanden?
    if not value:
        return {'wert':None, 'validity':-10}
    # In Float-Datentyp konvertieren
    try:
        fwert = float(re.sub(',', '.', value))
    except ValueError:
        return {'wert':None, 'validity':-11}
    # Im definierten Fehler-Bereich?
    if spalten_config.has_key('fehler'):
        if type(spalten_config['fehler']) == type({}) and int(fwert) in spalten_config['fehler']:
            return {'wert':None, 'validity':spalten_config['fehler'][int(fwert)]}
        elif type(spalten_config['fehler']) == type([]):
            for i in range(len(spalten_config['fehler'])):
                if spalten_config['fehler'][i][0] < fwert < spalten_config['fehler'][i][1]:
                    return {'wert':fwert, 'validity':spalten_config['fehler'][i][2]}
    #if spalten_config.has_key('fehler'):
    #    for i in range(len(spalten_config['fehler'])):
    #        if spalten_config['fehler'][i][0] < fwert < spalten_config['fehler'][i][1]:
    #            return {'wert':fwert, 'validity':spalten_config['fehler'][i][2]}
    # Im gueltigen Wertebereich?
    if spalten_config['min'] <= fwert <= spalten_config['max']:
        return {'wert':fwert, 'validity':1}
    else:
        return {'wert':fwert, 'validity':-12}



def rangecheck_alpha(value, spalten_config):
    # Wert vorhanden?
    if not value:
        return {'wert':None, 'validity':-10}
    if re.findall('\W', value, re.UNICODE):
        return {'wert':None, 'validity':-11}        
    if spalten_config.has_key('fehler') and value in spalten_config['fehler']:
        return {'wert':value, 'validity':spalten_config['fehler'][value]}
    # Laenge im gueltigen Bereich?
    if spalten_config['min'] <= len(value) <= spalten_config['max']:
        return {'wert':value, 'validity':1}
    else:
        return {'wert':value, 'validity':-12}
    
def strip_control_characters(input):  
      
    if input:  
          
        # unicode invalid characters  
        RE_XML_ILLEGAL = u'([\u0000-\u0008\u000b-\u000c\u000e-\u001f\ufffe-\uffff])' + u'|' + \
                         u'([%s-%s][^%s-%s])|([^%s-%s][%s-%s])|([%s-%s]$)|(^[%s-%s])' % \
                          (unichr(0xd800),unichr(0xdbff),unichr(0xdc00),unichr(0xdfff),  
                           unichr(0xd800),unichr(0xdbff),unichr(0xdc00),unichr(0xdfff),  
                           unichr(0xd800),unichr(0xdbff),unichr(0xdc00),unichr(0xdfff),  
                           )  
        input = re.sub(RE_XML_ILLEGAL, "", input)  
                          
        # ascii control characters  
        input = re.sub(r"[\x01-\x1F\x7F]", "", input)  
              
    return input  
