

BEGIN;
DROP TABLE IF EXISTS datensatz_view;
COMMIT;
BEGIN;
    SELECT d.*, 
        g.datum, 
        a.datum AS aufnahmedatum, t.datum AS entlassungsdatum,
        b.dauer AS behandlungsdauer, r.typ AS versorgungsbereich, 
        null2int(b.valid) = 1 AND 
        null2int(g.valid) = 1 AND 
        null2int(a.valid) = 1 AND 
        null2int(e.valid) = 1 AND 
        null2int(r.valid) = 1 AND 
        null2int(i.valid) = 1 AND 
        null2int(t.valid) = 1 AND 
        d.behandler_nr IS NOT NULL AS valid 
    INTO datensatz_view
    FROM datensatz d 
        LEFT OUTER JOIN geburtsdatum g        ON d.id = g.id                   
        LEFT OUTER JOIN behandlungsdauer b    ON d.id = b.id                       
        LEFT OUTER JOIN aufnahmedatum a       ON d.id = a.id                    
        LEFT OUTER JOIN geschlecht e          ON d.id = e.id                 
        LEFT OUTER JOIN psychische_diagnose i ON d.id = i.id                          
        LEFT OUTER JOIN versorgungsbereich r  ON d.id = r.id                         
        LEFT OUTER JOIN entlassungsdatum t    ON d.id = t.id
    WHERE 
        i.seq_nr = 0;
CREATE INDEX datensatz_view_pkey ON datensatz_view(id);
CREATE INDEX datensatz_view_daten_jahr ON datensatz_view(daten_jahr);
CREATE INDEX datensatz_view_behandler_nr ON datensatz_view(behandler_nr);
CREATE INDEX datensatz_view_behandlungsdauer ON datensatz_view(behandlungsdauer);
CREATE INDEX datensatz_view_aufnahmedatum ON datensatz_view(aufnahmedatum);
CREATE INDEX datensatz_view_versorgungsbereich ON datensatz_view(versorgungsbereich);
CREATE INDEX datensatz_view_entlassungsdatum ON datensatz_view(entlassungsdatum);
COMMIT;


BEGIN;
DROP TABLE IF EXISTS psychische_diagnose_anzahl;
COMMIT;
BEGIN;
    SELECT i.id, max(i.seq_nr) + 1 AS anzahl, every(null2int(i.valid) = 1) AS valid
    INTO psychische_diagnose_anzahl
    FROM datensatz_view d
         LEFT OUTER JOIN psychische_diagnose i ON i.id=d.id
    WHERE 
        d.valid 
    GROUP BY i.id ORDER BY i.id;
CREATE INDEX psychische_diagnose_anzahl_id ON psychische_diagnose_anzahl(id);
COMMIT;


BEGIN;
DROP TABLE IF EXISTS somatische_diagnose_anzahl;
COMMIT;
BEGIN;
  SELECT d.id, sum(INT4(null2int(i.valid) = 1)) AS anzahl, every(null2int(i.valid) = 1) OR sum(INT4(null2int(i.valid) = 1)) = 0 AS valid
    INTO somatische_diagnose_anzahl
    FROM datensatz_view d 
        LEFT OUTER JOIN somatische_diagnose i ON i.id = d.id
    WHERE d.valid
    GROUP BY d.id ORDER BY d.id;
CREATE INDEX somatische_diagnose_anzahl_id ON somatische_diagnose_anzahl(id);
COMMIT;

BEGIN;
DROP TABLE IF EXISTS verweildauer;
COMMIT;
BEGIN;
    SELECT
        a.id,
        e.datum - a.datum AS dauer,
        INT4(null2int(a.valid) = 1 AND null2int(e.valid) = 1 AND days(e.datum - a.datum)>=0) AS valid
    INTO verweildauer
    FROM datensatz_view d
        LEFT OUTER JOIN aufnahmedatum a    ON  a.id = d.id
        LEFT OUTER JOIN entlassungsdatum e ON  e.id = d.id
    WHERE d.valid;
CREATE INDEX verweildauer_id ON verweildauer(id);
COMMIT;

BEGIN;
DROP TABLE IF EXISTS alter_bei_aufnahme_view;
COMMIT;
BEGIN;
    SELECT
        a.id,
        a.datum - e.datum AS alter,
        null2int(a.valid) = 1 AND null2int(e.valid) = 1 AS valid
    INTO alter_bei_aufnahme_view
    FROM  datensatz_view d
        LEFT OUTER JOIN aufnahmedatum a   ON  a.id = d.id 
        LEFT OUTER JOIN geburtsdatum e    ON  e.id = d.id 
    WHERE d.valid;
CREATE INDEX alter_bei_aufnahme_view_id ON alter_bei_aufnahme_view(id);
COMMIT;

BEGIN;
DROP TABLE IF EXISTS altersklassen_view;
COMMIT;
BEGIN;
    SELECT
        a.id,
        (years(a.datum - e.datum)/10)*10 AS alter,
        null2int(a.valid) = 1 AND null2int(e.valid) = 1 AS valid
    INTO altersklassen_view
    FROM  datensatz_view d
        LEFT OUTER JOIN aufnahmedatum a   ON  a.id = d.id 
        LEFT OUTER JOIN geburtsdatum e    ON  e.id = d.id 
    WHERE d.valid;
CREATE INDEX altersklassen_view_id ON altersklassen_view(id);
COMMIT;

BEGIN;
DROP TABLE IF EXISTS vorbehandlung_art;
COMMIT;
BEGIN;
    SELECT
        a.id,
        INT4(a.anzahl > 0) + 2 * INT4(s1.anzahl + s3.anzahl > 0) AS typ,
        null2int(a.valid) = 1 AND null2int(s1.valid) = 1 AND null2int(s3.valid) = 1 AS valid
    INTO vorbehandlung_art
    FROM
        datensatz_view d
        LEFT OUTER JOIN stat_vorbeh_anzahl s1     ON s1.id = d.id                       
        LEFT OUTER JOIN teilstat_vorbeh_anzahl s3 ON s3.id = d.id                          
        LEFT OUTER JOIN amb_vorbeh_anzahl a       ON a.id = d.id                    
    WHERE d.valid;
CREATE INDEX vorbehandlung_art_id ON vorbehandlung_art(id);
COMMIT;

BEGIN;
    DROP TABLE IF EXISTS visiten_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO visiten_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'C010' 
    GROUP BY k.valid, d.id;
CREATE INDEX visiten_ktl2007_id ON visiten_ktl2007(id);
COMMIT;

BEGIN;
    DROP TABLE IF EXISTS gruppe_tiefenpsychologisch_bis12_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_tiefenpsychologisch_bis12_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'G0(4[1-6]|83)' 
    GROUP BY k.valid, d.id;
CREATE INDEX gruppe_tiefenpsychologisch_bis12_ktl2007_id ON gruppe_tiefenpsychologisch_bis12_ktl2007(id);
COMMIT;

BEGIN;
    DROP TABLE IF EXISTS gruppe_verhaltenstherapeutisch_bis12_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_verhaltenstherapeutisch_bis12_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'G073' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_verhaltenstherapeutisch_bis12_ktl2007_id ON gruppe_verhaltenstherapeutisch_bis12_ktl2007(id);
COMMIT;

BEGIN;
    DROP TABLE IF EXISTS gruppe_andere_verbale_bis12_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_andere_verbale_bis12_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ '(G049|G121|G123)' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_andere_verbale_bis12_ktl2007_id ON gruppe_andere_verbale_bis12_ktl2007(id);
COMMIT;

BEGIN;
    DROP TABLE IF EXISTS gruppe_kunst_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_kunst_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'F163' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_kunst_ktl2007_id ON gruppe_kunst_ktl2007(id);
COMMIT;


BEGIN;
    DROP TABLE IF EXISTS gruppe_musik_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_musik_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'F161' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_musik_ktl2007_id ON gruppe_musik_ktl2007(id);
COMMIT;


BEGIN;
    DROP TABLE IF EXISTS gruppe_koerper_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_koerper_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ '(F162|G125)' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_koerper_ktl2007_id ON gruppe_koerper_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS gruppe_soziale_interaktion_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_soziale_interaktion_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'F164' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_soziale_interaktion_ktl2007_id ON gruppe_soziale_interaktion_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS gruppe_entspannung_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_entspannung_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'F0(6[129]|70|8[129]|9[12])' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_entspannung_ktl2007_id ON gruppe_entspannung_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS gruppe_meditation_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_meditation_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'F099' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_meditation_ktl2007_id ON gruppe_meditation_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS gruppe_themenzentriert_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_themenzentriert_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ '(F(05[1489]|140)|G(047|06[149]|077|081|099|102|122))' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_themenzentriert_ktl2007_id ON gruppe_themenzentriert_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS gruppe_indikation_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_indikation_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ '(C(18[19]|48[19]|52[1239])|F0(40|5[23567])|G0(7[124569]|8[245679]|9[1-4]))' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_indikation_ktl2007_id ON gruppe_indikation_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS gruppe_andere_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_andere_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ '(C0(20|42)|G(06[23]|10[139]|12[49]|15[12]|17[12]|190))' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_andere_ktl2007_id ON gruppe_andere_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS gruppe_milieu_versammlung_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_milieu_versammlung_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'D1[01]0' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_milieu_versammlung_ktl2007_id ON gruppe_milieu_versammlung_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS gruppe_milieu_themenzentriert_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_milieu_themenzentriert_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ '(C(0[5678][0-9]|1[0-3][0-9]|2[3-9][0-9]|3[0-9][0-9]|4[0-69][0-9]|5[01][0-9])|M0[12][012])' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_milieu_themenzentriert_ktl2007_id ON gruppe_milieu_themenzentriert_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS gruppe_milieu_andere_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_milieu_andere_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ '(D0[57][0-9]|E(0[3579][0-9]|1[02369][0-9]|2[1-468]0|3[034]0)|L03[0-9])' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_milieu_andere_ktl2007_id ON gruppe_milieu_andere_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS einzel_tiefenpsychologisch_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO einzel_tiefenpsychologisch_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ '(F021|G03[1-6]|G201)' 
    GROUP BY  k.valid, d.id;
CREATE INDEX einzel_tiefenpsychologisch_ktl2007_id ON einzel_tiefenpsychologisch_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS einzel_verhaltenstherapeutisch_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO einzel_verhaltenstherapeutisch_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ '(F022|G05[12]|G202)' 
    GROUP BY  k.valid, d.id;
CREATE INDEX einzel_verhaltenstherapeutisch_ktl2007_id ON einzel_verhaltenstherapeutisch_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS einzel_andere_verbale_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO einzel_andere_verbale_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ '(F(0[13]0|029)|G(0[12]0|039|11[1-59]|180|203))' 
    GROUP BY  k.valid, d.id;
CREATE INDEX einzel_andere_verbale_ktl2007_id ON einzel_andere_verbale_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS einzel_paar_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO einzel_paar_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'G1[34]0' 
    GROUP BY  k.valid, d.id;
CREATE INDEX einzel_paar_ktl2007_id ON einzel_paar_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS einzel_kunst_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO einzel_kunst_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'F153' 
    GROUP BY  k.valid, d.id;
CREATE INDEX einzel_kunst_ktl2007_id ON einzel_kunst_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS einzel_musik_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO einzel_musik_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'F151' 
    GROUP BY  k.valid, d.id;
CREATE INDEX einzel_musik_ktl2007_id ON einzel_musik_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS einzel_koerper_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO einzel_koerper_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'F152' 
    GROUP BY  k.valid, d.id;
CREATE INDEX einzel_koerper_ktl2007_id ON einzel_koerper_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS einzel_andere_sonstige_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO einzel_andere_sonstige_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ '(C0(30|41)|F154)' 
    GROUP BY  k.valid, d.id;
CREATE INDEX einzel_andere_sonstige_ktl2007_id ON einzel_andere_sonstige_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS einzel_milieu_sozio_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO einzel_milieu_sozio_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'D0(10|2[1-69]|3[1-59]|4[1-9])' 
    GROUP BY  k.valid, d.id;
CREATE INDEX einzel_milieu_sozio_ktl2007_id ON einzel_milieu_sozio_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS einzel_milieu_andere_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO einzel_milieu_andere_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ '(C(090|47[1-9])|D0[68]0|E(0[12468][0-9]|1[14578][0-9]|2[0579]0|3[125]0)|G16[12]|H[012][0-9][0-9]|M0[345]0)' 
    GROUP BY k.valid, d.id;
CREATE INDEX einzel_milieu_andere_ktl2007_id ON einzel_milieu_andere_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS gruppe_soma_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO gruppe_soma_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ '(A0[0-9][0-9]|B0[2356][0-9]|C(1[4-79][0-9]|2[012][0-9])|F1[13]0|L0[12][0-9])' 
    GROUP BY  k.valid, d.id;
CREATE INDEX gruppe_soma_ktl2007_id ON gruppe_soma_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS einzel_soma_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO einzel_soma_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ '(A10[123]|B0[147][0-9]|F1[02]0)' 
    GROUP BY  k.valid, d.id;
CREATE INDEX einzel_soma_ktl2007_id ON einzel_soma_ktl2007(id);
COMMIT;



BEGIN;
    DROP TABLE IF EXISTS balneotherapie_ktl2007;
    COMMIT;
BEGIN;
    SELECT 
        d.id, k.valid,  
         
        sum(dt.dauer*k.anzahl) AS dauer 
    INTO balneotherapie_ktl2007
    FROM 
        datensatz_view d, 
        ktl2007 k, 
        ktl2007_dauer_typ dt, 
        ktl2007_typ t 
    WHERE 
        k.ktl2007_dauer = dt.id AND null2int(k.valid) = 1 AND  
        k.typ = t.id AND 
        d.id = k.id AND 
        t.key ~ 'K[0-9][0-9][0-9]' 
    GROUP BY  k.valid, d.id;
CREATE INDEX balneotherapie_ktl2007_id ON balneotherapie_ktl2007(id);
COMMIT;

BEGIN;
DROP TABLE IF EXISTS gesamt_dosis_ktl2007;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        null2interval(w01.dauer) +
        null2interval(w02.dauer) +
        null2interval(w03.dauer) +
        null2interval(w04.dauer) +
        null2interval(w05.dauer) +
        null2interval(w06.dauer) +
        null2interval(w07.dauer) +
        null2interval(w08.dauer) +
        null2interval(w09.dauer) +
        null2interval(w10.dauer) +
        null2interval(w11.dauer) +
        null2interval(w12.dauer) +
        null2interval(w13.dauer) +
        null2interval(w14.dauer) +
        null2interval(w15.dauer) +
        null2interval(w16.dauer) +
        null2interval(w17.dauer) +
        null2interval(w18.dauer) +
        null2interval(w19.dauer) +
        null2interval(w20.dauer) +
        null2interval(w21.dauer) +
        null2interval(w22.dauer) +
        null2interval(w23.dauer) +
        null2interval(w24.dauer) +
        null2interval(w25.dauer) +
        null2interval(w26.dauer) +
        null2interval(w27.dauer) +
        null2interval(w28.dauer) +
        null2interval(w29.dauer) AS dauer, 
        null2int(w01.valid) > -11 AND
        null2int(w02.valid) > -11 AND
        null2int(w03.valid) > -11 AND
        null2int(w04.valid) > -11 AND
        null2int(w05.valid) > -11 AND
        null2int(w06.valid) > -11 AND
        null2int(w07.valid) > -11 AND
        null2int(w08.valid) > -11 AND
        null2int(w09.valid) > -11 AND
        null2int(w10.valid) > -11 AND
        null2int(w11.valid) > -11 AND
        null2int(w12.valid) > -11 AND
        null2int(w13.valid) > -11 AND
        null2int(w14.valid) > -11 AND
        null2int(w15.valid) > -11 AND
        null2int(w16.valid) > -11 AND
        null2int(w17.valid) > -11 AND
        null2int(w18.valid) > -11 AND
        null2int(w19.valid) > -11 AND
        null2int(w20.valid) > -11 AND
        null2int(w21.valid) > -11 AND
        null2int(w22.valid) > -11 AND
        null2int(w23.valid) > -11 AND
        null2int(w24.valid) > -11 AND
        null2int(w25.valid) > -11 AND
        null2int(w26.valid) > -11 AND
        null2int(w27.valid) > -11 AND
        null2int(w28.valid) > -11 AND
        null2int(w29.valid) > -11 AND
        ( 
        null2int(w01.valid) = 1 OR
        null2int(w02.valid) = 1 OR
        null2int(w03.valid) = 1 OR
        null2int(w04.valid) = 1 OR
        null2int(w05.valid) = 1 OR
        null2int(w06.valid) = 1 OR
        null2int(w07.valid) = 1 OR
        null2int(w08.valid) = 1 OR
        null2int(w09.valid) = 1 OR
        null2int(w10.valid) = 1 OR
        null2int(w11.valid) = 1 OR
        null2int(w12.valid) = 1 OR
        null2int(w13.valid) = 1 OR
        null2int(w14.valid) = 1 OR
        null2int(w15.valid) = 1 OR
        null2int(w16.valid) = 1 OR
        null2int(w17.valid) = 1 OR
        null2int(w18.valid) = 1 OR
        null2int(w19.valid) = 1 OR
        null2int(w20.valid) = 1 OR
        null2int(w21.valid) = 1 OR
        null2int(w22.valid) = 1 OR
        null2int(w23.valid) = 1 OR
        null2int(w24.valid) = 1 OR
        null2int(w25.valid) = 1 OR
        null2int(w26.valid) = 1 OR
        null2int(w27.valid) = 1 OR
        null2int(w28.valid) = 1 OR
        null2int(w29.valid) = 1 ) AS valid
    INTO gesamt_dosis_ktl2007
    FROM datensatz_view d 
        LEFT OUTER JOIN visiten_ktl2007 w01                              ON d.id = w01.id                    
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_bis12_ktl2007 w02     ON d.id = w02.id                                             
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_bis12_ktl2007 w03 ON d.id = w03.id                                                 
        LEFT OUTER JOIN gruppe_andere_verbale_bis12_ktl2007 w04          ON d.id = w04.id                                        
        LEFT OUTER JOIN gruppe_kunst_ktl2007 w05                         ON d.id = w05.id                         
        LEFT OUTER JOIN gruppe_musik_ktl2007 w06                         ON d.id = w06.id                         
        LEFT OUTER JOIN gruppe_koerper_ktl2007 w07                       ON d.id = w07.id                           
        LEFT OUTER JOIN gruppe_entspannung_ktl2007 w21                   ON d.id = w21.id                               
        LEFT OUTER JOIN gruppe_meditation_ktl2007 w22                    ON d.id = w22.id                              
        LEFT OUTER JOIN gruppe_themenzentriert_ktl2007 w23               ON d.id = w23.id                                   
        LEFT OUTER JOIN gruppe_soziale_interaktion_ktl2007 w08           ON d.id = w08.id                                       
        LEFT OUTER JOIN gruppe_indikation_ktl2007 w09                    ON d.id = w09.id                              
        LEFT OUTER JOIN gruppe_andere_ktl2007 w10                        ON d.id = w10.id                          
        LEFT OUTER JOIN gruppe_milieu_versammlung_ktl2007 w11            ON d.id = w11.id                                      
        LEFT OUTER JOIN gruppe_milieu_themenzentriert_ktl2007 w12        ON d.id = w12.id                                          
        LEFT OUTER JOIN gruppe_milieu_andere_ktl2007 w13                 ON d.id = w13.id                                 
        LEFT OUTER JOIN einzel_tiefenpsychologisch_ktl2007 w14           ON d.id = w14.id                                       
        LEFT OUTER JOIN einzel_verhaltenstherapeutisch_ktl2007 w15       ON d.id = w15.id                                           
        LEFT OUTER JOIN einzel_andere_verbale_ktl2007 w16                ON d.id = w16.id                                  
        LEFT OUTER JOIN einzel_paar_ktl2007 w17                          ON d.id = w17.id                        
        LEFT OUTER JOIN einzel_kunst_ktl2007 w18                         ON d.id = w18.id                         
        LEFT OUTER JOIN einzel_musik_ktl2007 w19                         ON d.id = w19.id                         
        LEFT OUTER JOIN einzel_koerper_ktl2007 w20                       ON d.id = w20.id                           
        LEFT OUTER JOIN einzel_andere_sonstige_ktl2007 w24               ON d.id = w24.id                                   
        LEFT OUTER JOIN einzel_milieu_sozio_ktl2007 w25                  ON d.id = w25.id                                
        LEFT OUTER JOIN einzel_milieu_andere_ktl2007 w26                 ON d.id = w26.id                                 
        LEFT OUTER JOIN gruppe_soma_ktl2007 w27                          ON d.id = w27.id                        
        LEFT OUTER JOIN einzel_soma_ktl2007 w28                          ON d.id = w28.id                        
        LEFT OUTER JOIN balneotherapie_ktl2007 w29                       ON d.id = w29.id                                   
    WHERE   
        d.valid
;

CREATE INDEX gesamt_dosis_ktl2007_id ON gesamt_dosis_ktl2007(id);
COMMIT;

BEGIN;
DROP TABLE IF EXISTS gesamt_dosis;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        null2interval(w01.dauer) +
        null2interval(w02.dauer) +
        null2interval(w03.dauer) +
        null2interval(w04.dauer) +
        null2interval(w05.dauer) +
        null2interval(w06.dauer) +
        null2interval(w07.dauer) +
        null2interval(w08.dauer) +
        null2interval(w09.dauer) +
        null2interval(w10.dauer) +
        null2interval(w11.dauer) +
        null2interval(w12.dauer) +
        null2interval(w13.dauer) +
        null2interval(w14.dauer) +
        null2interval(w15.dauer) +
        null2interval(w16.dauer) +
        null2interval(w17.dauer) +
        null2interval(w18.dauer) +
        null2interval(w19.dauer) +
        null2interval(w20.dauer) +
        null2interval(w21.dauer) +
        null2interval(w22.dauer) +
        null2interval(w23.dauer) +
        null2interval(w24.dauer) +
        null2interval(w25.dauer) +
        null2interval(w26.dauer) +
        null2interval(w27.dauer) +
        null2interval(w28.dauer) +
        null2interval(w29.dauer) +
        null2interval(w30.dauer) +
        null2interval(w31.dauer) +
        null2interval(w32.dauer) +
        null2interval(w33.dauer) +
        null2interval(w34.dauer) +
        null2interval(w35.dauer) +
        null2interval(w36.dauer) +
        null2interval(w37.dauer) +
        null2interval(w38.dauer) +
        null2interval(w39.dauer) +
        null2interval(w40.dauer) +
        null2interval(w41.dauer) +
        null2interval(w42.dauer) +
        null2interval(w43.dauer) +
        null2interval(w44.dauer) AS dauer, 
        null2int(w01.valid) > -11 AND
        null2int(w02.valid) > -11 AND
        null2int(w03.valid) > -11 AND
        null2int(w04.valid) > -11 AND
        null2int(w05.valid) > -11 AND
        null2int(w06.valid) > -11 AND
        null2int(w07.valid) > -11 AND
        null2int(w08.valid) > -11 AND
        null2int(w09.valid) > -11 AND
        null2int(w10.valid) > -11 AND
        null2int(w11.valid) > -11 AND
        null2int(w12.valid) > -11 AND
        null2int(w13.valid) > -11 AND
        null2int(w14.valid) > -11 AND
        null2int(w15.valid) > -11 AND
        null2int(w16.valid) > -11 AND
        null2int(w17.valid) > -11 AND
        null2int(w18.valid) > -11 AND
        null2int(w19.valid) > -11 AND
        null2int(w20.valid) > -11 AND
        null2int(w21.valid) > -11 AND
        null2int(w22.valid) > -11 AND
        null2int(w23.valid) > -11 AND
        null2int(w24.valid) > -11 AND
        null2int(w25.valid) > -11 AND
        null2int(w26.valid) > -11 AND
        null2int(w27.valid) > -11 AND
        null2int(w28.valid) > -11 AND
        null2int(w29.valid) > -11 AND
        null2int(w30.valid) > -11 AND
        null2int(w31.valid) > -11 AND
        null2int(w32.valid) > -11 AND
        null2int(w33.valid) > -11 AND
        null2int(w34.valid) > -11 AND
        null2int(w35.valid) > -11 AND
        null2int(w36.valid) > -11 AND
        null2int(w37.valid) > -11 AND
        null2int(w38.valid) > -11 AND
        null2int(w39.valid) > -11 AND
        null2int(w40.valid) > -11 AND
        null2int(w41.valid) > -11 AND
        null2int(w42.valid) > -11 AND
        null2int(w43.valid) > -11 AND
        ( 
        null2int(w01.valid) = 1 OR
        null2int(w02.valid) = 1 OR
        null2int(w03.valid) = 1 OR
        null2int(w04.valid) = 1 OR
        null2int(w05.valid) = 1 OR
        null2int(w06.valid) = 1 OR
        null2int(w07.valid) = 1 OR
        null2int(w08.valid) = 1 OR
        null2int(w09.valid) = 1 OR
        null2int(w10.valid) = 1 OR
        null2int(w11.valid) = 1 OR
        null2int(w12.valid) = 1 OR
        null2int(w13.valid) = 1 OR
        null2int(w14.valid) = 1 OR
        null2int(w15.valid) = 1 OR
        null2int(w16.valid) = 1 OR
        null2int(w17.valid) = 1 OR
        null2int(w18.valid) = 1 OR
        null2int(w19.valid) = 1 OR
        null2int(w20.valid) = 1 OR
        null2int(w21.valid) = 1 OR
        null2int(w22.valid) = 1 OR
        null2int(w23.valid) = 1 OR
        null2int(w24.valid) = 1 OR
        null2int(w25.valid) = 1 OR
        null2int(w26.valid) = 1 OR
        null2int(w27.valid) = 1 OR
        null2int(w28.valid) = 1 OR
        null2int(w29.valid) = 1 OR
        null2int(w30.valid) = 1 OR
        null2int(w31.valid) = 1 OR
        null2int(w32.valid) = 1 OR
        null2int(w33.valid) = 1 OR
        null2int(w34.valid) = 1 OR
        null2int(w35.valid) = 1 OR
        null2int(w36.valid) = 1 OR
        null2int(w37.valid) = 1 OR
        null2int(w38.valid) = 1 OR
        null2int(w39.valid) = 1 OR
        null2int(w40.valid) = 1 OR
        null2int(w41.valid) = 1 OR
        null2int(w42.valid) = 1 OR
        null2int(w43.valid) = 1 OR
        w44.valid )AS valid
    INTO gesamt_dosis
    FROM datensatz_view d 
        LEFT OUTER JOIN visiten w01                              ON d.id = w01.id                    
        LEFT OUTER JOIN kontakte_kotherapeutisch w02             ON d.id = w02.id                                     
        LEFT OUTER JOIN besprechung_patientenbezogen w03         ON d.id = w03.id                                         
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_bis10 w04     ON d.id = w04.id                                             
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_ab11 w05      ON d.id = w05.id                                            
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_bis10 w06 ON d.id = w06.id                                                 
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_ab11 w07  ON d.id = w07.id                                                
        LEFT OUTER JOIN gruppe_andere_verbale_bis10 w08          ON d.id = w08.id                                        
        LEFT OUTER JOIN gruppe_andere_verbale_ab11 w09           ON d.id = w09.id                
        LEFT OUTER JOIN gruppe_kunst w10                         ON d.id = w10.id                         
        LEFT OUTER JOIN gruppe_musik w11                         ON d.id = w11.id                         
        LEFT OUTER JOIN gruppe_koerper w12                       ON d.id = w12.id                           
        LEFT OUTER JOIN gruppe_soziale_interaktion w13           ON d.id = w13.id                                       
        LEFT OUTER JOIN gruppe_entspannung w14                   ON d.id = w14.id                               
        LEFT OUTER JOIN gruppe_meditation w15                    ON d.id = w15.id                              
        LEFT OUTER JOIN gruppe_themenzentriert w16               ON d.id = w16.id                                   
        LEFT OUTER JOIN gruppe_indikation w17                    ON d.id = w17.id                              
        LEFT OUTER JOIN gruppe_andere w18                        ON d.id = w18.id                          
        LEFT OUTER JOIN gruppe_milieu_versammlung w19            ON d.id = w19.id                                      
        LEFT OUTER JOIN gruppe_milieu_themenzentriert w20        ON d.id = w20.id                                          
        LEFT OUTER JOIN gruppe_milieu_andere w21                 ON d.id = w21.id                                 
        LEFT OUTER JOIN einzel_tiefenpsychologisch w22           ON d.id = w22.id                                       
        LEFT OUTER JOIN einzel_verhaltenstherapeutisch w23       ON d.id = w23.id                                           
        LEFT OUTER JOIN einzel_andere_verbale w24                ON d.id = w24.id                                  
        LEFT OUTER JOIN einzel_paar w25                          ON d.id = w25.id                        
        LEFT OUTER JOIN einzel_kunst w26                         ON d.id = w26.id                         
        LEFT OUTER JOIN einzel_musik w27                         ON d.id = w27.id                         
        LEFT OUTER JOIN einzel_koerper w28                       ON d.id = w28.id                           
        LEFT OUTER JOIN einzel_entspannung w29                   ON d.id = w29.id                               
        LEFT OUTER JOIN einzel_meditation w30                    ON d.id = w30.id                              
        LEFT OUTER JOIN einzel_themenzentriert w31               ON d.id = w31.id                                   
        LEFT OUTER JOIN einzel_andere_sonstige w32               ON d.id = w32.id                                   
        LEFT OUTER JOIN einzel_milieu_sozio w33                  ON d.id = w33.id                                
        LEFT OUTER JOIN einzel_milieu_andere w34                 ON d.id = w34.id                                 
        LEFT OUTER JOIN gruppe_soma w35                          ON d.id = w35.id                        
        LEFT OUTER JOIN einzel_soma w36                          ON d.id = w36.id                        
        LEFT OUTER JOIN balneotherapie         w37               ON d.id = w37.id                                   
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_bis12 w38     ON d.id = w38.id                                             
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_ab13 w39      ON d.id = w39.id                                            
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_bis12 w40 ON d.id = w40.id                                                 
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_ab13 w41  ON d.id = w41.id                                                
        LEFT OUTER JOIN gruppe_andere_verbale_bis12 w42          ON d.id = w42.id                                        
        LEFT OUTER JOIN gruppe_andere_verbale_ab13 w43           ON d.id = w43.id                
        LEFT OUTER JOIN gesamt_dosis_ktl2007 w44                 ON d.id = w44.id                
    WHERE   
        d.valid
;

CREATE INDEX gesamt_dosis_id ON gesamt_dosis(id);
COMMIT;




BEGIN;
DROP TABLE IF EXISTS gesamt_dosis_pro_tag;
COMMIT;
BEGIN;
    SELECT g.id, g.dauer / days(d.behandlungsdauer) AS dauer, g.valid 
    INTO gesamt_dosis_pro_tag
    FROM datensatz_view d, gesamt_dosis g
    WHERE d.id=g.id AND d.valid AND g.valid;
CREATE INDEX gesamt_dosis_pro_tag_id ON gesamt_dosis_pro_tag(id);
COMMIT;





BEGIN;
DROP TABLE IF EXISTS einzel_milieu_dosis_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
         + null2interval(w02.dauer)
         + null2interval(w03.dauer)
         + null2interval(w04.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -11 AND
        null2int(w02.valid) > -11 AND
        null2int(w03.valid) > -11 AND
        null2int(w04.valid) > -11 AND
        (
        null2int(w01.valid) > -10 OR
        null2int(w02.valid) > -10 OR
        null2int(w03.valid) > -10 OR
        null2int(w04.valid) > -10 ) AS valid
    INTO einzel_milieu_dosis_pro_tag
    FROM datensatz_view d 
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN einzel_milieu_sozio	 w01 ON d.id = w01.id
        LEFT OUTER JOIN einzel_milieu_andere w02 ON d.id = w02.id
        LEFT OUTER JOIN einzel_milieu_sozio_ktl2007	 w03 ON d.id = w03.id
        LEFT OUTER JOIN einzel_milieu_andere_ktl2007 w04 ON d.id = w04.id
    WHERE d.valid AND g.valid 
    ;
CREATE INDEX einzel_milieu_dosis_pro_tag_id ON einzel_milieu_dosis_pro_tag(id);
COMMIT;
 




BEGIN;
DROP TABLE IF EXISTS gruppe_milieu_dosis_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
         + null2interval(w02.dauer)
         + null2interval(w03.dauer)
         + null2interval(w04.dauer)
         + null2interval(w05.dauer)
         + null2interval(w06.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -11 AND
        null2int(w02.valid) > -11 AND
        null2int(w03.valid) > -11 AND
        null2int(w04.valid) > -11 AND
        null2int(w05.valid) > -11 AND
        null2int(w06.valid) > -11 AND
        (
        null2int(w01.valid) > -10 OR
        null2int(w02.valid) > -10 OR
        null2int(w03.valid) > -10 OR
        null2int(w04.valid) > -10 OR
        null2int(w05.valid) > -10 OR
        null2int(w06.valid) > -10 ) AS valid
    INTO gruppe_milieu_dosis_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN gruppe_milieu_versammlung w01     ON d.id = w01.id
        LEFT OUTER JOIN gruppe_milieu_themenzentriert w02 ON d.id = w02.id
        LEFT OUTER JOIN gruppe_milieu_andere w03          ON d.id = w03.id
        LEFT OUTER JOIN gruppe_milieu_versammlung_ktl2007 w04     ON d.id = w04.id
        LEFT OUTER JOIN gruppe_milieu_themenzentriert_ktl2007 w05 ON d.id = w05.id
        LEFT OUTER JOIN gruppe_milieu_andere_ktl2007 w06          ON d.id = w06.id
    WHERE d.valid
        AND g.valid
    ;
CREATE INDEX gruppe_milieu_dosis_pro_tag_id ON gruppe_milieu_dosis_pro_tag(id);
COMMIT;
 

BEGIN;
DROP TABLE IF EXISTS visiten_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
         + null2interval(w02.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -11 AND
        null2int(w02.valid) > -11 AND
        (
        null2int(w01.valid) > -10 OR
        null2int(w02.valid) > -10 ) AS valid
    INTO visiten_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN visiten	w01 ON d.id = w01.id
        LEFT OUTER JOIN visiten_ktl2007	w02 ON d.id = w02.id
    WHERE g.valid AND d.valid
    ;
CREATE INDEX visiten_pro_tag_id ON visiten_pro_tag(id);
COMMIT;



BEGIN;
DROP TABLE IF EXISTS kontakte_kotherapeutisch_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -10 
        AS valid
    INTO kontakte_kotherapeutisch_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN  kontakte_kotherapeutisch	w01 ON d.id = w01.id
    WHERE  
        d.valid
        AND g.valid
    ;
CREATE INDEX kontakte_kotherapeutisch_pro_tag_id ON kontakte_kotherapeutisch_pro_tag(id);
COMMIT;



BEGIN;
DROP TABLE IF EXISTS besprechung_patientenbezogen_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -10 
        AS valid
    INTO besprechung_patientenbezogen_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN besprechung_patientenbezogen	w01 ON d.id = w01.id
    WHERE 
        d.valid
        AND g.valid
    ;
CREATE INDEX besprechung_patientenbezogen_pro_tag_id ON besprechung_patientenbezogen_pro_tag(id);
COMMIT;



BEGIN;
DROP TABLE IF EXISTS einzel_dosis_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
          + null2interval(w02.dauer)
          + null2interval(w03.dauer)
          + null2interval(w04.dauer)
          + null2interval(w05.dauer)
          + null2interval(w06.dauer)
          + null2interval(w07.dauer)
          + null2interval(w08.dauer)
          + null2interval(w09.dauer)
          + null2interval(w10.dauer)
          + null2interval(w11.dauer)
          + null2interval(w12.dauer)
          + null2interval(w13.dauer)
          + null2interval(w14.dauer)
          + null2interval(w15.dauer)
          + null2interval(w16.dauer)
          + null2interval(w17.dauer)
          + null2interval(w18.dauer)
          + null2interval(w19.dauer)
          + null2interval(w20.dauer)
          + null2interval(w21.dauer)
          + null2interval(w22.dauer)
          + null2interval(w23.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -11 AND 
        null2int(w02.valid) > -11 AND  
        null2int(w03.valid) > -11 AND  
        null2int(w04.valid) > -11 AND  
        null2int(w05.valid) > -11 AND  
        null2int(w06.valid) > -11 AND  
        null2int(w07.valid) > -11 AND  
        null2int(w08.valid) > -11 AND  
        null2int(w09.valid) > -11 AND  
        null2int(w10.valid) > -11 AND  
        null2int(w11.valid) > -11 AND  
        null2int(w12.valid) > -11 AND  
        null2int(w13.valid) > -11 AND 
        null2int(w14.valid) > -11 AND  
        null2int(w15.valid) > -11 AND  
        null2int(w16.valid) > -11 AND  
        null2int(w17.valid) > -11 AND  
        null2int(w18.valid) > -11 AND  
        null2int(w19.valid) > -11 AND  
        null2int(w20.valid) > -11 AND  
        null2int(w21.valid) > -11 AND  
        null2int(w22.valid) > -11 AND  
        null2int(w23.valid) > -11 AND  
        (
        null2int(w01.valid) > -10 OR
        null2int(w02.valid) > -10 OR
        null2int(w03.valid) > -10 OR
        null2int(w04.valid) > -10 OR
        null2int(w05.valid) > -10 OR
        null2int(w06.valid) > -10 OR
        null2int(w07.valid) > -10 OR
        null2int(w08.valid) > -10 OR
        null2int(w09.valid) > -10 OR
        null2int(w10.valid) > -10 OR
        null2int(w11.valid) > -10 OR
        null2int(w12.valid) > -10 OR
        null2int(w13.valid) > -10 OR
        null2int(w14.valid) > -10 OR
        null2int(w15.valid) > -10 OR
        null2int(w16.valid) > -10 OR
        null2int(w17.valid) > -10 OR
        null2int(w18.valid) > -10 OR
        null2int(w19.valid) > -10 OR
        null2int(w20.valid) > -10 OR
        null2int(w21.valid) > -10 OR
        null2int(w22.valid) > -10 OR
        null2int(w23.valid) > -10 ) AS valid
    INTO einzel_dosis_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN einzel_tiefenpsychologisch	w01     ON d.id = w01.id                                           
        LEFT OUTER JOIN einzel_verhaltenstherapeutisch	w02 ON d.id = w02.id                                               
        LEFT OUTER JOIN einzel_andere_verbale	w03         ON d.id = w03.id                                       
        LEFT OUTER JOIN einzel_paar	w04                     ON d.id = w04.id                           
        LEFT OUTER JOIN einzel_kunst	w05                 ON d.id = w05.id                               
        LEFT OUTER JOIN einzel_musik	w06                 ON d.id = w06.id                               
        LEFT OUTER JOIN einzel_koerper	w07                 ON d.id = w07.id                               
        LEFT OUTER JOIN einzel_entspannung	w08             ON d.id = w08.id                                   
        LEFT OUTER JOIN einzel_meditation	w09             ON d.id = w09.id                                   
        LEFT OUTER JOIN einzel_themenzentriert	w10         ON d.id = w10.id                                       
        LEFT OUTER JOIN einzel_andere_sonstige	w11         ON d.id = w11.id                                       
        LEFT OUTER JOIN einzel_milieu_sozio	w12             ON d.id = w12.id                                   
        LEFT OUTER JOIN einzel_milieu_andere	w13         ON d.id = w13.id
        LEFT OUTER JOIN einzel_tiefenpsychologisch_ktl2007	w14     ON d.id = w14.id                                           
        LEFT OUTER JOIN einzel_verhaltenstherapeutisch_ktl2007	w15 ON d.id = w15.id                                               
        LEFT OUTER JOIN einzel_andere_verbale_ktl2007	w16         ON d.id = w16.id                                       
        LEFT OUTER JOIN einzel_paar_ktl2007	w17                     ON d.id = w17.id                           
        LEFT OUTER JOIN einzel_kunst_ktl2007	w18                 ON d.id = w18.id                               
        LEFT OUTER JOIN einzel_musik_ktl2007	w19                 ON d.id = w19.id                               
        LEFT OUTER JOIN einzel_koerper_ktl2007	w20                 ON d.id = w20.id                               
        LEFT OUTER JOIN einzel_andere_sonstige_ktl2007	w21         ON d.id = w21.id                                       
        LEFT OUTER JOIN einzel_milieu_sozio_ktl2007	w22             ON d.id = w22.id                                   
        LEFT OUTER JOIN einzel_milieu_andere_ktl2007	w23         ON d.id = w23.id
    WHERE d.valid AND g.valid
    ;
CREATE INDEX einzel_dosis_pro_tag_id ON einzel_dosis_pro_tag(id);
COMMIT;
 
BEGIN;
DROP TABLE IF EXISTS einzel_psychotherapie_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
          + null2interval(w02.dauer)
          + null2interval(w03.dauer)
          + null2interval(w04.dauer)
          + null2interval(w05.dauer)
          + null2interval(w06.dauer)
          + null2interval(w07.dauer)
          + null2interval(w08.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -11 AND 
        null2int(w02.valid) > -11 AND  
        null2int(w03.valid) > -11 AND  
        null2int(w04.valid) > -11 AND
        null2int(w05.valid) > -11 AND 
        null2int(w06.valid) > -11 AND  
        null2int(w07.valid) > -11 AND  
        null2int(w08.valid) > -11 AND
        (
        null2int(w01.valid) > -10 OR
        null2int(w02.valid) > -10 OR
        null2int(w03.valid) > -10 OR
        null2int(w04.valid) > -10 OR
        null2int(w05.valid) > -10 OR
        null2int(w06.valid) > -10 OR
        null2int(w07.valid) > -10 OR
        null2int(w08.valid) > -10
        ) AS valid
    INTO einzel_psychotherapie_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN einzel_tiefenpsychologisch	w01     ON d.id = w01.id                                           
        LEFT OUTER JOIN einzel_verhaltenstherapeutisch	w02 ON d.id = w02.id                                               
        LEFT OUTER JOIN einzel_andere_verbale	w03         ON d.id = w03.id                                       
        LEFT OUTER JOIN einzel_paar	w04                     ON d.id = w04.id                           
        LEFT OUTER JOIN einzel_tiefenpsychologisch_ktl2007	w05     ON d.id = w05.id                                           
        LEFT OUTER JOIN einzel_verhaltenstherapeutisch_ktl2007	w06 ON d.id = w06.id                                               
        LEFT OUTER JOIN einzel_andere_verbale_ktl2007	w07         ON d.id = w07.id                                       
        LEFT OUTER JOIN einzel_paar_ktl2007	w08                     ON d.id = w08.id                           
    WHERE d.valid AND g.valid
    ;
CREATE INDEX einzel_psychotherapie_pro_tag_id ON einzel_psychotherapie_pro_tag(id);
COMMIT;
 
BEGIN;
DROP TABLE IF EXISTS einzel_spezialtherapie_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
          + null2interval(w02.dauer)
          + null2interval(w03.dauer)
          + null2interval(w04.dauer)
          + null2interval(w05.dauer)
          + null2interval(w06.dauer)
          + null2interval(w07.dauer)
          + null2interval(w08.dauer)
          + null2interval(w09.dauer)
          + null2interval(w10.dauer)
          + null2interval(w11.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -11 AND 
        null2int(w02.valid) > -11 AND  
        null2int(w03.valid) > -11 AND  
        null2int(w04.valid) > -11 AND  
        null2int(w05.valid) > -11 AND  
        null2int(w06.valid) > -11 AND  
        null2int(w07.valid) > -11 AND  
        null2int(w08.valid) > -11 AND  
        null2int(w09.valid) > -11 AND  
        null2int(w10.valid) > -11 AND  
        null2int(w11.valid) > -11 AND  
        (
        null2int(w01.valid) > -10 OR
        null2int(w02.valid) > -10 OR
        null2int(w03.valid) > -10 OR
        null2int(w04.valid) > -10 OR
        null2int(w05.valid) > -10 OR
        null2int(w06.valid) > -10 OR
        null2int(w07.valid) > -10 OR
        null2int(w08.valid) > -10 OR
        null2int(w09.valid) > -10 OR
        null2int(w10.valid) > -10 OR
        null2int(w11.valid) > -10
        ) AS valid
    INTO einzel_spezialtherapie_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN einzel_kunst	w01                 ON d.id = w01.id                               
        LEFT OUTER JOIN einzel_musik	w02                 ON d.id = w02.id                               
        LEFT OUTER JOIN einzel_koerper	w03                 ON d.id = w03.id                               
        LEFT OUTER JOIN einzel_entspannung	w04             ON d.id = w04.id                                   
        LEFT OUTER JOIN einzel_meditation	w05             ON d.id = w05.id                                   
        LEFT OUTER JOIN einzel_themenzentriert	w06         ON d.id = w06.id                                       
        LEFT OUTER JOIN einzel_andere_sonstige	w07         ON d.id = w07.id                                       
        LEFT OUTER JOIN einzel_kunst_ktl2007	w08                 ON d.id = w08.id                               
        LEFT OUTER JOIN einzel_musik_ktl2007	w09                 ON d.id = w09.id                               
        LEFT OUTER JOIN einzel_koerper_ktl2007	w10                 ON d.id = w10.id                               
        LEFT OUTER JOIN einzel_andere_sonstige_ktl2007	w11         ON d.id = w11.id                                       
    WHERE d.valid AND g.valid
    ;
CREATE INDEX einzel_spezialtherapie_pro_tag_id ON einzel_spezialtherapie_pro_tag(id);
COMMIT;
 
BEGIN;
DROP TABLE IF EXISTS einzel_sonstige_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
          + null2interval(w02.dauer)
          + null2interval(w03.dauer)
          + null2interval(w04.dauer)
          + null2interval(w05.dauer)
          + null2interval(w06.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -11 AND 
        null2int(w02.valid) > -11 AND  
        null2int(w03.valid) > -11 AND  
        null2int(w04.valid) > -11 AND 
        null2int(w05.valid) > -11 AND  
        null2int(w06.valid) > -11 AND  
        (
        null2int(w01.valid) > -10 OR
        null2int(w02.valid) > -10 OR
        null2int(w03.valid) > -10 OR
        null2int(w04.valid) > -10 OR
        null2int(w05.valid) > -10 OR
        null2int(w06.valid) > -10 
        ) AS valid
    INTO einzel_sonstige_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN einzel_milieu_sozio	w01             ON d.id = w01.id                                   
        LEFT OUTER JOIN einzel_milieu_andere	w02         ON d.id = w02.id
        LEFT OUTER JOIN einzel_soma	w03                     ON d.id = w03.id
        LEFT OUTER JOIN einzel_milieu_sozio_ktl2007	w04             ON d.id = w04.id                                   
        LEFT OUTER JOIN einzel_milieu_andere_ktl2007	w05         ON d.id = w05.id
        LEFT OUTER JOIN einzel_soma_ktl2007	w06                     ON d.id = w06.id
    WHERE d.valid AND g.valid
    ;
CREATE INDEX einzel_sonstige_pro_tag_id ON einzel_sonstige_pro_tag(id);
COMMIT;
 

BEGIN;
DROP TABLE IF EXISTS einzel_soma_dosis_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
         + null2interval(w02.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -11 AND
        null2int(w02.valid) > -11 AND
        (
        null2int(w01.valid) > -10 OR
        null2int(w02.valid) > -10 ) AS valid
    INTO einzel_soma_dosis_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN einzel_soma	w01 ON d.id = w01.id
        LEFT OUTER JOIN einzel_soma_ktl2007	w02 ON d.id = w02.id
    WHERE 
        d.valid
        AND g.valid
    ;
CREATE INDEX einzel_soma_dosis_pro_tag_id ON einzel_soma_dosis_pro_tag(id);
COMMIT;
 


BEGIN;
DROP TABLE IF EXISTS gruppe_soma_dosis_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
         + null2interval(w02.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -11 AND
        null2int(w02.valid) > -11 AND
        (
        null2int(w01.valid) > -10 OR
        null2int(w02.valid) > -10 ) AS valid
    INTO gruppe_soma_dosis_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN gruppe_soma  w01 ON d.id = w01.id
        LEFT OUTER JOIN gruppe_soma_ktl2007  w02 ON d.id = w02.id
    WHERE 
        d.valid
        AND g.valid
    ;
CREATE INDEX gruppe_soma_dosis_pro_tag_id ON gruppe_soma_dosis_pro_tag(id);
COMMIT;
 

BEGIN;
DROP TABLE IF EXISTS gruppe_dosis_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
          + null2interval(w02.dauer)
          + null2interval(w03.dauer)
          + null2interval(w04.dauer)
          + null2interval(w05.dauer)
          + null2interval(w06.dauer)
          + null2interval(w07.dauer)
          + null2interval(w08.dauer)
          + null2interval(w09.dauer)
          + null2interval(w10.dauer)
          + null2interval(w11.dauer)
          + null2interval(w12.dauer)
          + null2interval(w13.dauer)
          + null2interval(w14.dauer)
          + null2interval(w15.dauer)
          + null2interval(w16.dauer)
          + null2interval(w17.dauer)
          + null2interval(w18.dauer)
          + null2interval(w19.dauer)
          + null2interval(w20.dauer)
          + null2interval(w21.dauer)
          + null2interval(w22.dauer)
          + null2interval(w23.dauer)
          + null2interval(w24.dauer)
          + null2interval(w25.dauer)
          + null2interval(w26.dauer)
          + null2interval(w27.dauer)
          + null2interval(w28.dauer)
          + null2interval(w29.dauer)
          + null2interval(w30.dauer)
          + null2interval(w31.dauer)
          + null2interval(w32.dauer)
          + null2interval(w33.dauer)
          + null2interval(w34.dauer)
          + null2interval(w35.dauer)
          + null2interval(w36.dauer)
          + null2interval(w37.dauer)
          + null2interval(w38.dauer)
          + null2interval(w39.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -11 AND 
        null2int(w02.valid) > -11 AND 
        null2int(w03.valid) > -11 AND 
        null2int(w04.valid) > -11 AND 
        null2int(w05.valid) > -11 AND 
        null2int(w06.valid) > -11 AND 
        null2int(w07.valid) > -11 AND 
        null2int(w08.valid) > -11 AND 
        null2int(w09.valid) > -11 AND 
        null2int(w10.valid) > -11 AND 
        null2int(w11.valid) > -11 AND 
        null2int(w12.valid) > -11 AND 
        null2int(w13.valid) > -11 AND 
        null2int(w14.valid) > -11 AND 
        null2int(w15.valid) > -11 AND 
        null2int(w16.valid) > -11 AND 
        null2int(w17.valid) > -11 AND 
        null2int(w18.valid) > -11 AND 
        null2int(w19.valid) > -11 AND 
        null2int(w20.valid) > -11 AND 
        null2int(w21.valid) > -11 AND 
        null2int(w22.valid) > -11 AND 
        null2int(w23.valid) > -11 AND 
        null2int(w24.valid) > -11 AND 
        null2int(w25.valid) > -11 AND 
        null2int(w26.valid) > -11 AND 
        null2int(w27.valid) > -11 AND 
        null2int(w28.valid) > -11 AND 
        null2int(w29.valid) > -11 AND 
        null2int(w30.valid) > -11 AND 
        null2int(w31.valid) > -11 AND 
        null2int(w32.valid) > -11 AND 
        null2int(w33.valid) > -11 AND 
        null2int(w34.valid) > -11 AND 
        null2int(w35.valid) > -11 AND 
        null2int(w36.valid) > -11 AND 
        null2int(w37.valid) > -11 AND 
        null2int(w38.valid) > -11 AND 
        null2int(w39.valid) > -11 AND 
        (
        null2int(w01.valid) > -10 OR
        null2int(w02.valid) > -10 OR
        null2int(w03.valid) > -10 OR
        null2int(w04.valid) > -10 OR
        null2int(w05.valid) > -10 OR
        null2int(w06.valid) > -10 OR
        null2int(w07.valid) > -10 OR
        null2int(w08.valid) > -10 OR
        null2int(w09.valid) > -10 OR
        null2int(w10.valid) > -10 OR
        null2int(w11.valid) > -10 OR
        null2int(w12.valid) > -10 OR
        null2int(w13.valid) > -10 OR
        null2int(w14.valid) > -10 OR
        null2int(w15.valid) > -10 OR
        null2int(w16.valid) > -10 OR
        null2int(w17.valid) > -10 OR
        null2int(w18.valid) > -10 OR
        null2int(w19.valid) > -10 OR
        null2int(w20.valid) > -10 OR
        null2int(w21.valid) > -10 OR
        null2int(w22.valid) > -10 OR
        null2int(w23.valid) > -10 OR
        null2int(w24.valid) > -10 OR
        null2int(w25.valid) > -10 OR
        null2int(w26.valid) > -10 OR
        null2int(w27.valid) > -10 OR
        null2int(w28.valid) > -10 OR
        null2int(w29.valid) > -10 OR
        null2int(w30.valid) > -10 OR
        null2int(w31.valid) > -10 OR
        null2int(w32.valid) > -10 OR
        null2int(w33.valid) > -10 OR
        null2int(w34.valid) > -10 OR
        null2int(w35.valid) > -10 OR
        null2int(w36.valid) > -10 OR
        null2int(w37.valid) > -10 OR
        null2int(w38.valid) > -10 OR
        null2int(w39.valid) > -10 ) AS valid
    INTO gruppe_dosis_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_bis10 w01     ON d.id = w01.id                                            
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_ab11 w02      ON d.id = w02.id                                           
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_bis10 w03 ON d.id = w03.id                                                
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_ab11 w04  ON d.id = w04.id                                               
        LEFT OUTER JOIN gruppe_andere_verbale_bis10 w05          ON d.id = w05.id                                       
        LEFT OUTER JOIN gruppe_andere_verbale_ab11 w06           ON d.id = w06.id                                      
        LEFT OUTER JOIN gruppe_kunst w07                         ON d.id = w07.id                        
        LEFT OUTER JOIN gruppe_musik w08                         ON d.id = w08.id                        
        LEFT OUTER JOIN gruppe_koerper w09                       ON d.id = w09.id                          
        LEFT OUTER JOIN gruppe_soziale_interaktion w10           ON d.id = w10.id                                      
        LEFT OUTER JOIN gruppe_entspannung w11                   ON d.id = w11.id                              
        LEFT OUTER JOIN gruppe_meditation w12                    ON d.id = w12.id                             
        LEFT OUTER JOIN gruppe_themenzentriert w13               ON d.id = w13.id                                  
        LEFT OUTER JOIN gruppe_indikation w14                    ON d.id = w14.id                             
        LEFT OUTER JOIN gruppe_andere w15                        ON d.id = w15.id                         
        LEFT OUTER JOIN gruppe_milieu_versammlung w16            ON d.id = w16.id                                     
        LEFT OUTER JOIN gruppe_milieu_themenzentriert w17        ON d.id = w17.id                                         
        LEFT OUTER JOIN gruppe_milieu_andere w18                 ON d.id = w18.id                                
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_bis12 w19     ON d.id = w19.id                                            
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_ab13 w20      ON d.id = w20.id                                           
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_bis12 w21 ON d.id = w21.id                                                
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_ab13 w22  ON d.id = w22.id                                               
        LEFT OUTER JOIN gruppe_andere_verbale_bis12 w23          ON d.id = w23.id                                       
        LEFT OUTER JOIN gruppe_andere_verbale_ab13 w24           ON d.id = w24.id                        
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_bis12_ktl2007 w25     ON d.id = w25.id                                            
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_bis12_ktl2007 w26 ON d.id = w26.id                                                
        LEFT OUTER JOIN gruppe_andere_verbale_bis12_ktl2007 w27          ON d.id = w27.id                                       
        LEFT OUTER JOIN gruppe_kunst_ktl2007 w28                         ON d.id = w28.id                        
        LEFT OUTER JOIN gruppe_musik_ktl2007 w29                         ON d.id = w29.id                        
        LEFT OUTER JOIN gruppe_koerper_ktl2007 w30                       ON d.id = w30.id                          
        LEFT OUTER JOIN gruppe_soziale_interaktion_ktl2007 w31           ON d.id = w31.id                                      
        LEFT OUTER JOIN gruppe_entspannung_ktl2007 w32                   ON d.id = w32.id                              
        LEFT OUTER JOIN gruppe_meditation_ktl2007 w33                    ON d.id = w33.id                             
        LEFT OUTER JOIN gruppe_themenzentriert_ktl2007 w34               ON d.id = w34.id                                  
        LEFT OUTER JOIN gruppe_indikation_ktl2007 w35                    ON d.id = w35.id                             
        LEFT OUTER JOIN gruppe_andere_ktl2007 w36                        ON d.id = w36.id                         
        LEFT OUTER JOIN gruppe_milieu_versammlung_ktl2007 w37            ON d.id = w37.id                                     
        LEFT OUTER JOIN gruppe_milieu_themenzentriert_ktl2007 w38        ON d.id = w38.id                                         
        LEFT OUTER JOIN gruppe_milieu_andere_ktl2007 w39                 ON d.id = w39.id                                
    WHERE d.valid
        AND g.valid
    ;
CREATE INDEX gruppe_dosis_pro_tag_id ON gruppe_dosis_pro_tag(id);
COMMIT;
 
BEGIN;
DROP TABLE IF EXISTS gruppe_psychotherapie_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
          + null2interval(w02.dauer)
          + null2interval(w03.dauer)
          + null2interval(w04.dauer)
          + null2interval(w05.dauer)
          + null2interval(w06.dauer)
          + null2interval(w07.dauer)
          + null2interval(w08.dauer)
          + null2interval(w09.dauer)
          + null2interval(w10.dauer)
          + null2interval(w11.dauer)
          + null2interval(w12.dauer)
          + null2interval(w13.dauer)
          + null2interval(w14.dauer)
          + null2interval(w15.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -11 AND 
        null2int(w02.valid) > -11 AND 
        null2int(w03.valid) > -11 AND 
        null2int(w04.valid) > -11 AND 
        null2int(w05.valid) > -11 AND 
        null2int(w06.valid) > -11 AND 
        null2int(w07.valid) > -11 AND 
        null2int(w08.valid) > -11 AND 
        null2int(w09.valid) > -11 AND 
        null2int(w10.valid) > -11 AND 
        null2int(w11.valid) > -11 AND 
        null2int(w12.valid) > -11 AND 
        null2int(w13.valid) > -11 AND 
        null2int(w14.valid) > -11 AND 
        null2int(w15.valid) > -11 AND 
        (
        null2int(w01.valid) > -10 OR
        null2int(w02.valid) > -10 OR
        null2int(w03.valid) > -10 OR
        null2int(w04.valid) > -10 OR
        null2int(w05.valid) > -10 OR
        null2int(w06.valid) > -10 OR 
        null2int(w07.valid) > -10 OR
        null2int(w08.valid) > -10 OR
        null2int(w09.valid) > -10 OR
        null2int(w10.valid) > -10 OR
        null2int(w11.valid) > -10 OR
        null2int(w12.valid) > -10 OR
        null2int(w13.valid) > -10 OR
        null2int(w14.valid) > -10 OR
        null2int(w15.valid) > -10
        ) AS valid
    INTO gruppe_psychotherapie_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_bis12 w01     ON d.id = w01.id                                            
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_ab13 w02      ON d.id = w02.id                                           
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_bis12 w03 ON d.id = w03.id                                                
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_ab13 w04  ON d.id = w04.id                                               
        LEFT OUTER JOIN gruppe_andere_verbale_bis12 w05          ON d.id = w05.id                                       
        LEFT OUTER JOIN gruppe_andere_verbale_ab13 w06           ON d.id = w06.id                                      
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_bis10 w07     ON d.id = w07.id                                            
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_ab11 w08      ON d.id = w08.id                                           
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_bis10 w09 ON d.id = w09.id                                                
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_ab11 w10  ON d.id = w10.id                                               
        LEFT OUTER JOIN gruppe_andere_verbale_bis10 w11          ON d.id = w11.id                                       
        LEFT OUTER JOIN gruppe_andere_verbale_ab11 w12           ON d.id = w12.id                                      
        LEFT OUTER JOIN gruppe_tiefenpsychologisch_bis12_ktl2007 w13     ON d.id = w13.id                                            
        LEFT OUTER JOIN gruppe_verhaltenstherapeutisch_bis12_ktl2007 w14 ON d.id = w14.id                                                
        LEFT OUTER JOIN gruppe_andere_verbale_bis12_ktl2007 w15          ON d.id = w15.id                                       
    WHERE d.valid
        AND g.valid
    ;
CREATE INDEX gruppe_psychotherapie_pro_tag_id ON gruppe_psychotherapie_pro_tag(id);
COMMIT;
 
BEGIN;
DROP TABLE IF EXISTS gruppe_spezialtherapie_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
          + null2interval(w02.dauer)
          + null2interval(w03.dauer)
          + null2interval(w04.dauer)
          + null2interval(w05.dauer)
          + null2interval(w06.dauer)
          + null2interval(w07.dauer)
          + null2interval(w08.dauer)
          + null2interval(w09.dauer)
          + null2interval(w10.dauer)
          + null2interval(w11.dauer)
          + null2interval(w12.dauer)
          + null2interval(w13.dauer)
          + null2interval(w14.dauer)
          + null2interval(w15.dauer)
          + null2interval(w16.dauer)
          + null2interval(w17.dauer)
          + null2interval(w18.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -11 AND 
        null2int(w02.valid) > -11 AND 
        null2int(w03.valid) > -11 AND 
        null2int(w04.valid) > -11 AND 
        null2int(w05.valid) > -11 AND 
        null2int(w06.valid) > -11 AND 
        null2int(w07.valid) > -11 AND 
        null2int(w08.valid) > -11 AND 
        null2int(w09.valid) > -11 AND 
        null2int(w10.valid) > -11 AND 
        null2int(w11.valid) > -11 AND 
        null2int(w12.valid) > -11 AND 
        null2int(w13.valid) > -11 AND 
        null2int(w14.valid) > -11 AND 
        null2int(w15.valid) > -11 AND 
        null2int(w16.valid) > -11 AND 
        null2int(w17.valid) > -11 AND 
        null2int(w18.valid) > -11 AND 
        (
        null2int(w01.valid) > -10 OR
        null2int(w02.valid) > -10 OR
        null2int(w03.valid) > -10 OR
        null2int(w04.valid) > -10 OR
        null2int(w05.valid) > -10 OR
        null2int(w06.valid) > -10 OR
        null2int(w07.valid) > -10 OR
        null2int(w08.valid) > -10 OR
        null2int(w09.valid) > -10 OR 
        null2int(w10.valid) > -10 OR
        null2int(w11.valid) > -10 OR
        null2int(w12.valid) > -10 OR
        null2int(w13.valid) > -10 OR
        null2int(w14.valid) > -10 OR
        null2int(w15.valid) > -10 OR
        null2int(w16.valid) > -10 OR
        null2int(w17.valid) > -10 OR
        null2int(w18.valid) > -10) AS valid
    INTO gruppe_spezialtherapie_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN gruppe_kunst w01                         ON d.id = w01.id                        
        LEFT OUTER JOIN gruppe_musik w02                         ON d.id = w02.id                        
        LEFT OUTER JOIN gruppe_koerper w03                       ON d.id = w03.id                          
        LEFT OUTER JOIN gruppe_soziale_interaktion w04           ON d.id = w04.id                                      
        LEFT OUTER JOIN gruppe_entspannung w05                   ON d.id = w05.id                              
        LEFT OUTER JOIN gruppe_meditation w06                    ON d.id = w06.id                             
        LEFT OUTER JOIN gruppe_themenzentriert w07               ON d.id = w07.id                                  
        LEFT OUTER JOIN gruppe_indikation w08                    ON d.id = w08.id                             
        LEFT OUTER JOIN gruppe_andere w09                        ON d.id = w09.id                         
        LEFT OUTER JOIN gruppe_kunst_ktl2007 w10                         ON d.id = w10.id                        
        LEFT OUTER JOIN gruppe_musik_ktl2007 w11                         ON d.id = w11.id                        
        LEFT OUTER JOIN gruppe_koerper_ktl2007 w12                       ON d.id = w12.id                          
        LEFT OUTER JOIN gruppe_soziale_interaktion_ktl2007 w13           ON d.id = w13.id                                      
        LEFT OUTER JOIN gruppe_entspannung_ktl2007 w14                   ON d.id = w14.id                              
        LEFT OUTER JOIN gruppe_meditation_ktl2007 w15                    ON d.id = w15.id                             
        LEFT OUTER JOIN gruppe_themenzentriert_ktl2007 w16               ON d.id = w16.id                                  
        LEFT OUTER JOIN gruppe_indikation_ktl2007 w17                    ON d.id = w17.id                             
        LEFT OUTER JOIN gruppe_andere_ktl2007 w18                        ON d.id = w18.id                         
    WHERE d.valid
        AND g.valid
    ;
CREATE INDEX gruppe_spezialtherapie_pro_tag_id ON gruppe_spezialtherapie_pro_tag(id);
COMMIT;
 


BEGIN;
DROP TABLE IF EXISTS gruppe_sonstige_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
          + null2interval(w02.dauer)
          + null2interval(w03.dauer)
          + null2interval(w04.dauer)
          + null2interval(w05.dauer)
          + null2interval(w06.dauer)
          + null2interval(w07.dauer)
          + null2interval(w08.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -11 AND 
        null2int(w02.valid) > -11 AND 
        null2int(w03.valid) > -11 AND 
        null2int(w04.valid) > -11 AND 
        null2int(w05.valid) > -11 AND 
        null2int(w06.valid) > -11 AND 
        null2int(w07.valid) > -11 AND 
        null2int(w08.valid) > -11 AND 
        (
        null2int(w01.valid) > -10 OR
        null2int(w02.valid) > -10 OR
        null2int(w03.valid) > -10 OR
        null2int(w04.valid) > -10 OR
        null2int(w05.valid) > -10 OR
        null2int(w06.valid) > -10 OR
        null2int(w07.valid) > -10 OR
        null2int(w08.valid) > -10
        ) AS valid
    INTO gruppe_sonstige_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN gruppe_milieu_versammlung w01            ON d.id = w01.id                                     
        LEFT OUTER JOIN gruppe_milieu_themenzentriert w02        ON d.id = w02.id                                         
        LEFT OUTER JOIN gruppe_milieu_andere w03                 ON d.id = w03.id                                
        LEFT OUTER JOIN gruppe_soma  w04                         ON d.id = w04.id
        LEFT OUTER JOIN gruppe_milieu_versammlung_ktl2007 w05            ON d.id = w05.id                                     
        LEFT OUTER JOIN gruppe_milieu_themenzentriert_ktl2007 w06        ON d.id = w06.id                                         
        LEFT OUTER JOIN gruppe_milieu_andere_ktl2007 w07                 ON d.id = w07.id                                
        LEFT OUTER JOIN gruppe_soma_ktl2007  w08                         ON d.id = w08.id
    WHERE d.valid
        AND g.valid
    ;
CREATE INDEX gruppe_sonstige_pro_tag_id ON gruppe_sonstige_pro_tag(id);
COMMIT;
 

BEGIN;
DROP TABLE IF EXISTS balneo_gesamt_pro_tag;
COMMIT;
BEGIN;
    SELECT
        d.id, d.behandlungsdauer, 
        (null2interval(w01.dauer)
         + null2interval(w02.dauer)
        ) / days(d.behandlungsdauer) AS dauer,
        null2int(w01.valid) > -11 AND
        null2int(w02.valid) > -11 AND
        (
        null2int(w01.valid) > -10 OR
        null2int(w02.valid) > -10 ) AS valid
    INTO balneo_gesamt_pro_tag
    FROM datensatz_view d
        LEFT OUTER JOIN  gesamt_dosis g ON d.id = g.id
        LEFT OUTER JOIN balneotherapie w01 ON d.id = w01.id
        LEFT OUTER JOIN balneotherapie_ktl2007 w02 ON d.id = w02.id
    WHERE 
        d.valid
        AND g.valid
    ;
CREATE INDEX balneo_gesamt_pro_tag_id ON balneo_gesamt_pro_tag(id);
COMMIT;
 

BEGIN;
DROP TABLE IF EXISTS isr_depressionscore;
COMMIT;
BEGIN;
    SELECT
        d.id, d2.eintrag_id, 
        ( CASE WHEN w01.valid = 1 THEN w01.typ ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.typ ELSE 0 END + 
          CASE WHEN w03.valid = 1 THEN w03.typ ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.typ ELSE 0 END) /
          CAST ( CASE WHEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.valid ELSE 0 END) <> 0
            THEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.valid ELSE 0 END)
            ELSE 1 END AS REAL ) AS score,
        w01.valid > -10 OR w02.valid > -10 OR w03.valid > -10  OR w04.valid > -10 AS valid
    INTO isr_depressionscore
    FROM datensatz_view d 
         LEFT OUTER JOIN isr_datensatz d2 ON d.id = d2.id 
         LEFT OUTER JOIN isr_d01 w01 ON d2.eintrag_id = w01.eintrag_id
         LEFT OUTER JOIN isr_d02 w02 ON d2.eintrag_id = w02.eintrag_id
         LEFT OUTER JOIN isr_d03 w03 ON d2.eintrag_id = w03.eintrag_id
         LEFT OUTER JOIN isr_d05 w04 ON d2.eintrag_id = w04.eintrag_id
    WHERE   
        d.valid AND d2.valid > 0
    ;
CREATE INDEX isr_depressionscore_id ON isr_depressionscore(id);
COMMIT;

BEGIN;
DROP TABLE IF EXISTS isr_depr_schweregrad;
COMMIT;
BEGIN;
    SELECT d.id, d2.eintrag_id,
        i.score AS score,
        1 + INT4(i.score >= 0.75) + INT4(i.score >= 1) + INT4(i.score >= 2) + INT4(i.score >= 3) AS grad,
        i.valid AS valid
    INTO isr_depr_schweregrad
    FROM datensatz_view d
        LEFT OUTER JOIN isr_datensatz d2 ON d.id = d2.id
        LEFT OUTER JOIN isr_depressionscore i ON d2.eintrag_id = i.eintrag_id
    WHERE d.valid AND d2.valid > 0;
CREATE INDEX isr_depr_schweregrad_id ON isr_depr_schweregrad(id);
COMMIT;

 

BEGIN;
DROP TABLE IF EXISTS isr_angstscore;
COMMIT;
BEGIN;
    SELECT
        d.id, d2.eintrag_id,
        ( CASE WHEN w01.valid = 1 THEN w01.typ ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.typ ELSE 0 END +
          CASE WHEN w03.valid = 1 THEN w03.typ ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.typ ELSE 0 END) /
          CAST ( CASE WHEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.valid ELSE 0 END) <> 0
            THEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.valid ELSE 0 END)
            ELSE 1 END AS REAL ) AS score,
        w01.valid > -10 OR w02.valid > -10 OR w03.valid > -10  OR w04.valid > -10 AS valid
    INTO isr_angstscore
    FROM datensatz_view d 
        LEFT OUTER JOIN isr_datensatz d2  ON d.id = d2.id
        LEFT OUTER JOIN isr_a01 w01       ON d2.eintrag_id = w01.eintrag_id  
        LEFT OUTER JOIN isr_a02 w02       ON d2.eintrag_id = w02.eintrag_id
        LEFT OUTER JOIN isr_a03 w03       ON d2.eintrag_id = w03.eintrag_id
        LEFT OUTER JOIN isr_a04 w04       ON d2.eintrag_id = w04.eintrag_id
    WHERE  d.valid 
        AND d2.valid > 0;
CREATE INDEX isr_angstscore_id ON isr_angstscore(id);
COMMIT;

BEGIN;
DROP TABLE IF EXISTS isr_angst_schweregrad;
COMMIT;
BEGIN;
    SELECT d.id, d2.eintrag_id,
        i.score AS score,
        1 + INT4(i.score >= 0.75) + INT4(i.score >= 1) + INT4(i.score >= 2) + INT4(i.score >= 3) AS grad,
        i.valid AS valid
    INTO isr_angst_schweregrad
    FROM datensatz_view d
        LEFT OUTER JOIN isr_angstscore i ON d.id = i.id 
        LEFT OUTER JOIN isr_datensatz d2 ON i.eintrag_id = d2.eintrag_id
    WHERE d.valid AND d2.valid > 0;
CREATE INDEX isr_angst_schweregrad_id ON isr_angst_schweregrad(id);
COMMIT;



BEGIN;
DROP TABLE IF EXISTS isr_zwangscore;
COMMIT;
BEGIN;
    SELECT
        d.id, d2.eintrag_id,
        ( CASE WHEN w01.valid = 1 THEN w01.typ ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.typ ELSE 0 END +
          CASE WHEN w03.valid = 1 THEN w03.typ ELSE 0 END) /
          CAST ( CASE WHEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END) <> 0
            THEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END)
            ELSE 1 END AS REAL ) AS score,
        w01.valid > -10 OR w02.valid > -10 OR w03.valid > -10 AS valid
    INTO isr_zwangscore
    FROM datensatz_view d 
        LEFT OUTER JOIN isr_datensatz d2   ON d.id = d2.id
        LEFT OUTER JOIN isr_z01 w01        ON d2.eintrag_id = w01.eintrag_id 
        LEFT OUTER JOIN isr_z02 w02        ON d2.eintrag_id = w02.eintrag_id
        LEFT OUTER JOIN isr_z03 w03        ON d2.eintrag_id = w03.eintrag_id
    WHERE d.valid
        AND d2.valid > 0;
CREATE INDEX isr_zwangscore_id ON isr_zwangscore(id);
COMMIT;


BEGIN;
DROP TABLE IF EXISTS isr_zwang_schweregrad;
COMMIT;
BEGIN;
    SELECT d.id, d2.eintrag_id,
        i.score AS score,
        1 + INT4(i.score >= 0.65) + INT4(i.score >= 1) + INT4(i.score >= 2) + INT4(i.score >= 3) AS grad,
        i.valid AS valid
    INTO isr_zwang_schweregrad
    FROM datensatz_view d
        LEFT OUTER JOIN isr_datensatz d2 ON d2.id = d.id
        LEFT OUTER JOIN isr_zwangscore i ON i.eintrag_id = d2.eintrag_id 
    WHERE d.valid AND d2.valid > 0;
CREATE INDEX isr_zwang_schweregrad_id ON isr_zwang_schweregrad(id);
COMMIT;


BEGIN;
DROP TABLE IF EXISTS isr_somatisierungscore;
COMMIT;
BEGIN;
    SELECT
        d.id, d2.eintrag_id,
        ( CASE WHEN w01.valid = 1 THEN w01.typ ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.typ ELSE 0 END +
          CASE WHEN w03.valid = 1 THEN w03.typ ELSE 0 END) /
          CAST ( CASE WHEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END) <> 0
            THEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END)
            ELSE 1 END AS REAL ) AS score,
        w01.valid > -10 OR w02.valid > -10 OR w03.valid > -10 AS valid
    INTO isr_somatisierungscore
    FROM datensatz_view d 
        LEFT OUTER JOIN isr_datensatz d2  ON d.id = d2.id
        LEFT OUTER JOIN isr_s01 w01       ON d2.eintrag_id = w01.eintrag_id 
        LEFT OUTER JOIN isr_s02 w02       ON d2.eintrag_id = w02.eintrag_id
        LEFT OUTER JOIN isr_s03 w03       ON d2.eintrag_id = w03.eintrag_id
    WHERE d.valid
        AND d2.valid > 0;
CREATE INDEX isr_somatisierungscore_id ON isr_somatisierungscore(id);
COMMIT;


BEGIN;
DROP TABLE IF EXISTS isr_soma_schweregrad;
COMMIT;
BEGIN;
    SELECT d.id, d2.eintrag_id,
        i.score AS score,
        1 + INT4(i.score >= 0.32) + INT4(i.score >= 0.75) + INT4(i.score >= 1.25) + INT4(i.score >= 2.65) AS grad,
        i.valid AS valid
    INTO isr_soma_schweregrad
    FROM datensatz_view d
        LEFT OUTER JOIN isr_datensatz d2         ON d.id = d2.id
        LEFT OUTER JOIN isr_somatisierungscore i ON i.eintrag_id = d2.eintrag_id 
    WHERE d.valid AND d2.valid > 0;
CREATE INDEX isr_soma_schweregrad_id ON isr_soma_schweregrad(id);
COMMIT;


BEGIN;
DROP TABLE IF EXISTS isr_essstoerungscore;
COMMIT;
BEGIN;
    SELECT
        d.id, d2.eintrag_id,
        ( CASE WHEN w01.valid = 1 THEN w01.typ ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.typ ELSE 0 END +
          CASE WHEN w03.valid = 1 THEN w03.typ ELSE 0 END) /
          CAST ( CASE WHEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END) <> 0
            THEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END)
            ELSE 1 END AS REAL ) AS score,
        w01.valid > -10 OR w02.valid > -10 OR w03.valid > -10 AS valid
    INTO isr_essstoerungscore
    FROM datensatz_view d 
        LEFT OUTER JOIN isr_datensatz d2   ON d.id = d2.id
        LEFT OUTER JOIN isr_e01 w01        ON d2.eintrag_id = w01.eintrag_id 
        LEFT OUTER JOIN isr_e02 w02        ON d2.eintrag_id = w02.eintrag_id
        LEFT OUTER JOIN isr_e03 w03        ON d2.eintrag_id = w03.eintrag_id
    WHERE d.valid
        AND d2.valid > 0;
CREATE INDEX isr_essstoerungscore_id ON isr_essstoerungscore(id);
COMMIT;

BEGIN;
DROP TABLE IF EXISTS isr_ess_schweregrad;
COMMIT;
BEGIN;
    SELECT d.id, d2.eintrag_id,
        i.score AS score,
        1 + INT4(i.score >= 0.32) + INT4(i.score >= 0.65) + INT4(i.score >= 1.5) + INT4(i.score >= 2.75) AS grad,
        i.valid AS valid
    INTO isr_ess_schweregrad
    FROM datensatz_view d
        LEFT OUTER JOIN isr_datensatz d2       ON d.id = d2.id
        LEFT OUTER JOIN isr_essstoerungscore i ON i.eintrag_id = d2.eintrag_id 
    WHERE d.valid AND d2.valid > 0;
CREATE INDEX isr_ess_schweregrad_id ON isr_ess_schweregrad(id);
COMMIT;



BEGIN;
DROP TABLE IF EXISTS isr_zusatzscore;
COMMIT;
BEGIN;
    SELECT
        d.id,  d2.eintrag_id,
        ( CASE WHEN w01.valid = 1 THEN w01.typ ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.typ ELSE 0 END +
          CASE WHEN w03.valid = 1 THEN w03.typ ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.typ ELSE 0 END +
          CASE WHEN w05.valid = 1 THEN w05.typ ELSE 0 END + CASE WHEN w06.valid = 1 THEN w06.typ ELSE 0 END +
          CASE WHEN w07.valid = 1 THEN w07.typ ELSE 0 END + CASE WHEN w08.valid = 1 THEN w08.typ ELSE 0 END +
          CASE WHEN w09.valid = 1 THEN w09.typ ELSE 0 END + CASE WHEN w10.valid = 1 THEN w10.typ ELSE 0 END +
          CASE WHEN w11.valid = 1 THEN w11.typ ELSE 0 END + CASE WHEN w12.valid = 1 THEN w12.typ ELSE 0 END) /
          CAST ( CASE WHEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.valid ELSE 0 END +
            CASE WHEN w05.valid = 1 THEN w05.valid ELSE 0 END + CASE WHEN w06.valid = 1 THEN w06.valid ELSE 0 END +
            CASE WHEN w07.valid = 1 THEN w07.valid ELSE 0 END + CASE WHEN w08.valid = 1 THEN w08.valid ELSE 0 END +
            CASE WHEN w09.valid = 1 THEN w09.valid ELSE 0 END + CASE WHEN w10.valid = 1 THEN w10.valid ELSE 0 END +
            CASE WHEN w11.valid = 1 THEN w11.valid ELSE 0 END + CASE WHEN w12.valid = 1 THEN w12.valid ELSE 0 END ) <> 0
            THEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.valid ELSE 0 END +
            CASE WHEN w05.valid = 1 THEN w05.valid ELSE 0 END + CASE WHEN w06.valid = 1 THEN w06.valid ELSE 0 END +
            CASE WHEN w07.valid = 1 THEN w07.valid ELSE 0 END + CASE WHEN w08.valid = 1 THEN w08.valid ELSE 0 END +
            CASE WHEN w09.valid = 1 THEN w09.valid ELSE 0 END + CASE WHEN w10.valid = 1 THEN w10.valid ELSE 0 END +
            CASE WHEN w11.valid = 1 THEN w11.valid ELSE 0 END + CASE WHEN w12.valid = 1 THEN w12.valid ELSE 0 END )
            ELSE 1 END AS REAL ) AS score,
        w01.valid > -10 OR w02.valid > -10 OR w03.valid > -10 OR w04.valid > -10 OR 
        w05.valid > -10 OR w06.valid > -10 OR w07.valid > -10 OR w08.valid > -10 OR 
        w09.valid > -10 OR w10.valid > -10 OR w11.valid > -10 OR w12.valid > -10 AS valid 
    INTO isr_zusatzscore
    FROM datensatz_view d 
        LEFT OUTER JOIN isr_datensatz d2 ON d.id = d2.id
        LEFT OUTER JOIN isr_d04 w01      ON d2.eintrag_id = w01.eintrag_id 
        LEFT OUTER JOIN isr_d10 w02      ON d2.eintrag_id = w02.eintrag_id  
        LEFT OUTER JOIN isr_d11 w03      ON d2.eintrag_id = w03.eintrag_id  
        LEFT OUTER JOIN isr_d12 w04      ON d2.eintrag_id = w04.eintrag_id  
        LEFT OUTER JOIN isr_w01 w05      ON d2.eintrag_id = w05.eintrag_id  
        LEFT OUTER JOIN isr_w02 w06      ON d2.eintrag_id = w06.eintrag_id 
        LEFT OUTER JOIN isr_w03 w07      ON d2.eintrag_id = w07.eintrag_id  
        LEFT OUTER JOIN isr_w05 w08      ON d2.eintrag_id = w08.eintrag_id  
        LEFT OUTER JOIN isr_w06 w09      ON d2.eintrag_id = w09.eintrag_id  
        LEFT OUTER JOIN isr_w07 w10      ON d2.eintrag_id = w10.eintrag_id  
        LEFT OUTER JOIN isr_w08 w11      ON d2.eintrag_id = w11.eintrag_id  
        LEFT OUTER JOIN isr_w09 w12      ON d2.eintrag_id = w12.eintrag_id  
    WHERE 
        d.valid
        AND d2.valid > 0;
CREATE INDEX isr_zusatzscore_id ON isr_zusatzscore(id);
COMMIT;


BEGIN;
DROP TABLE IF EXISTS isr_gesamtscore;
COMMIT;
BEGIN;
    SELECT
        d.id,  d2.eintrag_id,
        ( CASE WHEN w01.valid THEN w01.score ELSE 0 END + CASE WHEN w02.valid THEN w02.score ELSE 0 END +
          CASE WHEN w03.valid THEN w03.score ELSE 0 END + CASE WHEN w04.valid THEN w04.score ELSE 0 END +
          CASE WHEN w05.valid THEN w05.score ELSE 0 END + CASE WHEN w06.valid THEN w06.score*2 ELSE 0 END ) /
          CAST ( CASE WHEN
          ( CASE WHEN w01.valid THEN 1 ELSE 0 END + CASE WHEN w02.valid THEN 1 ELSE 0 END +
            CASE WHEN w03.valid THEN 1 ELSE 0 END + CASE WHEN w04.valid THEN 1 ELSE 0 END +
            CASE WHEN w05.valid THEN 1 ELSE 0 END + CASE WHEN w06.valid THEN 1 ELSE 0 END ) <> 0
            THEN
          ( CASE WHEN w01.valid THEN 1 ELSE 0 END + CASE WHEN w02.valid THEN 1 ELSE 0 END +
            CASE WHEN w03.valid THEN 1 ELSE 0 END + CASE WHEN w04.valid THEN 1 ELSE 0 END +
            CASE WHEN w05.valid THEN 1 ELSE 0 END + CASE WHEN w06.valid THEN 2 ELSE 0 END )
            ELSE 1 END AS REAL ) AS score,
        w01.valid OR w02.valid OR w03.valid OR w04.valid OR 
        w05.valid OR w06.valid AS valid 
    INTO isr_gesamtscore
    FROM datensatz_view d 
        LEFT OUTER JOIN isr_datensatz d2            ON d.id = d2.id
        LEFT OUTER JOIN isr_depressionscore w01     ON d2.eintrag_id = w01.eintrag_id                       
        LEFT OUTER JOIN isr_angstscore w02          ON d2.eintrag_id = w02.eintrag_id                  
        LEFT OUTER JOIN isr_zwangscore w03          ON d2.eintrag_id = w03.eintrag_id                  
        LEFT OUTER JOIN isr_somatisierungscore w04  ON d2.eintrag_id = w04.eintrag_id                          
        LEFT OUTER JOIN isr_essstoerungscore w05    ON d2.eintrag_id = w05.eintrag_id                        
        LEFT OUTER JOIN isr_zusatzscore w06         ON d2.eintrag_id = w06.eintrag_id                   
    WHERE 
        d.valid
        AND d2.valid > 0;
CREATE INDEX isr_gesamtscore_id ON isr_gesamtscore(id);
COMMIT;

BEGIN;
DROP TABLE IF EXISTS isr_gesamt_schweregrad;
COMMIT;
BEGIN;
    SELECT d.id, d2.eintrag_id,
        i.score AS score,
        1 + INT4(i.score >= 0.5)+ INT4(i.score >= 0.6) + INT4(i.score >= 0.9) + INT4(i.score >= 1.7) AS grad,
        i.valid AS valid
    INTO isr_gesamt_schweregrad
    FROM datensatz_view d
        LEFT OUTER JOIN isr_datensatz d2  ON d.id = d2.id
        LEFT OUTER JOIN isr_gesamtscore i ON i.eintrag_id = d2.eintrag_id
    WHERE d.valid AND d2.valid > 0;
CREATE INDEX isr_gesamt_schweregrad_id ON isr_gesamt_schweregrad(id);
COMMIT;


BEGIN;
DROP TABLE IF EXISTS gaf_schweregrad;
COMMIT;
BEGIN;
    SELECT d.id,
        i.typ,
        1 + INT4(i.typ < 8) + INT4(i.typ < 7) + INT4(i.typ < 6) + INT4(i.typ < 5 AND i.typ > 0)AS grad,
        i.valid AS valid
    INTO gaf_schweregrad
    FROM datensatz_view d
        LEFT OUTER JOIN gaf_a i ON i.id = d.id
    WHERE d.valid AND i.valid > 0;
CREATE INDEX gaf_schweregrad_id ON gaf_schweregrad(id);
COMMIT;



DROP VIEW IF EXISTS index1 CASCADE;

CREATE VIEW index1

AS

WITH psycat AS (
SELECT
p.id,
coalesce(array_to_string(array_agg(t.key ORDER BY p.seq_nr),',','')::text,'') AS diag,
coalesce(array_to_string(array_agg(p.sicher::text ORDER BY p.seq_nr),',','')::text,'') AS sicher,
coalesce(array_to_string(array_agg(p.valid::text ORDER BY p.seq_nr),',','')::text,'') AS valid
FROM
psychische_diagnose p
JOIN diagnose_typ t ON p.typ = t.id

GROUP BY p.id ORDER BY p.id),




somacat AS (
SELECT
p.id,
coalesce(array_to_string(array_agg(t.key ORDER BY p.seq_nr),',','')::text,'') AS diag,
coalesce(array_to_string(array_agg(p.sicher::text ORDER BY p.seq_nr),',','')::text,'') AS sicher,
coalesce(array_to_string(array_agg(p.valid::text ORDER BY p.seq_nr),',','')::text,'') AS valid
FROM
somatische_diagnose p
JOIN diagnose_typ t ON p.typ = t.id

GROUP BY p.id ORDER BY p.id)


SELECT
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[      
coalesce(1::text,''),
coalesce(d.behandler_nr::text,'')        ,
coalesce(d.sub_behandler_nr::text,'')    ,
coalesce(d.patienten_nr::text,'')       ,
coalesce(n1.typ::text,'')                ,
coalesce(to_char(n2.datum ,'DD.MM.YYYY')::text,'')             ,
coalesce(n3.typ::text,'')                ,
coalesce(n4.typ::text,'')                ,
coalesce(n5.typ::text,'')                ,
coalesce(n6.typ::text,'')                ,
coalesce(n7.typ::text,'')                ,
coalesce(n8.typ::text,'')                ,
coalesce(n9.anzahl::text,'')             ,
coalesce(n10.typ::text,'')               ,
coalesce(n11.typ::text,'')               ,
coalesce(n12.typ::text,'')               ,
coalesce(n13.typ::text,'')               ,
coalesce(n14.diag::text,'')              ,
coalesce(n14.sicher::text,'')              ,
coalesce(n16.diag::text,'')              ,
coalesce(n16.sicher::text,'')              ,
coalesce(n18.typ::text,'')               ,
coalesce(n19.typ::text,'')               
],'|') AS index1
FROM

datensatz d                         
LEFT JOIN versorgungsbereich             n1 ON n1.id=d.id
LEFT JOIN aufnahmedatum                  n2 ON n2.id=d.id
LEFT JOIN kostentraeger                  n3 ON n3.id=d.id
LEFT JOIN abrechnungsart                 n4 ON n4.id=d.id
LEFT JOIN einweiser                      n5 ON n5.id=d.id
LEFT JOIN barriere                       n6 ON n6.id=d.id
LEFT JOIN rentenbegehren                 n7 ON n7.id=d.id
LEFT JOIN suizidversuch                  n8 ON n8.id=d.id
LEFT JOIN suizidversuch_anzahl           n9 ON n9.id=d.id
LEFT JOIN motivation                     n10 ON n10.id=d.id
LEFT JOIN anamnese_gesamt                n11 ON n11.id=d.id
LEFT JOIN anamnese_aktuell               n12 ON n12.id=d.id
LEFT JOIN hauptdiagnose                  n13 ON n13.id=d.id
LEFT JOIN psycat                         n14 ON n14.id=d.id
LEFT JOIN somacat                        n16 ON n16.id=d.id
LEFT JOIN gaf_a                          n18 ON n18.id=d.id
LEFT JOIN garf_a                         n19 ON n19.id=d.id

WHERE

n1.valid   IS NOT NULL OR
n2.valid   IS NOT NULL OR
n3.valid   IS NOT NULL OR
n4.valid   IS NOT NULL OR
n5.valid   IS NOT NULL OR
n6.valid   IS NOT NULL OR
n7.valid   IS NOT NULL OR
n8.valid   IS NOT NULL OR
n9.valid   IS NOT NULL OR
n10.valid  IS NOT NULL OR
n11.valid  IS NOT NULL OR
n12.valid  IS NOT NULL OR
n13.valid  IS NOT NULL OR
n14.valid  IS NOT NULL OR
n16.valid  IS NOT NULL OR
n18.valid  IS NOT NULL OR
n19.valid  IS NOT NULL  

ORDER BY d.id;


DROP VIEW IF EXISTS index1_v CASCADE;

CREATE VIEW index1_v

AS

WITH psycat AS (
SELECT
p.id,
coalesce(array_to_string(array_agg(t.key ORDER BY p.seq_nr),',','')::text,'') AS diag,
coalesce(array_to_string(array_agg(p.sicher::text ORDER BY p.seq_nr),',','')::text,'') AS sicher,
coalesce(array_to_string(array_agg(p.valid::text ORDER BY p.seq_nr),',','')::text,'') AS valid
FROM
psychische_diagnose p
JOIN diagnose_typ t ON p.typ = t.id

GROUP BY p.id ORDER BY p.id),




somacat AS (
SELECT
p.id,
coalesce(array_to_string(array_agg(t.key ORDER BY p.seq_nr),',','')::text,'') AS diag,
coalesce(array_to_string(array_agg(p.sicher::text ORDER BY p.seq_nr),',','')::text,'') AS sicher,
coalesce(array_to_string(array_agg(p.valid::text ORDER BY p.seq_nr),',','')::text,'') AS valid
FROM
somatische_diagnose p
JOIN diagnose_typ t ON p.typ = t.id

GROUP BY p.id ORDER BY p.id)




SELECT
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[      
coalesce(1::text,''),
coalesce(1::text,'')        ,
coalesce(1::text,'')    ,
coalesce(1::text,'')       ,
coalesce(n1.valid::text,'')                ,
coalesce(n2.valid::text,'')             ,
coalesce(n3.valid::text,'')                ,
coalesce(n4.valid::text,'')                ,
coalesce(n5.valid::text,'')                ,
coalesce(n6.valid::text,'')                ,
coalesce(n7.valid::text,'')                ,
coalesce(n8.valid::text,'')                ,
coalesce(n9.valid::text,'')             ,
coalesce(n10.valid::text,'')               ,
coalesce(n11.valid::text,'')               ,
coalesce(n12.valid::text,'')               ,
coalesce(n13.valid::text,'')               ,
coalesce(n14.valid::text,'')              ,
coalesce(n14.valid::text,'')              ,
coalesce(n16.valid::text,'')              ,
coalesce(n16.valid::text,'')              ,
coalesce(n18.valid::text,'')               ,
coalesce(n19.valid::text,'')               
],'|') AS index1
FROM

datensatz d                         
LEFT JOIN versorgungsbereich             n1 ON n1.id=d.id
LEFT JOIN aufnahmedatum                  n2 ON n2.id=d.id
LEFT JOIN kostentraeger                  n3 ON n3.id=d.id
LEFT JOIN abrechnungsart                 n4 ON n4.id=d.id
LEFT JOIN einweiser                      n5 ON n5.id=d.id
LEFT JOIN barriere                       n6 ON n6.id=d.id
LEFT JOIN rentenbegehren                 n7 ON n7.id=d.id
LEFT JOIN suizidversuch                  n8 ON n8.id=d.id
LEFT JOIN suizidversuch_anzahl           n9 ON n9.id=d.id
LEFT JOIN motivation                     n10 ON n10.id=d.id
LEFT JOIN anamnese_gesamt                n11 ON n11.id=d.id
LEFT JOIN anamnese_aktuell               n12 ON n12.id=d.id
LEFT JOIN hauptdiagnose                  n13 ON n13.id=d.id
LEFT JOIN psycat                         n14 ON n14.id=d.id
LEFT JOIN somacat                        n16 ON n16.id=d.id
LEFT JOIN gaf_a                          n18 ON n18.id=d.id
LEFT JOIN garf_a                         n19 ON n19.id=d.id

WHERE

n1.valid   IS NOT NULL OR
n2.valid   IS NOT NULL OR
n3.valid   IS NOT NULL OR
n4.valid   IS NOT NULL OR
n5.valid   IS NOT NULL OR
n6.valid   IS NOT NULL OR
n7.valid   IS NOT NULL OR
n8.valid   IS NOT NULL OR
n9.valid   IS NOT NULL OR
n10.valid  IS NOT NULL OR
n11.valid  IS NOT NULL OR
n12.valid  IS NOT NULL OR
n13.valid  IS NOT NULL OR
n14.valid  IS NOT NULL OR
n16.valid  IS NOT NULL OR
n18.valid  IS NOT NULL OR
n19.valid  IS NOT NULL 

ORDER BY d.id;



DROP VIEW IF EXISTS index2;

CREATE VIEW index2

AS

WITH behandcat AS (
SELECT
b.id,
coalesce(array_to_string(array_agg(b.typ::text),',','')::text,'') AS typ,
coalesce(array_to_string(array_agg(b.valid::text),',','')::text,'') AS valid
FROM
behandlungsempfehlung b

GROUP BY b.id ORDER BY b.id),

nationkey AS (
SELECT 
nation.id, 
coalesce(nation_typ.key::text,'') AS key, 
coalesce(nation.valid::text,'') AS valid
FROM
nation 
LEFT JOIN nation_typ ON nation.typ = nation_typ.id ORDER BY nation.id)


SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(2::text,''),
coalesce(d.behandler_nr::text,''),
coalesce(d.sub_behandler_nr::text,''),
coalesce(d.patienten_nr::text,''),
coalesce(n1.typ::text,''),
coalesce(n2.typ::text,''),
coalesce(to_char(n3.datum ,'DD.MM.YYYY')::text,''), 
coalesce(n4.key::text,''),
coalesce(n5.typ::text,''),
coalesce(n6.typ::text,''),
coalesce(n7.typ::text,''),
coalesce(n8.anzahl::text,''),
coalesce(n9.typ::text,''),
coalesce(n10.typ::text,''),
coalesce(n11.typ::text,''),
coalesce(n12.typ::text,''),
coalesce(n13.typ::text,''),
coalesce(weeks(n14.dauer)::text,''),
coalesce(weeks(n15.dauer) ::text,''),
coalesce(n16.typ          ::text,''),
coalesce(n17.anzahl       ::text,''),
coalesce(weeks(n18.dauer) ::text,''),
coalesce(n19.anzahl       ::text,''),
coalesce(weeks(n20.dauer) ::text,''),
coalesce(n21.anzahl       ::text,''),
coalesce(n22.typ          ::text,''),
coalesce(n23.typ          ::text,''),
coalesce(n24.typ          ::text,'')
],'|') AS index2

FROM

datensatz d                         
LEFT JOIN  behandcat                n1 ON n1.id=d.id
LEFT JOIN  geschlecht               n2 ON n2.id=d.id
LEFT JOIN  geburtsdatum             n3 ON n3.id=d.id
LEFT JOIN  nationkey                n4 ON n4.id=d.id
LEFT JOIN  haushalt                 n5 ON n5.id=d.id
LEFT JOIN  partnersituation         n6 ON n6.id=d.id
LEFT JOIN  familienstand            n7 ON n7.id=d.id
LEFT JOIN  anzahl_kinder            n8 ON n8.id=d.id
LEFT JOIN  schulabschluss           n9 ON n9.id=d.id
LEFT JOIN  berufsabschluss          n10 ON n10.id=d.id
LEFT JOIN  berufstaetigkeit         n11 ON n11.id=d.id
LEFT JOIN  erwerbstaetigkeit        n12 ON n12.id=d.id
LEFT JOIN  haupteinkommen           n13 ON n13.id=d.id
LEFT JOIN  au_aufnahme              n14 ON n14.id=d.id
LEFT JOIN  au_gesamt                n15 ON n15.id=d.id
LEFT JOIN  rentenverfahren          n16 ON n16.id=d.id
LEFT JOIN  stat_vorbeh_anzahl       n17 ON n17.id=d.id
LEFT JOIN  stat_vorbeh_dauer        n18 ON n18.id=d.id
LEFT JOIN  teilstat_vorbeh_anzahl   n19 ON n19.id=d.id
LEFT JOIN  teilstat_vorbeh_dauer    n20 ON n20.id=d.id
LEFT JOIN  amb_vorbeh_anzahl        n21 ON n21.id=d.id
LEFT JOIN  amb_vorbeh_dauer         n22 ON n22.id=d.id
LEFT JOIN  amb_vorbeh_aufnahme      n23 ON n23.id=d.id
LEFT JOIN  pharma_aufnahme          n24 ON n24.id=d.id

WHERE

n1.valid   IS NOT NULL OR
n2.valid   IS NOT NULL OR
n3.valid   IS NOT NULL OR
n4.valid   IS NOT NULL OR
n5.valid   IS NOT NULL OR
n6.valid   IS NOT NULL OR
n7.valid   IS NOT NULL OR
n8.valid   IS NOT NULL OR
n9.valid   IS NOT NULL OR
n10.valid  IS NOT NULL OR
n11.valid  IS NOT NULL OR
n12.valid  IS NOT NULL OR
n13.valid  IS NOT NULL OR
n14.valid  IS NOT NULL OR
n15.valid  IS NOT NULL OR
n16.valid  IS NOT NULL OR
n17.valid  IS NOT NULL OR
n18.valid  IS NOT NULL OR
n19.valid  IS NOT NULL OR
n20.valid  IS NOT NULL OR
n21.valid  IS NOT NULL OR
n22.valid  IS NOT NULL OR
n23.valid  IS NOT NULL OR
n24.valid  IS NOT NULL 

ORDER BY d.id;


DROP VIEW IF EXISTS index2_v;

CREATE VIEW index2_v

AS

WITH behandcat AS (
SELECT
b.id,
coalesce(array_to_string(array_agg(b.typ::text),',','')::text,'') AS typ,
coalesce(array_to_string(array_agg(b.valid::text),',','')::text,'') AS valid
FROM
behandlungsempfehlung b

GROUP BY b.id ORDER BY b.id),

nationkey AS (
SELECT 
nation.id, 
coalesce(nation_typ.key::text,'') AS key,
coalesce(nation.valid::text,'') AS valid
FROM
nation 
LEFT JOIN nation_typ ON nation.typ = nation_typ.id  ORDER BY nation.id)

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(2::text,''),
coalesce(1::text,''),
coalesce(1::text,''),
coalesce(1::text,''),
coalesce(n1.valid::text,''),
coalesce(n2.valid::text,''),
coalesce(n3.valid::text,''), 
coalesce(n4.valid::text,''),
coalesce(n5.valid::text,''),
coalesce(n6.valid::text,''),
coalesce(n7.valid::text,''),
coalesce(n8.valid::text,''),
coalesce(n9.valid::text,''),
coalesce(n10.valid::text,''),
coalesce(n11.valid::text,''),
coalesce(n12.valid::text,''),
coalesce(n13.valid::text,''),
coalesce(n14.valid::text,''),
coalesce(n15.valid ::text,''),
coalesce(n16.valid          ::text,''),
coalesce(n17.valid       ::text,''),
coalesce(n18.valid ::text,''),
coalesce(n19.valid       ::text,''),
coalesce(n20.valid ::text,''),
coalesce(n21.valid       ::text,''),
coalesce(n22.valid          ::text,''),
coalesce(n23.valid          ::text,''),
coalesce(n24.valid          ::text,'')
],'|') AS index2

FROM

datensatz d                         
LEFT JOIN  behandcat                n1 ON n1.id=d.id
LEFT JOIN  geschlecht               n2 ON n2.id=d.id
LEFT JOIN  geburtsdatum             n3 ON n3.id=d.id
LEFT JOIN  nationkey                n4 ON n4.id=d.id
LEFT JOIN  haushalt                 n5 ON n5.id=d.id
LEFT JOIN  partnersituation         n6 ON n6.id=d.id
LEFT JOIN  familienstand            n7 ON n7.id=d.id
LEFT JOIN  anzahl_kinder            n8 ON n8.id=d.id
LEFT JOIN  schulabschluss           n9 ON n9.id=d.id
LEFT JOIN  berufsabschluss          n10 ON n10.id=d.id
LEFT JOIN  berufstaetigkeit         n11 ON n11.id=d.id
LEFT JOIN  erwerbstaetigkeit        n12 ON n12.id=d.id
LEFT JOIN  haupteinkommen           n13 ON n13.id=d.id
LEFT JOIN  au_aufnahme              n14 ON n14.id=d.id
LEFT JOIN  au_gesamt                n15 ON n15.id=d.id
LEFT JOIN  rentenverfahren          n16 ON n16.id=d.id
LEFT JOIN  stat_vorbeh_anzahl       n17 ON n17.id=d.id
LEFT JOIN  stat_vorbeh_dauer        n18 ON n18.id=d.id
LEFT JOIN  teilstat_vorbeh_anzahl   n19 ON n19.id=d.id
LEFT JOIN  teilstat_vorbeh_dauer    n20 ON n20.id=d.id
LEFT JOIN  amb_vorbeh_anzahl        n21 ON n21.id=d.id
LEFT JOIN  amb_vorbeh_dauer         n22 ON n22.id=d.id
LEFT JOIN  amb_vorbeh_aufnahme      n23 ON n23.id=d.id
LEFT JOIN  pharma_aufnahme          n24 ON n24.id=d.id

WHERE

n1.valid   IS NOT NULL OR
n2.valid   IS NOT NULL OR
n3.valid   IS NOT NULL OR
n4.valid   IS NOT NULL OR
n5.valid   IS NOT NULL OR
n6.valid   IS NOT NULL OR
n7.valid   IS NOT NULL OR
n8.valid   IS NOT NULL OR
n9.valid   IS NOT NULL OR
n10.valid  IS NOT NULL OR
n11.valid  IS NOT NULL OR
n12.valid  IS NOT NULL OR
n13.valid  IS NOT NULL OR
n14.valid  IS NOT NULL OR
n15.valid  IS NOT NULL OR
n16.valid  IS NOT NULL OR
n17.valid  IS NOT NULL OR
n18.valid  IS NOT NULL OR
n19.valid  IS NOT NULL OR
n20.valid  IS NOT NULL OR
n21.valid  IS NOT NULL OR
n22.valid  IS NOT NULL OR
n23.valid  IS NOT NULL OR
n24.valid  IS NOT NULL 

ORDER BY d.id;



DROP VIEW IF EXISTS index3;

CREATE VIEW index3

AS

WITH weitercat AS (
SELECT
b.id,
array_to_string(array_agg(b.typ::text),',','') AS typ,
array_to_string(array_agg(b.valid::text),',','') AS valid
FROM
weiterbehandlung b

GROUP BY b.id ORDER BY b.id)


SELECT
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(3                     ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(to_char(n1.datum ,'DD.MM.YYYY')::text,''),               
coalesce(days(n2.dauer)        ::text,''),     
coalesce(n3.anzahl             ::text,''),
coalesce(n4.typ                ::text,''),
coalesce(n5.typ                ::text,''),
coalesce(n6.typ                ::text,''),
coalesce(n7.typ                ::text,''),
coalesce(n8.typ                ::text,''),
coalesce(n9.typ                ::text,''),
coalesce(n10.typ               ::text,''),
coalesce(n11.anzahl            ::text,''),
coalesce(n12.typ               ::text,''),
coalesce(n13.typ               ::text,''),
coalesce(n14.typ               ::text,''),
coalesce(n15.typ               ::text,''),
coalesce(n16.typ               ::text,'')
],'|') AS index3

FROM

datensatz d                         
LEFT JOIN entlassungsdatum                n1 ON n1.id=d.id
LEFT JOIN behandlungsdauer                n2 ON n2.id=d.id
LEFT JOIN anzahl_sitzungen                n3 ON n3.id=d.id
LEFT JOIN beendigungsart                  n4 ON n4.id=d.id
LEFT JOIN af_entlassung                   n5 ON n5.id=d.id
LEFT JOIN alltagspflichten_therapeut      n6 ON n6.id=d.id
LEFT JOIN aenderung_koerperlich_therapeut n7 ON n7.id=d.id
LEFT JOIN aenderung_psychisch_therapeut   n8 ON n8.id=d.id
LEFT JOIN gaf_e                           n9 ON n9.id=d.id
LEFT JOIN garf_e                          n10 ON n10.id=d.id
LEFT JOIN vev_k                           n11 ON n11.id=d.id
LEFT JOIN medikation_antidepressiva       n12 ON n12.id=d.id
LEFT JOIN medikation_anxiolytika          n13 ON n13.id=d.id
LEFT JOIN medikation_neuroleptika         n14 ON n14.id=d.id
LEFT JOIN medikation_analgetika           n15 ON n15.id=d.id
LEFT JOIN weitercat                       n16 ON n16.id=d.id

WHERE

n1.valid   IS NOT NULL OR
n2.valid   IS NOT NULL OR
n3.valid   IS NOT NULL OR
n4.valid   IS NOT NULL OR
n5.valid   IS NOT NULL OR
n6.valid   IS NOT NULL OR
n7.valid   IS NOT NULL OR
n8.valid   IS NOT NULL OR
n9.valid   IS NOT NULL OR
n10.valid  IS NOT NULL OR
n11.valid  IS NOT NULL OR
n12.valid  IS NOT NULL OR
n13.valid  IS NOT NULL OR
n14.valid  IS NOT NULL OR
n15.valid  IS NOT NULL OR
n16.valid  IS NOT NULL 

ORDER BY d.id;



DROP VIEW IF EXISTS index3_v;

CREATE VIEW index3_v

AS

WITH weitercat AS (
SELECT
b.id,
array_to_string(array_agg(b.typ::text),',','') AS typ,
array_to_string(array_agg(b.valid::text),',','') AS valid
FROM
weiterbehandlung b

GROUP BY b.id ORDER BY b.id)


SELECT
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(3                     ::text,''),
coalesce(1        ::text,''),
coalesce(1    ::text,''),
coalesce(1        ::text,''),
coalesce(n1.valid::text,''),               
coalesce(n2.valid        ::text,''),     
coalesce(n3.valid             ::text,''),
coalesce(n4.valid             ::text,''),
coalesce(n5.valid             ::text,''),
coalesce(n6.valid             ::text,''),
coalesce(n7.valid             ::text,''),
coalesce(n8.valid             ::text,''),
coalesce(n9.valid             ::text,''),
coalesce(n10.valid            ::text,''),
coalesce(n11.valid            ::text,''),
coalesce(n12.valid            ::text,''),
coalesce(n13.valid            ::text,''),
coalesce(n14.valid            ::text,''),
coalesce(n15.valid            ::text,''),
coalesce(n16.valid            ::text,'')
],'|') AS index3

FROM

datensatz d                         
LEFT JOIN entlassungsdatum                n1 ON n1.id=d.id
LEFT JOIN behandlungsdauer                n2 ON n2.id=d.id
LEFT JOIN anzahl_sitzungen                n3 ON n3.id=d.id
LEFT JOIN beendigungsart                  n4 ON n4.id=d.id
LEFT JOIN af_entlassung                   n5 ON n5.id=d.id
LEFT JOIN alltagspflichten_therapeut      n6 ON n6.id=d.id
LEFT JOIN aenderung_koerperlich_therapeut n7 ON n7.id=d.id
LEFT JOIN aenderung_psychisch_therapeut   n8 ON n8.id=d.id
LEFT JOIN gaf_e                           n9 ON n9.id=d.id
LEFT JOIN garf_e                          n10 ON n10.id=d.id
LEFT JOIN vev_k                           n11 ON n11.id=d.id
LEFT JOIN medikation_antidepressiva       n12 ON n12.id=d.id
LEFT JOIN medikation_anxiolytika          n13 ON n13.id=d.id
LEFT JOIN medikation_neuroleptika         n14 ON n14.id=d.id
LEFT JOIN medikation_analgetika           n15 ON n15.id=d.id
LEFT JOIN weitercat                       n16 ON n16.id=d.id

WHERE

n1.valid   IS NOT NULL OR
n2.valid   IS NOT NULL OR
n3.valid   IS NOT NULL OR
n4.valid   IS NOT NULL OR
n5.valid   IS NOT NULL OR
n6.valid   IS NOT NULL OR
n7.valid   IS NOT NULL OR
n8.valid   IS NOT NULL OR
n9.valid   IS NOT NULL OR
n10.valid  IS NOT NULL OR
n11.valid  IS NOT NULL OR
n12.valid  IS NOT NULL OR
n13.valid  IS NOT NULL OR
n14.valid  IS NOT NULL OR
n15.valid  IS NOT NULL OR
n16.valid  IS NOT NULL 

ORDER BY d.id;



DROP VIEW IF EXISTS index4;

CREATE VIEW index4

AS


SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(4                     ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(n1.typ                ::text,''),
coalesce(n2.typ                ::text,''),
coalesce(n3.typ                ::text,''),
coalesce(n4.typ                ::text,''),
coalesce(n5.typ                ::text,''),
coalesce(n6.typ                ::text,''),
coalesce(n7.typ                ::text,''),
coalesce(n8.typ                ::text,''),
coalesce(n9.typ                ::text,''),
coalesce(n10.typ               ::text,''),
coalesce(n11.typ               ::text,''),
coalesce(n12.typ               ::text,''),
coalesce(n13.typ               ::text,''),
coalesce(n14.typ               ::text,''),
coalesce(n15.typ               ::text,''),
coalesce(n16.typ               ::text,''),
coalesce(n17.typ               ::text,''),
coalesce(n18.typ               ::text,''),
coalesce(n19.typ               ::text,''),
coalesce(n20.typ               ::text,'')
],'|') AS index4

FROM

datensatz d                         
LEFT JOIN alltagspflichten_patient             n1 ON n1.id=d.id
LEFT JOIN zuf_1                                n2 ON n2.id=d.id
LEFT JOIN zuf_2                                n3 ON n3.id=d.id
LEFT JOIN zuf_3                                n4 ON n4.id=d.id
LEFT JOIN zuf_4                                n5 ON n5.id=d.id
LEFT JOIN zuf_5                                n6 ON n6.id=d.id
LEFT JOIN zuf_6                                n7 ON n7.id=d.id
LEFT JOIN zuf_7                                n8 ON n8.id=d.id
LEFT JOIN zuf_8                                n9 ON n9.id=d.id
LEFT JOIN aenderung_koerperlich_patient        n10 ON n10.id=d.id
LEFT JOIN aenderung_psychisch_patient          n11 ON n11.id=d.id
LEFT JOIN aenderung_selbstwerterleben          n12 ON n12.id=d.id
LEFT JOIN aenderung_sozial                     n13 ON n13.id=d.id
LEFT JOIN aenderung_privat                     n14 ON n14.id=d.id
LEFT JOIN aenderung_beruflich                  n15 ON n15.id=d.id
LEFT JOIN aenderung_eigenaktivitaet            n16 ON n16.id=d.id
LEFT JOIN aenderung_krankheitsverstaendnis     n17 ON n17.id=d.id
LEFT JOIN aenderung_zukunft                    n18 ON n18.id=d.id
LEFT JOIN aenderung_befinden                   n19 ON n19.id=d.id
LEFT JOIN aenderung_alltag                      n20 ON n20.id=d.id

WHERE

n1.valid   IS NOT NULL OR
n2.valid   IS NOT NULL OR
n3.valid   IS NOT NULL OR
n4.valid   IS NOT NULL OR
n5.valid   IS NOT NULL OR
n6.valid   IS NOT NULL OR
n7.valid   IS NOT NULL OR
n8.valid   IS NOT NULL OR
n9.valid   IS NOT NULL OR
n10.valid  IS NOT NULL OR
n11.valid  IS NOT NULL OR
n12.valid  IS NOT NULL OR
n13.valid  IS NOT NULL OR
n14.valid  IS NOT NULL OR
n15.valid  IS NOT NULL OR
n16.valid  IS NOT NULL OR
n17.valid  IS NOT NULL OR
n18.valid  IS NOT NULL OR
n19.valid  IS NOT NULL OR
n20.valid  IS NOT NULL 

ORDER BY d.id;



DROP VIEW IF EXISTS index4_v;

CREATE VIEW index4_v

AS


SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(4                     ::text,''),
coalesce(1        ::text,''),
coalesce(1    ::text,''),
coalesce(1       ::text,''),
coalesce(n1.valid                ::text,''),
coalesce(n2.valid                ::text,''),
coalesce(n3.valid                ::text,''),
coalesce(n4.valid                ::text,''),
coalesce(n5.valid                ::text,''),
coalesce(n6.valid                ::text,''),
coalesce(n7.valid                ::text,''),
coalesce(n8.valid                ::text,''),
coalesce(n9.valid                ::text,''),
coalesce(n10.valid               ::text,''),
coalesce(n11.valid               ::text,''),
coalesce(n12.valid               ::text,''),
coalesce(n13.valid               ::text,''),
coalesce(n14.valid               ::text,''),
coalesce(n15.valid               ::text,''),
coalesce(n16.valid               ::text,''),
coalesce(n17.valid               ::text,''),
coalesce(n18.valid               ::text,''),
coalesce(n19.valid               ::text,''),
coalesce(n20.valid               ::text,'')
],'|') AS index4

FROM

datensatz d                         
LEFT JOIN alltagspflichten_patient             n1 ON n1.id=d.id
LEFT JOIN zuf_1                                n2 ON n2.id=d.id
LEFT JOIN zuf_2                                n3 ON n3.id=d.id
LEFT JOIN zuf_3                                n4 ON n4.id=d.id
LEFT JOIN zuf_4                                n5 ON n5.id=d.id
LEFT JOIN zuf_5                                n6 ON n6.id=d.id
LEFT JOIN zuf_6                                n7 ON n7.id=d.id
LEFT JOIN zuf_7                                n8 ON n8.id=d.id
LEFT JOIN zuf_8                                n9 ON n9.id=d.id
LEFT JOIN aenderung_koerperlich_patient        n10 ON n10.id=d.id
LEFT JOIN aenderung_psychisch_patient          n11 ON n11.id=d.id
LEFT JOIN aenderung_selbstwerterleben          n12 ON n12.id=d.id
LEFT JOIN aenderung_sozial                     n13 ON n13.id=d.id
LEFT JOIN aenderung_privat                     n14 ON n14.id=d.id
LEFT JOIN aenderung_beruflich                  n15 ON n15.id=d.id
LEFT JOIN aenderung_eigenaktivitaet            n16 ON n16.id=d.id
LEFT JOIN aenderung_krankheitsverstaendnis     n17 ON n17.id=d.id
LEFT JOIN aenderung_zukunft                    n18 ON n18.id=d.id
LEFT JOIN aenderung_befinden                   n19 ON n19.id=d.id
LEFT JOIN aenderung_alltag                      n20 ON n20.id=d.id

WHERE

n1.valid   IS NOT NULL OR
n2.valid   IS NOT NULL OR
n3.valid   IS NOT NULL OR
n4.valid   IS NOT NULL OR
n5.valid   IS NOT NULL OR
n6.valid   IS NOT NULL OR
n7.valid   IS NOT NULL OR
n8.valid   IS NOT NULL OR
n9.valid   IS NOT NULL OR
n10.valid  IS NOT NULL OR
n11.valid  IS NOT NULL OR
n12.valid  IS NOT NULL OR
n13.valid  IS NOT NULL OR
n14.valid  IS NOT NULL OR
n15.valid  IS NOT NULL OR
n16.valid  IS NOT NULL OR
n17.valid  IS NOT NULL OR
n18.valid  IS NOT NULL OR
n19.valid  IS NOT NULL OR
n20.valid  IS NOT NULL 

ORDER BY d.id;



DROP VIEW IF EXISTS index5;

CREATE VIEW index5

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array_agg(array_to_string(array[ 
coalesce(5                     ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(to_char(id.datum ,'DD.MM.YYYY') ::text,''),
coalesce(n2.typ                ::text,''),
coalesce(n3.typ                ::text,''),
coalesce(n4.typ                ::text,''),
coalesce(n5.typ                ::text,''),
coalesce(n6.typ                ::text,''),
coalesce(n7.typ                ::text,''),
coalesce(n8.typ                ::text,''),
coalesce(n9.typ                ::text,''),
coalesce(n10.typ               ::text,''),
coalesce(n11.typ               ::text,''),
coalesce(n12.typ               ::text,''),
coalesce(n13.typ               ::text,''),
coalesce(n14.typ               ::text,''),
coalesce(n15.typ               ::text,''),
coalesce(n16.typ               ::text,''),
coalesce(n17.typ               ::text,''),
coalesce(n18.typ               ::text,''),
coalesce(n19.typ               ::text,''),
coalesce(n20.typ               ::text,''),
coalesce(n21.typ               ::text,''),
coalesce(n22.typ               ::text,''),
coalesce(n23.typ               ::text,''),
coalesce(n24.typ               ::text,''),
coalesce(n25.typ               ::text,''),
coalesce(n26.typ               ::text,''),
coalesce(n27.typ               ::text,''),
coalesce(n28.typ               ::text,''),
coalesce(n29.typ               ::text,''),
coalesce(n30.typ               ::text,'')
],'|')),'|') AS index5

FROM

datensatz d                         
LEFT JOIN isr_datensatz id ON id.id = d.id
LEFT JOIN isr_d01   n2 ON n2.eintrag_id=id.eintrag_id
LEFT JOIN isr_d02   n3 ON n3.eintrag_id=id.eintrag_id
LEFT JOIN isr_d03   n4 ON n4.eintrag_id=id.eintrag_id
LEFT JOIN isr_d05   n5 ON n5.eintrag_id=id.eintrag_id
LEFT JOIN isr_a01   n6 ON n6.eintrag_id=id.eintrag_id
LEFT JOIN isr_a02   n7 ON n7.eintrag_id=id.eintrag_id
LEFT JOIN isr_a03   n8 ON n8.eintrag_id=id.eintrag_id
LEFT JOIN isr_a04   n9 ON n9.eintrag_id=id.eintrag_id
LEFT JOIN isr_z01   n10 ON n10.eintrag_id=id.eintrag_id
LEFT JOIN isr_z02   n11 ON n11.eintrag_id=id.eintrag_id
LEFT JOIN isr_z03   n12 ON n12.eintrag_id=id.eintrag_id
LEFT JOIN isr_s01   n13 ON n13.eintrag_id=id.eintrag_id
LEFT JOIN isr_s02   n14 ON n14.eintrag_id=id.eintrag_id
LEFT JOIN isr_s03   n15 ON n15.eintrag_id=id.eintrag_id
LEFT JOIN isr_e01   n16 ON n16.eintrag_id=id.eintrag_id
LEFT JOIN isr_e02   n17 ON n17.eintrag_id=id.eintrag_id
LEFT JOIN isr_e03   n18 ON n18.eintrag_id=id.eintrag_id
LEFT JOIN isr_d04   n19 ON n19.eintrag_id=id.eintrag_id
LEFT JOIN isr_d10   n20 ON n20.eintrag_id=id.eintrag_id
LEFT JOIN isr_d11   n21 ON n21.eintrag_id=id.eintrag_id
LEFT JOIN isr_d12   n22 ON n22.eintrag_id=id.eintrag_id
LEFT JOIN isr_w01   n23 ON n23.eintrag_id=id.eintrag_id
LEFT JOIN isr_w02   n24 ON n24.eintrag_id=id.eintrag_id
LEFT JOIN isr_w03   n25 ON n25.eintrag_id=id.eintrag_id
LEFT JOIN isr_w05   n26 ON n26.eintrag_id=id.eintrag_id
LEFT JOIN isr_w06   n27 ON n27.eintrag_id=id.eintrag_id
LEFT JOIN isr_w07   n28 ON n28.eintrag_id=id.eintrag_id
LEFT JOIN isr_w08   n29 ON n29.eintrag_id=id.eintrag_id
LEFT JOIN isr_w09    n30 ON n30.eintrag_id=id.eintrag_id

WHERE

id.valid   IS NOT NULL OR
n2.valid   IS NOT NULL OR
n3.valid   IS NOT NULL OR
n4.valid   IS NOT NULL OR
n5.valid   IS NOT NULL OR
n6.valid   IS NOT NULL OR
n7.valid   IS NOT NULL OR
n8.valid   IS NOT NULL OR
n9.valid   IS NOT NULL OR
n10.valid  IS NOT NULL OR
n11.valid  IS NOT NULL OR
n12.valid  IS NOT NULL OR
n13.valid  IS NOT NULL OR
n14.valid  IS NOT NULL OR
n15.valid  IS NOT NULL OR
n16.valid  IS NOT NULL OR
n17.valid  IS NOT NULL OR
n18.valid  IS NOT NULL OR
n19.valid  IS NOT NULL OR
n20.valid  IS NOT NULL OR
n21.valid  IS NOT NULL OR
n22.valid  IS NOT NULL OR
n23.valid  IS NOT NULL OR
n24.valid  IS NOT NULL OR
n25.valid  IS NOT NULL OR
n26.valid  IS NOT NULL OR
n27.valid  IS NOT NULL OR
n28.valid  IS NOT NULL OR
n29.valid  IS NOT NULL OR
n30.valid  IS NOT NULL

GROUP BY d.id, d.behandler_nr, d.patienten_nr ORDER BY d.id;

DROP VIEW IF EXISTS index5_v;

CREATE VIEW index5_v

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array_agg(array_to_string(array[ 
coalesce(5                     ::text,''),
coalesce(1        ::text,''),
coalesce(1    ::text,''),
coalesce(1        ::text,''),
coalesce(id.valid ::text,''),
coalesce(n2.valid                ::text,''),
coalesce(n3.valid                ::text,''),
coalesce(n4.valid                ::text,''),
coalesce(n5.valid                ::text,''),
coalesce(n6.valid                ::text,''),
coalesce(n7.valid                ::text,''),
coalesce(n8.valid                ::text,''),
coalesce(n9.valid                ::text,''),
coalesce(n10.valid               ::text,''),
coalesce(n11.valid               ::text,''),
coalesce(n12.valid               ::text,''),
coalesce(n13.valid               ::text,''),
coalesce(n14.valid               ::text,''),
coalesce(n15.valid               ::text,''),
coalesce(n16.valid               ::text,''),
coalesce(n17.valid               ::text,''),
coalesce(n18.valid               ::text,''),
coalesce(n19.valid               ::text,''),
coalesce(n20.valid               ::text,''),
coalesce(n21.valid               ::text,''),
coalesce(n22.valid               ::text,''),
coalesce(n23.valid               ::text,''),
coalesce(n24.valid               ::text,''),
coalesce(n25.valid               ::text,''),
coalesce(n26.valid               ::text,''),
coalesce(n27.valid               ::text,''),
coalesce(n28.valid               ::text,''),
coalesce(n29.valid               ::text,''),
coalesce(n30.valid               ::text,'')
],'|')),'|') AS index5

FROM

datensatz d                         
LEFT JOIN isr_datensatz id ON id.id = d.id
LEFT JOIN isr_d01   n2 ON n2.eintrag_id=id.eintrag_id
LEFT JOIN isr_d02   n3 ON n3.eintrag_id=id.eintrag_id
LEFT JOIN isr_d03   n4 ON n4.eintrag_id=id.eintrag_id
LEFT JOIN isr_d05   n5 ON n5.eintrag_id=id.eintrag_id
LEFT JOIN isr_a01   n6 ON n6.eintrag_id=id.eintrag_id
LEFT JOIN isr_a02   n7 ON n7.eintrag_id=id.eintrag_id
LEFT JOIN isr_a03   n8 ON n8.eintrag_id=id.eintrag_id
LEFT JOIN isr_a04   n9 ON n9.eintrag_id=id.eintrag_id
LEFT JOIN isr_z01   n10 ON n10.eintrag_id=id.eintrag_id
LEFT JOIN isr_z02   n11 ON n11.eintrag_id=id.eintrag_id
LEFT JOIN isr_z03   n12 ON n12.eintrag_id=id.eintrag_id
LEFT JOIN isr_s01   n13 ON n13.eintrag_id=id.eintrag_id
LEFT JOIN isr_s02   n14 ON n14.eintrag_id=id.eintrag_id
LEFT JOIN isr_s03   n15 ON n15.eintrag_id=id.eintrag_id
LEFT JOIN isr_e01   n16 ON n16.eintrag_id=id.eintrag_id
LEFT JOIN isr_e02   n17 ON n17.eintrag_id=id.eintrag_id
LEFT JOIN isr_e03   n18 ON n18.eintrag_id=id.eintrag_id
LEFT JOIN isr_d04   n19 ON n19.eintrag_id=id.eintrag_id
LEFT JOIN isr_d10   n20 ON n20.eintrag_id=id.eintrag_id
LEFT JOIN isr_d11   n21 ON n21.eintrag_id=id.eintrag_id
LEFT JOIN isr_d12   n22 ON n22.eintrag_id=id.eintrag_id
LEFT JOIN isr_w01   n23 ON n23.eintrag_id=id.eintrag_id
LEFT JOIN isr_w02   n24 ON n24.eintrag_id=id.eintrag_id
LEFT JOIN isr_w03   n25 ON n25.eintrag_id=id.eintrag_id
LEFT JOIN isr_w05   n26 ON n26.eintrag_id=id.eintrag_id
LEFT JOIN isr_w06   n27 ON n27.eintrag_id=id.eintrag_id
LEFT JOIN isr_w07   n28 ON n28.eintrag_id=id.eintrag_id
LEFT JOIN isr_w08   n29 ON n29.eintrag_id=id.eintrag_id
LEFT JOIN isr_w09    n30 ON n30.eintrag_id=id.eintrag_id

WHERE

id.valid   IS NOT NULL OR
n2.valid   IS NOT NULL OR
n3.valid   IS NOT NULL OR
n4.valid   IS NOT NULL OR
n5.valid   IS NOT NULL OR
n6.valid   IS NOT NULL OR
n7.valid   IS NOT NULL OR
n8.valid   IS NOT NULL OR
n9.valid   IS NOT NULL OR
n10.valid  IS NOT NULL OR
n11.valid  IS NOT NULL OR
n12.valid  IS NOT NULL OR
n13.valid  IS NOT NULL OR
n14.valid  IS NOT NULL OR
n15.valid  IS NOT NULL OR
n16.valid  IS NOT NULL OR
n17.valid  IS NOT NULL OR
n18.valid  IS NOT NULL OR
n19.valid  IS NOT NULL OR
n20.valid  IS NOT NULL OR
n21.valid  IS NOT NULL OR
n22.valid  IS NOT NULL OR
n23.valid  IS NOT NULL OR
n24.valid  IS NOT NULL OR
n25.valid  IS NOT NULL OR
n26.valid  IS NOT NULL OR
n27.valid  IS NOT NULL OR
n28.valid  IS NOT NULL OR
n29.valid  IS NOT NULL OR
n30.valid  IS NOT NULL

GROUP BY d.id, d.behandler_nr, d.patienten_nr ORDER BY d.id;


DROP VIEW IF EXISTS index6;

CREATE VIEW index6

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array_agg(array_to_string(array[ 
coalesce(6                     ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(to_char(id.datum ,'DD.MM.YYYY')::text,''), 
coalesce(n2.typ                ::text,''),
coalesce(n3.typ                ::text,''),
coalesce(n4.typ                ::text,''),
coalesce(n5.typ                ::text,''),
coalesce(n6.typ                ::text,''),
coalesce(n7.typ                ::text,''),
coalesce(n8.typ                ::text,''),
coalesce(n9.typ                ::text,''),
coalesce(n10.typ               ::text,''),
coalesce(n11.typ               ::text,''),
coalesce(n12.typ               ::text,''),
coalesce(n13.typ               ::text,''),
coalesce(n14.typ               ::text,''),
coalesce(n15.grad              ::text,'')
],'|')),'|') AS index6

FROM

datensatz d   
LEFT JOIN mini_icf_datensatz id ON id.id = d.id                     
LEFT JOIN mini_icf_01      n2 ON n2.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_02      n3 ON n3.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_03      n4 ON n4.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_04      n5 ON n5.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_05      n6 ON n6.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_06      n7 ON n7.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_07      n8 ON n8.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_08      n9 ON n9.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_09      n10 ON n10.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_10      n11 ON n11.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_11      n12 ON n12.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_12      n13 ON n13.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_13      n14 ON n14.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_gesamt  n15 ON n15.eintrag_id=id.eintrag_id

WHERE

id.valid   IS NOT NULL OR
n2.valid   IS NOT NULL OR
n3.valid   IS NOT NULL OR
n4.valid   IS NOT NULL OR
n5.valid   IS NOT NULL OR
n6.valid   IS NOT NULL OR
n7.valid   IS NOT NULL OR
n8.valid   IS NOT NULL OR
n9.valid   IS NOT NULL OR
n10.valid  IS NOT NULL OR
n11.valid  IS NOT NULL OR
n12.valid  IS NOT NULL OR
n13.valid  IS NOT NULL OR
n14.valid  IS NOT NULL OR
n15.valid  IS NOT NULL

GROUP BY d.id, d.behandler_nr, d.patienten_nr ORDER BY d.id;

DROP VIEW IF EXISTS index6_v;

CREATE VIEW index6_v

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array_agg(array_to_string(array[ 
coalesce(6                     ::text,''),
coalesce(1        ::text,''),
coalesce(1    ::text,''),
coalesce(1        ::text,''),
coalesce(id.valid ::text,''), 
coalesce(n2.valid                ::text,''),
coalesce(n3.valid                ::text,''),
coalesce(n4.valid                ::text,''),
coalesce(n5.valid                ::text,''),
coalesce(n6.valid                ::text,''),
coalesce(n7.valid                ::text,''),
coalesce(n8.valid                ::text,''),
coalesce(n9.valid                ::text,''),
coalesce(n10.valid              ::text,''),
coalesce(n11.valid              ::text,''),
coalesce(n12.valid              ::text,''),
coalesce(n13.valid              ::text,''),
coalesce(n14.valid              ::text,''),
coalesce(n15.valid              ::text,'')
],'|')),'|') AS index6

FROM

datensatz d   
LEFT JOIN mini_icf_datensatz id ON id.id = d.id                     
LEFT JOIN mini_icf_01      n2 ON n2.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_02      n3 ON n3.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_03      n4 ON n4.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_04      n5 ON n5.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_05      n6 ON n6.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_06      n7 ON n7.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_07      n8 ON n8.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_08      n9 ON n9.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_09      n10 ON n10.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_10      n11 ON n11.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_11      n12 ON n12.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_12      n13 ON n13.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_13      n14 ON n14.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_gesamt  n15 ON n15.eintrag_id=id.eintrag_id

WHERE

id.valid   IS NOT NULL OR
n2.valid   IS NOT NULL OR
n3.valid   IS NOT NULL OR
n4.valid   IS NOT NULL OR
n5.valid   IS NOT NULL OR
n6.valid   IS NOT NULL OR
n7.valid   IS NOT NULL OR
n8.valid   IS NOT NULL OR
n9.valid   IS NOT NULL OR
n10.valid  IS NOT NULL OR
n11.valid  IS NOT NULL OR
n12.valid  IS NOT NULL OR
n13.valid  IS NOT NULL OR
n14.valid  IS NOT NULL OR
n15.valid  IS NOT NULL

GROUP BY d.id, d.behandler_nr, d.patienten_nr ORDER BY d.id;

DROP VIEW IF EXISTS index7;

CREATE VIEW index7

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array_agg(array_to_string(array[ 
coalesce(7                     ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(to_char(id.datum ,'DD.MM.YYYY')::text,''),             
coalesce(n2.grad                ::text,''),
coalesce(n3.grad                ::text,''),
coalesce(n4.grad                ::text,''),
coalesce(n5.grad                ::text,''),
coalesce(n6.grad                ::text,''),
coalesce(n7.grad                ::text,''),
coalesce(n8.grad                ::text,''),
coalesce(n9.grad                ::text,''),
coalesce(n10.grad               ::text,''),
coalesce(n11.grad               ::text,'')
],'|')),'|') AS index7

FROM

datensatz d                         
LEFT JOIN scl90_datensatz id ON id.id = d.id 
LEFT JOIN scl90_somatisierung       n2 ON n2.eintrag_id=id.eintrag_id
LEFT JOIN scl90_zwanghaftigkeit     n3 ON n3.eintrag_id=id.eintrag_id
LEFT JOIN scl90_sozialkontakt       n4 ON n4.eintrag_id=id.eintrag_id
LEFT JOIN scl90_depressivitaet      n5 ON n5.eintrag_id=id.eintrag_id
LEFT JOIN scl90_aengstlichkeit      n6 ON n6.eintrag_id=id.eintrag_id
LEFT JOIN scl90_aggressivitaet      n7 ON n7.eintrag_id=id.eintrag_id
LEFT JOIN scl90_phobische_angst     n8 ON n8.eintrag_id=id.eintrag_id
LEFT JOIN scl90_paranoides_denken   n9 ON n9.eintrag_id=id.eintrag_id
LEFT JOIN scl90_psychotizismus      n10 ON n10.eintrag_id=id.eintrag_id
LEFT JOIN scl90_gsi                  n11 ON n11.eintrag_id=id.eintrag_id

WHERE

id.valid               IS NOT NULL OR             
n2.valid   IS NOT NULL OR
n3.valid   IS NOT NULL OR
n4.valid   IS NOT NULL OR
n5.valid   IS NOT NULL OR
n6.valid   IS NOT NULL OR
n7.valid   IS NOT NULL OR
n8.valid   IS NOT NULL OR
n9.valid   IS NOT NULL OR
n10.valid  IS NOT NULL OR
n11.valid  IS NOT NULL 


GROUP BY d.id, d.behandler_nr, d.patienten_nr ORDER BY d.id;

DROP VIEW IF EXISTS index7_v;

CREATE VIEW index7_v

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array_agg(array_to_string(array[ 
coalesce(7                     ::text,''),
coalesce(1        ::text,''),
coalesce(1    ::text,''),
coalesce(1        ::text,''),
coalesce(id.valid ::text,''),             
coalesce(n2.valid                ::text,''),
coalesce(n3.valid                ::text,''),
coalesce(n4.valid                ::text,''),
coalesce(n5.valid                ::text,''),
coalesce(n6.valid                ::text,''),
coalesce(n7.valid                ::text,''),
coalesce(n8.valid                ::text,''),
coalesce(n9.valid                ::text,''),
coalesce(n10.valid               ::text,''),
coalesce(n11.valid               ::text,'')
],'|')),'|') AS index7

FROM

datensatz d                         
LEFT JOIN scl90_datensatz id ON id.id = d.id 
LEFT JOIN scl90_somatisierung       n2 ON n2.eintrag_id=id.eintrag_id
LEFT JOIN scl90_zwanghaftigkeit     n3 ON n3.eintrag_id=id.eintrag_id
LEFT JOIN scl90_sozialkontakt       n4 ON n4.eintrag_id=id.eintrag_id
LEFT JOIN scl90_depressivitaet      n5 ON n5.eintrag_id=id.eintrag_id
LEFT JOIN scl90_aengstlichkeit      n6 ON n6.eintrag_id=id.eintrag_id
LEFT JOIN scl90_aggressivitaet      n7 ON n7.eintrag_id=id.eintrag_id
LEFT JOIN scl90_phobische_angst     n8 ON n8.eintrag_id=id.eintrag_id
LEFT JOIN scl90_paranoides_denken   n9 ON n9.eintrag_id=id.eintrag_id
LEFT JOIN scl90_psychotizismus      n10 ON n10.eintrag_id=id.eintrag_id
LEFT JOIN scl90_gsi                  n11 ON n11.eintrag_id=id.eintrag_id

WHERE

id.valid               IS NOT NULL OR             
n2.valid   IS NOT NULL OR
n3.valid   IS NOT NULL OR
n4.valid   IS NOT NULL OR
n5.valid   IS NOT NULL OR
n6.valid   IS NOT NULL OR
n7.valid   IS NOT NULL OR
n8.valid   IS NOT NULL OR
n9.valid   IS NOT NULL OR
n10.valid  IS NOT NULL OR
n11.valid  IS NOT NULL 

GROUP BY d.id, d.behandler_nr, d.patienten_nr ORDER BY d.id;

DROP VIEW IF EXISTS index8;

CREATE VIEW index8

AS


SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(8                     ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(minutesf(n1.dauer)    ::text,''),
coalesce(minutesf(n2.dauer)    ::text,''),
coalesce(minutesf(n3.dauer)    ::text,''),
coalesce(minutesf(n4.dauer)    ::text,''),
coalesce(minutesf(n5.dauer)    ::text,''),
coalesce(minutesf(n6.dauer)    ::text,''),
coalesce(minutesf(n7.dauer)    ::text,''),
coalesce(minutesf(n8.dauer)    ::text,''),
coalesce(minutesf(n9.dauer)    ::text,''),
coalesce(minutesf(n10.dauer)   ::text,''),
coalesce(minutesf(n11.dauer)   ::text,''),
coalesce(minutesf(n12.dauer)   ::text,''),
coalesce(minutesf(n13.dauer)   ::text,''),
coalesce(minutesf(n14.dauer)   ::text,''),
coalesce(minutesf(n15.dauer)   ::text,''),
coalesce(minutesf(n16.dauer)   ::text,''),
coalesce(minutesf(n17.dauer)   ::text,''),
coalesce(minutesf(n18.dauer)   ::text,''),
coalesce(minutesf(n19.dauer)   ::text,''),
coalesce(minutesf(n20.dauer)   ::text,''),
coalesce(minutesf(n21.dauer)   ::text,''),
coalesce(minutesf(n22.dauer)   ::text,''),
coalesce(minutesf(n23.dauer)   ::text,''),
coalesce(minutesf(n24.dauer)   ::text,''),
coalesce(minutesf(n25.dauer)   ::text,''),
coalesce(minutesf(n26.dauer)   ::text,''),
coalesce(minutesf(n27.dauer)   ::text,''),
coalesce(minutesf(n28.dauer)   ::text,''),
coalesce(minutesf(n29.dauer)   ::text,''),
coalesce(minutesf(n30.dauer)   ::text,''),
coalesce(minutesf(n31.dauer)   ::text,''),
coalesce(minutesf(n32.dauer)   ::text,''),
coalesce(minutesf(n33.dauer)   ::text,''),
coalesce(minutesf(n34.dauer)   ::text,''),
coalesce(minutesf(n35.dauer)   ::text,''),
coalesce(minutesf(n36.dauer)   ::text,''),
coalesce(minutesf(n37.dauer)   ::text,'')
],'|') AS index8


FROM

datensatz d                         
LEFT JOIN visiten                                n1 ON n1.id=d.id
LEFT JOIN kontakte_kotherapeutisch               n2 ON n2.id=d.id
LEFT JOIN besprechung_patientenbezogen           n3 ON n3.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_bis10       n4 ON n4.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_ab11        n5 ON n5.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_bis10   n6 ON n6.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_ab11    n7 ON n7.id=d.id
LEFT JOIN gruppe_andere_verbale_bis10            n8 ON n8.id=d.id
LEFT JOIN gruppe_andere_verbale_ab11             n9 ON n9.id=d.id
LEFT JOIN gruppe_kunst                           n10 ON n10.id=d.id
LEFT JOIN gruppe_musik                           n11 ON n11.id=d.id
LEFT JOIN gruppe_koerper                         n12 ON n12.id=d.id
LEFT JOIN gruppe_soziale_interaktion             n13 ON n13.id=d.id
LEFT JOIN gruppe_entspannung                     n14 ON n14.id=d.id
LEFT JOIN gruppe_meditation                      n15 ON n15.id=d.id
LEFT JOIN gruppe_themenzentriert                 n16 ON n16.id=d.id
LEFT JOIN gruppe_indikation                      n17 ON n17.id=d.id
LEFT JOIN gruppe_andere                          n18 ON n18.id=d.id
LEFT JOIN gruppe_milieu_versammlung              n19 ON n19.id=d.id
LEFT JOIN gruppe_milieu_themenzentriert          n20 ON n20.id=d.id
LEFT JOIN gruppe_milieu_andere                   n21 ON n21.id=d.id
LEFT JOIN einzel_tiefenpsychologisch             n22 ON n22.id=d.id
LEFT JOIN einzel_verhaltenstherapeutisch         n23 ON n23.id=d.id
LEFT JOIN einzel_andere_verbale                  n24 ON n24.id=d.id
LEFT JOIN einzel_paar                            n25 ON n25.id=d.id
LEFT JOIN einzel_kunst                           n26 ON n26.id=d.id
LEFT JOIN einzel_musik                           n27 ON n27.id=d.id
LEFT JOIN einzel_koerper                         n28 ON n28.id=d.id
LEFT JOIN einzel_entspannung                     n29 ON n29.id=d.id
LEFT JOIN einzel_meditation                      n30 ON n30.id=d.id
LEFT JOIN einzel_themenzentriert                 n31 ON n31.id=d.id
LEFT JOIN einzel_andere_sonstige                 n32 ON n32.id=d.id
LEFT JOIN einzel_milieu_sozio                    n33 ON n33.id=d.id
LEFT JOIN einzel_milieu_andere                   n34 ON n34.id=d.id
LEFT JOIN gruppe_soma                            n35 ON n35.id=d.id
LEFT JOIN einzel_soma                            n36 ON n36.id=d.id
LEFT JOIN balneotherapie                         n37 ON n37.id=d.id

WHERE

n1.valid   IS NOT NULL AND
n2.valid   IS NOT NULL AND
n3.valid   IS NOT NULL AND
n4.valid   IS NOT NULL AND
n5.valid   IS NOT NULL AND
n6.valid   IS NOT NULL AND
n7.valid   IS NOT NULL AND
n8.valid   IS NOT NULL AND
n9.valid   IS NOT NULL AND
n10.valid  IS NOT NULL AND
n11.valid  IS NOT NULL AND
n12.valid  IS NOT NULL AND
n13.valid  IS NOT NULL AND
n14.valid  IS NOT NULL AND
n15.valid  IS NOT NULL AND
n16.valid  IS NOT NULL AND
n17.valid  IS NOT NULL AND
n18.valid  IS NOT NULL AND
n19.valid  IS NOT NULL AND
n20.valid  IS NOT NULL AND
n21.valid  IS NOT NULL AND
n22.valid  IS NOT NULL AND
n23.valid  IS NOT NULL AND
n24.valid  IS NOT NULL AND
n25.valid  IS NOT NULL AND
n26.valid  IS NOT NULL AND
n27.valid  IS NOT NULL AND
n28.valid  IS NOT NULL AND
n29.valid  IS NOT NULL AND
n30.valid  IS NOT NULL AND
n31.valid  IS NOT NULL AND
n32.valid  IS NOT NULL AND
n33.valid  IS NOT NULL AND
n34.valid  IS NOT NULL AND
n35.valid  IS NOT NULL AND
n36.valid  IS NOT NULL AND
n37.valid  IS NOT NULL

ORDER BY d.id;

DROP VIEW IF EXISTS index8_v;

CREATE VIEW index8_v

AS


SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(8                     ::text,''),
coalesce(1        ::text,''),
coalesce(1    ::text,''),
coalesce(1        ::text,''),
coalesce(n1.valid   ::text,''),
coalesce(n2.valid   ::text,''),
coalesce(n3.valid   ::text,''),
coalesce(n4.valid   ::text,''),
coalesce(n5.valid   ::text,''),
coalesce(n6.valid   ::text,''),
coalesce(n7.valid   ::text,''),
coalesce(n8.valid   ::text,''),
coalesce(n9.valid   ::text,''),
coalesce(n10.valid   ::text,''),
coalesce(n11.valid   ::text,''),
coalesce(n12.valid   ::text,''),
coalesce(n13.valid   ::text,''),
coalesce(n14.valid   ::text,''),
coalesce(n15.valid   ::text,''),
coalesce(n16.valid   ::text,''),
coalesce(n17.valid   ::text,''),
coalesce(n18.valid   ::text,''),
coalesce(n19.valid   ::text,''),
coalesce(n20.valid   ::text,''),
coalesce(n21.valid   ::text,''),
coalesce(n22.valid   ::text,''),
coalesce(n23.valid   ::text,''),
coalesce(n24.valid   ::text,''),
coalesce(n25.valid   ::text,''),
coalesce(n26.valid   ::text,''),
coalesce(n27.valid   ::text,''),
coalesce(n28.valid   ::text,''),
coalesce(n29.valid   ::text,''),
coalesce(n30.valid   ::text,''),
coalesce(n31.valid   ::text,''),
coalesce(n32.valid   ::text,''),
coalesce(n33.valid   ::text,''),
coalesce(n34.valid   ::text,''),
coalesce(n35.valid   ::text,''),
coalesce(n36.valid   ::text,''),
coalesce(n37.valid   ::text,'')
],'|') AS index8


FROM

datensatz d                         
LEFT JOIN visiten                                n1 ON n1.id=d.id
LEFT JOIN kontakte_kotherapeutisch               n2 ON n2.id=d.id
LEFT JOIN besprechung_patientenbezogen           n3 ON n3.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_bis10       n4 ON n4.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_ab11        n5 ON n5.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_bis10   n6 ON n6.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_ab11    n7 ON n7.id=d.id
LEFT JOIN gruppe_andere_verbale_bis10            n8 ON n8.id=d.id
LEFT JOIN gruppe_andere_verbale_ab11             n9 ON n9.id=d.id
LEFT JOIN gruppe_kunst                           n10 ON n10.id=d.id
LEFT JOIN gruppe_musik                           n11 ON n11.id=d.id
LEFT JOIN gruppe_koerper                         n12 ON n12.id=d.id
LEFT JOIN gruppe_soziale_interaktion             n13 ON n13.id=d.id
LEFT JOIN gruppe_entspannung                     n14 ON n14.id=d.id
LEFT JOIN gruppe_meditation                      n15 ON n15.id=d.id
LEFT JOIN gruppe_themenzentriert                 n16 ON n16.id=d.id
LEFT JOIN gruppe_indikation                      n17 ON n17.id=d.id
LEFT JOIN gruppe_andere                          n18 ON n18.id=d.id
LEFT JOIN gruppe_milieu_versammlung              n19 ON n19.id=d.id
LEFT JOIN gruppe_milieu_themenzentriert          n20 ON n20.id=d.id
LEFT JOIN gruppe_milieu_andere                   n21 ON n21.id=d.id
LEFT JOIN einzel_tiefenpsychologisch             n22 ON n22.id=d.id
LEFT JOIN einzel_verhaltenstherapeutisch         n23 ON n23.id=d.id
LEFT JOIN einzel_andere_verbale                  n24 ON n24.id=d.id
LEFT JOIN einzel_paar                            n25 ON n25.id=d.id
LEFT JOIN einzel_kunst                           n26 ON n26.id=d.id
LEFT JOIN einzel_musik                           n27 ON n27.id=d.id
LEFT JOIN einzel_koerper                         n28 ON n28.id=d.id
LEFT JOIN einzel_entspannung                     n29 ON n29.id=d.id
LEFT JOIN einzel_meditation                      n30 ON n30.id=d.id
LEFT JOIN einzel_themenzentriert                 n31 ON n31.id=d.id
LEFT JOIN einzel_andere_sonstige                 n32 ON n32.id=d.id
LEFT JOIN einzel_milieu_sozio                    n33 ON n33.id=d.id
LEFT JOIN einzel_milieu_andere                   n34 ON n34.id=d.id
LEFT JOIN gruppe_soma                            n35 ON n35.id=d.id
LEFT JOIN einzel_soma                            n36 ON n36.id=d.id
LEFT JOIN balneotherapie                         n37 ON n37.id=d.id

WHERE

n1.valid   IS NOT NULL AND
n2.valid   IS NOT NULL AND
n3.valid   IS NOT NULL AND
n4.valid   IS NOT NULL AND
n5.valid   IS NOT NULL AND
n6.valid   IS NOT NULL AND
n7.valid   IS NOT NULL AND
n8.valid   IS NOT NULL AND
n9.valid   IS NOT NULL AND
n10.valid  IS NOT NULL AND
n11.valid  IS NOT NULL AND
n12.valid  IS NOT NULL AND
n13.valid  IS NOT NULL AND
n14.valid  IS NOT NULL AND
n15.valid  IS NOT NULL AND
n16.valid  IS NOT NULL AND
n17.valid  IS NOT NULL AND
n18.valid  IS NOT NULL AND
n19.valid  IS NOT NULL AND
n20.valid  IS NOT NULL AND
n21.valid  IS NOT NULL AND
n22.valid  IS NOT NULL AND
n23.valid  IS NOT NULL AND
n24.valid  IS NOT NULL AND
n25.valid  IS NOT NULL AND
n26.valid  IS NOT NULL AND
n27.valid  IS NOT NULL AND
n28.valid  IS NOT NULL AND
n29.valid  IS NOT NULL AND
n30.valid  IS NOT NULL AND
n31.valid  IS NOT NULL AND
n32.valid  IS NOT NULL AND
n33.valid  IS NOT NULL AND
n34.valid  IS NOT NULL AND
n35.valid  IS NOT NULL AND
n36.valid  IS NOT NULL AND
n37.valid  IS NOT NULL

ORDER BY d.id;




DROP VIEW IF EXISTS index9;

CREATE VIEW index9

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(9                     ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(minutesf(n1.dauer)    ::text,''),
coalesce(minutesf(n2.dauer)    ::text,''),
coalesce(minutesf(n3.dauer)    ::text,''),
coalesce(minutesf(n4.dauer)    ::text,''),
coalesce(minutesf(n5.dauer)    ::text,''),
coalesce(minutesf(n6.dauer)    ::text,''),
coalesce(minutesf(n7.dauer)    ::text,''),
coalesce(minutesf(n8.dauer)    ::text,''),
coalesce(minutesf(n9.dauer)    ::text,''),
coalesce(minutesf(n10.dauer)   ::text,''),
coalesce(minutesf(n11.dauer)   ::text,''),
coalesce(minutesf(n12.dauer)   ::text,''),
coalesce(minutesf(n13.dauer)   ::text,''),
coalesce(minutesf(n14.dauer)   ::text,''),
coalesce(minutesf(n15.dauer)   ::text,''),
coalesce(minutesf(n16.dauer)   ::text,''),
coalesce(minutesf(n17.dauer)   ::text,''),
coalesce(minutesf(n18.dauer)   ::text,''),
coalesce(minutesf(n19.dauer)   ::text,''),
coalesce(minutesf(n20.dauer)   ::text,''),
coalesce(minutesf(n21.dauer)   ::text,''),
coalesce(minutesf(n22.dauer)   ::text,''),
coalesce(minutesf(n23.dauer)   ::text,''),
coalesce(minutesf(n24.dauer)   ::text,''),
coalesce(minutesf(n25.dauer)   ::text,''),
coalesce(minutesf(n26.dauer)   ::text,''),
coalesce(minutesf(n27.dauer)   ::text,''),
coalesce(minutesf(n28.dauer)   ::text,''),
coalesce(minutesf(n29.dauer)   ::text,''),
coalesce(minutesf(n30.dauer)   ::text,''),
coalesce(minutesf(n31.dauer)   ::text,''),
coalesce(minutesf(n32.dauer)   ::text,''),
coalesce(minutesf(n33.dauer)   ::text,''),
coalesce(minutesf(n34.dauer)   ::text,''),
coalesce(minutesf(n35.dauer)   ::text,''),
coalesce(minutesf(n36.dauer)   ::text,''),
coalesce(minutesf(n37.dauer)   ::text,'')
],'|') AS index9


FROM

datensatz d                         
LEFT JOIN visiten                              n1 ON n1.id=d.id
LEFT JOIN kontakte_kotherapeutisch             n2 ON n2.id=d.id
LEFT JOIN besprechung_patientenbezogen         n3 ON n3.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_bis12     n4 ON n4.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_ab13      n5 ON n5.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_bis12 n6 ON n6.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_ab13  n7 ON n7.id=d.id
LEFT JOIN gruppe_andere_verbale_bis12          n8 ON n8.id=d.id
LEFT JOIN gruppe_andere_verbale_ab13           n9 ON n9.id=d.id
LEFT JOIN gruppe_kunst                         n10 ON n10.id=d.id
LEFT JOIN gruppe_musik                         n11 ON n11.id=d.id
LEFT JOIN gruppe_koerper                       n12 ON n12.id=d.id
LEFT JOIN gruppe_soziale_interaktion           n13 ON n13.id=d.id
LEFT JOIN gruppe_entspannung                   n14 ON n14.id=d.id
LEFT JOIN gruppe_meditation                    n15 ON n15.id=d.id
LEFT JOIN gruppe_themenzentriert               n16 ON n16.id=d.id
LEFT JOIN gruppe_indikation                    n17 ON n17.id=d.id
LEFT JOIN gruppe_andere                        n18 ON n18.id=d.id
LEFT JOIN gruppe_milieu_versammlung            n19 ON n19.id=d.id
LEFT JOIN gruppe_milieu_themenzentriert        n20 ON n20.id=d.id
LEFT JOIN gruppe_milieu_andere                 n21 ON n21.id=d.id
LEFT JOIN einzel_tiefenpsychologisch           n22 ON n22.id=d.id
LEFT JOIN einzel_verhaltenstherapeutisch       n23 ON n23.id=d.id
LEFT JOIN einzel_andere_verbale                n24 ON n24.id=d.id
LEFT JOIN einzel_paar                          n25 ON n25.id=d.id
LEFT JOIN einzel_kunst                         n26 ON n26.id=d.id
LEFT JOIN einzel_musik                         n27 ON n27.id=d.id
LEFT JOIN einzel_koerper                       n28 ON n28.id=d.id
LEFT JOIN einzel_entspannung                   n29 ON n29.id=d.id
LEFT JOIN einzel_meditation                    n30 ON n30.id=d.id
LEFT JOIN einzel_themenzentriert               n31 ON n31.id=d.id
LEFT JOIN einzel_andere_sonstige               n32 ON n32.id=d.id
LEFT JOIN einzel_milieu_sozio                  n33 ON n33.id=d.id
LEFT JOIN einzel_milieu_andere                 n34 ON n34.id=d.id
LEFT JOIN gruppe_soma                          n35 ON n35.id=d.id
LEFT JOIN einzel_soma                          n36 ON n36.id=d.id
LEFT JOIN balneotherapie                       n37 ON n37.id=d.id

WHERE

n1.valid   IS NOT NULL AND
n2.valid   IS NOT NULL AND
n3.valid   IS NOT NULL AND
n4.valid   IS NOT NULL AND
n5.valid   IS NOT NULL AND
n6.valid   IS NOT NULL AND
n7.valid   IS NOT NULL AND
n8.valid   IS NOT NULL AND
n9.valid   IS NOT NULL AND
n10.valid  IS NOT NULL AND
n11.valid  IS NOT NULL AND
n12.valid  IS NOT NULL AND
n13.valid  IS NOT NULL AND
n14.valid  IS NOT NULL AND
n15.valid  IS NOT NULL AND
n16.valid  IS NOT NULL AND
n17.valid  IS NOT NULL AND
n18.valid  IS NOT NULL AND
n19.valid  IS NOT NULL AND
n20.valid  IS NOT NULL AND
n21.valid  IS NOT NULL AND
n22.valid  IS NOT NULL AND
n23.valid  IS NOT NULL AND
n24.valid  IS NOT NULL AND
n25.valid  IS NOT NULL AND
n26.valid  IS NOT NULL AND
n27.valid  IS NOT NULL AND
n28.valid  IS NOT NULL AND
n29.valid  IS NOT NULL AND
n30.valid  IS NOT NULL AND
n31.valid  IS NOT NULL AND
n32.valid  IS NOT NULL AND
n33.valid  IS NOT NULL AND
n34.valid  IS NOT NULL AND
n35.valid  IS NOT NULL AND
n36.valid  IS NOT NULL AND
n37.valid  IS NOT NULL

 ORDER BY d.id;

DROP VIEW IF EXISTS index9_v;

CREATE VIEW index9_v

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(9                     ::text,''),
coalesce(1        ::text,''),
coalesce(1    ::text,''),
coalesce(1        ::text,''),
coalesce(n1.valid    ::text,''),
coalesce(n2.valid    ::text,''),
coalesce(n3.valid    ::text,''),
coalesce(n4.valid    ::text,''),
coalesce(n5.valid    ::text,''),
coalesce(n6.valid    ::text,''),
coalesce(n7.valid    ::text,''),
coalesce(n8.valid    ::text,''),
coalesce(n9.valid    ::text,''),
coalesce(n10.valid   ::text,''),
coalesce(n11.valid   ::text,''),
coalesce(n12.valid   ::text,''),
coalesce(n13.valid   ::text,''),
coalesce(n14.valid   ::text,''),
coalesce(n15.valid   ::text,''),
coalesce(n16.valid   ::text,''),
coalesce(n17.valid   ::text,''),
coalesce(n18.valid   ::text,''),
coalesce(n19.valid   ::text,''),
coalesce(n20.valid   ::text,''),
coalesce(n21.valid   ::text,''),
coalesce(n22.valid   ::text,''),
coalesce(n23.valid   ::text,''),
coalesce(n24.valid   ::text,''),
coalesce(n25.valid   ::text,''),
coalesce(n26.valid   ::text,''),
coalesce(n27.valid   ::text,''),
coalesce(n28.valid   ::text,''),
coalesce(n29.valid   ::text,''),
coalesce(n30.valid   ::text,''),
coalesce(n31.valid   ::text,''),
coalesce(n32.valid   ::text,''),
coalesce(n33.valid   ::text,''),
coalesce(n34.valid   ::text,''),
coalesce(n35.valid   ::text,''),
coalesce(n36.valid   ::text,''),
coalesce(n37.valid   ::text,'')
],'|') AS index9


FROM

datensatz d                         
LEFT JOIN visiten                              n1 ON n1.id=d.id
LEFT JOIN kontakte_kotherapeutisch             n2 ON n2.id=d.id
LEFT JOIN besprechung_patientenbezogen         n3 ON n3.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_bis12     n4 ON n4.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_ab13      n5 ON n5.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_bis12 n6 ON n6.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_ab13  n7 ON n7.id=d.id
LEFT JOIN gruppe_andere_verbale_bis12          n8 ON n8.id=d.id
LEFT JOIN gruppe_andere_verbale_ab13           n9 ON n9.id=d.id
LEFT JOIN gruppe_kunst                         n10 ON n10.id=d.id
LEFT JOIN gruppe_musik                         n11 ON n11.id=d.id
LEFT JOIN gruppe_koerper                       n12 ON n12.id=d.id
LEFT JOIN gruppe_soziale_interaktion           n13 ON n13.id=d.id
LEFT JOIN gruppe_entspannung                   n14 ON n14.id=d.id
LEFT JOIN gruppe_meditation                    n15 ON n15.id=d.id
LEFT JOIN gruppe_themenzentriert               n16 ON n16.id=d.id
LEFT JOIN gruppe_indikation                    n17 ON n17.id=d.id
LEFT JOIN gruppe_andere                        n18 ON n18.id=d.id
LEFT JOIN gruppe_milieu_versammlung            n19 ON n19.id=d.id
LEFT JOIN gruppe_milieu_themenzentriert        n20 ON n20.id=d.id
LEFT JOIN gruppe_milieu_andere                 n21 ON n21.id=d.id
LEFT JOIN einzel_tiefenpsychologisch           n22 ON n22.id=d.id
LEFT JOIN einzel_verhaltenstherapeutisch       n23 ON n23.id=d.id
LEFT JOIN einzel_andere_verbale                n24 ON n24.id=d.id
LEFT JOIN einzel_paar                          n25 ON n25.id=d.id
LEFT JOIN einzel_kunst                         n26 ON n26.id=d.id
LEFT JOIN einzel_musik                         n27 ON n27.id=d.id
LEFT JOIN einzel_koerper                       n28 ON n28.id=d.id
LEFT JOIN einzel_entspannung                   n29 ON n29.id=d.id
LEFT JOIN einzel_meditation                    n30 ON n30.id=d.id
LEFT JOIN einzel_themenzentriert               n31 ON n31.id=d.id
LEFT JOIN einzel_andere_sonstige               n32 ON n32.id=d.id
LEFT JOIN einzel_milieu_sozio                  n33 ON n33.id=d.id
LEFT JOIN einzel_milieu_andere                 n34 ON n34.id=d.id
LEFT JOIN gruppe_soma                          n35 ON n35.id=d.id
LEFT JOIN einzel_soma                          n36 ON n36.id=d.id
LEFT JOIN balneotherapie                       n37 ON n37.id=d.id

WHERE

n1.valid   IS NOT NULL AND
n2.valid   IS NOT NULL AND
n3.valid   IS NOT NULL AND
n4.valid   IS NOT NULL AND
n5.valid   IS NOT NULL AND
n6.valid   IS NOT NULL AND
n7.valid   IS NOT NULL AND
n8.valid   IS NOT NULL AND
n9.valid   IS NOT NULL AND
n10.valid  IS NOT NULL AND
n11.valid  IS NOT NULL AND
n12.valid  IS NOT NULL AND
n13.valid  IS NOT NULL AND
n14.valid  IS NOT NULL AND
n15.valid  IS NOT NULL AND
n16.valid  IS NOT NULL AND
n17.valid  IS NOT NULL AND
n18.valid  IS NOT NULL AND
n19.valid  IS NOT NULL AND
n20.valid  IS NOT NULL AND
n21.valid  IS NOT NULL AND
n22.valid  IS NOT NULL AND
n23.valid  IS NOT NULL AND
n24.valid  IS NOT NULL AND
n25.valid  IS NOT NULL AND
n26.valid  IS NOT NULL AND
n27.valid  IS NOT NULL AND
n28.valid  IS NOT NULL AND
n29.valid  IS NOT NULL AND
n30.valid  IS NOT NULL AND
n31.valid  IS NOT NULL AND
n32.valid  IS NOT NULL AND
n33.valid  IS NOT NULL AND
n34.valid  IS NOT NULL AND
n35.valid  IS NOT NULL AND
n36.valid  IS NOT NULL AND
n37.valid  IS NOT NULL

ORDER BY d.id;

DROP VIEW IF EXISTS index10;

CREATE VIEW index10

AS

WITH ktlcat AS (
SELECT
p.id,
textcat_all(t.key||t2.key||lpad(text(p.anzahl),2,'0')) AS ktl,
p.valid AS valid
FROM
ktl2007 p,
ktl2007_typ t,
ktl2007_dauer_typ t2
WHERE p.typ=t.id AND p.ktl2007_dauer=t2.id
GROUP BY p.id, p.valid ORDER BY p.id)


SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(10                    ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(n1.ktl                ::text,'')
],'|') AS index10

FROM

datensatz d                         
LEFT JOIN ktlcat                         n1 ON n1.id=d.id

WHERE 

n1.valid IS NOT NULL

ORDER BY d.id;

DROP VIEW IF EXISTS index10_v;

CREATE VIEW index10_v

AS

WITH ktlcat AS (
SELECT
p.id,
textcat_all(t.key||t2.key||lpad(text(p.anzahl),2,'0')) AS ktl,
p.valid AS valid
FROM
ktl2007 p,
ktl2007_typ t,
ktl2007_dauer_typ t2
WHERE p.typ=t.id AND p.ktl2007_dauer=t2.id
GROUP BY p.id, p.valid ORDER BY p.id)


SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(10                    ::text,''),
coalesce(1       ::text,''),
coalesce(1    ::text,''),
coalesce(1        ::text,''),
coalesce(n1.valid                ::text,'')
],'|') AS index10

FROM

datensatz d                         
LEFT JOIN ktlcat                         n1 ON n1.id=d.id

WHERE 

n1.valid IS NOT NULL 

ORDER BY d.id;

DROP VIEW IF EXISTS index_all;

CREATE VIEW index_all

AS


SELECT d.id, d.behandler_nr, d.patienten_nr, 
	array_to_string(array[
	NULLIF(i1.index1,''),
	NULLIF(i2.index2,''),
	NULLIF(i3.index3,''),
	NULLIF(i4.index4,''),
	NULLIF(i5.index5,''),
	NULLIF(i6.index6,''),
	NULLIF(i7.index7,''),
	NULLIF(i8.index8,''),
	NULLIF(i9.index9,''),
	NULLIF(i10.index10,'')
	],'|') AS indexes
	FROM datensatz d
             LEFT JOIN index1 i1 ON d.id = i1.id
             LEFT JOIN index2 i2 ON d.id = i2.id
             LEFT JOIN index3 i3 ON d.id = i3.id
             LEFT JOIN index4 i4 ON d.id = i4.id
             LEFT JOIN index5 i5 ON d.id = i5.id
             LEFT JOIN index6 i6 ON d.id = i6.id
             LEFT JOIN index7 i7 ON d.id = i7.id
             LEFT JOIN index8 i8 ON d.id = i8.id
             LEFT JOIN index9 i9 ON d.id = i9.id
             LEFT JOIN index10 i10 ON d.id = i10.id ORDER BY d.id;
			 
DROP VIEW IF EXISTS index_all_v;

CREATE VIEW index_all_v

AS

SELECT d.id, d.behandler_nr, d.patienten_nr, 
	array_to_string(array[
	NULLIF(i1.index1,''),
	NULLIF(i2.index2,''),
	NULLIF(i3.index3,''),
	NULLIF(i4.index4,''),
	NULLIF(i5.index5,''),
	NULLIF(i6.index6,''),
	NULLIF(i7.index7,''),
	NULLIF(i8.index8,''),
	NULLIF(i9.index9,''),
	NULLIF(i10.index10,'')
	],'|') AS indexes_v
	FROM datensatz d
             LEFT JOIN index1_v i1 ON d.id = i1.id
             LEFT JOIN index2_v i2 ON d.id = i2.id
             LEFT JOIN index3_v i3 ON d.id = i3.id
             LEFT JOIN index4_v i4 ON d.id = i4.id
             LEFT JOIN index5_v i5 ON d.id = i5.id
             LEFT JOIN index6_v i6 ON d.id = i6.id
             LEFT JOIN index7_v i7 ON d.id = i7.id
             LEFT JOIN index8_v i8 ON d.id = i8.id
             LEFT JOIN index9_v i9 ON d.id = i9.id
             LEFT JOIN index10_v i10 ON d.id = i10.id ORDER BY d.id;
