#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Copyright 2006 - 2010:
#    Qualitas GmbH support@iqp-online.de


import pickle

db = pickle.load(file('enum.pickle'))


validity = {
      1:u'Gültig',
     -1:u'Nicht anwendbar',
     -2:u'Unbekannt',
     -3:u'Nicht erhoben',
     -4:u'Strukt. nicht gegeben',
     -5:u'Nicht durchgeführt / Nicht stattgefunden',
     -6:u'Nicht verordnet / Nicht teilgenommen',
    -10:u'Nicht angegeben',
    -11:u'Falscher Datentyp',
    -12:u'Außerhalb des Wertebereichs',
    -13:u'Logik-Fehler',
    -14:u'Ungültiger Wert',
}

isrcolor = [(0.3, 0.6, 0),(0.6,0.6,0),(0.8,0.75,0),(0.8,0.5,0),(0.8, 0.3, 0)]

isr_norm = {u'depression':[(0.0,0.75,isrcolor[0],0),(0.75,1.0,isrcolor[1],1),(1.0,2.0,isrcolor[2],2),(2.0,3.0,isrcolor[3],3),(3.0,4.1,isrcolor[4],4)],
            u'angst':[(0.0,0.75,isrcolor[0],0),(0.75,1.0,isrcolor[1],1),(1.0,2.0,isrcolor[2],2),(2.0,3.0,isrcolor[3],3),(3.0,4.1,isrcolor[4],4)],
            u'zwang':[(0.0,0.66,isrcolor[0],0),(0.66,1.0,isrcolor[1],1),(1.0,2.0,isrcolor[2],2),(2.0,3.0,isrcolor[3],3),(3.0,4.1,isrcolor[4],4)],
            u'soma':[(0.0,0.33,isrcolor[0],0),(0.33,0.75,isrcolor[1],1),(0.75,1.25,isrcolor[2],2),(1.25,2.66,isrcolor[3],3),(2.66,4.1,isrcolor[4],4)],
            u'essstörung':[(0.0,0.33,isrcolor[0],0),(0.33,0.66,isrcolor[1],1),(0.66,1.5,isrcolor[2],2),(1.5,2.75,isrcolor[3],3),(2.75,4.1,isrcolor[4],4)],
            u'zusatz':[(0.0,1.0,isrcolor[0],0),(1.0,4.1,isrcolor[3],3)],
            u'gesamt':[(0.0,0.5,isrcolor[0],0),(0.5,0.6,isrcolor[1],1),(0.6,0.9,isrcolor[2],2),(0.9,1.7,isrcolor[3],3),(1.7,4.1,isrcolor[4],4)],
            u'isr_d04':[(0.0,1.0,isrcolor[0],0),(1.0,4.1,isrcolor[3],3)],
            u'isr_d10':[(0.0,1.0,isrcolor[0],0),(1.0,4.1,isrcolor[3],3)],
            u'isr_d11':[(0.0,1.0,isrcolor[0],0),(1.0,4.1,isrcolor[3],3)],
            u'isr_d12':[(0.0,1.0,isrcolor[0],0),(1.0,4.1,isrcolor[3],3)],
            u'isr_w01':[(0.0,1.0,isrcolor[0],0),(1.0,4.1,isrcolor[3],3)],
            u'isr_w02':[(0.0,1.0,isrcolor[0],0),(1.0,4.1,isrcolor[3],3)],
            u'isr_w03':[(0.0,1.0,isrcolor[0],0),(1.0,4.1,isrcolor[3],3)],
            u'isr_w05':[(0.0,1.0,isrcolor[0],0),(1.0,4.1,isrcolor[3],3)],
            u'isr_w06':[(0.0,1.0,isrcolor[0],0),(1.0,4.1,isrcolor[3],3)],
            u'isr_w07':[(0.0,1.0,isrcolor[0],0),(1.0,4.1,isrcolor[3],3)],
            u'isr_w08':[(0.0,1.0,isrcolor[0],0),(1.0,4.1,isrcolor[3],3)],
            u'isr_w09':[(0.0,1.0,isrcolor[0],0),(1.0,4.1,isrcolor[3],3)],
            }

mini_icf_color = isrcolor

isr_fcats = {'isr_d01':[(u'Depression (F32,F33,34.1)','F(3[23]|341)')],
             'isr_a01':[(u'Angst (F40, F41)','F(4[01])')],
             'isr_z01':[(u'Zwang (F42)','F42')],
             'isr_s01':[(u'Somatoform (F45)','F45')],
             'isr_e01':[(u'Essstörung (F50)','F50')]}

fcats = [
        (u'Organische Störung (F0)',                                        'F0'), 
        (u'Psych. Störung durch Alkohol (F10)',                            'F10'), 
        (u'Sonstige Substanzmittel (F11-19)',                          'F1[1-9]'),
        (u'Psychotische Störung (F2)',                                      'F2'),
        (u'Manische, bipolare Störung (F30-31)',                        'F3[01]'),
        (u'Depressive Episode (F32)',                                      'F32'),
        (u'Rezidivierende depressive Störung (F33)',                       'F33'),
        (u'Sonst. anh. affekt. Störung (F34.0/8/9, F38-39)', 'F(34[02-9]|3[89]|34$)'),
        (u'Dysthymia (F34.1)',                                             'F341'),
        (u'Phobie (F40)',                                                  'F40'),
        (u'Sonstige Angststörung (F41)',                                   'F41'),
        (u'Zwangstörung (F42)',                                            'F42'),
        (u'Anpassungsstörung (F43.2/8/9)',                            'F(43[289]|43$)'),
        (u'Akute Belastungsreaktion (F43.0)',                              'F430'),
        (u'Psycho-Traumatisierung (F43.1)',                                'F431'),
        (u'Dissoziative Störung (F44)',                                    'F44'),
        (u'Somatoforme Störung (F45)',                                     'F45'),
        (u'Sonstige neurotische Störungen (F48)',                          'F48'),
        (u'Essstörungen (F50)',                                            'F50'),
        (u'Sonst. Verh.-auff. mit somat. Fakt. (F51-53)',              'F5[123]'),
        (u'Psych. Faktoren anderorts klassifiziert (F54)',                 'F54'),
        (u'Mißbrauch ohne Abhängigkeit (F55)',                             'F55'),
        (u'Sonstige Verhaltensauffälligkeiten (F59)',                      'F59'),
        (u'Persönlichkeitsstörung (F60-61)',                            'F6[01]'),
        (u'Andere Persönlichkeitsstörungen (F62-69)',                'F(6[2-9])'),
        (u'Intelligenzminderung (F7)',                                      'F7'),
        (u'Entwicklungsstörungen (F8)',                                     'F8'),
        (u'Störung beginnend in Kindheit und Jugend (F9)',                  'F9'),
        ] 

scats = [
        (u'Infektionskrankheiten (A00-B99)', '(A|B)'),
        (u'Neubildungen (C00-D48)', '(C|(D(0|1|2|3|4)))'),
        (u'Blutkrankheiten (D50-90)', 'D(5|6|7|8|9)'),
        (u'Endokrine / Stoffwechselkrankheiten (E00-E90)', 'E'),
        (u'Nervensystem (G00-G99)', 'G'),
        (u'Augenkrankheiten (H00-H59)', 'H(0|1|2|3|4|5)'),
        (u'Ohrenkrankheiten (H60-H95)', 'H(6|7|8|9)'),
        (u'Kreislaufkrankheiten (I00-I99)', 'I'),
        (u'Atmungssystem (J00-J99)', 'J'),
        (u'Verdauungssystem (K00-K93)', 'K'),
        (u'Hautkrankheiten (L00-L99)', 'L'),
        (u'Muskel-Skelett-System (M00-M99)', 'M'),
        (u'Urogenitalsystem (N00-N99)', 'N'),
        (u'Schwangerschaft / Geburt (O00-O99)', 'O'),
        (u'Perinatalperiode (P00-P96)', 'P'),
        (u'Fehlbildungen / Chromosomenanomalien (Q00-Q99)', 'Q'),
        (u'Nicht klassifizierte Symptome (R00-R99)', 'R'),
        (u'Verletzungen / Vergiftungen (S00-T98)', '(S|T)'),
        (u'Besondere Schlüsselnummern (U00-U99)', 'U'),
        (u'Äußere Ursachen Morbidität (V00-Y98)', '(V|W|X|Y)'),
        (u'Einflussfaktoren Gesundheitszustand (Z00-Z99)', 'Z'),
]


dateiformat = {
    1 :['behandler_nr',
        'sub_behandler_nr',
        'patienten_nr',
        'versorgungsbereich',
        'aufnahmedatum',
        'kostentraeger',
        'abrechnungsart',
        'einweiser',
        'barriere',
        'rentenbegehren',
        'suizidversuch',
        'suizidversuch_anzahl',
        'motivation',
        'anamnese_gesamt',
        'anamnese_aktuell',
        'hauptdiagnose',
        ['psychische_diagnose',
        'psychische_diagnose_sicherheit'],
        ['somatische_diagnose',
        'somatische_diagnose_sicherheit'],
        'gaf_a',
        'garf_a'
        ],
    2 :['behandler_nr',
        'sub_behandler_nr',
        'patienten_nr',
        'behandlungsempfehlung',
        'geschlecht',
        'geburtsdatum',
        'nation',
        'haushalt',
        'partnersituation',
        'familienstand',
        'anzahl_kinder',
        'schulabschluss',
        'berufsabschluss',
        'berufstaetigkeit',
        'erwerbstaetigkeit',
        'haupteinkommen',
        'au_aufnahme',
        'au_gesamt',
        'rentenverfahren',
        'stat_vorbeh_anzahl',
        'stat_vorbeh_dauer',
        'teilstat_vorbeh_anzahl',
        'teilstat_vorbeh_dauer',
        'amb_vorbeh_anzahl',
        'amb_vorbeh_dauer',
        'amb_vorbeh_aufnahme',
        'pharma_aufnahme'
         ],
    3: ['behandler_nr',
        'sub_behandler_nr',
        'patienten_nr',
        'entlassungsdatum',
        'behandlungsdauer',
        'anzahl_sitzungen',
        'beendigungsart',
        'af_entlassung',
        'alltagspflichten_therapeut',
        'aenderung_koerperlich_therapeut',
        'aenderung_psychisch_therapeut',
        'gaf_e',
        'garf_e',
        'vev_k',
        'medikation_antidepressiva',
        'medikation_anxiolytika',
        'medikation_neuroleptika',
        'medikation_analgetika',
        'weiterbehandlung'],
    4: ['behandler_nr',
        'sub_behandler_nr',
        'patienten_nr',
        'alltagspflichten_patient',
        'zuf_1',
        'zuf_2',
        'zuf_3',
        'zuf_4',
        'zuf_5',
        'zuf_6',
        'zuf_7',
        'zuf_8',
        'aenderung_koerperlich_patient',
        'aenderung_psychisch_patient',
        'aenderung_selbstwerterleben',
        'aenderung_sozial',
        'aenderung_privat',
        'aenderung_beruflich',
        'aenderung_eigenaktivitaet',
        'aenderung_krankheitsverstaendnis',
        'aenderung_zukunft',
        'aenderung_befinden',
        'aenderung_alltag'],
        
    5: ['behandler_nr',
        'sub_behandler_nr',
        'patienten_nr',
        'isr_datum',
        'isr_d01',
        'isr_d02',
        'isr_d03',
        'isr_d05',
        'isr_a01',
        'isr_a02',
        'isr_a03',
        'isr_a04',
        'isr_z01',
        'isr_z02',
        'isr_z03',
        'isr_s01',
        'isr_s02',
        'isr_s03',
        'isr_e01',
        'isr_e02',
        'isr_e03',
        'isr_d04',
        'isr_d10',
        'isr_d11',
        'isr_d12',
        'isr_w01',
        'isr_w02',
        'isr_w03',
        'isr_w05',
        'isr_w06',
        'isr_w07',
        'isr_w08',
        'isr_w09'
        ],
    6: ['behandler_nr',
        'sub_behandler_nr',
        'patienten_nr',
        'mini_icf_datum',
        'mini_icf_01',
        'mini_icf_02',
        'mini_icf_03',
        'mini_icf_04',
        'mini_icf_05',
        'mini_icf_06',
        'mini_icf_07',
        'mini_icf_08',
        'mini_icf_09',
        'mini_icf_10',
        'mini_icf_11',
        'mini_icf_12',
        'mini_icf_13',
        'mini_icf_gesamt'],
    7: ['behandler_nr',
        'sub_behandler_nr',
        'patienten_nr',
        'scl90_datum',
        'scl90_somatisierung',
        'scl90_zwanghaftigkeit',
        'scl90_sozialkontakt',
        'scl90_depressivitaet',
        'scl90_aengstlichkeit',
        'scl90_aggressivitaet',
        'scl90_phobische_angst',
        'scl90_paranoides_denken',
        'scl90_psychotizismus',
        'scl90_gsi'],
    8: ['behandler_nr',
        'sub_behandler_nr',
        'patienten_nr',
        'visiten',
        'kontakte_kotherapeutisch',
        'besprechung_patientenbezogen',
        'gruppe_tiefenpsychologisch_bis10',
        'gruppe_tiefenpsychologisch_ab11',
        'gruppe_verhaltenstherapeutisch_bis10',
        'gruppe_verhaltenstherapeutisch_ab11',
        'gruppe_andere_verbale_bis10',
        'gruppe_andere_verbale_ab11',
        'gruppe_kunst',
        'gruppe_musik',
        'gruppe_koerper',
        'gruppe_soziale_interaktion',
        'gruppe_entspannung',
        'gruppe_meditation',
        'gruppe_themenzentriert',
        'gruppe_indikation',
        'gruppe_andere',
        'gruppe_milieu_versammlung',
        'gruppe_milieu_themenzentriert',
        'gruppe_milieu_andere',
        'einzel_tiefenpsychologisch',
        'einzel_verhaltenstherapeutisch',
        'einzel_andere_verbale',
        'einzel_paar',
        'einzel_kunst',
        'einzel_musik',
        'einzel_koerper',
        'einzel_entspannung',
        'einzel_meditation',
        'einzel_themenzentriert',
        'einzel_andere_sonstige',
        'einzel_milieu_sozio',
        'einzel_milieu_andere',
        'gruppe_soma',
        'einzel_soma',
        'balneotherapie'],
    9: ['behandler_nr',
        'sub_behandler_nr',
        'patienten_nr',
        'visiten',
        'kontakte_kotherapeutisch',
        'besprechung_patientenbezogen',
        'gruppe_tiefenpsychologisch_bis12',
        'gruppe_tiefenpsychologisch_ab13',
        'gruppe_verhaltenstherapeutisch_bis12',
        'gruppe_verhaltenstherapeutisch_ab13',
        'gruppe_andere_verbale_bis12',
        'gruppe_andere_verbale_ab13',
        'gruppe_kunst',
        'gruppe_musik',
        'gruppe_koerper',
        'gruppe_soziale_interaktion',
        'gruppe_entspannung',
        'gruppe_meditation',
        'gruppe_themenzentriert',
        'gruppe_indikation',
        'gruppe_andere',
        'gruppe_milieu_versammlung',
        'gruppe_milieu_themenzentriert',
        'gruppe_milieu_andere',
        'einzel_tiefenpsychologisch',
        'einzel_verhaltenstherapeutisch',
        'einzel_andere_verbale',
        'einzel_paar',
        'einzel_kunst',
        'einzel_musik',
        'einzel_koerper',
        'einzel_entspannung',
        'einzel_meditation',
        'einzel_themenzentriert',
        'einzel_andere_sonstige',
        'einzel_milieu_sozio',
        'einzel_milieu_andere',
        'gruppe_soma',
        'einzel_soma',
        'balneotherapie'],
    10: ['behandler_nr',
        'sub_behandler_nr',
        'patienten_nr',
        'ktl2007']
 }



check = {

'behandler_nr':{'db_tabelle':'datensatz',
        'db_spalte':'behandler_nr',
        'name':u'Behandlernummer',
        'typ':'enum',
        'werte':db['behandler']},

'sub_behandler_nr':{'db_tabelle':'datensatz',
        'db_spalte':'sub_behandler_nr',
        'name':u'Sub-Behandlernummer',
        'typ':'alpha',
        'min':1, 'max':10,
        'fehler':{u'9999999999':-3}},

'patienten_nr':{'db_tabelle':'datensatz',
        'db_spalte':'patienten_nr',
        'name':u'Patientennummer',
        'typ':'alpha',
        'min':1, 'max':20},

'versorgungsbereich':{'db_tabelle':'versorgungsbereich',
        'db_spalte':'typ',
        'name':u'Versorgungsbereich',
        'typ':'enum',
        'werte':db['versorgungsbereich']},

'aufnahmedatum':{'db_tabelle':'aufnahmedatum',
        'db_spalte':'datum',
        'name':u'Aufnahmedatum',
        'typ':'datum'},

'kostentraeger':{'db_tabelle':'kostentraeger',
        'db_spalte':'typ',
        'name':u'Kostenträger',
        'typ':'enum',
        'werte':db['kostentraeger']},

'abrechnungsart':{'db_tabelle':'abrechnungsart',
        'db_spalte':'typ',
        'name':u'Abrechnungsart',
        'typ':'enum',
        'werte':db['abrechnungsart']},

'einweiser':{'db_tabelle':'einweiser',
        'db_spalte':'typ',
        'name':u'Einweiser',
        'typ':'enum',
        'werte':db['einweiser']},

'barriere':{'db_tabelle':'barriere',
        'db_spalte':'typ',
        'name':u'Sprach- und Kulturbarrieren',
        'typ':'enum',
        'werte':db['barriere']},

'haushalt':{'db_tabelle':'haushalt',
        'db_spalte':'typ',
        'name':u'Haushalt',
        'typ':'enum',
        'werte':db['haushalt']},

'rentenbegehren':{'db_tabelle':'rentenbegehren',
        'db_spalte':'typ',
        'name':u'Rentenbegehren',
        'typ':'enum',
        'werte':db['rentenbegehren'],
        'fehler':{999:-3}},

'suizidversuch':{'db_tabelle':'suizidversuch',
        'db_spalte':'typ',
        'name':u'Suizidversuch',
        'typ':'enum',
        'werte':db['suizidversuch']},

'suizidversuch_anzahl':{'db_tabelle':'suizidversuch_anzahl',
        'db_spalte':'anzahl',
        'name':u'Anzahl Suizidversuche',
        'typ':'integer',
        'descr_unit':u'Anzahl Suizidversuche ($ \\pm $ SD)',
        'min':0, 'max':12,
        'fehler':{999:-2}},

'motivation':{'db_tabelle':'motivation',
        'db_spalte':'typ',
        'name':u'Motivation',
        'typ':'enum',
        'werte':db['motivation']},

'anamnese_gesamt':{'db_tabelle':'anamnese_gesamt',
        'db_spalte':'typ',
        'name':u'Krankheitsanamnese gesamt',
        'typ':'enum',
        'werte':db['anamnese_gesamt']},        
        
'anamnese_aktuell':{'db_tabelle':'anamnese_aktuell',
        'db_spalte':'typ',
        'name':u'Krankheitsanamnese aktuell',
        'typ':'enum',
        'werte':db['anamnese_aktuell'],
        'fehler':{888:-3}},

'hauptdiagnose':{'db_tabelle':'hauptdiagnose',
        'db_spalte':'typ',
        'name':u'Hauptdiagnose',
        'typ':'enum',
        'werte':db['hauptdiagnose']},
        
'psychische_diagnose':{'db_tabelle':'psychische_diagnose',
        'db_spalte':'typ',
        'name':u'Psych. ICD-10-Diagnosen',
        'typ':'enum_diag_multi',
        'werte':db['diagnose'],
        'descr_unit':u'Anzahl Diagnosen ($ \\pm $ SD)',
        'variante': {'psychische_diagnose_anzahl':{'name':u'Anzahl psychische ICD-10-Diagnosen','db_spalte':'anzahl', 'db_tabelle':'psychische_diagnose_anzahl', 'db_valid':'valid'},
                     'somatische_diagnose_anzahl':{'name':u'Anzahl somatische ICD-10-Diagnosen','db_spalte':'anzahl', 'db_tabelle':'somatische_diagnose_anzahl', 'db_valid':'valid'},
                     'icd10_check':{'name':u'Anzahl Diagnosekombinationen'},
                     'sicher':{'db_spalte':'sicher', 'db_valid':'sicher != -1', 'db_typtab':'sicher_typ', 'db_id':'id'}},
        'db_typtab':'diagnose_typ',
        'db_id':'key'},

'psychische_diagnose_sicherheit':{'db_tabelle':'psychische_diagnose',
        'db_spalte':'sicher',
        'name':u'Psych. Diagnosen Sicherheit',
        'typ':'enum_multi',
        'werte':db['sicher'],
        'fehler':{999:-3}},
        
'somatische_diagnose':{'db_tabelle':'somatische_diagnose',
        'db_spalte':'typ',
        'db_typtab':'diagnose_typ',
        'db_id':'key',
        'name':u'Somat. ICD-10-Diagnosen',
        'typ':'enum_diag_multi',
        'werte':db['diagnose'],
        'fehler':{'99999':-1},
        'variante':{}},

'somatische_diagnose_sicherheit':{'db_tabelle':'somatische_diagnose',
        'db_spalte':'sicher',
        'name':u'Somat. Diagnose Sicherheit',
        'typ':'enum_multi',
        'werte':db['sicher'],
        'fehler':{999:-3}},        
        
'gaf_a':{'db_tabelle':'gaf_a',
        'db_spalte':'typ',
        'name':u'GAF bei Aufnahme',
        'typ':'enum',
        'fehler':{0:-2},        
        'db_tabelle_vgl':'gaf_e',
        'werte':db['gaf'],
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'style':'gaf'},

'garf_a':{'db_tabelle':'garf_a',
        'db_spalte':'typ',
        'name':u'GARF bei Aufnahme',
        'typ':'enum',        
        'db_tabelle_vgl':'garf_e',
        'werte':db['garf'],
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'fehler':{0:-2,999:-3},        
        'style':'gaf'},        
        

        
'behandlungsempfehlung':{'db_tabelle':'behandlungsempfehlung',
        'db_spalte':'typ',
        'name':u'Behandlungsempfehlung',
        'typ':'enum_multi',
        'werte':db['behandlungsempfehlung']},

'geschlecht':{'db_tabelle':'geschlecht',
        'db_spalte':'typ',
        'name':u'Geschlecht',
        'typ':'enum',
        'werte':db['geschlecht']},

'geburtsdatum':{'db_tabelle':'geburtsdatum',
        'db_spalte':'datum',
        'name':u'Geburtsdatum',
        'typ':'datum',
        'unit':'years','descr_unit':'Jahre Mittelwert ($ \\pm $ SD)',
        'variante':{'alter':{'db_tabelle':'alter_bei_aufnahme_view','db_spalte':'alter','db_valid':'valid', 'name':u'Alter bei Aufnahme'},
                    'altersklassen':{'db_tabelle':'altersklassen_view','db_spalte':'alter','db_valid':'valid', 'name':u'Alter bei Aufnahme','unit':''}}},

'nation':{'db_tabelle':'nation',
        'db_spalte':'typ',
        'name':u'Nationalität',
        'typ':'enum_s',
        'werte':db['nation']},

'partnersituation':{'db_tabelle':'partnersituation',
        'db_spalte':'typ',
        'name':u'Partnersituation',
        'typ':'enum',
        'werte':db['partnersituation']},

'familienstand':{'db_tabelle':'familienstand',
        'db_spalte':'typ',
        'name':u'Familienstand',
        'typ':'enum',
        'werte':db['familienstand']},

'anzahl_kinder':{'db_tabelle':'anzahl_kinder',
        'db_spalte':'anzahl',
        'name':u'Anzahl Kinder',
        'typ':'integer',
        'min':0, 'max':12,
        'fehler':{999:-3}},

'schulabschluss':{'db_tabelle':'schulabschluss',
        'db_spalte':'typ',
        'name':u'Schulabschluß',
        'typ':'enum',
        'werte':db['schulabschluss']},

'berufsabschluss':{'db_tabelle':'berufsabschluss',
        'db_spalte':'typ',
        'name':u'Berufsabschluß',
        'typ':'enum',
        'werte':db['berufsabschluss']},

'berufstaetigkeit':{'db_tabelle':'berufstaetigkeit',
        'db_spalte':'typ',
        'name':u'Derzeitige (bzw. letzte) Berufstätigkeit',
        'typ':'enum',
        'werte':db['berufstaetigkeit']},

'erwerbstaetigkeit':{'db_tabelle':'erwerbstaetigkeit',
        'db_spalte':'typ',
        'name':u'Erwerbstätigkeit',
        'typ':'enum',
        'werte':db['erwerbstaetigkeit']},

'haupteinkommen':{'db_tabelle':'haupteinkommen',
        'db_spalte':'typ',
        'name':u'Haupteinkommen',
        'typ':'enum',
        'werte':db['haupteinkommen']},

'au_aufnahme':{'db_tabelle':'au_aufnahme',
        'db_spalte':'dauer',
        'name':u'AU bei Aufnahme',
        'typ':'interval',
        'min':0, 'max':998, 
        'unit':'weeks','descr_unit':u'Wochen Mittelwert ($ \\pm $ SD)',
        'fehler':{999:-2},
        'weiche_grenze':1092},

'au_gesamt':{'db_tabelle':'au_gesamt',
        'db_spalte':'dauer',
        'name':u'AU gesamt',
        'typ':'interval',
        'Jahrpfusch':True,
        'min':0, 'max':52, 
        'unit':'weeks','descr_unit':u'Wochen Mittelwert ($ \\pm $ SD)',
        'fehler':{999:-2}},

'rentenverfahren':{'db_tabelle':'rentenverfahren',
        'db_spalte':'typ',
        'name':u'Rentenverfahren',
        'typ':'enum',
        'werte':db['rentenverfahren']},
        
'stat_vorbeh_anzahl':{'db_tabelle':'stat_vorbeh_anzahl',
        'db_spalte':'anzahl',
        'name':u'Stationäre Vorbehandler',
        'typ':'integer',
        'min':0, 'max':20,
        'variante':{'vorbehandlung_art':{'db_typtab':'vorbehandlung_art_typ', 'db_spalte':'typ', 'db_tabelle':'vorbehandlung_art', 'db_valid':'valid'}},
        'fehler':{999:-2}},
        
'stat_vorbeh_dauer':{'db_tabelle':'stat_vorbeh_dauer',
        'db_spalte':'dauer',
        'name':u'Stat. Vorbehandlungen Dauer',
        'typ':'interval',
        'min':0, 'max':208, 
        'unit':'weeks', 'descr_unit':u'Wochen ($ \\pm $ SD)',
        'fehler':{999:-2}}, 

'teilstat_vorbeh_anzahl':{'db_tabelle':'teilstat_vorbeh_anzahl',
        'db_spalte':'anzahl',
        'name':u'Teilstationäre Vorbehandler',
        'typ':'integer',
        'min':0, 'max':20,
        'fehler':{999:-2}},
        
'teilstat_vorbeh_dauer':{'db_tabelle':'teilstat_vorbeh_dauer',
        'db_spalte':'dauer',
        'name':u'Teilstat. Vorbehandlungen Dauer',
        'typ':'interval',
        'min':0, 'max':208, 
        'unit':'weeks', 'descr_unit':u'Wochen ($ \\pm $ SD)',
        'fehler':{999:-2}}, 
           
'amb_vorbeh_anzahl':{'db_tabelle':'amb_vorbeh_anzahl',
        'db_spalte':'anzahl',
        'name':u'Ambulante Vorbehandler',
        'typ':'integer',
        'min':0, 'max':20,
        'fehler':{999:-2}},
        
'amb_vorbeh_dauer':{'db_tabelle':'amb_vorbeh_dauer',
        'db_spalte':'typ',
        'name':u'Dauer amb. Vorbehandlungen',
        'typ':'enum',
        'werte':db['amb_vorbeh_dauer']},
        
'amb_vorbeh_aufnahme':{'db_tabelle':'amb_vorbeh_aufnahme',
        'db_spalte':'typ',
        'name':u'Amb. Psth. vor Aufnahme',
        'typ':'enum',
        'werte':db['ja_nein'],
        'db_typtab':'ja_nein_typ',
        'fehler':{999:-3}},

'pharma_aufnahme':{'db_tabelle':'pharma_aufnahme',
        'db_spalte':'typ',
        'name':u'Psychopharmaka vor Aufnahme',
        'typ':'enum',
        'werte':db['pharma_aufnahme']},
        
        
        
        
'entlassungsdatum':{'db_tabelle':'entlassungsdatum',
        'db_spalte':'datum',
        'name':u'Entlassungsdatum',
        'typ':'datum'},
        
'behandlungsdauer':{'db_tabelle':'behandlungsdauer',
        'db_spalte':'dauer',
        'name':u'Behandlungsdauer in Tagen',
        'typ':'interval',
        'min':1, 'max':730, 
        'fehler':{999:-3},        
        'unit':'days', 'descr_unit':u'Tage ($ \\pm $ SD)',
        'style':'behandlungsdauer',
        'variante':{'verweildauer':{'name':u'Verweildauer in Tagen',
                                    'db_tabelle':'verweildauer',
                                    'db_tabelle_vgl':'behandlungsdauer',
                                    'style':'verweildauer'},
                    'isr_gesamt':{'name':u'Behandlungsdauer nach ISR - Schweregrad Gesamt', 
                                            'db_tabelle_vgl':'isr_gesamt_schweregrad'},
                    'isr_d01':{'name':u'Behandlungsdauer nach ISR - Schweregrad Depression', 
                                            'db_tabelle_vgl':'isr_depr_schweregrad',
                                            'fcat':'isr_d01'},
                    'isr_a01':{'name':u'Behandlungsdauer nach ISR - Schweregrad Angst', 
                                            'db_tabelle_vgl':'isr_depr_schweregrad',
                                            'fcat':'isr_a01'},
                    'isr_z01':{'name':u'Behandlungsdauer nach ISR - Schweregrad Zwang', 
                                            'db_tabelle_vgl':'isr_depr_schweregrad',
                                            'fcat':'isr_z01'},
                    'isr_s01':{'name':u'Behandlungsdauer nach ISR - Schweregrad Somatisierung', 
                                            'db_tabelle_vgl':'isr_depr_schweregrad',
                                            'fcat':'isr_s01'},
                    'isr_e01':{'name':u'Behandlungsdauer nach ISR - Schweregrad Essstörung', 
                                            'db_tabelle_vgl':'isr_depr_schweregrad',
                                            'fcat':'isr_e01'},
                    'isr_gesamt_diff':{'name':u'Behandlungsdauer nach ISR - Differenzen und Schweregrad', 
                                            'db_tabelle_vgl':'isr_gesamt_schweregrad',
                                            'db_tabelle_score':'isr_gesamtscore',},
                    'isr_d01_diff':{'name':u'Behandlungsdauer nach ISR - Differenzen und Schweregrad', 
                                            'db_tabelle_vgl':'isr_depr_schweregrad',
                                            'db_tabelle_score':'isr_depressionscore',
                                            'fcat':'isr_d01'},
                    'isr_a01_diff':{'name':u'Behandlungsdauer nach ISR - Differenzen und Schweregrad', 
                                            'db_tabelle_vgl':'isr_angst_schweregrad',
                                            'db_tabelle_score':'isr_angstscore',
                                            'fcat':'isr_a01'},
                    'isr_z01_diff':{'name':u'Behandlungsdauer nach ISR - Differenzen und Schweregrad', 
                                            'db_tabelle_vgl':'isr_zwang_schweregrad',
                                            'db_tabelle_score':'isr_zwangscore',
                                            'fcat':'isr_z01'},
                    'isr_s01_diff':{'name':u'Behandlungsdauer nach ISR - Differenzen und Schweregrad', 
                                            'db_tabelle_vgl':'isr_soma_schweregrad',
                                            'db_tabelle_score':'isr_somatisierungscore',
                                            'fcat':'isr_s01'},
                    'isr_e01_diff':{'name':u'Behandlungsdauer nach ISR - Differenzen und Schweregrad', 
                                            'db_tabelle_vgl':'isr_ess_schweregrad',
                                            'db_tabelle_score':'isr_essstoerungscore',
                                            'fcat':'isr_e01'},
                   }
        
        },
        
'anzahl_sitzungen':{'db_tabelle':'anzahl_sitzungen',
        'db_spalte':'anzahl',
        'name':u'Anzahl Sitzungen',
        'typ':'integer',
        'min':0, 'max':999, 
        'fehler':{999:-3}},        

'beendigungsart':{'db_tabelle':'beendigungsart',
        'db_spalte':'typ',
        'name':u'Art der Beendigung',
        'typ':'enum',
        'werte':db['beendigungsart']},

'af_entlassung':{'db_tabelle':'af_entlassung',
        'db_spalte':'typ',
        'name':u'Arbeitsfähigkeit bei Entlassung',
        'typ':'enum',
        'werte':db['af_entlassung']},

'alltagspflichten_therapeut':{'db_tabelle':'alltagspflichten_therapeut',
        'db_spalte':'typ',
        'name':u'Alltagspflichten Therapeut',
        'typ':'enum',
        'werte':db['ja_nein'],
        'db_typtab':'ja_nein_typ'},

'aenderung_koerperlich_therapeut':{'db_tabelle':'aenderung_koerperlich_therapeut',
        'db_spalte':'typ',
        'name':u'Änderung körperl. Befinden (Therapeut)',
        'typ':'enum',
        'werte':db['aenderung_8'],
        'db_typtab':'aenderung_8_typ'},

'aenderung_psychisch_therapeut':{'db_tabelle':'aenderung_psychisch_therapeut',
        'db_spalte':'typ',
        'name':u'Änderung psych. Befinden (Therapeut)',
        'typ':'enum',
        'werte':db['aenderung_8'],
        'db_typtab':'aenderung_8_typ'},

'gaf_e':{'db_tabelle':'gaf_e',
        'db_spalte':'typ',
        'name':u'GAF bei Entlassung',
        'typ':'enum',
        'fehler':{0:-2},        
        'werte':db['gaf'],
        'style':'gaf'},

'garf_e':{'db_tabelle':'garf_e',
        'db_spalte':'typ',
        'name':u'GARF bei Entlassung',
        'typ':'enum',
        'werte':db['garf'],
        'fehler':{0:-2,999:-3},        
        'style':'gaf'}, 

'vev_k':{'db_tabelle':'vev_k',
        'db_spalte':'anzahl',
        'name':u'VEV-K',
        'typ':'integer',
        'descr_unit':u'VEV-K Mittelwert ($ \\pm $ SD)',
        'min':25, 'max':175,
        'fehler':{999:-3}},
 
'medikation_antidepressiva':{'db_tabelle':'medikation_antidepressiva',
        'db_spalte':'typ',
        'name':u'Antidepressiva',
        'typ':'enum',
        'werte':db['mediaktion'],
        'db_typtab':'mediaktion_typ'},

'medikation_anxiolytika':{'db_tabelle':'medikation_anxiolytika',
        'db_spalte':'typ',
        'name':u'Anxiolytika',
        'typ':'enum',
        'werte':db['mediaktion'],
        'db_typtab':'mediaktion_typ'},

'medikation_neuroleptika':{'db_tabelle':'medikation_neuroleptika',
        'db_spalte':'typ',
        'name':u'Neuroleptika',
        'typ':'enum',
        'werte':db['mediaktion'],
        'db_typtab':'mediaktion_typ'},

'medikation_analgetika':{'db_tabelle':'medikation_analgetika',
        'db_spalte':'typ',
        'name':u'Analgetika',
        'typ':'enum',
        'werte':db['mediaktion'],
        'db_typtab':'mediaktion_typ'},
        
'weiterbehandlung':{'db_tabelle':'weiterbehandlung',
        'db_spalte':'typ',
        'name':u'Weiterbehandlung',
        'typ':'enum_multi',
        'werte':db['weiterbehandlung'],
        'fehler':{999:-3}}, 
        
        
'alltagspflichten_patient':{'db_tabelle':'alltagspflichten_patient',
        'db_spalte':'typ',
        'name':u'Alltagspflichten Patient',
        'typ':'enum',
        'db_typtab':'ja_nein_typ',
        'werte':db['ja_nein']},
                
'zuf_1':{'db_tabelle':'zuf_1',
        'db_spalte':'typ',
        'name':u'Zuf-1',
        'typ':'enum',
        'fehler':{999:-3}, 
        'db_typtab':'zuf_fragen_1_typ',
        'werte':db['zuf_fragen_1']},
        
'zuf_2':{'db_tabelle':'zuf_2',
        'db_spalte':'typ',
        'name':u'Zuf-2',
        'typ':'enum',
        'fehler':{999:-3}, 
        'db_typtab':'zuf_fragen_2_typ',
        'werte':db['zuf_fragen_2']},        
        
'zuf_3':{'db_tabelle':'zuf_3',
        'db_spalte':'typ',
        'name':u'Zuf-3',
        'typ':'enum',
        'fehler':{999:-3}, 
        'db_typtab':'zuf_fragen_3_typ',
        'werte':db['zuf_fragen_3']},
        
'zuf_4':{'db_tabelle':'zuf_4',
        'db_spalte':'typ',
        'name':u'Zuf-4',
        'typ':'enum',
        'fehler':{999:-3}, 
        'db_typtab':'zuf_fragen_4_typ',
        'werte':db['zuf_fragen_4']},
        
'zuf_5':{'db_tabelle':'zuf_5',
        'db_spalte':'typ',
        'name':u'Zuf-5',
        'typ':'enum',
        'fehler':{999:-3}, 
        'db_typtab':'zuf_fragen_5_typ',
        'werte':db['zuf_fragen_5']},
        
'zuf_6':{'db_tabelle':'zuf_6',
        'db_spalte':'typ',
        'name':u'Zuf-6',
        'typ':'enum',
        'fehler':{999:-3}, 
        'db_typtab':'zuf_fragen_6_typ',
        'werte':db['zuf_fragen_6']},
        
'zuf_7':{'db_tabelle':'zuf_7',
        'db_spalte':'typ',
        'name':u'Zuf-7',
        'typ':'enum',
        'fehler':{999:-3}, 
        'db_typtab':'zuf_fragen_7_typ',
        'werte':db['zuf_fragen_7']},
        
'zuf_8':{'db_tabelle':'zuf_8',
        'db_spalte':'typ',
        'name':u'Zuf-8',
        'typ':'enum',
        'fehler':{999:-3}, 
        'db_typtab':'zuf_fragen_4_typ',
        'werte':db['zuf_fragen_4']},

'aenderung_koerperlich_patient':{'db_tabelle':'aenderung_koerperlich_patient',
        'db_spalte':'typ',
        'name':u'Änderung körperlich (Patient)',
        'typ':'enum',
        'werte':db['aenderung_7'],
        'db_typtab':'aenderung_7_typ'},

'aenderung_psychisch_patient':{'db_tabelle':'aenderung_psychisch_patient',
        'db_spalte':'typ',
        'name':u'Änderung psychisch (Patient)',
        'typ':'enum',
        'werte':db['aenderung_7'],
        'db_typtab':'aenderung_7_typ'},

'aenderung_selbstwerterleben':{'db_tabelle':'aenderung_selbstwerterleben',
        'db_spalte':'typ',
        'name':u'Selbstwerterleben',
        'typ':'enum',
        'werte':db['aenderung_7'],
        'fehler':{999:-3},
        'db_typtab':'aenderung_7_typ'},

'aenderung_sozial':{'db_tabelle':'aenderung_sozial',
        'db_spalte':'typ',
        'name':u'Änderung sozial',
        'typ':'enum',
        'werte':db['aenderung_7'],
        'fehler':{999:-3},
        'db_typtab':'aenderung_7_typ'},

'aenderung_privat':{'db_tabelle':'aenderung_privat',
        'db_spalte':'typ',
        'name':u'Änderung privat',
        'typ':'enum',
        'werte':db['aenderung_7'],
        'fehler':{999:-3},
        'db_typtab':'aenderung_7_typ'},

'aenderung_beruflich':{'db_tabelle':'aenderung_beruflich',
        'db_spalte':'typ',
        'name':u'Änderung beruflich',
        'typ':'enum',
        'werte':db['aenderung_7'],
        'fehler':{999:-3},
        'db_typtab':'aenderung_7_typ'},

'aenderung_eigenaktivitaet':{'db_tabelle':'aenderung_eigenaktivitaet',
        'db_spalte':'typ',
        'name':u'Eigenaktivität',
        'typ':'enum',
        'werte':db['aenderung_7'],
        'fehler':{999:-3},
        'db_typtab':'aenderung_7_typ'},

'aenderung_krankheitsverstaendnis':{'db_tabelle':'aenderung_krankheitsverstaendnis',
        'db_spalte':'typ',
        'name':u'Krankheitsverständnis',
        'typ':'enum',
        'werte':db['aenderung_7'],
        'fehler':{999:-3},
        'db_typtab':'aenderung_7_typ'},

'aenderung_zukunft':{'db_tabelle':'aenderung_zukunft',
        'db_spalte':'typ',
        'name':u'Einstellung Zukunft',
        'typ':'enum',
        'werte':db['aenderung_7'],
        'fehler':{999:-3},
        'db_typtab':'aenderung_7_typ'},

'aenderung_befinden':{'db_tabelle':'aenderung_befinden',
        'db_spalte':'typ',
        'name':u'Seel. Wohlbefinden',
        'typ':'enum',
        'werte':db['aenderung_7'],
        'fehler':{999:-3},
        'db_typtab':'aenderung_7_typ'},

'aenderung_alltag':{'db_tabelle':'aenderung_alltag',
        'db_spalte':'typ',
        'name':u'Alltagsanforderungen',
        'typ':'enum',
        'werte':db['aenderung_7'],
        'fehler':{999:-3},
        'db_typtab':'aenderung_7_typ'},
       
        
        
# die Tabelle für den ISR-Datensatz enthält eine isr_datensatz_id, datensatz_id und datum
'isr_datum':{'db_tabelle':'isr_datensatz',
        'db_spalte':'datum',
        'db_has_pkey':True,
        'name':u'Datum ISR Test',
        'typ':'datum'},
        
'isr_d01':{'db_tabelle':'isr_d01',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR01',
        'typ':'enum',
        'werte':db['isr'],
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ',
        'colors':isr_norm['depression'],
        'variante':{'isr_depressionscore':{'name':u'ISR - Depressionscore', 
                                            'db_spalte':'score',  
                                            'db_tabelle':'isr_depressionscore',   
                                            'db_valid':'valid', 
                                            'style':'isr'},
                    'isr_diagnose_aufnahme':{'name':u'ISR - Depressionscore Diagnosebezogen', 
                                            'db_spalte':'score',  
                                            'db_tabelle':'isr_depressionscore',   
                                            'db_valid':'valid', 
                                            'style':'isr'},
                    'isr_schweregrad_diag':{'name':u'ISR - Schweregrad mit und ohne Diagnose', 
                                            'db_spalte':'grad',  
                                            'db_tabelle':'isr_depr_schweregrad',   
                                            'db_valid':'valid', 
                                            'style':'isr'},
                    'isr_gesamtscore':     {'name':u'ISR - Gesamtscore', 
                                            'db_spalte':'score',  
                                            'db_tabelle':'isr_gesamtscore',   
                                            'db_valid':'valid', 
                                            'colors':isr_norm['gesamt'],
                                            'style':'isr'},
                    'isr_gesamtscore_aufnahme':{'name':u'ISR - Gesamtscore bei Aufnahme', 
                                            'db_spalte':'score',  
                                            'db_tabelle':'isr_gesamtscore',   
                                            'db_valid':'valid', 
                                            'colors':isr_norm['gesamt'],
                                            'style':'isr'}},
         },

'isr_d02':{'db_tabelle':'isr_d02',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR02',
        'typ':'enum',
        'werte':db['isr'],
        'db_typtab':'isr_typ'},

'isr_d03':{'db_tabelle':'isr_d03',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR03',
        'typ':'enum',
        'werte':db['isr'],
        'db_typtab':'isr_typ'},

'isr_d05':{'db_tabelle':'isr_d05',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR04',
        'typ':'enum',
        'werte':db['isr'],
        'db_typtab':'isr_typ'},

'isr_a01':{'db_tabelle':'isr_a01',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR05',
        'typ':'enum',
        'werte':db['isr'],
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ',
        'colors':isr_norm['angst'],
        'variante':{'isr_angstscore':{'name':u'ISR - Angstscore', 
                                            'db_spalte':'score',  
                                            'db_tabelle':'isr_angstscore',   
                                            'db_valid':'valid', 
                                            'style':'isr'},
                    'isr_schweregrad_diag':{'name':u'ISR - Schweregrad mit und ohne Diagnose', 
                                            'db_spalte':'grad',  
                                            'db_tabelle':'isr_angst_schweregrad',   
                                            'db_valid':'valid', 
                                            'style':'isr'},
                    'isr_diagnose_aufnahme':{'name':u'ISR - Angstscore Diagnosebezogen', 
                                            'db_spalte':'score',  
                                            'db_tabelle':'isr_angstscore',   
                                            'db_valid':'valid', 
                                            'style':'isr'}},
        },
        
'isr_a02':{'db_tabelle':'isr_a02',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR06',
        'typ':'enum',
        'werte':db['isr'],
        'db_typtab':'isr_typ'},

'isr_a03':{'db_tabelle':'isr_a03',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR07',
        'typ':'enum',
        'werte':db['isr'],
        'db_typtab':'isr_typ'},

'isr_a04':{'db_tabelle':'isr_a04',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR08',
        'typ':'enum',
        'werte':db['isr'],
        'db_typtab':'isr_typ'},

'isr_z01':{'db_tabelle':'isr_z01',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR09',
        'typ':'enum',
        'werte':db['isr'],
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ',
        'colors':isr_norm['zwang'],
        'variante':{'isr_zwangscore':{'name':u'ISR - Zwangscore', 
                                            'db_spalte':'score',  
                                            'db_tabelle':'isr_zwangscore',   
                                            'db_valid':'valid', 
                                            'style':'isr'},
                    'isr_schweregrad_diag':{'name':u'ISR - Schweregrad mit und ohne Diagnose', 
                                            'db_spalte':'grad',  
                                            'db_tabelle':'isr_zwang_schweregrad',   
                                            'db_valid':'valid', 
                                            'style':'isr'},
                    'isr_diagnose_aufnahme':{'name':u'ISR - Zwangscore Diagnosebezogen', 
                                            'db_spalte':'score',  
                                            'db_tabelle':'isr_zwangscore',   
                                            'db_valid':'valid', 
                                            'style':'isr'}},
        },

'isr_z02':{'db_tabelle':'isr_z02',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR10',
        'typ':'enum',
        'werte':db['isr'],
        'db_typtab':'isr_typ'},

'isr_z03':{'db_tabelle':'isr_z03',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR11',
        'typ':'enum',
        'werte':db['isr'],
        'db_typtab':'isr_typ'},

'isr_s01':{'db_tabelle':'isr_s01',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR12',
        'typ':'enum',
        'werte':db['isr'],
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ',
        'colors':isr_norm['soma'],
        'variante':{'isr_somatisierungscore':{'name':u'ISR - Somatisierungscore', 
                                            'db_spalte':'score',  
                                            'db_tabelle':'isr_somatisierungscore',   
                                            'db_valid':'valid', 
                                            'style':'isr'},
                    'isr_schweregrad_diag':{'name':u'ISR - Schweregrad mit und ohne Diagnose', 
                                            'db_spalte':'grad',  
                                            'db_tabelle':'isr_soma_schweregrad',   
                                            'db_valid':'valid', 
                                            'style':'isr'},
                    'isr_diagnose_aufnahme':{'name':u'ISR - Somatisierungscore Diagnosebezogen', 
                                            'db_spalte':'score',  
                                            'db_tabelle':'isr_somatisierungscore',   
                                            'db_valid':'valid', 
                                            'style':'isr'}},
        },

'isr_s02':{'db_tabelle':'isr_s02',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR13',
        'typ':'enum',
        'werte':db['isr'],
        'db_typtab':'isr_typ'},

'isr_s03':{'db_tabelle':'isr_s03',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR14',
        'typ':'enum',
        'werte':db['isr'],
        'db_typtab':'isr_typ'},

'isr_e01':{'db_tabelle':'isr_e01',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR15',
        'typ':'enum',
        'werte':db['isr'],
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ',
        'colors':isr_norm[u'essstörung'],
        'variante':{'isr_essstoerungscore':{'name':u'ISR - Essstörungscore', 
                                            'db_spalte':'score',  
                                            'db_tabelle':'isr_essstoerungscore',   
                                            'db_valid':'valid', 
                                            'style':'isr'},
                    'isr_schweregrad_diag':{'name':u'ISR - Schweregrad mit und ohne Diagnose', 
                                            'db_spalte':'grad',  
                                            'db_tabelle':'isr_ess_schweregrad',   
                                            'db_valid':'valid', 
                                            'style':'isr'},
                    'isr_diagnose_aufnahme':{'name':u'ISR - Essstörungscore Diagnosebezogen', 
                                            'db_spalte':'score',  
                                            'db_tabelle':'isr_essstoerungscore',   
                                            'db_valid':'valid', 
                                            'style':'isr'}},
        },

'isr_e02':{'db_tabelle':'isr_e02',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR16',
        'typ':'enum',
        'werte':db['isr'],
        'db_typtab':'isr_typ'},

'isr_e03':{'db_tabelle':'isr_e03',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR17',
        'typ':'enum',
        'werte':db['isr'],
        'db_typtab':'isr_typ'},


'isr_d04':{'db_tabelle':'isr_d04',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR18',
        'typ':'enum',
        'werte':db['isr'],
        'colors':isr_norm['zusatz'],
        'style':'isr',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ'},

'isr_d10':{'db_tabelle':'isr_d10',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR19',
        'typ':'enum',
        'werte':db['isr'],
        'colors':isr_norm['zusatz'],
        'style':'isr',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ'},

'isr_d11':{'db_tabelle':'isr_d11',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR20',
        'typ':'enum',
        'werte':db['isr'],
        'colors':isr_norm['zusatz'],
        'style':'isr',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ'},

'isr_d12':{'db_tabelle':'isr_d12',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR21',
        'typ':'enum',
        'werte':db['isr'],
        'colors':isr_norm['zusatz'],
        'style':'isr',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ'},
        
'isr_w01':{'db_tabelle':'isr_w01',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR22',
        'typ':'enum',
        'werte':db['isr'],
        'colors':isr_norm['zusatz'],
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ',
        'style':'isr',
        'variante':{'isr_zusatzscore':{'name':u'ISR - Zusatzscore', 
                                            'db_spalte':'score',  
                                            'db_tabelle':'isr_zusatzscore',   
                                            'db_valid':'valid', 
                                            'style':'isr'}},
        },

'isr_w02':{'db_tabelle':'isr_w02',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR23',
        'typ':'enum',
        'werte':db['isr'],
        'colors':isr_norm['zusatz'],
        'style':'isr',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ',
        'variante':{'isr_diagnose_aufnahme':{'name':u'ISR - Flashbacks Diagnosebezogen' 
                                                 }},
        },

'isr_w03':{'db_tabelle':'isr_w03',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR24',
        'typ':'enum',
        'werte':db['isr'],
        'colors':isr_norm['zusatz'],
        'style':'isr',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ'},

'isr_w05':{'db_tabelle':'isr_w05',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR25',
        'typ':'enum',
        'werte':db['isr'],
        'colors':isr_norm['zusatz'],
        'style':'isr',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ'},

'isr_w06':{'db_tabelle':'isr_w06',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR26',
        'typ':'enum',
        'werte':db['isr'],
        'colors':isr_norm['zusatz'],
        'style':'isr',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ'},

'isr_w07':{'db_tabelle':'isr_w07',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR27',
        'typ':'enum',
        'werte':db['isr'],
        'colors':isr_norm['zusatz'],
        'style':'isr',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ'},

'isr_w08':{'db_tabelle':'isr_w08',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR28',
        'typ':'enum',
        'werte':db['isr'],
        'colors':isr_norm['zusatz'],
        'style':'isr',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ'},

'isr_w09':{'db_tabelle':'isr_w09',
        'db_spalte':'typ',
        'db_datensatz':'isr_datensatz',
        'name':u'ISR29',
        'typ':'enum',
        'werte':db['isr'],
        'colors':isr_norm['zusatz'],
        'style':'isr',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'isr_typ'},



        
        
'mini_icf_datum':{'db_tabelle':'mini_icf_datensatz',
        'db_spalte':'datum',
        'db_has_pkey':True,
        'name':u'Datum Mini-ICF Test',
        'typ':'datum'},
        
'mini_icf_01':{'db_tabelle':'mini_icf_01',
        'db_spalte':'typ',
        'db_datensatz':'mini_icf_datensatz',
        'name':u'Mini_icf_01',
        'typ':'enum',
        'werte':db['mini_icf'],
        'style':'mini_icf',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'mini_icf_typ'},
        
'mini_icf_02':{'db_tabelle':'mini_icf_02',
        'db_spalte':'typ',
        'db_datensatz':'mini_icf_datensatz',
        'name':u'Mini_icf_02',
        'typ':'enum',
        'werte':db['mini_icf'],
        'style':'mini_icf',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'mini_icf_typ'},
        
'mini_icf_03':{'db_tabelle':'mini_icf_03',
        'db_spalte':'typ',
        'db_datensatz':'mini_icf_datensatz',
        'name':u'Mini_icf_03',
        'typ':'enum',
        'werte':db['mini_icf'],
        'style':'mini_icf',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'mini_icf_typ'},
        
'mini_icf_04':{'db_tabelle':'mini_icf_04',
        'db_spalte':'typ',
        'db_datensatz':'mini_icf_datensatz',
        'name':u'Mini_icf_04',
        'typ':'enum',
        'werte':db['mini_icf'],
        'style':'mini_icf',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'mini_icf_typ'},
        
'mini_icf_05':{'db_tabelle':'mini_icf_05',
        'db_spalte':'typ',
        'db_datensatz':'mini_icf_datensatz',
        'name':u'Mini_icf_05',
        'typ':'enum',
        'werte':db['mini_icf'],
        'style':'mini_icf',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'mini_icf_typ'},
        
'mini_icf_06':{'db_tabelle':'mini_icf_06',
        'db_spalte':'typ',
        'db_datensatz':'mini_icf_datensatz',
        'name':u'Mini_icf_06',
        'typ':'enum',
        'werte':db['mini_icf'],
        'style':'mini_icf',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'mini_icf_typ'},
        
'mini_icf_07':{'db_tabelle':'mini_icf_07',
        'db_spalte':'typ',
        'db_datensatz':'mini_icf_datensatz',
        'name':u'Mini_icf_07',
        'typ':'enum',
        'werte':db['mini_icf'],
        'style':'mini_icf',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'mini_icf_typ'},
        
'mini_icf_08':{'db_tabelle':'mini_icf_08',
        'db_spalte':'typ',
        'db_datensatz':'mini_icf_datensatz',
        'name':u'Mini_icf_08',
        'typ':'enum',
        'werte':db['mini_icf'],
        'style':'mini_icf',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'mini_icf_typ'},
        
'mini_icf_09':{'db_tabelle':'mini_icf_09',
        'db_spalte':'typ',
        'db_datensatz':'mini_icf_datensatz',
        'name':u'Mini_icf_09',
        'typ':'enum',
        'werte':db['mini_icf'],
        'style':'mini_icf',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'mini_icf_typ'},
        
'mini_icf_10':{'db_tabelle':'mini_icf_10',
        'db_spalte':'typ',
        'db_datensatz':'mini_icf_datensatz',
        'name':u'Mini_icf_10',
        'typ':'enum',
        'werte':db['mini_icf'],
        'style':'mini_icf',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'mini_icf_typ'},
        
'mini_icf_11':{'db_tabelle':'mini_icf_11',
        'db_spalte':'typ',
        'db_datensatz':'mini_icf_datensatz',
        'name':u'Mini_icf_11',
        'typ':'enum',
        'werte':db['mini_icf'],
        'style':'mini_icf',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'mini_icf_typ'},
        
'mini_icf_12':{'db_tabelle':'mini_icf_12',
        'db_spalte':'typ',
        'db_datensatz':'mini_icf_datensatz',
        'name':u'Mini_icf_12',
        'typ':'enum',
        'werte':db['mini_icf'],
        'style':'mini_icf',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'mini_icf_typ'},
        
'mini_icf_13':{'db_tabelle':'mini_icf_13',
        'db_spalte':'typ',
        'db_datensatz':'mini_icf_datensatz',
        'name':u'Mini_icf_13',
        'typ':'enum',
        'werte':db['mini_icf'],
        'style':'mini_icf',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'db_typtab':'mini_icf_typ'},

'mini_icf_gesamt':{'db_tabelle':'mini_icf_gesamt',
        'db_spalte':'grad',
        'db_datensatz':'mini_icf_datensatz',
        'name':u'Mini-ICF Gesamtwert',
        'typ':'float',
        'min':0, 'max':100,
        'fehler':{9:-5},
        'style':'mini_icf',
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'variante':{                   'mini_icf_gesamt_aufnahme':{'name':u'MiniICF - Gesamtscore bei Aufnahme',
                                            'db_spalte':'grad',
                                            'db_tabelle':'mini_icf_gesamt',
                                            'db_valid':'valid',
                                            'style':'mini_icf'}}
},
        
        
        
        
'scl90_datum':{'db_tabelle':'scl90_datensatz',
        'db_spalte':'datum',
        'db_has_pkey':True,
        'name':u'Datum SCL Test',
        'typ':'datum'},

'scl90_somatisierung':{'db_tabelle':'scl90_somatisierung',
        'db_spalte':'grad',
        'db_datensatz':'scl90_datensatz',
        'name':u'SCL-90-R (1): Somatisierung',
        'typ':'float',
        'min':0, 'max':4,
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'fehler':{9:-5},
        'style':'scl'},

'scl90_zwanghaftigkeit':{'db_tabelle':'scl90_zwanghaftigkeit',
        'db_spalte':'grad',
        'db_datensatz':'scl90_datensatz',
        'name':u'SCL-90-R (2): Zwanghaftigkeit',
        'typ':'float',
        'min':0, 'max':4,
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'fehler':{9:-5},
        'style':'scl'},

'scl90_sozialkontakt':{'db_tabelle':'scl90_sozialkontakt',
        'db_spalte':'grad',
        'db_datensatz':'scl90_datensatz',
        'name':u'SCL-90-R (3): Sozialkontakt',
        'typ':'float',
        'min':0, 'max':4,
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'fehler':{9:-5},
        'style':'scl'},

'scl90_depressivitaet':{'db_tabelle':'scl90_depressivitaet',
        'db_spalte':'grad',
        'db_datensatz':'scl90_datensatz',
        'name':u'SCL-90-R (4): Depressivität',
        'typ':'float',
        'min':0, 'max':4,
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'fehler':{9:-5},
        'style':'scl'},

'scl90_aengstlichkeit':{'db_tabelle':'scl90_aengstlichkeit',
        'db_spalte':'grad',
        'db_datensatz':'scl90_datensatz',
        'name':u'SCL-90-R (5): Ängstlichkeit',
        'typ':'float',
        'min':0, 'max':4,
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'fehler':{9:-5},
        'style':'scl'},

'scl90_aggressivitaet':{'db_tabelle':'scl90_aggressivitaet',
        'db_spalte':'grad',
        'db_datensatz':'scl90_datensatz',
        'name':u'SCL-90-R (6): Aggressivität',
        'typ':'float',
        'min':0, 'max':4,
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'fehler':{9:-5},
        'style':'scl'},

'scl90_phobische_angst':{'db_tabelle':'scl90_phobische_angst',
        'db_spalte':'grad',
        'db_datensatz':'scl90_datensatz',
        'name':u'SCL-90-R (7): Phobische Angst',
        'typ':'float',
        'min':0, 'max':4,
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'fehler':{9:-5},
        'style':'scl'},

'scl90_paranoides_denken':{'db_tabelle':'scl90_paranoides_denken',
        'db_spalte':'grad',
        'db_datensatz':'scl90_datensatz',
        'name':u'SCL-90-R (8): Paranoides Denken',
        'typ':'float',
        'min':0, 'max':4,
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'fehler':{9:-5},
        'style':'scl'},

'scl90_psychotizismus':{'db_tabelle':'scl90_psychotizismus',
        'db_spalte':'grad',
        'db_datensatz':'scl90_datensatz',
        'name':u'SCL-90-R (9): Psychotizismus',
        'typ':'float',
        'min':0, 'max':4,
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'fehler':{9:-5},
        'style':'scl'},

'scl90_gsi':{'db_tabelle':'scl90_gsi',
        'db_spalte':'grad',
        'db_datensatz':'scl90_datensatz',
        'name':u'SCL-90-R (10): GSI',
        'typ':'float',
        'min':0, 'max':4,
        'descr_unit':u'mittl. Diff.-werte ($ \\pm $ SD)',
        'fehler':{9:-5},
        'style':'scl'},

'visiten':{'db_tabelle':'visiten',
        'db_spalte':'dauer',
        'name':u'Visiten',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -5, 99999:-4},
        'weiche_grenze':{'=1tag':180,'>1tag':90},
        'harte_grenze':{'=1tag':360,'>1tag':120, 'min':10},
        'variante':{'visiten_pro_tag':             {'db_tabelle':'visiten_pro_tag',             'db_spalte':'dauer', 'db_valid': 'valid'},
                    'gesamt_dosis_pro_tag':        {'db_tabelle':'gesamt_dosis_pro_tag',        'db_spalte':'dauer', 'db_valid': 'valid'},
                    'gruppe_dosis_pro_tag':        {'db_tabelle':'gruppe_dosis_pro_tag',        'db_spalte':'dauer', 'db_valid': 'valid'},
                    'gruppe_milieu_dosis_pro_tag': {'db_tabelle':'gruppe_milieu_dosis_pro_tag', 'db_spalte':'dauer', 'db_valid': 'valid'},
                    'einzel_dosis_pro_tag':        {'db_tabelle':'einzel_dosis_pro_tag',        'db_spalte':'dauer', 'db_valid': 'valid'},
                    'einzel_milieu_dosis_pro_tag': {'db_tabelle':'einzel_milieu_dosis_pro_tag', 'db_spalte':'dauer', 'db_valid': 'valid'},
                    'gruppe_soma_dosis_pro_tag':   {'db_tabelle':'gruppe_soma_dosis_pro_tag',   'db_spalte':'dauer', 'db_valid': 'valid'},
                    'einzel_soma_dosis_pro_tag':   {'db_tabelle':'einzel_soma_dosis_pro_tag',   'db_spalte':'dauer', 'db_valid': 'valid'},
                    'einzel_psychotherapie_pro_tag':    {'db_tabelle':'einzel_psychotherapie_pro_tag',  'db_spalte':'dauer', 'db_valid': 'valid'},
                    'einzel_spezialtherapie_pro_tag':   {'db_tabelle':'einzel_spezialtherapie_pro_tag', 'db_spalte':'dauer', 'db_valid': 'valid'},
                    'einzel_sonstige_pro_tag':          {'db_tabelle':'einzel_sonstige_pro_tag',        'db_spalte':'dauer', 'db_valid': 'valid'},
                    'gruppe_psychotherapie_pro_tag':    {'db_tabelle':'gruppe_psychotherapie_pro_tag',  'db_spalte':'dauer', 'db_valid': 'valid'},
                    'gruppe_spezialtherapie_pro_tag':   {'db_tabelle':'gruppe_spezialtherapie_pro_tag', 'db_spalte':'dauer', 'db_valid': 'valid'},
                    'gruppe_sonstige_pro_tag':          {'db_tabelle':'gruppe_sonstige_pro_tag',        'db_spalte':'dauer', 'db_valid': 'valid'}}},
                    
'kontakte_kotherapeutisch':{'db_tabelle':'kontakte_kotherapeutisch',
        'db_spalte':'dauer',
        'name':u'Co-therapeutische Kontakte',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -5, 99999:-4},
        'weiche_grenze':{'=1tag':180,'>1tag':90},
        'harte_grenze':{'=1tag':360,'>1tag':120, 'min':10},
        'variante':{'kontakte_kotherapeutisch_pro_tag':{'db_tabelle':'kontakte_kotherapeutisch_pro_tag','db_spalte':'dauer', 'db_valid': 'valid'}}},

'besprechung_patientenbezogen':{'db_tabelle':'besprechung_patientenbezogen',
        'db_spalte':'dauer',
        'name':u'Pat.-bezogene Besprechung',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -5, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':60},
        'harte_grenze':{'=1tag':180,'>1tag':120, 'min':10},
        'variante':{'besprechung_patientenbezogen_pro_tag':{'db_tabelle':'besprechung_patientenbezogen_pro_tag','db_spalte':'dauer', 'db_valid': 'valid'}}},
        
'gruppe_tiefenpsychologisch_bis10':{'db_tabelle':'gruppe_tiefenpsychologisch_bis10',
        'db_spalte':'dauer',
        'name':u'Gruppe: tiefenpsychologisch bis 10 Personen',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -5, 99999:-4},
        'weiche_grenze':{'=1tag':180,'>1tag':150},
        'harte_grenze':{'=1tag':360,'>1tag':300, 'min':10}},
        
'gruppe_tiefenpsychologisch_ab11':{'db_tabelle':'gruppe_tiefenpsychologisch_ab11',
        'db_spalte':'dauer',
        'name':u'Gruppe: tiefenpsychologisch ab 11 Personen',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -5, 99999:-4},
        'weiche_grenze':{'=1tag':180,'>1tag':150},
        'harte_grenze':{'=1tag':360,'>1tag':300, 'min':10}},
        
'gruppe_verhaltenstherapeutisch_bis10':{'db_tabelle':'gruppe_verhaltenstherapeutisch_bis10',
        'db_spalte':'dauer',
        'name':u'Gruppe: verhaltenstherapeutisch bis 10 Personen',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -5, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':180,'>1tag':120, 'min':10}},
        
'gruppe_verhaltenstherapeutisch_ab11':{'db_tabelle':'gruppe_verhaltenstherapeutisch_ab11',
        'db_spalte':'dauer',
        'name':u'Gruppe: verhaltenstherapeutisch ab 11 Personen',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -5, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':180,'>1tag':120, 'min':10}},
        
        
'gruppe_andere_verbale_bis10':{'db_tabelle':'gruppe_andere_verbale_bis10',
        'db_spalte':'dauer',
        'name':u'Gruppe: andere verbale bis 10 Personen',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -5, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':180,'>1tag':120, 'min':10}},

'gruppe_andere_verbale_ab11':{'db_tabelle':'gruppe_andere_verbale_ab11',
        'db_spalte':'dauer',
        'name':u'Gruppe: andere verbale ab 11 Personen',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -5, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':180,'>1tag':120, 'min':10}},

'gruppe_kunst':{'db_tabelle':'gruppe_kunst',
        'db_spalte':'dauer',
        'name':u'Gruppe: Kunst',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':240,'>1tag':360, 'min':10}},
        
'gruppe_musik':{'db_tabelle':'gruppe_musik',
        'db_spalte':'dauer',
        'name':u'Gruppe: Musik',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':90,'>1tag':120},
        'harte_grenze':{'=1tag':180,'>1tag':300, 'min':10}},
        
'gruppe_koerper':{'db_tabelle':'gruppe_koerper',
        'db_spalte':'dauer',
        'name':u'Gruppe: Körper',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':360,'>1tag':300, 'min':10}},
        
'gruppe_soziale_interaktion':{'db_tabelle':'gruppe_soziale_interaktion',
        'db_spalte':'dauer',
        'name':u'Gruppe: Soziale Interaktion',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':240,'>1tag':180, 'min':10}},
        
'gruppe_entspannung':{'db_tabelle':'gruppe_entspannung',
        'db_spalte':'dauer',
        'name':u'Gruppe: Entspannung',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':240,'>1tag':180, 'min':10}},
        
'gruppe_meditation':{'db_tabelle':'gruppe_meditation',
        'db_spalte':'dauer',
        'name':u'Gruppe: Meditation',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':180,'>1tag':90},
        'harte_grenze':{'=1tag':360,'>1tag':180, 'min':10}},
        
'gruppe_themenzentriert':{'db_tabelle':'gruppe_themenzentriert',
        'db_spalte':'dauer',
        'name':u'Gruppe: Themenzentriert',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':180,'>1tag':90},
        'harte_grenze':{'=1tag':360,'>1tag':180, 'min':10}},
        
'gruppe_indikation':{'db_tabelle':'gruppe_indikation',
        'db_spalte':'dauer',
        'name':u'Indikationsgruppe',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':240,'>1tag':180, 'min':10}},
        
'gruppe_andere':{'db_tabelle':'gruppe_andere',
        'db_spalte':'dauer',
        'name':u'Andere Gruppe',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':180,'>1tag':300, 'min':10}},
        
'gruppe_milieu_versammlung':{'db_tabelle':'gruppe_milieu_versammlung',
        'db_spalte':'dauer',
        'name':u'Milieu-Gruppe: Versammlung',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':180,'>1tag':120},
        'harte_grenze':{'=1tag':240,'>1tag':300, 'min':10}},
        
'gruppe_milieu_themenzentriert':{'db_tabelle':'gruppe_milieu_themenzentriert',
        'db_spalte':'dauer',
        'name':u'Milieu-Gruppe: themenzentriert',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':90,'>1tag':120},
        'harte_grenze':{'=1tag':300,'>1tag':180, 'min':10}},
        
'gruppe_milieu_andere':{'db_tabelle':'gruppe_milieu_andere',
        'db_spalte':'dauer',
        'name':u'Milieu-Gruppe: andere',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':90,'>1tag':120},
        'harte_grenze':{'=1tag':300,'>1tag':180, 'min':10}},
        
'einzel_tiefenpsychologisch':{'db_tabelle':'einzel_tiefenpsychologisch',
        'db_spalte':'dauer',
        'name':u'Einzel: tiefenpsychologisch',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':180,'>1tag':180, 'min':10}},
        
'einzel_verhaltenstherapeutisch':{'db_tabelle':'einzel_verhaltenstherapeutisch',
        'db_spalte':'dauer',
        'name':u'Einzel: verhaltenstherapeutisch',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':240,'>1tag':90},
        'harte_grenze':{'=1tag':360,'>1tag':240, 'min':10}},
        
'einzel_andere_verbale':{'db_tabelle':'einzel_andere_verbale',
        'db_spalte':'dauer',
        'name':u'Einzel: andere verbale Therapie',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':240,'>1tag':120, 'min':10}},
        
'einzel_paar':{'db_tabelle':'einzel_paar',
        'db_spalte':'dauer',
        'name':u'Einzel: Paar/Familie',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':180,'>1tag':180, 'min':10}},
        
'einzel_kunst':{'db_tabelle':'einzel_kunst',
        'db_spalte':'dauer',
        'name':u'Einzel: Kunst',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':120,'>1tag':180, 'min':10}},
        
'einzel_musik':{'db_tabelle':'einzel_musik',
        'db_spalte':'dauer',
        'name':u'Einzel: Musik',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':60,'>1tag':60},
        'harte_grenze':{'=1tag':90,'>1tag':90, 'min':10}},
        
'einzel_koerper':{'db_tabelle':'einzel_koerper',
        'db_spalte':'dauer',
        'name':u'Einzel: andere Körpertherapie',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':90,'>1tag':60},
        'harte_grenze':{'=1tag':180,'>1tag':180, 'min':10}},
        
'einzel_entspannung':{'db_tabelle':'einzel_entspannung',
        'db_spalte':'dauer',
        'name':u'Einzel: Entspannung',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':120,'>1tag':120, 'min':10}},
        
'einzel_meditation':{'db_tabelle':'einzel_meditation',
        'db_spalte':'dauer',
        'name':u'Einzel: Meditation',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':120,'>1tag':120, 'min':10}},
        
'einzel_themenzentriert':{'db_tabelle':'einzel_themenzentriert',
        'db_spalte':'dauer',
        'name':u'Einzel: themenzentriert',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':120,'>1tag':120, 'min':10}},
        
'einzel_andere_sonstige':{'db_tabelle':'einzel_andere_sonstige',
        'db_spalte':'dauer',
        'name':u'Einzel: andere sonstige',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':120,'>1tag':120, 'min':10}},
        
'einzel_milieu_sozio':{'db_tabelle':'einzel_milieu_sozio',
        'db_spalte':'dauer',
        'name':u'Milieu-Einzel: Soziotherapie',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':90,'>1tag':120},
        'harte_grenze':{'=1tag':120,'>1tag':180, 'min':10}},
        
'einzel_milieu_andere':{'db_tabelle':'einzel_milieu_andere',
        'db_spalte':'dauer',
        'name':u'Milieu-Einzel: andere',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':90,'>1tag':90},
        'harte_grenze':{'=1tag':120,'>1tag':180, 'min':10}},
        
'gruppe_soma':{'db_tabelle':'gruppe_soma',
        'db_spalte':'dauer',
        'name':u'Soma-Gruppe',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':60,'>1tag':60},
        'harte_grenze':{'=1tag':120,'>1tag':120, 'min':10}},
        
'einzel_soma':{'db_tabelle':'einzel_soma',
        'db_spalte':'dauer',
        'name':u'Soma-Einzel',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':60,'>1tag':60},
        'harte_grenze':{'=1tag':90,'>1tag':120, 'min':10}},
        
'balneotherapie':{'db_tabelle':'balneotherapie',
        'db_spalte':'dauer',
        'name':u'Balneotherapie',
        'typ':'interval',
        'min':0.01, 'max':99998,
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':60,'>1tag':60},
        'harte_grenze':{'=1tag':90,'>1tag':120, 'min':10},
        'variante':{'balneo_gesamt_pro_tag':        {'db_tabelle':'balneo_gesamt_pro_tag',        'db_spalte':'dauer', 'db_valid':'valid'}}},

'gruppe_tiefenpsychologisch_bis12':{'db_tabelle':'gruppe_tiefenpsychologisch_bis12',
        'db_spalte':'dauer',
        'name':u'Gruppe: tiefenpsychologisch bis 12 Personen',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':180,'>1tag':150},
        'harte_grenze':{'=1tag':360,'>1tag':300, 'min':10}},
        
'gruppe_tiefenpsychologisch_ab13':{'db_tabelle':'gruppe_tiefenpsychologisch_ab13',
        'db_spalte':'dauer',
        'name':u'Gruppe: tiefenpsychologisch ab 13 Personen',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':180,'>1tag':150},
        'harte_grenze':{'=1tag':360,'>1tag':300, 'min':10}},
        
'gruppe_verhaltenstherapeutisch_bis12':{'db_tabelle':'gruppe_verhaltenstherapeutisch_bis12',
        'db_spalte':'dauer',
        'name':u'Gruppe: verhaltenstherapeutisch bis 12 Personen',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':180,'>1tag':120, 'min':10}},
        
'gruppe_verhaltenstherapeutisch_ab13':{'db_tabelle':'gruppe_verhaltenstherapeutisch_ab13',
        'db_spalte':'dauer',
        'name':u'Gruppe: verhaltenstherapeutisch ab 13 Personen',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':180,'>1tag':120, 'min':10}},
        
        
'gruppe_andere_verbale_bis12':{'db_tabelle':'gruppe_andere_verbale_bis12',
        'db_spalte':'dauer',
        'name':u'Gruppe: andere verbale bis 12 Personen',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':180,'>1tag':120, 'min':10}},

'gruppe_andere_verbale_ab13':{'db_tabelle':'gruppe_andere_verbale_ab13',
        'db_spalte':'dauer',
        'name':u'Gruppe: andere verbale ab 13 Personen',
        'typ':'interval',
        'min':0.01, 'max':99998, 
        'unit':'minutes', 'descr_unit':u'Minuten Mittelwert ($ \\pm $ SD)',
        'fehler':{0: -6, 99999:-4},
        'weiche_grenze':{'=1tag':120,'>1tag':90},
        'harte_grenze':{'=1tag':180,'>1tag':120, 'min':10}},

'ktl2007':{'db_tabelle':'ktl2007',
        'db_spalte':'typ',
        'name':u'KTL 2007',
        'typ':'enum_ktl_multi',
        'werte':db['ktl2007'],
        'db_typtab':'ktl2007_typ',
        'db_id':'key'},

        
}

icd10_checks = [
    ('F9','F0'),
    ('F9','F1'),
    ('F9','F2'),
    ('F18','F10'),
    ('F18','F11'),
    ('F18','F12'),
    ('F18','F13'),
    ('F19','F10'),
    ('F19','F11'),
    ('F19','F12'),
    ('F19','F13'),
    ('F19','F18'),
    ('F28','F20'),
    ('F28','F21'),
    ('F28','F22'),
    ('F28','F23'),
    ('F28','F24'),
    ('F3','F0'),
    ('F3','F1'),
    ('F3','F2'),
    ('F4','F106'),
    ('F4','F116'),
    ('F4','F126'),
    ('F4','F136'),
    ('F4','F146'),
    ('F4','F156'),
    ('F4','F166'),
    ('F4','F176'),
    ('F4','F186'),
    ('F4','F196'),
    ('F4','F3'),
    ('F5','F10'),
    ('F5','F11'),
    ('F5','F12'),
    ('F5','F13'),
    ('F5','F14'),
    ('F5','F15'),
    ('F5','F16'),
    ('F5','F17'),
    ('F5','F18'),
    ('F5','F19'),
    ('F58','F50'),
    ('F58','F51'),
    ('F59','F50'),
    ('F59','F51'),
    ('F59','F58'),
    ('F6','F0'),
    ('F6','F1'),
    ('F6','F2'),
    ('F6','F3'),
    ('F6','F5'),
    ('F60','F1052'),
    ('F60','F20'),
    ('F61','F202'),
    ('F61','F442'),
    ('F62','F105'),
    ('F62','F115'),
    ('F62','F125'),
    ('F62','F135'),
    ('F62','F145'),
    ('F62','F155'),
    ('F62','F165'),
    ('F62','F175'),
    ('F62','F185'),
    ('F62','F195'),
    ('F62','F20'),
    ('F62','F22'),
    ('F62','F23'),
    ('F63','F78'),
    ('F63','F30'),
    ('F63','F31'),
    ('F63','F32'),
    ('F63','F33'),
    ('F63','F34'),
    ('F63','F38'),
    ('F63','F39'),
    ('F64','F41'),
    ('F65','F44'),
    ('F66','F45'),
    ('F67','F0'),
    ('F67','F1'),
    ('F67','F2'),
    ('F67','F3'),
    ('F67','F4'),
    ('F67','F5'),
    ('F68','F60'),
    ('F68','F61'),
    ('F68','F62'),
    ('F68','F63'),
    ('F68','F64'),
    ('F68','F65'),
    ('F68','F66'),
    ('F68','F67'),
    ('F69','F60'),
    ('F69','F61'),
    ('F69','F62'),
    ('F69','F63'),
    ('F69','F64'),
    ('F69','F65'),
    ('F69','F66'),
    ('F69','F67'),
    ('F69','F68'),
    ('F70','F72'),
    ('F71','F70'),
    ('F78','F5'),
    ('F78','F70'),
    ('F78','F71'),
    ('F78','F72'),
    ('F79','F70'),
    ('F79','F71'),
    ('F79','F72'),
    ('F79','F78'),
    ('F9','F0'),
    ('F9','F1'),
    ('F9','F2'),
    ('F9','F3'),
    ('F9','F4'),
    ('F9','F5'),
    ('F9','F6'),
    ('F9','F7'),
    ('F104','F5'),
    ('F114','F5'),
    ('F124','F5'),
    ('F134','F5'),
    ('F144','F5'),
    ('F154','F5'),
    ('F164','F5'),
    ('F174','F5'),
    ('F184','F5'),
    ('F19','F10'),
    ('F19','F11'),
    ('F19','F12'),
    ('F19','F13'),
    ('F19','F14'),
    ('F19','F15'),
    ('F19','F16'),
    ('F19','F17'),
    ('F19','F18'),
    ('F194','F5'),
    ('F200','F220'),
    ('F203','F200'),
    ('F203','F201'),
    ('F203','F202'),
    ('F203','F204'),
    ('F203','F205'),
    ('F208','F200'),
    ('F208','F201'),
    ('F208','F202'),
    ('F208','F203'),
    ('F208','F204'),
    ('F208','F205'),
    ('F208','F206'),
    ('F208','F21'),
    ('F208','F252'),
    ('F209','F200'),
    ('F209','F201'),
    ('F209','F202'),
    ('F209','F203'),
    ('F209','F204'),
    ('F209','F205'),
    ('F209','F206'),
    ('F209','F208'),
    ('F21','F20'),
    ('F220','F0'),
    ('F220','F232'),
    ('F220','F233'),
    ('F228','F20'),
    ('F228','F220'),
    ('F229','F220'),
    ('F229','F228'),
    ('F23','F0'),
    ('F23','F30'),
    ('F23','F32'),
    ('F230','F20'),
    ('F230','F30'),
    ('F230','F32'),
    ('F232','F208'),
    ('F233','F20'),
    ('F233','F230'),
    ('F238','F230'),
    ('F238','F231'),
    ('F238','F232'),
    ('F238','F233'),
    ('F239','F230'),
    ('F239','F231'),
    ('F239','F232'),
    ('F239','F233'),
    ('F239','F238'),
    ('F258','F250'),
    ('F258','F251'),
    ('F258','F252'),
    ('F259','F250'),
    ('F259','F251'),
    ('F259','F252'),
    ('F259','F258'),
    ('F28','F20'),
    ('F28','F21'),
    ('F28','F22'),
    ('F28','F23'),
    ('F28','F24'),
    ('F28','F25'),
    ('F28','F3'),
    ('F29','F9'),
    ('F29','F20'),
    ('F29','F21'),
    ('F29','F22'),
    ('F29','F23'),
    ('F29','F24'),
    ('F29','F25'),
    ('F29','F28'),
    ('F30','F31'),
    ('F300','F301'),
    ('F300','F302'),
    ('F308','F300'),
    ('F308','F301'),
    ('F308','F302'),
    ('F309','F300'),
    ('F309','F301'),
    ('F309','F302'),
    ('F309','F308'),
    ('F31','F32'),
    ('F31','F33'),
    ('F316','F380'),
    ('F318','F310'),
    ('F318','F311'),
    ('F318','F312'),
    ('F318','F313'),
    ('F318','F314'),
    ('F318','F315'),
    ('F318','F316'),
    ('F318','F317'),
    ('F319','F310'),
    ('F319','F311'),
    ('F319','F312'),
    ('F319','F313'),
    ('F319','F314'),
    ('F319','F315'),
    ('F319','F316'),
    ('F319','F317'),
    ('F319','F318'),
    ('F32','F33'),
    ('F320','F321'),
    ('F320','F322'),
    ('F320','F323'),
    ('F321','F322'),
    ('F321','F323'),
    ('F322','F323'),
    ('F328','F320'),
    ('F328','F321'),
    ('F328','F322'),
    ('F328','F323'),
    ('F329','F320'),
    ('F329','F321'),
    ('F329','F322'),
    ('F329','F323'),
    ('F329','F328'),
    ('F33','F381'),
    ('F330','F331'),
    ('F330','F332'),
    ('F330','F333'),
    ('F330','F334'),
    ('F331','F332'),
    ('F331','F333'),
    ('F331','F334'),
    ('F332','F333'),
    ('F332','F334'),
    ('F333','F334'),
    ('F338','F330'),
    ('F338','F331'),
    ('F338','F332'),
    ('F338','F333'),
    ('F338','F334'),
    ('F339','F330'),
    ('F339','F331'),
    ('F339','F332'),
    ('F339','F333'),
    ('F339','F334'),
    ('F339','F338'),
    ('F340','F30'),
    ('F340','F31'),
    ('F340','F32'),
    ('F340','F33'),
    ('F341','F205'),
    ('F341','F330'),
    ('F341','F331'),
    ('F341','F4321'),
    ('F348','F320'),
    ('F348','F321'),
    ('F348','F340'),
    ('F348','F341'),
    ('F349','F320'),
    ('F349','F321'),
    ('F349','F340'),
    ('F349','F341'),
    ('F349','F348'),
    ('F38','F30'),
    ('F38','F31'),
    ('F38','F32'),
    ('F38','F33'),
    ('F38','F34'),
    ('F388','F380'),
    ('F388','F381'),
    ('F39','F30'),
    ('F39','F31'),
    ('F39','F32'),
    ('F39','F33'),
    ('F39','F34'),
    ('F39','F38'),
    ('F40','F41'),
    ('F401','F0'),
    ('F401','F2'),
    ('F401','F3'),
    ('F401','F42'),
    ('F408','F400'),
    ('F408','F401'),
    ('F408','F402'),
    ('F409','F400'),
    ('F409','F401'),
    ('F409','F402'),
    ('F409','F408'),
    ('F411','F32'),
    ('F411','F410'),
    ('F411','F42'),
    ('F411','F452'),
    ('F412','F32'),
    ('F412','F33'),
    ('F412','F341'),
    ('F412','F411'),
    ('F412','F413'),
    ('F413','F42'),
    ('F413','F432'),
    ('F413','F44'),
    ('F413','F450'),
    ('F413','F451'),
    ('F413','F452'),
    ('F418','F410'),
    ('F418','F411'),
    ('F418','F412'),
    ('F418','F413'),
    ('F419','F410'),
    ('F419','F411'),
    ('F419','F412'),
    ('F419','F413'),
    ('F419','F418'),
    ('F428','F420'),
    ('F428','F421'),
    ('F428','F422'),
    ('F429','F420'),
    ('F429','F421'),
    ('F429','F422'),
    ('F429','F428'),
    ('F432','F3'),
    ('F432','F4'),
    ('F432','F91'),
    ('F4320','F32'),
    ('F4320','F33'),
    ('F4320','F34'),
    ('F4320','F4321'),
    ('F4320','F4322'),
    ('F4320','F4323'),
    ('F4320','F4324'),
    ('F4320','F4325'),
    ('F4320','F4328'),
    ('F4321','F32'),
    ('F4321','F33'),
    ('F4321','F34'),
    ('F4321','F4322'),
    ('F4321','F4323'),
    ('F4321','F4324'),
    ('F4321','F4325'),
    ('F4321','F4328'),
    ('F4322','F32'),
    ('F4322','F33'),
    ('F4322','F34'),
    ('F4322','F40'),
    ('F4322','F412'),
    ('F4322','F413'),
    ('F4322','F4323'),
    ('F4322','F4324'),
    ('F4322','F4325'),
    ('F4322','F4328'),
    ('F4323','F412'),
    ('F4323','F413'),
    ('F4323','F4324'),
    ('F4323','F4325'),
    ('F4323','F4328'),
    ('F4324','F4325'),
    ('F4324','F4328'),
    ('F4325','F4328'),
    ('F438','F430'),
    ('F438','F431'),
    ('F438','F432'),
    ('F439','F430'),
    ('F439','F431'),
    ('F439','F432'),
    ('F439','F438'),
    ('F440','F4'),
    ('F440','F106'),
    ('F440','F116'),
    ('F440','F126'),
    ('F440','F136'),
    ('F440','F146'),
    ('F440','F156'),
    ('F440','F166'),
    ('F440','F176'),
    ('F440','F186'),
    ('F440','F196'),
    ('F440','F441'),
    ('F443','F2'),
    ('F443','F3'),
    ('F443','F480'),
    ('F445','F45'),
    ('F445','F480'),
    ('F446','F45'),
    ('F446','F480'),
    ('F447','F440'),
    ('F447','F441'),
    ('F447','F442'),
    ('F447','F443'),
    ('F447','F444'),
    ('F447','F445'),
    ('F447','F446'),
    ('F447','F45'),
    ('F447','F480'),
    ('F448','F440'),
    ('F448','F441'),
    ('F448','F442'),
    ('F448','F443'),
    ('F448','F444'),
    ('F448','F445'),
    ('F448','F446'),
    ('F448','F447'),
    ('F448','F45'),
    ('F448','F480'),
    ('F449','F440'),
    ('F449','F441'),
    ('F449','F442'),
    ('F449','F443'),
    ('F449','F444'),
    ('F449','F445'),
    ('F449','F446'),
    ('F449','F447'),
    ('F449','F448'),
    ('F449','F45'),
    ('F449','F480'),
    ('F45','F22'),
    ('F45','F44'),
    ('F45','F52'),
    ('F45','F54'),
    ('F45','F633'),
    ('F45','F800'),
    ('F45','F808'),
    ('F45','F95'),
    ('F45','F984'),
    ('F45','F988'),
    ('F450','F451'),
    ('F452','F22'),
    ('F452','F3'),
    ('F453','F40'),
    ('F453','F410'),
    ('F4538','F54'),
    ('F454','F2'),
    ('F454','F3'),
    ('F454','F450'),
    ('F454','F451'),
    ('F454','F452'),
    ('F454','F54'),
    ('F458','F450'),
    ('F458','F451'),
    ('F458','F452'),
    ('F458','F453'),
    ('F458','F454'),
    ('F458','F520'),
    ('F458','F526'),
    ('F458','F54'),
    ('F459','F450'),
    ('F459','F451'),
    ('F459','F452'),
    ('F459','F453'),
    ('F459','F454'),
    ('F459','F458'),
    ('F48','F3'),
    ('F48','F41'),
    ('F480','F66'),
    ('F480','F71'),
    ('F480','F72'),
    ('F480','F3'),
    ('F480','F410'),
    ('F480','F411'),
    ('F481','F5'),
    ('F481','F6'),
    ('F481','F1'),
    ('F481','F2'),
    ('F481','F3'),
    ('F481','F40'),
    ('F481','F41'),
    ('F488','F480'),
    ('F488','F481'),
    ('F489','F480'),
    ('F489','F481'),
    ('F489','F488'),
    ('F50','F982'),
    ('F50','F983'),
    ('F500','F501'),
    ('F500','F502'),
    ('F503','F502'),
    ('F508','F500'),
    ('F508','F501'),
    ('F508','F502'),
    ('F508','F503'),
    ('F508','F504'),
    ('F508','F505'),
    ('F509','F500'),
    ('F509','F501'),
    ('F509','F502'),
    ('F509','F503'),
    ('F509','F504'),
    ('F509','F505'),
    ('F509','F508'),
    ('F513','F441'),
    ('F514','F515'),
    ('F518','F510'),
    ('F518','F511'),
    ('F518','F512'),
    ('F518','F513'),
    ('F518','F514'),
    ('F518','F515'),
    ('F519','F510'),
    ('F519','F511'),
    ('F519','F512'),
    ('F519','F513'),
    ('F519','F514'),
    ('F519','F515'),
    ('F519','F518'),
    ('F52','F488'),
    ('F5210','F5211'),
    ('F527','F0'),
    ('F527','F1'),
    ('F527','F2'),
    ('F527','F3'),
    ('F527','F30'),
    ('F527','F31'),
    ('F527','F32'),
    ('F527','F33'),
    ('F527','F34'),
    ('F527','F38'),
    ('F527','F39'),
    ('F528','F520'),
    ('F528','F521'),
    ('F528','F522'),
    ('F528','F523'),
    ('F528','F524'),
    ('F528','F525'),
    ('F528','F526'),
    ('F528','F527'),
    ('F529','F520'),
    ('F529','F521'),
    ('F529','F522'),
    ('F529','F523'),
    ('F529','F524'),
    ('F529','F525'),
    ('F529','F526'),
    ('F529','F527'),
    ('F529','F528'),
    ('F538','F530'),
    ('F538','F531'),
    ('F539','F530'),
    ('F539','F531'),
    ('F539','F538'),
    ('F55','F10'),
    ('F55','F11'),
    ('F55','F12'),
    ('F55','F13'),
    ('F55','F14'),
    ('F55','F15'),
    ('F55','F16'),
    ('F55','F17'),
    ('F55','F18'),
    ('F55','F19'),
    ('F558','F550'),
    ('F558','F551'),
    ('F558','F552'),
    ('F558','F553'),
    ('F558','F554'),
    ('F558','F555'),
    ('F558','F556'),
    ('F559','F550'),
    ('F559','F551'),
    ('F559','F552'),
    ('F559','F553'),
    ('F559','F554'),
    ('F559','F555'),
    ('F559','F556'),
    ('F559','F558'),
    ('F59','F50'),
    ('F59','F51'),
    ('F59','F52'),
    ('F59','F53'),
    ('F59','F54'),
    ('F59','F55'),
    ('F60','F7'),
    ('F600','F20'),
    ('F600','F22'),
    ('F601','F20'),
    ('F601','F21'),
    ('F601','F22'),
    ('F601','F845'),
    ('F602','F603'),
    ('F602','F91'),
    ('F605','F42'),
    ('F608','F600'),
    ('F608','F601'),
    ('F608','F602'),
    ('F608','F603'),
    ('F608','F604'),
    ('F608','F605'),
    ('F608','F606'),
    ('F608','F607'),
    ('F609','F600'),
    ('F609','F601'),
    ('F609','F602'),
    ('F609','F603'),
    ('F609','F604'),
    ('F609','F605'),
    ('F609','F606'),
    ('F609','F607'),
    ('F609','F608'),
    ('F61','F7'),
    ('F61','F60'),
    ('F61','F62'),
    ('F62','F7'),
    ('F620','F431'),
    ('F628','F620'),
    ('F628','F621'),
    ('F629','F620'),
    ('F629','F621'),
    ('F629','F628'),
    ('F63','F10'),
    ('F63','F11'),
    ('F63','F12'),
    ('F63','F13'),
    ('F63','F14'),
    ('F63','F15'),
    ('F63','F16'),
    ('F63','F17'),
    ('F63','F18'),
    ('F63','F19'),
    ('F63','F52'),
    ('F63','F65'),
    ('F630','F30'),
    ('F630','F602'),
    ('F631','F0'),
    ('F631','F1'),
    ('F631','F2'),
    ('F631','F3'),
    ('F631','F4'),
    ('F631','F5'),
    ('F631','F6'),
    ('F631','F7'),
    ('F631','F9'),
    ('F631','F20'),
    ('F631','F602'),
    ('F631','F911'),
    ('F632','F0'),
    ('F632','F1'),
    ('F632','F2'),
    ('F632','F3'),
    ('F632','F4'),
    ('F632','F5'),
    ('F632','F6'),
    ('F632','F7'),
    ('F632','F9'),
    ('F632','F30'),
    ('F632','F31'),
    ('F632','F32'),
    ('F632','F33'),
    ('F633','F984'),
    ('F638','F630'),
    ('F638','F631'),
    ('F638','F632'),
    ('F638','F633'),
    ('F639','F630'),
    ('F639','F631'),
    ('F639','F632'),
    ('F639','F633'),
    ('F639','F638'),
    ('F641','F651'),
    ('F642','F660'),
    ('F642','F661'),
    ('F648','F640'),
    ('F648','F641'),
    ('F648','F642'),
    ('F649','F640'),
    ('F649','F641'),
    ('F649','F642'),
    ('F649','F648'),
    ('F65','F66'),
    ('F656','F650'),
    ('F656','F651'),
    ('F656','F652'),
    ('F656','F653'),
    ('F656','F654'),
    ('F656','F655'),
    ('F658','F650'),
    ('F658','F651'),
    ('F658','F652'),
    ('F658','F653'),
    ('F658','F654'),
    ('F658','F655'),
    ('F658','F656'),
    ('F659','F650'),
    ('F659','F651'),
    ('F659','F652'),
    ('F659','F653'),
    ('F659','F654'),
    ('F659','F655'),
    ('F659','F656'),
    ('F659','F658'),
    ('F668','F660'),
    ('F668','F661'),
    ('F668','F662'),
    ('F669','F660'),
    ('F669','F661'),
    ('F669','F662'),
    ('F669','F668'),
    ('F68','F60'),
    ('F68','F61'),
    ('F68','F62'),
    ('F68','F63'),
    ('F68','F64'),
    ('F68','F65'),
    ('F68','F66'),
    ('F688','F680'),
    ('F688','F681'),
    ('F69','F60'),
    ('F69','F61'),
    ('F69','F62'),
    ('F69','F63'),
    ('F69','F64'),
    ('F69','F65'),
    ('F69','F66'),
    ('F69','F68'),
    ('F78','F70'),
    ('F78','F71'),
    ('F78','F72'),
    ('F78','F73'),
    ('F79','F70'),
    ('F79','F71'),
    ('F79','F72'),
    ('F79','F73'),
    ('F79','F79'),
    ('F80','F7'),
    ('F800','F84'),
    ('F800','F801'),
    ('F800','F802'),
    ('F801','F84'),
    ('F801','F802'),
    ('F801','F803'),
    ('F802','F803'),
    ('F802','F841'),
    ('F803','F840'),
    ('F803','F841'),
    ('F808','F800'),
    ('F808','F801'),
    ('F808','F802'),
    ('F808','F803'),
    ('F809','F800'),
    ('F809','F801'),
    ('F809','F802'),
    ('F809','F803'),
    ('F809','F808'),
    ('F810','F93'),
    ('F811','F810'),
    ('F812','F811'),
    ('F813','F810'),
    ('F813','F811'),
    ('F813','F812'),
    ('F818','F810'),
    ('F818','F811'),
    ('F818','F812'),
    ('F818','F813'),
    ('F819','F810'),
    ('F819','F811'),
    ('F819','F812'),
    ('F819','F813'),
    ('F819','F818'),
    ('F82','F7'),
    ('F840','F20'),
    ('F840','F70'),
    ('F840','F71'),
    ('F840','F72'),
    ('F840','F802'),
    ('F840','F842'),
    ('F840','F845'),
    ('F840','F941'),
    ('F840','F942'),
    ('F843','F20'),
    ('F843','F803'),
    ('F843','F842'),
    ('F844','F840'),
    ('F844','F841'),
    ('F844','F842'),
    ('F845','F206'),
    ('F845','F21'),
    ('F845','F42'),
    ('F845','F605'),
    ('F845','F941'),
    ('F845','F942'),
    ('F848','F840'),
    ('F848','F841'),
    ('F848','F842'),
    ('F848','F843'),
    ('F848','F844'),
    ('F848','F845'),
    ('F849','F840'),
    ('F849','F841'),
    ('F849','F842'),
    ('F849','F843'),
    ('F849','F844'),
    ('F849','F845'),
    ('F849','F848'),
    ('F88','F80'),
    ('F88','F81'),
    ('F88','F82'),
    ('F88','F83'),
    ('F88','F84'),
    ('F89','F80'),
    ('F89','F81'),
    ('F89','F82'),
    ('F89','F83'),
    ('F89','F84'),
    ('F89','F88'),
    ('F90','F20'),
    ('F90','F30'),
    ('F90','F31'),
    ('F90','F32'),
    ('F90','F33'),
    ('F90','F34'),
    ('F90','F38'),
    ('F90','F39'),
    ('F90','F41'),
    ('F90','F84'),
    ('F90','F930'),
    ('F900','F901'),
    ('F908','F900'),
    ('F908','F901'),
    ('F909','F900'),
    ('F909','F901'),
    ('F909','F908'),
    ('F91','F20'),
    ('F91','F3'),
    ('F91','F84'),
    ('F91','F901'),
    ('F91','F92'),
    ('F913','F910'),
    ('F913','F911'),
    ('F913','F912'),
    ('F918','F910'),
    ('F918','F911'),
    ('F918','F912'),
    ('F918','F913'),
    ('F919','F910'),
    ('F919','F911'),
    ('F919','F912'),
    ('F919','F913'),
    ('F919','F918'),
    ('F928','F920'),
    ('F929','F920'),
    ('F929','F928'),
    ('F930','F3'),
    ('F930','F4'),
    ('F930','F931'),
    ('F930','F932'),
    ('F931','F411'),
    ('F933','F938'),
    ('F938','F642'),
    ('F938','F930'),
    ('F938','F931'),
    ('F938','F932'),
    ('F938','F933'),
    ('F939','F930'),
    ('F939','F931'),
    ('F939','F932'),
    ('F939','F933'),
    ('F939','F938'),
    ('F940','F20'),
    ('F940','F80'),
    ('F940','F84'),
    ('F940','F930'),
    ('F940','F942'),
    ('F942','F432'),
    ('F942','F90'),
    ('F948','F940'),
    ('F948','F941'),
    ('F948','F942'),
    ('F949','F940'),
    ('F949','F941'),
    ('F949','F942'),
    ('F949','F948'),
    ('F958','F950'),
    ('F958','F951'),
    ('F958','F952'),
    ('F959','F950'),
    ('F959','F951'),
    ('F959','F952'),
    ('F959','F958'),
    ('F98','F42'),
    ('F98','F51'),
    ('F98','F642'),
    ('F982','F983'),
    ('F984','F42'),
    ('F984','F95'),
    ('F985','F42'),
    ('F985','F95'),
    ('F985','F986'),
    ('F986','F42'),
    ('F986','F95'),
    ('F988','F980'),
    ('F988','F981'),
    ('F988','F982'),
    ('F988','F983'),
    ('F988','F984'),
    ('F988','F985'),
    ('F988','F986'),
    ('F989','F980'),
    ('F989','F981'),
    ('F989','F982'),
    ('F989','F983'),
    ('F989','F984'),
    ('F989','F985'),
    ('F989','F986'),
    ('F989','F988'),
    ('F99','F0'),
    ('F99','F1'),
    ('F99','F2'),
    ('F99','F3'),
    ('F99','F4'),
    ('F99','F5'),
    ('F99','F6'),
    ('F99','F7'),
    ('F99','F8'),
    ('F99','F90'),
    ('F99','F91'),
    ('F99','F92'),
    ('F99','F93'),
    ('F99','F94'),
    ('F99','F95'),
    ('F99','F98')
    ]


