#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#bado_start.py: main program for starting the bado-gui V4
#Copyright (C) 2008 qualitas GmbH
#Author: Sönke von Heymann <svheymann@iqp-online.de>
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

version  = "2.1"

import sys, os, copy
from datetime import datetime
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from types import *
import string
import codecs
import hashlib
from bado_gui.main_therapeut import Ui_MainTherapeut
from bado_gui.main_patient import Ui_MainPatient

from bado_gui.auswahl_therapeut import Ui_auswahlTherapeut
from bado_gui.auswahl_patient import Ui_auswahlPatient
from bado_gui.auswahl_isr_therapeut import Ui_auswahlIsrTherapeut
from bado_gui.auswahl_isr_patient import Ui_auswahlIsrPatient
from bado_gui.aufnahme_therapeut import Ui_aufnahme_therapeut
from bado_gui.aufnahme_patient import Ui_aufnahme_patient
from bado_gui.entlassung_therapeut import Ui_entlassung_therapeut
from bado_gui.entlassung_patient import Ui_entlassung_patient
from bado_gui.isr import Ui_isr
from bado_gui.isr_grafik import Ui_isr_grafik
from bado_gui.mini_icf import Ui_mini_icf
from bado_gui.scl90 import Ui_scl90
from bado_gui.ktl_krankenhaus import Ui_ktl_krankenhaus
from bado_gui.ktl_reha import Ui_ktl_reha
from bado_gui.einstellungen import Ui_einstellungen
from bado_gui.jahrgang import Ui_jahrgang
from bado_gui.auth import Ui_auth
from bado_gui.listenauswahl import Ui_Listenauswahl
from bado_gui.useradmin import Ui_userAdmin
from bado_gui.auth_createdb import Ui_auth_createdb
import qualiconfV4 

from bado_gui.auswahl_test import Ui_auswahlTest
import db_helperlib

import pickle
db = pickle.load(file('enum.pickle'))
dateiformat = qualiconfV4.dateiformat
from qualiconfV4 import check



class BadoStart(QMainWindow):
    def __init__(self, guiType = 1, args = []):
        self.guiType = guiType
        QWidget.__init__(self, None)
        if self.guiType == 1 or self.guiType == 3 or self.guiType == 0:
            self.ui = Ui_MainTherapeut()
        else:
            self.ui = Ui_MainPatient()
        self.ui.setupUi(self)
        self.setObjectName("MainWindow")
        self.move(QPoint(0,0))
        self.setWindowTitle('BaDo V4 Datenerfassung V%s'% version)
        self.patientenDict = {}
        self.activePatient = None
        self.dataDict = []
        self.choice = -1
        self.behandler_nr = ''
        self.sub_behandler_nr = ''
        self.dataChanged = False
        self.isTestNew = True
        self.isNewPatient = False
        self.activeTestDatum = ''
        self.connectedToDb = False
        self.readConfig()
        

        if self.dataSource == 'filesystem':
            self.patientendatei_pfad = os.path.abspath(os.path.normcase(unicode('Patientenliste/Patientenliste.txt')))
            if not os.path.exists(os.path.split(unicode(self.patientendatei_pfad))[0]):
                os.makedirs(os.path.split(unicode(self.patientendatei_pfad))[0])
                self.daten_pfad = os.path.abspath('Patientendaten')
                if not os.path.exists(os.path.split(unicode(self.daten_pfad))[0]):
                    os.makedirs(os.path.split(unicode(self.daten_pfad))[0])
        # Stammdaten lesen
        if self.guiType == 1 or self.guiType == 3 or self.guiType == 0:
            self.readPatientenFile()
          
            # If patient is provided with commandline arguments, access this patient directly.
            # Refuse direct access if some of the three parameters is missing.
            if args.patnr != None and args.vname != None and args.nname != None:
            # Check, if data file exists
                if args.patnr in self.patientenDict.keys():
                    QMessageBox.critical(self, 'Anlegen fehlgeschlagen', 
                                'Es exisitert bereits ein Datensatz mit der Patientennummer: ' + args.patnr, 
                                'Ok', '', '', 0, -1)
                else:
                    self.activePatient = args.patnr
                    if self.dataSource == 'sql':
                        pass
                    else:
                        patDataFile = self.daten_pfad + "/" + self.activePatient
                        if not os.path.isfile(unicode(patDataFile)):
                            # Insert new patient
                            self.patientenDict[self.activePatient] = (args.vname, args.nname)
                            # Rewrite appended patient list
                            self.writePatientenFile()
                            # Create patient data
                            self.saveDataFile(patDataFile)
                        else: 
                            # Read patient data
                            self.loadDataFile(patDataFile)
                    # Jump directly to the overview
                    self.showAuswahl(self.activePatient)
        
                  
    def showInfo(self):
        QMessageBox.information(self, 'Informationen', 
                                        """IQP BaDo - Datenerfassungstool
Version %s

Fragen, Anregungen oder Fehlerberichte bitte an: support@iqp-online.de""" % version, 
                                        'Ok', '', '', 0, -1)
                                        
    def readPatientenFile(self):
        self.patientenDict = {}
        if self.dataSource == 'sql':
            #print self.connectedToDb
            if not self.connectedToDb == True:
                if not self.askDbPassword():
                    return False
            #print self.behandler_nr, type(self.behandler_nr)
            dataList = db_helperlib.getPatientenlisteFromDatabase(self.behandler_nr)
            for listitem in dataList:
                self.patientenDict[QString(listitem[0])] = (QString(listitem[1]), QString(listitem[2])) 
        else:
            if os.path.exists(unicode(self.patientendatei_pfad)):
                patientenFile = codecs.open(unicode(self.patientendatei_pfad),'r','utf8')
                if patientenFile:
                    for line in patientenFile:
                        dataList = line.strip().split('|')
                        self.patientenDict[QString(dataList[0])] = (QString(dataList[1]), QString(dataList[2])) 
        return True
                    
    def writePatientenFile(self):
        #print os.path.split(self.patientendatei_pfad)
        if self.dataSource == 'sql':
            pass
        else:
            if not os.path.exists(os.path.split(unicode(self.patientendatei_pfad))[0]):
                answer = QMessageBox.question(self, 'Verzeichnis erstellen?', 
                                                        u'Das ausgewählte Verzeichnis existiert nicht, soll es erstellt werden?', 
                                                        'Ja', 'Nein', '', 0, -1)
                if answer == 0:
                    os.makedirs(os.path.split(unicode(self.patientendatei_pfad))[0])
                else:
                    return
            
            #if os.path.exists(self.patientendatei_pfad):
            #    patientenFile = open(self.patientendatei_pfad,'w')
            #else:
            #    return
            output = QString('')
            for key in self.patientenDict.keys():
                if not key:
                    continue
                output += key + '|' + self.patientenDict[key][0] + '|' + self.patientenDict[key][1] + '\r\n'
            output = output.trimmed()
            patientenFile = codecs.open(unicode(self.patientendatei_pfad),'w','utf8')
            #print len(output)
            patientenFile.writelines(unicode(output))
            patientenFile.close()
            patientenFile = codecs.open(unicode(self.patientendatei_pfad),'r','utf8')
            laenge = len(QString(patientenFile.read()))
            patientenFile = codecs.open(unicode(self.patientendatei_pfad),'r','utf8')
            patientenFile.close()
            if not laenge == len(output):
                QMessageBox.critical(self, 'Speichern fehlgeschlagen', 
                                'Speichern der Patientendatei in die Datei ' + self.patientendatei_pfad + 
                                u' ist fehlgeschlagen. Prüfen Sie bitte, ob diese Datei von einem anderen Programm verwendet wird oder versuchen Sie es erneut mit Datei --> Speichern.', 
                                'Ok', '', '', 0, -1)
        
        
    def readConfig(self):
        configList = self.getConfigList()
        if configList:
            self.behandler_nr = configList[0]
            if len(configList) > 1:
                self.sub_behandler_nr = configList[1]
            if len(configList) > 2:
                self.patientendatei_pfad = configList[2]
                if not os.path.exists(os.path.split(unicode(self.patientendatei_pfad))[0]):
                    os.makedirs(os.path.split(unicode(self.patientendatei_pfad))[0])
            if len(configList) > 3:
                self.daten_pfad = configList[3]
                if not os.path.exists(os.path.split(unicode(self.daten_pfad))[0]):
                    os.makedirs(os.path.split(unicode(self.daten_pfad))[0])
            if len(configList) > 4:
                self.dataSource = configList[4]
            if len(configList) > 7:
                self.dsn = [configList[5], configList[6], configList[7]]
            
        elif self.guiType == 1 or self.guiType == 3 or self.guiType == 0:
            if not self.setPreferences(init = True):
                self.close()
            
                    
    def newFile(self):
        if not self.questionSaveChanges():
            return False
        self.closeActiveWidget()
        if self.activePatient and self.dataSource == 'sql':
            if self.askDbPassword():
                db_helperlib.releaseLock(behandler_nr=self.behandler_nr, patienten_nr=self.activePatient)
            else:
                self.activePatient = None
                self.dataDict = []
                return
        self.activePatient = None
        self.dataDict = []
        self.choice = -1
        self.isNewPatient = True
        self.showAuswahl()
        self.setWindowTitle('BaDo V4 Datenerfassung V%s - Neuer Patient' % version)
        
        
    def closeActiveWidget(self):
        if hasattr(self,'ActiveWidget'):
            try:
                self.ActiveWidget.close()
                self.ActiveWidget.deleteLater()
                self.ActiveWidget = None
            except:
                pass
                

    def setDataChanged(self, string = None):
        #print 'changed'
        self.dataChanged = True
               
    def showAuswahl(self, patienten_nr = None):
        self.closeActiveWidget()
        if self.guiType == 1:
            self.ActiveWidget = AuswahlTherapeut(self)
        elif self.guiType == 2:
            self.ActiveWidget = AuswahlPatient(self)
        elif self.guiType == 3:
            self.ActiveWidget = AuswahlIsrTherapeut(self)
        elif self.guiType == 4:
            self.ActiveWidget = AuswahlIsrPatient(self)
        elif self.guiType == 0:
            self.ActiveWidget = AuswahlTest(self)
        else:
            self.ActiveWidget = AuswahlPatient(self)
        self.ui.layout.addWidget(self.ActiveWidget)
        self.ActiveWidget.move(QPoint(10,50))
        QObject.connect(self.ActiveWidget.ui.okButton, SIGNAL("clicked()"),self.acceptChoice)
        #QObject.connect(self.ActiveWidget.ui.cancelButton, SIGNAL("clicked()"),self.cancelChoice)
        
        QObject.connect(self.ActiveWidget.ui.isrList, SIGNAL("currentIndexChanged(int)"),self.updateIsIsrChanged)
        QObject.connect(self.ActiveWidget.ui.vorname, SIGNAL("textEdited(QString)"), self.setDataChanged)
        QObject.connect(self.ActiveWidget.ui.nachname, SIGNAL("textEdited(QString)"), self.setDataChanged)
        QObject.connect(self.ActiveWidget.ui.patienten_nr, SIGNAL("textEdited(QString)"), self.setDataChanged)
        QObject.connect(self.ActiveWidget.ui.behandler_nr, SIGNAL("textEdited(QString)"), self.setDataChanged)
        QObject.connect(self.ActiveWidget.ui.sub_behandler_nr, SIGNAL("textEdited(QString)"), self.setDataChanged)
        if self.guiType == 1 or self.guiType == 3 or self.guiType == 0:
            QObject.connect(self.ActiveWidget.ui.deleteButton, SIGNAL("clicked()"),self.deleteChoice)
            QObject.connect(self.ActiveWidget.ui.evalIsr, SIGNAL("clicked()"),self.evalIsr)
            
        if self.guiType == 2 or self.guiType == 4 or self.guiType == 0:
            QObject.connect(self.ActiveWidget.ui.saveButton, SIGNAL("clicked()"),self.saveFile)

        if self.guiType == 1 or self.guiType == 0:            
            QObject.connect(self.ActiveWidget.ui.scl90List, SIGNAL("currentIndexChanged(int)"),self.updateIsScl90Changed)
            QObject.connect(self.ActiveWidget.ui.miniIcfList, SIGNAL("currentIndexChanged(int)"),self.updateIsMiniIcfChanged)
            
        if self.guiType == 0:            
            QObject.connect(self.ActiveWidget.ui.loadFromDatabase, SIGNAL("clicked()"),self.loadFromDatabase)
            QObject.connect(self.ActiveWidget.ui.saveToDatabase, SIGNAL("clicked()"),self.saveToDatabase)  

        #QObject.connect(self.ActiveWidget.ui.testAuswahl, SIGNAL("mousePressEvent(event)"), self.test)
        self.ActiveWidget.show()
        item_behandler_nr = self.ActiveWidget.findChild(QLineEdit,'behandler_nr')
        item_sub_behandler_nr = self.ActiveWidget.findChild(QLineEdit,'sub_behandler_nr')
        self.setLineInput(item_behandler_nr, self.behandler_nr)
        self.setLineInput(item_sub_behandler_nr, self.sub_behandler_nr)
        isrList = self.ActiveWidget.findChild(QComboBox,'isrList')
        # Combo-Boxen befüllen
        if isinstance(isrList, QComboBox):
            self.initTestList(isrList)
        miniIcfList = self.ActiveWidget.findChild(QComboBox,'miniIcfList')
        if isinstance(miniIcfList, QComboBox):
            self.initTestList(miniIcfList)
        scl90List = self.ActiveWidget.findChild(QComboBox,'scl90List')
        if isinstance(scl90List, QComboBox):
            self.initTestList(scl90List)
        # bis hierher Init-Phase für das Auswahl-Widget
        if self.isNewPatient:
            #print 'Neuer Patient'
            return
        # den ersten Datenblock holen, alle Datenblöcke müssen die Patienten-Nummer enthalten
        if len(self.dataDict) > 0:
            dataBlock = self.dataDict[0]
        else:
            dataBlock = None
        # Entweder gibt es einen Datenblock mit der Patientennummer
        if dataBlock:
            patienten_nr = dataBlock['patienten_nr']
            self.activePatient = patienten_nr
        # oder es gibt einen aktiven Patienen ohne Datenblock (Abbruch bei ersten Dateneingabe)
        elif self.activePatient:
            patienten_nr = self.activePatient
        #print patienten_nr

        item = self.ActiveWidget.findChild(QLineEdit,'patienten_nr')
        self.setLineInput(item, patienten_nr)
        patientData = self.patientenDict.get(patienten_nr)
        if patientData:
            item = self.ActiveWidget.findChild(QLineEdit,'vorname')
            self.setLineInput(item, patientData[0])
            item = self.ActiveWidget.findChild(QLineEdit,'nachname')
            self.setLineInput(item, patientData[1])
            self.setWindowTitle('BaDo V4 Datenerfassung V' + version + ' - Patient: ' + patientData[0] + ' ' + patientData[1] + ' ' + patienten_nr)

        if not dataBlock:
            #print 'Data-Dict ist leer!'
            return

        if dataBlock.has_key('behandler_nr') and dataBlock['behandler_nr']:
            self.setLineInput(item_behandler_nr, dataBlock['behandler_nr'])
        if dataBlock.has_key('sub_behandler_nr') and dataBlock['sub_behandler_nr']:
            self.setLineInput(item_sub_behandler_nr, dataBlock['sub_behandler_nr'])
        # wenn das dataDict leer ist, kann hier abgebrochen werden
        
        # update der häkchen und Listen-Einträge
        for dataBlock in self.dataDict:
            dataFormat = int(dataBlock['format'])
            if dataFormat == 1:
                item = self.ActiveWidget.findChild(QCheckBox,'isAufnahmeTherapeut')
                if item:
                    item.setChecked(True)
                    if self.checkComplete(dataBlock)[0]:
                        item = self.ActiveWidget.findChild(QCheckBox,'isAufnahmeTherapeutComplete')
                        item.setChecked(True)
            elif dataFormat == 2:
                item = self.ActiveWidget.findChild(QCheckBox,'isAufnahmePatient')
                if item:
                    item.setChecked(True)
                    if self.checkComplete(dataBlock)[0]:
                        item = self.ActiveWidget.findChild(QCheckBox,'isAufnahmePatientComplete')
                        item.setChecked(True)
            elif dataFormat == 3:
                item = self.ActiveWidget.findChild(QCheckBox,'isEntlassungTherapeut')
                if item:
                    item.setChecked(True)
                    if self.checkComplete(dataBlock)[0]:
                        item = self.ActiveWidget.findChild(QCheckBox,'isEntlassungTherapeutComplete')
                        item.setChecked(True)
            elif dataFormat == 4:
                item = self.ActiveWidget.findChild(QCheckBox,'isEntlassungPatient')
                if item:
                    item.setChecked(True)
                    if self.checkComplete(dataBlock)[0]:
                        item = self.ActiveWidget.findChild(QCheckBox,'isEntlassungPatientComplete')
                        item.setChecked(True)
            elif dataFormat == 5:
                if isrList:
                    isrList.insertItem(-1,dataBlock['isr_datum'])
                    isrList.setCurrentIndex(0)
            elif dataFormat == 6:
                if miniIcfList:
                    miniIcfList.insertItem(-1,dataBlock['mini_icf_datum'])
                    miniIcfList.setCurrentIndex(0)
            elif dataFormat == 7:
                if scl90List:
                    scl90List.insertItem(-1,dataBlock['scl90_datum'])
                    scl90List.setCurrentIndex(0)
            elif dataFormat == 8:
                item = self.ActiveWidget.findChild(QCheckBox,'isKtlKrankenhaus')
                if item:
                    item.setChecked(True)
                    if self.checkComplete(dataBlock)[0]:
                        item = self.ActiveWidget.findChild(QCheckBox,'isKtlKrankenhausComplete')
                        item.setChecked(True)
            elif dataFormat == 9:
                item = self.ActiveWidget.findChild(QCheckBox,'isKtlReha')
                if item:
                    item.setChecked(True)
                    if self.checkComplete(dataBlock)[0]:
                        item = self.ActiveWidget.findChild(QCheckBox,'isKtlRehaComplete')
                        item.setChecked(True)
    
    def evalIsr(self):
        if not self.questionSaveChanges():
            return False
        listItem = self.ActiveWidget.findChild(QComboBox,'isrList')
        #dataBlock = self.getDataBlockByDate(listItem, 5, 'isr_datum')
        dataBlocks = []
        for nDataBlock in range(len(self.dataDict)):
            if int(self.dataDict[nDataBlock]['format']) == 5:
                datum = datetime.strptime(str(self.dataDict[nDataBlock]['isr_datum']),"%d.%m.%Y")
                dataBlocks.append(copy.deepcopy(self.dataDict[nDataBlock]))
                dataBlocks[-1]['isr_datum_datetime']=datum
        #print dataBlocks
        if not dataBlocks:
            return
        
        dataBlocks = sorted(dataBlocks, key=lambda x: x['isr_datum_datetime'], reverse=True)

        itemDict = {}
        itemDict['depression']  = ['isr_d01', 'isr_d02', 'isr_d03', 'isr_d05']
        itemDict['angst']       = ['isr_a01', 'isr_a02', 'isr_a03', 'isr_a04']                
        itemDict['zwang']       = ['isr_z01', 'isr_z02', 'isr_z03']
        itemDict['soma']        = ['isr_s01', 'isr_s02', 'isr_s03']
        itemDict['essstörung']  = ['isr_e01', 'isr_e02', 'isr_e03']
        itemDict['zusatz']      = ['isr_d04', 'isr_d10', 'isr_d11', 'isr_d12', 
                                   'isr_w01', 'isr_w02', 'isr_w03', 'isr_w05',
                                   'isr_w06', 'isr_w07', 'isr_w08', 'isr_w09']

        scoreDict = []
        for dataBlock in dataBlocks:
            scoreDict.append({})
            scoreDict[-1]['depression'] = {}
            scoreDict[-1]['angst'] = {}
            scoreDict[-1]['zwang'] = {}
            scoreDict[-1]['soma'] = {}
            scoreDict[-1]['essstörung'] = {}
            scoreDict[-1]['zusatz'] = {}
            scoreDict[-1]['gesamt'] = {}
            scoreDict[-1]['isr_datum'] = dataBlock['isr_datum']
            scoreDict[-1]['gesamt']['count'] = 0
            scoreDict[-1]['gesamt']['finalScore'] = 0

            nMissingGesamt = 0
            nMissingMax ={}
            nMissingMax['gesamt'] = 2
            nMissingMax['depression'] = 0
            nMissingMax['angst'] = 0
            nMissingMax['zwang'] = 0
            nMissingMax['soma'] = 0
            nMissingMax['essstörung'] = 0
            nMissingMax['zusatz'] = 1
            
            nMissing ={}
            nMissing['gesamt'] = 0
            nMissing['depression'] = 0
            nMissing['angst'] = 0
            nMissing['zwang'] = 0
            nMissing['soma'] = 0
            nMissing['essstörung'] = 0
            nMissing['zusatz'] = 0
            
            calculateGesamtScore = True
            
            for skala in ['depression','angst','zwang','soma','essstörung','zusatz']:
                scoreDict[-1][skala]['score'] = 0.0
                scoreDict[-1][skala]['count'] = 0.0
                scoreDict[-1][skala]['finalScore'] = None
                for skalaItem in itemDict[skala]:
                    if dataBlock[skalaItem]:
                        scoreDict[-1][skala]['count'] = scoreDict[-1][skala]['count'] + 1
                        scoreDict[-1][skala]['score'] = scoreDict[-1][skala]['score'] + float(int(dataBlock[skalaItem]))
                    else:
                        nMissingGesamt = nMissingGesamt + 1
                        nMissing[skala] = nMissing[skala] + 1
                        
                if (len(itemDict[skala]) - scoreDict[-1][skala]['count']) <= nMissingMax[skala]:
                    scoreDict[-1][skala]['finalScore'] = scoreDict[-1][skala]['score'] / scoreDict[-1][skala]['count']
                    scoreDict[-1][skala]['finalScoreText'] = '%1.2f' % scoreDict[-1][skala]['finalScore']
                else:
                    scoreDict[-1][skala]['finalScoreText'] = '--'
                    
                
                if skala == 'zusatz':
                    if nMissing[skala] < 3:
                        scoreDict[-1]['gesamt']['count'] =  scoreDict[-1]['gesamt']['count'] + 2
                        scoreDict[-1]['gesamt']['finalScore'] = scoreDict[-1]['gesamt']['finalScore'] + 2*scoreDict[-1][skala]['score'] / scoreDict[-1][skala]['count']
                    else:
                        calculateGesamtScore = False
                else:
                    if nMissing[skala] < 2:
                        scoreDict[-1]['gesamt']['count'] =  scoreDict[-1]['gesamt']['count'] + 1
                        scoreDict[-1]['gesamt']['finalScore'] = scoreDict[-1]['gesamt']['finalScore'] + scoreDict[-1][skala]['score'] / scoreDict[-1][skala]['count']
                    else:
                        calculateGesamtScore = False
                
                
            # Zusatz-Items haben fÃ¼r die Darstellung keinen gesamt-score
            for skala in itemDict['zusatz']:
                if not scoreDict[-1].has_key(skala):
                    scoreDict[-1][skala] = {}

                if dataBlock[skala]:
                    scoreDict[-1][skala]['finalScore'] = float(dataBlock[skala])
                    scoreDict[-1][skala]['finalScoreText'] = '%1.2f' % scoreDict[-1][skala]['finalScore']
                else:
                    scoreDict[-1][skala]['finalScoreText'] = '--'
            #print nMissingGesamt
            if nMissingGesamt <= nMissingMax['gesamt'] and calculateGesamtScore:
                scoreDict[-1]['gesamt']['finalScore'] = scoreDict[-1]['gesamt']['finalScore'] / scoreDict[-1]['gesamt']['count']
                scoreDict[-1]['gesamt']['finalScoreText'] = '%1.2f' % scoreDict[-1]['gesamt']['finalScore']
            else:
                del(scoreDict[-1]['gesamt']['finalScore'])
                scoreDict[-1]['gesamt']['finalScoreText'] = '--'
        #print self.patientenDict
        itemDict['patienten_nr'] = self.activePatient
        itemDict['vorname']  = self.patientenDict[self.activePatient][0]
        itemDict['nachname'] = self.patientenDict[self.activePatient][1]
    
        self.closeActiveWidget()
        self.ActiveWidget = Isr_grafik(self, scoreDict, itemDict)
        self.setWindowTitle('BaDo V4 Datenerfassung V%s - ISR-Auswertung' % version)
        QObject.connect(self.ActiveWidget.ui.cancelButton, SIGNAL("clicked()"),self.showAuswahl)
        self.ui.layout.addWidget(self.ActiveWidget)
        self.ActiveWidget.move(QPoint(10,32))
        self.ActiveWidget.show()

        

                
    def checkComplete(self, dataBlock):
        #print 'Starting completness check'
        missingVariables = []
        for key in dataBlock.keys():
            if type(dataBlock[key]) == ListType:
                if not dataBlock[key][0]:
                    #print 'fehlt: ',key
                    missingVariables.append(key)
                #else:
                    #print 'vorhanden: ', key, dataBlock[key]
            elif not dataBlock[key]:
                #print 'fehlt: ',key
                missingVariables.append(key)
            #else:
                #print 'vorhanden: ', key, dataBlock[key]
        if missingVariables:
            return False, missingVariables
        else:
            return True, None
        
    def updateIsIsrChanged(self, lala):
        listItem = self.ActiveWidget.findChild(QComboBox,'isrList')
        dataBlock = self.getDataBlockByDate(listItem, 5, 'isr_datum')
        item = self.ActiveWidget.findChild(QCheckBox,'isIsrComplete')
        if dataBlock and self.checkComplete(dataBlock)[0]:
            item.setChecked(True)
        else:
            item.setChecked(False)
    
    def updateIsMiniIcfChanged(self):
        listItem = self.ActiveWidget.findChild(QComboBox,'miniIcfList')
        dataBlock = self.getDataBlockByDate(listItem, 6, 'mini_icf_datum')
        item = self.ActiveWidget.findChild(QCheckBox,'isMiniIcfComplete')
        if dataBlock and self.checkComplete(dataBlock)[0]:
            item.setChecked(True)
        else:
            item.setChecked(False)
            
    def updateIsScl90Changed(self):
        listItem = self.ActiveWidget.findChild(QComboBox,'scl90List')
        dataBlock = self.getDataBlockByDate(listItem, 7, 'scl90_datum')
        item = self.ActiveWidget.findChild(QCheckBox,'isScl90Complete')
        if dataBlock and self.checkComplete(dataBlock)[0]:
            
            item.setChecked(True)
        else:
            item.setChecked(False)
            
    def questionSaveChanges(self):
        
        if self.dataChanged:
            if not self.activePatient:
                #print 'activePatient None'
                pass
            if not self.patientenDict.get(self.activePatient):
                text = ''
            else:
                nachname = self.patientenDict[self.activePatient][0]
                vorname = self.patientenDict[self.activePatient][1]
                text = nachname + ', ' + vorname + ' '
            answer = QMessageBox.question(self, u'Änderungen Abspeichern?', 
                                                    u'Sollen die Änderungen am Patient ' + text + 'gespeichert werden?', 
                                                    'Ja', 'Nein', '', 0, -1)
            if answer == 0:
                if not self.saveFile():
                    return False
            self.dataChanged = False
        return True
            
    def showPatients(self):
        if not self.questionSaveChanges():
            return False
        if self.guiType == 2 or self.guiType == 4:
            if self.askDbPassword(forcepasswd = True) == False:
                return False
        if not self.readPatientenFile() == True:
            return False
        if self.guiType == 1 or self.guiType == 3 or self.guiType == 0:
            header = ['Patienten-Nummer', 'Nachname', 'Vorname']
            patienten = [(k, v[1], v[0]) for (k, v) in self.patientenDict.iteritems()]
        else:
            header = ['Patienten-Nummer']
            patienten = [(k,) for (k, v) in self.patientenDict.iteritems()]
        
        patientenListe = Listenauswahl(patienten, header, parent = self)
        index = patientenListe.exec_()
        
        if patientenListe.returnValue:
            patienten_nr = patientenListe.returnValue
        else:
            return
        
        self.closeActiveWidget()
        if self.activePatient and self.dataSource == 'sql':
            db_helperlib.releaseLock(behandler_nr=self.behandler_nr, patienten_nr=self.activePatient)
        self.dataDict = []
        self.activePatient = patienten_nr
        self.isNewPatient = False
        if self.dataSource == 'sql':

            self.loadFromDatabase(patienten_nr)
        else:
            self.loadDataFile(os.path.normcase(unicode(self.daten_pfad + u'/' + patienten_nr)))
        
        
    def closeEvent(self, event):
        if self.dataChanged:
            if self.activePatient and self.patientenDict.get(self.activePatient):
                answer = QMessageBox.question(self, u'Änderungen Abspeichern?', 
                                                        u'Sollen vor dem Beenden alle Änderungen am Patienten ' 
                                                        + self.patientenDict[self.activePatient][0] + ', ' 
                                                        + self.patientenDict[self.activePatient][1] 
                                                        + u' abgespeichert werden?', 
                                                        'Ja', 'Nein', '', 0, -1)
                if answer == 0:
                    self.saveFile()
        if self.activePatient and self.dataSource == 'sql' and self.connectedToDb == True:
            db_helperlib.releaseLock(behandler_nr=self.behandler_nr, patienten_nr=self.activePatient)        
        event.accept()
    
        
    def cancelChoice(self):
        if self.ActiveWidget and self.ActiveWidget.findChild(QPushButton,'cancelButton'):
            if not self.cancelInput():
                return
        if not self.questionSaveChanges():
            return False
        self.closeActiveWidget()
        if self.activePatient and self.dataSource == 'sql':
            if self.askDbPassword():
                db_helperlib.releaseLock(behandler_nr=self.behandler_nr, patienten_nr=self.activePatient)
        self.setWindowTitle('BaDo V4 Datenerfassung V%s' % version)
        
        
    def getDataBlock(self, format):
        for dataBlock in self.dataDict:
            if int(dataBlock['format']) == format:
                return dataBlock
        return None
        
    def updatePatientenDict(self):
        if not self.readPatientenFile():
            return False
        
        try:
            item = self.ActiveWidget.findChild(QLineEdit,'vorname')
        except:
            return False
        if not item:
            return False
        vorname = self.getLineInput(item)

        item = self.ActiveWidget.findChild(QLineEdit,'nachname')
        if not item:
            return False
        nachname = self.getLineInput(item)
        item = self.ActiveWidget.findChild(QLineEdit,'patienten_nr')
        patienten_nr = self.getLineInput(item)
        # Wenn das Feld Patienten-Nr leer ist, versuchen diesen aus dem aktuellen Data-Dict zu holen
        if not patienten_nr:
            if len(self.dataDict) > 0:
                dataBlock = self.dataDict[0]
                self.activePatient = dataBlock['patienten_nr']
                patienten_nr = self.activePatient
                self.setLineInput(item,self.activePatient)
            else:
                self.activePatient = None
                QMessageBox.information(self, u'Aktion abgebrochen', 
                        u'Patientennummer fehlt: Bitte geben Sie eine Patientennummer ein!', 
                        'Ok', '', '', 0, -1)
                return False

        if self.activePatient:
            numberChanged = not(patienten_nr == self.activePatient)
        else:
            numberChanged = False
        #print numberChanged, patienten_nr, self.activePatient
        moveDataFile = False
        if numberChanged == True:
            answer = QMessageBox.question(self, u'Patientennummer ändern', 
                                                u'Soll die Patientennummer von ' + self.activePatient + ' auf ' + patienten_nr + u' geändert werden?', 
                                                'Ja', 'Nein', '', 0, -1)
            if not answer == 0:
                self.setLineInput(item, self.activePatient)
                patienten_nr = self.activePatient
                numberChanged = False
                return
            else:
                moveDataFile = True
        #print self.isNewPatient,numberChanged
        if self.dataSource == 'sql':
            query = u"""SELECT count(*) FROM datensatz WHERE behandler_nr = %s and patienten_nr = '%s' """ % (self.behandler_nr, patienten_nr)
            nLines = db_helperlib.query_one(query)
    
            if nLines > 0 and (self.isNewPatient == True or numberChanged == True):
                answer = QMessageBox.question(self, u'Patientennummer bereits vergeben', 
                                                    u'Ein Datensatz mit dieser Patientennummer existiert bereits. Soll der bisherige Datensatz überschrieben werden?', 
                                                    'Ja', 'Nein', '', 0, -1)
                if not answer == 0:
                    self.setLineInput(item, self.activePatient)
                    patienten_nr = self.activePatient
                    numberChanged = False
                    return False
                elif answer == 0:
                    lock = db_helperlib.getLock(behandler_nr=self.behandler_nr, patienten_nr=patienten_nr)
                    if lock == False:
                        QMessageBox.critical(self, u'Speichern fehlgeschlagen', 
                                 u'Ein anderer Benutzer hat einen Patienten mit dieser Nummer geöffnet!', 
                                 'Ok', '', '', 0, -1)
                        self.setLineInput(item, self.activePatient)
                        patienten_nr = self.activePatient
                        numberChanged = False
                        return False
                    else:
                        oldId = db_helperlib.getDatensatzId(self.behandler_nr, patienten_nr)
                        #print 'Löschen bei überschreiben:', oldId
                        if oldId:
                            db_helperlib.deleteDatensatz(id = oldId)
                            db_helperlib.releaseLock(id = oldId)
        else:
            if self.patientenDict.has_key(patienten_nr) and (self.isNewPatient == True or numberChanged == True):
                answer = QMessageBox.question(self, u'Patientennummer bereits vergeben', 
                                                    u'Eine Datei mit dieser Patientennummer existiert bereits. Soll die bisherige Datei überschrieben werden?', 
                                                    'Ja', 'Nein', '', 0, -1)
                if not answer == 0:
                    self.setLineInput(item, self.activePatient)
                    patienten_nr = self.activePatient
                    numberChanged = False
                    return False
            
        if moveDataFile == True:
            if self.dataSource == 'sql':
                query = u"""UPDATE datensatz SET patienten_nr = '%s' WHERE behandler_nr = %s and patienten_nr = '%s' """ % (patienten_nr, self.behandler_nr, self.activePatient)
                db_helperlib.query_execute(query)
            else: 
                if os.path.isfile(os.path.normcase(unicode(self.daten_pfad + '/' + self.activePatient))):
                    try:
                        os.remove(os.path.normcase(unicode(self.daten_pfad + '/' + self.activePatient)))
                    except:
                        QMessageBox.critical(self, u'Umbenennen fehlgeschlagen', 
                                                u'Umbenennen der Patientennummer ' + self.activePatient
                                                + 'in ' + patienten_nr + u' ist fehlgeschlagen. Prüfen Sie bitte, ob die Datei ' + os.path.normcase(unicode(self.daten_pfad + '/' + self.activePatient)) + 'von einem anderen Programm verwendet wird.', 
                                                'Ok', '', '', 0, -1)
                        return False
                if self.activePatient and self.patientenDict.has_key(self.activePatient):
                    del self.patientenDict[self.activePatient]
            # geänderte Patienten-Nummer in das aktuelle dataDict reinschreiben
            if len(self.dataDict) > 0:  
                for x in range(len(self.dataDict)):
                    self.dataDict[x]['patienten_nr'] = patienten_nr
            #print self.dataDict
                 
        self.activePatient = patienten_nr
            
        if self.dataSource == 'sql':
            if not self.readPatientenFile():
                return False
                           
        self.patientenDict[self.activePatient] = (vorname, nachname)


        self.writePatientenFile()
        
        item = self.ActiveWidget.findChild(QLineEdit,'behandler_nr')
        self.behandler_nr = self.getLineInput(item)
        item = self.ActiveWidget.findChild(QLineEdit,'sub_behandler_nr')
        self.sub_behandler_nr = self.getLineInput(item)
        
        return [self.activePatient, vorname, nachname]
        
    def acceptChoice(self):
        item = self.ActiveWidget.findChild(QButtonGroup,'testAuswahl')
        #print item
        value = self.getRadio(item)
        # Wenn nichts ausgewählt ist, nichts machen
        if value:
            self.choice = int(value)
        else:
            QMessageBox.information(self, u'Kein Formular ausgewählt', 
                                        u'Bitte wählen Sie eines der Formulare zur Bearbeitung aus.', 
                                        'Ok', '', '', 0, -1)
            return
            
        patientData = self.updatePatientenDict()
        if not patientData:
            return
        patienten_nr, vorname, nachname = patientData
        
        item = self.ActiveWidget.findChild(QLineEdit,'behandler_nr')
        self.behandler_nr = self.getLineInput(item)
        item = self.ActiveWidget.findChild(QLineEdit,'sub_behandler_nr')
        self.sub_behandler_nr = self.getLineInput(item)
        if self.dataSource == 'sql':
            lock = db_helperlib.getLock(behandler_nr=self.behandler_nr, patienten_nr=patienten_nr)
            #print lock
            if lock == False:
                QMessageBox.critical(self, u'Speichern fehlgeschlagen', 
                                     u'Ein anderer Benutzer hat einen Patienten mit dieser Nummer geöffnet!', 
                                     'Ok', '', '', 0, -1)
                return False
        if patienten_nr:
            self.activePatient = patienten_nr
        self.isNewPatient = False
        self.setWindowTitle(u'BaDo V4 - Datenerfassung V' + version + u' - Patient: ' + vorname + ' ' + nachname + ' ' + patienten_nr)
        
        
        
        self.activeTestDatum = ''
            
        if self.choice == 1:
            self.closeActiveWidget()
            self.ActiveWidget = AufnahmeTherapeut(self)
        elif self.choice == 2:
            self.closeActiveWidget()
            self.ActiveWidget = AufnahmePatient(self)
        elif self.choice == 3:
            self.closeActiveWidget()
            self.ActiveWidget = EntlassungTherapeut(self)
        elif self.choice == 4:
            self.closeActiveWidget()
            self.ActiveWidget = EntlassungPatient(self)
        elif self.choice == 5:
            testList = self.ActiveWidget.findChild(QComboBox,'isrList')
            self.activeTestDatum = testList.currentText()
            self.closeActiveWidget()
            self.ActiveWidget = Isr(self)
        elif self.choice == 6:
            testList = self.ActiveWidget.findChild(QComboBox,'miniIcfList')
            self.activeTestDatum = testList.currentText()
            self.closeActiveWidget()
            self.ActiveWidget = MiniIcf(self)
        elif self.choice == 7:
            testList = self.ActiveWidget.findChild(QComboBox,'scl90List')
            self.activeTestDatum = testList.currentText()
            self.closeActiveWidget()
            self.ActiveWidget = Scl90(self)
        elif self.choice == 8:
            self.closeActiveWidget()
            self.ActiveWidget = KtlKrankenhaus(self)
        elif self.choice == 9:
            self.closeActiveWidget()
            self.ActiveWidget = KtlReha(self)
        else:
            self.closeActiveWidget()
            return
        
        item = self.ActiveWidget.findChild(QLineEdit,'behandler_nr')
        self.setLineInput(item, self.behandler_nr)
        #print 'behandlernummer: ',self.behandler_nr
        item = self.ActiveWidget.findChild(QLineEdit,'sub_behandler_nr')
        self.setLineInput(item, self.sub_behandler_nr)
        item = self.ActiveWidget.findChild(QLineEdit,'patienten_nr')
        self.setLineInput(item, patienten_nr)
        
        QObject.connect(self.ActiveWidget.ui.done, SIGNAL("clicked()"),self.inputDone)
        QObject.connect(self.ActiveWidget.ui.cancelButton, SIGNAL("clicked()"),self.cancelInput)
        self.ui.layout.addWidget(self.ActiveWidget)
        self.ActiveWidget.move(QPoint(10,32))
        self.ActiveWidget.show()
        self.dataChanged = True
        for dataBlock in self.dataDict:
            if int(dataBlock['format']) == int(self.choice):
                if dataBlock.has_key('isr_datum') and not dataBlock['isr_datum'] == self.activeTestDatum:
                    self.isTestNew = True
                    continue
                elif dataBlock.has_key('mini_icf_datum') and not dataBlock['mini_icf_datum'] == self.activeTestDatum:
                    self.isTestNew = True
                    continue
                elif dataBlock.has_key('scl90_datum') and not dataBlock['scl90_datum'] == self.activeTestDatum:
                    self.isTestNew = True
                    continue
                else:
                    self.isTestNew = False
                    #print dataBlock
                    self.updateGuiElements(dataBlock)
                    
    def deleteChoice(self):
        item = self.ActiveWidget.findChild(QButtonGroup,'testAuswahl')
        value = self.getRadio(item)
        if value:
            self.choice = int(value)
        else:
            return
            
        formularNames = ['Aufnahme Therapeut', 'Aufnahme Patient', 'Entlassung Therapeut', 'Entlassung Patient', 'ISR', 'Mini-ICF', 'SCL90', 'KTL-Krankenhaus','KTL-Reha']
        questionString = u'Sollen die Inhalte des markierten Formulars "' + formularNames[self.choice-1] + '" '
        if self.choice == 5:
            listItem = self.ActiveWidget.findChild(QComboBox,'isrList')
            questionString += 'mit Test-Datum ' + listItem.currentText()
        elif self.choice == 6:
            listItem = self.ActiveWidget.findChild(QComboBox,'miniIcfList')
            questionString += 'mit Test-Datum ' + listItem.currentText()
        elif self.choice == 7:
            listItem = self.ActiveWidget.findChild(QComboBox,'scl90List')
            questionString += 'mit Test-Datum ' + listItem.currentText()
            
        questionString += u'unwiederruflich gelöscht werden?'
            
        answer = QMessageBox.question(self, u'Löschen?', 
                                                    questionString, 
                                                    'Ja', 'Nein', '', 0, -1)
        if not answer == 0:
            return
        if self.choice in [1,2,3,4,8,9]:
            self.deleteDataBlockByFormat(self.choice)
        elif self.choice == 5:
            self.deleteIsrItem()
        elif self.choice == 6:
            self.deleteMiniIcfItem()
        elif self.choice == 7:
            self.deleteScl90Item()
        else:
            return
        self.showAuswahl()
            
    def deleteIsrItem(self):
        listItem = self.ActiveWidget.findChild(QComboBox,'isrList')
        self.deleteDataBlockByDate(5, 'isr_datum', listItem.currentText())
        self.deleteListItem(listItem)
    
    def deleteMiniIcfItem(self):
        listItem = self.ActiveWidget.findChild(QComboBox,'miniIcfList')
        self.deleteDataBlockByDate(6, 'mini_icf_datum', listItem.currentText())
        self.deleteListItem(listItem)
    
    def deleteScl90Item(self):
        listItem = self.ActiveWidget.findChild(QComboBox,'scl90List')
        self.deleteDataBlockByDate(7, 'scl90_datum', listItem.currentText())
        self.deleteListItem(listItem)
    
    def deleteListItem(self, listItem):
        index = listItem.currentIndex()
        if index > 0:
            listItem.removeItem(index)
        
    def deleteDataBlockByDate(self, format, datumKey, datum):
        for nDataBlock in range(len(self.dataDict)):
            if int(self.dataDict[nDataBlock]['format']) == int(format):
                if self.dataDict[nDataBlock][datumKey] == datum:
                    self.dataDict.pop(nDataBlock)
                    
                    self.dataChanged = True
                    return
    
    def deleteDataBlockByFormat(self, format):
        #print len(self.dataDict)
        for nDataBlock in range(len(self.dataDict)):
            #print 'Nummer',nDataBlock
            #print 'Format', self.dataDict[nDataBlock]['format']
            if int(self.dataDict[nDataBlock]['format']) == int(format):
                self.dataDict.pop(nDataBlock)
                
                self.dataChanged = True
                #print nDataBlock,'deleted'
                return
                    
    def getDataBlockByDate(self, listItem, format, datumKey):
        for nDataBlock in range(len(self.dataDict)):
            if int(self.dataDict[nDataBlock]['format']) == int(format):
                if self.dataDict[nDataBlock][datumKey] == listItem.currentText():
                    return self.dataDict[nDataBlock]
        
    def inputDone(self):
        dataBlock = self.getInputValues()
        complete, varList = self.checkComplete(dataBlock)
        
        if self.isTestNew and not self.checkIsDataBlockNew(dataBlock):
            answer = QMessageBox.question(self, u'Test überschreiben?', 
                                    u'Ein Test mit diesem Datum ist bereits vorhanden. Soll dieser überschrieben werden?', 
                                    'Ja', 'Nein', '', 0, -1)
            if not answer == 0:
                return False
                
        if not complete:
            varListText = u''
            for listItem in varList:
                if qualiconfV4.check.has_key(listItem):
                    varListText += qualiconfV4.check[listItem]['name'] + u'\x0A'
                else:
                    varListText += listItem + '\x0A'
            #varListText = unicode(varListText, 'utf8').encode('latin1')
            answer = QMessageBox.question(self, u'Eingabe unvollständig', 
                                                u'Das Formular ist noch nicht vollständig ausgefüllt. ' +
                                                u'Die Variablen\x0A\x0A' + varListText 
                                                + u'\x0Asind leer! \x0A Eingabe trotzdem beenden?', 
                                                'Ja', 'Nein', '', 0, -1)
            if not answer == 0:
                return
                
        self.updateDataDict(dataBlock)

        self.closeActiveWidget()
        #print dataBlock
        self.showAuswahl()
        return True
        
    def cancelInput(self):
        answer = QMessageBox.question(self, u'Eingabe abbrechen?', 
                                                u'Wollen Sie die Eingabe abbrechen und alle Änderungen verwerfen?', 
                                                'Ja', 'Nein', '', 0, -1)
        if not answer == 0:
            return
        self.dataChanged = False
        self.closeActiveWidget()
        self.showAuswahl()
        return True

        
    def checkIsDataBlockNew(self, dataBlock):
        for x in self.dataDict:
            if int(x['format']) == int(dataBlock['format']):
                if dataBlock.has_key('isr_datum') and x.has_key('isr_datum'):
                    if dataBlock['isr_datum'] == x['isr_datum'] or x['isr_datum'] == self.activeTestDatum:
                        return False
                    else:
                        continue
                elif dataBlock.has_key('mini_icf_datum') and x.has_key('mini_icf_datum'):
                    if dataBlock['mini_icf_datum'] == x['mini_icf_datum'] or x['mini_icf_datum'] == self.activeTestDatum:
                        return False
                    else:
                        continue
                elif dataBlock.has_key('scl90_datum') and x.has_key('scl90_datum'):
                    if dataBlock['scl90_datum'] == x['scl90_datum'] or x['scl90_datum'] == self.activeTestDatum:
                        return False
                    else:
                        continue
                else: 
                    return False
        return True
        
    def updateDataDict(self, dataBlock):
        newDict = []
        for x in self.dataDict:
            if int(x['format']) == int(dataBlock['format']):
                if dataBlock.has_key('isr_datum') and x.has_key('isr_datum') \
                                                  and not (dataBlock['isr_datum'] == x['isr_datum'] \
                                                           or x['isr_datum'] == self.activeTestDatum):
                    newDict.append(x)
                elif dataBlock.has_key('mini_icf_datum') and x.has_key('mini_icf_datum') \
                                                         and not (dataBlock['mini_icf_datum'] == x['mini_icf_datum'] \
                                                         or x['mini_icf_datum'] == self.activeTestDatum):
                    newDict.append(x)
                elif dataBlock.has_key('scl90_datum') and x.has_key('scl90_datum') \
                                                      and not (dataBlock['scl90_datum'] == x['scl90_datum']
                                                      or x['scl90_datum'] == self.activeTestDatum):
                                                     
                    newDict.append(x)
                else: 
                    pass
            else:
                newDict.append(x)
        newDict.append(dataBlock)
        self.dataDict = newDict

        self.dataChanged = True
            
    def loadFile(self):
        if not self.questionSaveChanges():
            return False
        fileName = self.getLoadFileName()
        if not fileName:
            return
        if not self.loadDataFile(fileName):
            return
        else:

            self.dataChanged = False
            
    def loadDataFile(self, fileName):
        self.closeActiveWidget()
        if self.activePatient and self.dataSource == 'sql':
            if self.askDbPassword():
                db_helperlib.releaseLock(behandler_nr=self.behandler_nr, patienten_nr=self.activePatient)
            else:
                return
        self.activePatient = None
        if os.path.isfile(unicode(fileName)):
            fileHandler = codecs.open(unicode(fileName),'r','utf8')
        else:
            return False
        try:
            fileData = fileHandler.readlines()
        except UnicodeDecodeError:
            QMessageBox.information(self, u'Laden Fehlgeschlagen', 
                                        u'UnicodeDecodeError: Die Datei ' + fileName + u' hat ein falsches Datenformat!'
                                        + u'\x0AEs können nur Dateien im UTF-8 Format geladen werden!', 
                                        'Ok', '', '', 0, -1)
            return False
        if len(fileData) == 0:
            QMessageBox.information(self, u'Laden Fehlgeschlagen', 
                                        u'In der Datei ' + fileName + u' wurden keine Daten gefunden!', 
                                        'Ok', '', '', 0, -1)
            return False
        elif len(fileData) > 1:
            QMessageBox.information(self, u'Laden Fehlgeschlagen', 
                                        u'Die Datei ' + fileName + u' hat ein falsches Datenformat!', 
                                        'Ok', '', '', 0, -1)
            return
        fileHandler.close()
        
        try:
            self.dataDict = self.convertToDataDict(fileData[0])
        except:
            QMessageBox.information(self, u'Laden Fehlgeschlagen', 
                                        u'Die Datei ' + fileName + u' hat ein falsches Datenformat!', 
                                        'Ok', '', '', 0, -1)
            return
            
        #print self.dataDict
        self.activePatient = self.dataDict[0]['patienten_nr']
        self.behandler_nr = self.dataDict[0]['behandler_nr']
        
        if not self.patientenDict.has_key(self.activePatient):
            # Wenn ein Datenfile geladen wird, das noch keinen Eintrag im patientenDict hat, jetzt diesen anlegen
            self.patientenDict[self.activePatient]=(QString(''),QString(''))
            self.isNewPatient = False
        
        if self.dataSource == 'sql':
            if self.guiType == 2 or self.guiType == 4:
                if self.askDbPassword(forcepasswd = True) == False:
                    self.dataDict ={}
                    self.activePatient = None
                    self.isNewPatient = False
                    return False
            query = u"""SELECT count(*) FROM datensatz WHERE behandler_nr = %s and patienten_nr = '%s' """ % (self.behandler_nr, self.activePatient)
            nLines = db_helperlib.query_one(query)
    
            if nLines > 0:
                answer = QMessageBox.question(self, u'Patientennummer bereits vergeben', 
                                                    u'Ein Datensatz mit dieser Patientennummer existiert bereits. Soll der bisherige Datensatz überschrieben werden?', 
                                                    'Ja', 'Nein', '', 0, -1)
                if not answer == 0:
                    self.dataDict ={}
                    self.activePatient = None
                    self.isNewPatient = False
                    return False
                elif answer == 0:
                    lock = db_helperlib.getLock(behandler_nr=self.behandler_nr, patienten_nr=self.activePatient)
                    if lock == False:
                        QMessageBox.critical(self, u'Speichern fehlgeschlagen', 
                                 u'Ein anderer Benutzer hat einen Patienten mit dieser Nummer geöffnet!', 
                                 'Ok', '', '', 0, -1)
                        self.dataDict ={}
                        self.activePatient = None
                        self.isNewPatient = False
                        return False
                    else:
                        oldId = db_helperlib.getDatensatzId(self.behandler_nr, self.activePatient)
                        #print 'Löschen bei überschreiben:', oldId
                        if oldId:
                            db_helperlib.deleteDatensatz(id = oldId)
                            db_helperlib.releaseLock(id = oldId)
                            
            if self.saveToDatabase(vorname=self.patientenDict[self.activePatient][0], nachname=self.patientenDict[self.activePatient][1]):
                
                QMessageBox.information(self, u'Speichern erfolgreich', 
                                            u'Daten des Patienten ' + self.patientenDict[self.activePatient][0] 
                                            + ', ' + self.patientenDict[self.activePatient][1] 
                                            + u'\x0Awurden erfolgreich in die Datenbank geschrieben.', 
                                            'Ok', '', '', 0, -1)
    
                self.dataChanged = False
                self.isNewPatient = False
            else:
                QMessageBox.critical(self, u'Speichern fehlgeschlagen', 
                                            u'Speichern des Patienten ' + self.patientenDict[self.activePatient][0] 
                                            + ', ' + self.patientenDict[self.activePatient][1] 
                                            + u'\x0A in die Datenbank ist fehlgeschlagen.', 
                                            'Ok', '', '', 0, -1)
                self.dataDict ={}
                self.activePatient = None
                self.isNewPatient = False
                return False
            

        self.showAuswahl()
        return True
        

    def initTestList(self, testList):
        testList.clear()
        testList.addItem('Neuer Test')
        
    def convertToDataDict(self, dataLine, validLine = None):
        dataList = dataLine.strip().split('|')
        #print 'dataList', dataList
        if validLine:
            #print 'validLine', validLine
            validList = validLine.strip().split('|')
        keyList = []
        dataDict = []
        nDataBlock = -1
        # Es sollten mind. 4  Elemente in der Liste stehen
        while len(dataList) > 4:
            nDataBlock = nDataBlock + 1
            dataValue = dataList.pop(0).strip()

            if validLine:
                validList.pop(0)
            if len(dataValue) == 0:
                nDataBlock = nDataBlock - 1
                continue
            #print [dataValue]
            dataFormat = int(dataValue)
            #print [dataFormat], type(dataFormat)

            
            dataDict.append({})
            dataDict[nDataBlock]['format'] = dataFormat
            #print dataFormat, len(dateiformat[dataFormat])
            for iData in range(len(dateiformat[dataFormat])):
                if type(dateiformat[dataFormat][iData]) == ListType:       
                    dataDict[nDataBlock][dateiformat[dataFormat][iData][0]] = []
                    #print 'ListData', dateiformat[dataFormat][iData]
                    for iListData in range(len(dateiformat[dataFormat][iData])):
                        dataDict[nDataBlock][dateiformat[dataFormat][iData][0]].append(QString(dataList.pop(0).strip()))
                        #print 'listdata ', dateiformat[dataFormat][iData][iListData], dataDict[nDataBlock][dateiformat[dataFormat][iData][0]]
                        if dateiformat[dataFormat][iData][iListData] in ['somatische_diagnose']:
                            dataitems = dataDict[nDataBlock][dateiformat[dataFormat][iData][0]][iListData]
                            if dataitems == QString(u''):
                                dataDict[nDataBlock][dateiformat[dataFormat][iData][0]][iListData] = QString('99999')
                        if validLine:
                            
                            validityitems = QString(validList.pop(0).strip()).split(',')
                            #print dateiformat[dataFormat][iData][iListData], dataDict[nDataBlock][dateiformat[dataFormat][iData][0]][iListData]
                            if dateiformat[dataFormat][iData][iListData] in ['psychische_diagnose_sicherheit', 'somatische_diagnose_sicherheit']:
                                dataitems = dataDict[nDataBlock][dateiformat[dataFormat][iData][0]][iListData].split(',')
                                erg = QString('')
                                #print [validityitems], len(validityitems)
                                for iValidityitem in range(len(validityitems)):
                                    dataitem = dataitems[iValidityitem].simplified()
                                    #print 'dataitem', iValidityitem ,[dataitem], dataitem == u''
                                    if dataitem == u'':
                                        if erg:
                                            erg += ',999'
                                        else:
                                            erg = QString('999')
                                        
                                    else:
                                        if erg:
                                            erg += ',' + dataitem
                                        else:
                                            erg = dataitem
                                #print 'erg', erg
                                dataDict[nDataBlock][dateiformat[dataFormat][iData][0]][iListData] = erg
                       
                else:
                    # Fix für falsches Datenformat: Bei Index 3 fehlt bis Version 1.1 das Item "Weiterbehandlung"
                    # Beim vorletzen Item checken, sonst gibts evtl Probleme mit leeren Variablen
                    #print iData, dataList[0], dataList[0]
                    if dataFormat == 3 and iData == 17:
                        # letzer Index des Datensatzes und es fehlt ein Feld
                        # sub-behandler-nr könnte ein string sein, daher behandler_nr auf int testen
                        # wenn fehlschlägt, dann fehlt weiterbehandlung auf jeden fall
                        #print 'check', [dataList[1]]

                        # Wenn Datensatz zu kurz, 999 einfügen
                        #if len(dataList) > 3:
                        #    print dataDict[nDataBlock]['patienten_nr'], dataList[2], dataList[4], dataList[5]
                            
                        if len(dataList) < 2:
                            dataList.insert(1,'999')
                        # patientennummer vom nächsten Index an der richtigen Stelle
                        elif len(dataList) == 2:
                            pass
                        elif len(dataList) > 5 and dataDict[nDataBlock]['patienten_nr'] ==  dataList[5].strip() and dataDict[nDataBlock]['behandler_nr'] ==  dataList[3].strip():
                            pass
                        # index 3 ist 1 Feld zu lang!
                        elif len(dataList) > 6 and dataDict[nDataBlock]['patienten_nr'] ==  dataList[6].strip() and dataDict[nDataBlock]['behandler_nr'] ==  dataList[4].strip():
                            pass
                        # leeres Feld passt
                        elif dataList[1].strip() == '':
                            #print 'Leeres Feld gefunden'
                            pass
                        # Mulitfeld mit komma-getrennt --> ok
                        elif dataList[1].strip().find(',') >= 0:
                            #print 'Multifeld gefunden'
                            pass
                        # Zahl größer max(Index) --> ok
                        elif int(dataList[1].strip()) > len(qualiconfV4.dateiformat):
                            #print 'Zahl größer als höchster Index'
                            pass
                        # wenn es scheint, dass der nächste Index stimmt --> ok
                        #elif len(dataList) > 2 and int(dataList[2]) <= len(qualiconfV4.dateiformat):
                            #print 'Index stimmt'
                        #    pass
                        # ansonsten 999 einfügen
                        else:
                            #print 'Insert 999'
                            dataList.insert(1,'999')
                        #print dataList
                        #print dataList[1],dataList[2],dataList[3],dataList[4]
                    
                    dataDict[nDataBlock][dateiformat[dataFormat][iData]] = QString(dataList.pop(0).strip())
                    #print 'dataDict', dataDict[nDataBlock][dateiformat[dataFormat][iData]]
                    if validLine:
                        #print dateiformat[dataFormat][iData],dataDict[nDataBlock][dateiformat[dataFormat][iData]], validList
                        dataitems = dataDict[nDataBlock][dateiformat[dataFormat][iData]].split(',')
                        validitytems = QString(validList.pop(0).strip()).split(',')
                        
                        erg = ''
                        for iValidityitem in range(len(validitytems)):
                            #print validitytems[iValidityitem]
                            validity = int(validitytems[iValidityitem].simplified())
                            dataitem = dataitems[iValidityitem].simplified()
                            itemconfig = check[dateiformat[dataFormat][iData]]
                            #print itemconfig
                            
                            if dataitem == u'' and itemconfig.has_key('fehler') and not validity == -10:
                                for key in itemconfig['fehler'].keys():
                                    #print key, itemconfig['fehler'][key]
                                    if itemconfig['fehler'][key] == validity:
                                        if erg:
                                            erg += ',' + unicode(key)
                                        else:
                                            erg = unicode(key)
                                        break
                                        #print dateiformat[dataFormat][iData], erg, validity
                            else:
                                if erg:
                                    erg += ',' + dataitem
                                else:
                                    erg = dataitem
                                    
                        dataDict[nDataBlock][dateiformat[dataFormat][iData]] = erg
        return dataDict
            
        
    
    def updateGuiElements(self, dataBlock):
        for key in dataBlock.keys():
            #print key
            item = None
            if not dataBlock[key]:
                continue
            for type in [QButtonGroup,QGridLayout,QVBoxLayout, QFormLayout, QHBoxLayout]:
                item = self.findChild(type,key)
                if item:
                    self.setRadio(item, dataBlock[key])
                    break
            if self.findChild(QLineEdit,key):
                #print key,dataBlock[key]
                item = self.findChild(QLineEdit,key)
                self.setLineInput(item, dataBlock[key])
            elif self.findChild(QDateEdit,key):
                item = self.findChild(QDateEdit,key)
                self.setDateInput(item, dataBlock[key])
            elif self.findChild(QTableView,key):
                item = self.findChild(QTableView,key)
                self.setTableData(item, dataBlock[key], key)
            else:
                continue
            
        
        
        
    def getInputValues(self):
        dataBlock ={}
        dataBlock['format'] = int(self.choice)
        for key in dateiformat[int(self.choice)]:
            if type(key) == ListType:
                key = key[0]
            itemValue = ''
            item = self.findChild(QObject,key)
            #if not item:
            #    item = self.findChild(QWidget, key)
            #print 'getInputValues find Object:', key, item
            if item:
                itemClass = item.metaObject().className()
                if itemClass == 'QLineEdit':
                    
                    itemValue = self.getLineInput(item)
                    #print key, itemValue
                elif itemClass == 'QDateEdit':
                    itemValue = self.getDateInput(item)
                elif itemClass == 'QTableView' or itemClass == 'QTableWidget':
                    itemValue = self.getTableData(item, key)
                elif itemClass in ['QButtonGroup','QGridLayout','QVBoxLayout', 'QFormLayout', 'QHBoxLayout']:
                    itemValue = self.getRadio(item)
            if not item or itemValue == None or itemValue == '':
                #print 'No itemValue set for ' + key
                itemValue = ''
            dataBlock[key] = itemValue
        return dataBlock
        

    
    def saveFile(self, fileName = None):
        #print self.dataSource, self.connectedToDb
        if self.ActiveWidget and self.ActiveWidget.findChild(QPushButton,'cancelButton'):
            if not self.inputDone():
                QMessageBox.information(self, u'Speichern abgebrochen', 
                            u'Speichern abgebrochen.', 
                            'Ok', '', '', 0, -1)
                return False
        if not self.updatePatientenDict():
            #print self.activePatient
            if not self.activePatient:
                return False
            else:
                QMessageBox.information(self, u'Speichern abgebrochen', 
                            u'Speichern abgebrochen.', 
                            'Ok', '', '', 0, -1)
                return False
        # alle header der Data-Blöcke aktualisieren
        if len(self.dataDict) > 0:  
            for x in range(len(self.dataDict)):
                self.dataDict[x]['behandler_nr'] = self.behandler_nr
                self.dataDict[x]['sub_behandler_nr'] = self.sub_behandler_nr
                self.dataDict[x]['patienten_nr'] = self.activePatient
                
        if self.dataSource == 'sql' and not fileName:
            #if self.isNewPatient == True:
            lock = db_helperlib.getLock(behandler_nr=self.behandler_nr, patienten_nr=self.activePatient)
            #print lock
            if lock == False:
                QMessageBox.critical(self, u'Speichern fehlgeschlagen', 
                                     u'Ein anderer Benutzer hat einen Patienten mit dieser Nummer geöffnet!', 
                                     'Ok', '', '', 0, -1)
                return False
            if self.saveToDatabase(vorname=self.patientenDict[self.activePatient][0], nachname=self.patientenDict[self.activePatient][1]):
                
                QMessageBox.information(self, u'Speichern erfolgreich', 
                                            u'Daten des Patienten ' + self.patientenDict[self.activePatient][0] 
                                            + ', ' + self.patientenDict[self.activePatient][1] 
                                            + u'\x0Awurden erfolgreich in die Datenbank geschrieben.', 
                                            'Ok', '', '', 0, -1)
    
                self.dataChanged = False
                self.isNewPatient = False
            else:
                QMessageBox.critical(self, u'Speichern fehlgeschlagen', 
                                            u'Speichern des Patienten ' + self.patientenDict[self.activePatient][0] 
                                            + ', ' + self.patientenDict[self.activePatient][1] 
                                            + u'\x0A in die Datenbank ist fehlgeschlagen.', 
                                            'Ok', '', '', 0, -1)
        else:
            if not os.path.isdir(unicode(self.daten_pfad)):
                os.mkdir(unicode(self.daten_pfad))

            if not fileName:
                fileName = os.path.normcase(unicode(self.daten_pfad + '/' + self.activePatient))
                
            if self.saveDataFile(fileName):
                
                QMessageBox.information(self, u'Speichern erfolgreich', 
                                            u'Daten des Patienten ' + self.patientenDict[self.activePatient][0] 
                                            + ', ' + self.patientenDict[self.activePatient][1] 
                                            + u'\x0Awurden erfolgreich in die Datei ' + fileName + ' abgespeichert.', 
                                            'Ok', '', '', 0, -1)
    
                self.dataChanged = False
                self.isNewPatient = False
            else:
                QMessageBox.critical(self, u'Speichern fehlgeschlagen', 
                                            u'Speichern des Patienten ' + self.patientenDict[self.activePatient][0] 
                                            + ', ' + self.patientenDict[self.activePatient][1] 
                                            + u'\x0A in die Datei ' + fileName + u' ist fehlgeschlagen. Prüfen Sie bitte, ob diese Datei von einem anderen Programm verwendet wird.', 
                                            'Ok', '', '', 0, -1)
        return True

    def saveAs(self):
        if not self.updatePatientenDict():
            if not self.activePatient:
                return
            else:
                QMessageBox.information(self, u'Speichern abgebrochen', 
                                            u'Speichern abgebrochen!', 
                                            'Ok', '', '', 0, -1)
                return
        fileName = self.getSaveFileName(defaultName = self.activePatient)
        #print fileName
        if fileName:
            if self.saveFile(fileName = fileName):
                self.isNewPatient = False
    
    def saveDataFile(self, fileName):
        dataString = ''
        # wenn datadict leer ist, leeren therapeuten-aufnahme-datensatz erzeugen
        if len(self.dataDict) == 0:
            self.createMinimalDataBlock()

        #print dataBlock
        for dataBlock in self.dataDict:
            dataString += self.dataBlock2dataString(dataBlock)
            dataString += '|'
        dataString = dataString[:-1]
        #print dataString
        #ry:
        fileHandler = codecs.open(unicode(fileName),'w','utf8')
        fileHandler.write(dataString)
        fileHandler.close()
        #except:
        #    return False
        return True
    
    def createMinimalDataBlock(self):
        if len(self.dataDict) == 0:
            dataBlock = {}
            dataBlock['format'] = QString('1')
            for iKey in range(len(dateiformat[1])):
                #print dateiformat[1][iKey]
                if dateiformat[1][iKey] == 'patienten_nr':
                    dataBlock[dateiformat[1][iKey]] = self.activePatient
                elif dateiformat[1][iKey] == 'behandler_nr':
                    dataBlock[dateiformat[1][iKey]] = self.behandler_nr
                elif dateiformat[1][iKey] == 'sub_behandler_nr':
                    dataBlock[dateiformat[1][iKey]] = self.sub_behandler_nr
                else:
                    if type(dateiformat[1][iKey]) == ListType:
                        dataBlock[dateiformat[1][iKey][0]] = []
                        for iListData in range(len(dateiformat[1][iKey])):
                            #print 'ListType', dateiformat[1][iKey][iListData]
                            dataBlock[dateiformat[1][iKey][0]].append(QString(''))
                    else:
                        dataBlock[dateiformat[1][iKey]] = QString('')
            self.dataDict.append(dataBlock)
        else:
            print "Warnung: dataDict war nicht leer!"
            
            
    def dataBlock2dataString(self, dataBlock):
        dataString = unicode(dataBlock['format'])
        slist = []
        for key in dateiformat[int(dataBlock['format'])]:
            #print key
            #print dataBlock
            if type(key) == ListType:
                slist.extend(['|%s' % (dataBlock[key[0]][iBlock]) for iBlock in range(len(key))])
            else:
                slist.append('|%s' % dataBlock[key])
        dataString += "".join(slist)
        #print dataString
        return dataString
       
                
    def getSaveFileName(self, defaultName = ''):
        dialog = QFileDialog()
        #if dirOnly:
        #    print 'dironly'
        #    dialog.setFileMode(QFileDialog.DirectoryOnly)
        #dialog.setAcceptMode(QFileDialog.AcceptSave)
        #fileName = dialog.exec_()
        fileName = dialog.getSaveFileName(self, 'Speichern', directory=defaultName)
        return fileName
    
    def getLoadFileName(self):
        #print self.daten_pfad
        #fileName = str(QFileDialog.getOpenFileName(self, 'Laden', self.daten_pfad).toAscii())
        fileName = QFileDialog.getOpenFileName(self, 'Laden', self.daten_pfad)
        return fileName
    
    def getLoadFileNames(self):
        fileNames = QFileDialog.getOpenFileNames(self, 'Mehrere Dateien Laden', self.daten_pfad)
        return fileNames
    
    def saveToDatabase(self, vorname=False, nachname=False, importMode = False):
        #print "savetest"
        #print self.dataDict
        if len(self.dataDict) == 0:
            self.createMinimalDataBlock()
        
        dbDict=self.dataDict2dbDict(self.dataDict)
        if vorname == False:
            vorname = self.patientenDict.get(self.activePatient)[0]
        if nachname == False:
            nachname = self.patientenDict.get(self.activePatient)[1]
        #print dbDict
        oldId = db_helperlib.getDatensatzId(self.behandler_nr, self.activePatient)
        #print 'oldid:', oldId
        if oldId:
            db_helperlib.deleteDatensatz(id = oldId)
            db_helperlib.releaseLock(id = oldId)
        db_helperlib.writeDictToDatabse(dbDict, 'badoV4', 2001, verbose=False, vorname = vorname, nachname = nachname, behandler_nr = self.behandler_nr)
        if importMode == False:
            newId = db_helperlib.getDatensatzId(self.behandler_nr, self.activePatient)
            db_helperlib.getLock(id = newId)
            if not self.readPatientenFile():
                return False
        return True
        
    def loadFromDatabase(self, patienten_nr):
  
        lock = db_helperlib.getLock(behandler_nr=self.behandler_nr, patienten_nr=patienten_nr)
        #print lock
        if lock == False:
            QMessageBox.critical(self, u'Laden fehlgeschlagen', 
                        u'Ein anderer Benutzer hat den Datensatz geöffnet!', 
                        'Ok', '', '', 0, -1)
            return
        dataList = db_helperlib.getdbDictFromDatabase(self.behandler_nr, patienten_nr)
        
        if dataList[0][0] == 'indexes':
            dataLine = dataList[0][1]
            validLine = dataList[1][1]
        else:
            dataLine = dataList[1][1]
            validLine = dataList[0][1]
        #print len(dataLine.split('|')), dataLine
        #print len(validLine.split('|')), validLine
        self.dataDict = self.convertToDataDict(dataLine, validLine = validLine)
        self.isNewPatient = False
        self.showAuswahl(patienten_nr)
        
    def askDbPassword(self, forcepasswd = False):
        if not self.dataSource == 'sql':
            print 'Keine SQL Verbindung eingestellt!'
            return False
        
        #print self.connectedToDb, self.guiType, forcepasswd
        if self.connectedToDb == True and forcepasswd == False:
            return True
        elif self.connectedToDb == True and forcepasswd == True:
            authDialog = AuthDialog(self)
            index = authDialog.exec_()
            #print 'return',authDialog.returnValue
            if authDialog.returnValue:
                auth = authDialog.returnValue
                if not db_helperlib.checkpasswd(dbname=self.dsn[2], user=auth[0], host=self.dsn[0], port=self.dsn[1], password=auth[1]):
                    QMessageBox.critical(self, u'Authentifizierung fehlgeschlagen', 
                                u"Der Benutzername und/oder das Passwort ist falsch!" % auth[0], 
                                'Ok', '', '', 0, -1)
                    return False
                else:
                    return True
            else:
                return False
        else:
        
            authDialog = AuthDialog(self)
            index = authDialog.exec_()
            #print 'return',authDialog.returnValue
            if authDialog.returnValue:
                auth = authDialog.returnValue
                if not db_helperlib.connectToDb(dbname=self.dsn[2], user=auth[0], host=self.dsn[0], port=self.dsn[1], password=auth[1]):
                    QMessageBox.critical(self, u'Authentifizierung fehlgeschlagen', 
                                u"Der Benutzername und/oder das Passwort ist falsch!" % auth[0], 
                                'Ok', '', '', 0, -1)
                    return False
                else:
                    self.connectedToDb = True
                    return True
            else:
                return False
               
    def dataDict2dbDict(self, dataDict):
        behandler_nr = dataDict[0]['behandler_nr']
        patient_nr = dataDict[0]['patienten_nr']
        dbDict = {}
        dbDict[behandler_nr] = {}
        dbDict[behandler_nr][patient_nr] = {}
        multi_index = {5:'isr',6:'mini_icf',7:'scl90'}
        
        for dataBlock in dataDict:
            newData = {}
            currentindex = int(dataBlock['format'])
            #print dataBlock
            for key in dataBlock.keys():
                if key == 'format':
                    continue
                newData[key] = {}
                newData[key]['orig'] = dataBlock[key]
                if key in ['psychische_diagnose','somatische_diagnose']:
                    spalten_config = qualiconfV4.check[key]
                    newData[key] = db_helperlib.rangecheck_element(value=dataBlock[key][0], config=qualiconfV4.check, spalten_config=spalten_config)
                    sicherkey = key + '_sicherheit'
                    spalten_config = qualiconfV4.check[sicherkey]
                    newData[sicherkey] = db_helperlib.rangecheck_element(value=dataBlock[key][1], config=qualiconfV4.check, spalten_config=spalten_config)

                #print currentindex
                else:
                    spalten_config = qualiconfV4.check[key]
                    newData[key] = db_helperlib.rangecheck_element(value=dataBlock[key], config=qualiconfV4.check, spalten_config=spalten_config)
                #print key, newData[key]
            if currentindex in multi_index.keys():
                if not dbDict[behandler_nr][patient_nr].has_key(multi_index[currentindex]):
                    dbDict[behandler_nr][patient_nr][multi_index[currentindex]] = []
                dbDict[behandler_nr][patient_nr][multi_index[currentindex]].append(newData)
            else: 
                dbDict[behandler_nr][patient_nr].update(newData)
        return dbDict
            
    def exportFile(self):
        if not self.dataSource == 'sql':
            QMessageBox.critical(self, u'Export fehlgeschlagen', 
                                u"Ohne Datenbankverbindung ist kein Export möglich!", 
                                'Ok', '', '', 0, -1)
            return False
        if not self.connectedToDb == True:
            if not self.askDbPassword():
                return
        self.saveAs()
    
    def exportDb(self):
        if not self.dataSource == 'sql':
            QMessageBox.critical(self, u'Export fehlgeschlagen', 
                    u"Ohne Datenbankverbindung ist kein Export möglich!", 
                    'Ok', '', '', 0, -1)
            return False
        if not self.readPatientenFile():
            return False
        fileName = self.getSaveFileName()
        dataString = u''
        
        #print self.patientenDict.keys()
        progress = QProgressDialog("Exportiere...", "Abbrechen", 0, 100); 
        progress.setWindowTitle('Datenbank-Export');
        progress.setMinimumDuration(0)
        progress.setWindowModality(Qt.WindowModal);
        progress.show()
        progress.setValue(10);
        dataList = db_helperlib.getDbExport()
        progress.setValue(20);
        iLine = 0.0
        nLine = len(dataList)
        #print nLine
        slist = []
        for dataLine in dataList:
            if progress.wasCanceled() == True:
                 return False
            progress.setValue(20+ iLine/nLine*80);
            #print 20+iLine/nLine*0.8
            #print dataLine[1], dataLine[2]
            #self.dataDict = self.convertToDataDict(dataLine[1], validLine = dataLine[2])
            slist.extend([sitem for sublist in [[self.dataBlock2dataString(dataBlock),'|'] for dataBlock in self.convertToDataDict(dataLine[1], validLine = dataLine[2])] for sitem in sublist])
            #for dataBlock in self.dataDict:
            #    dataString += self.dataBlock2dataString(dataBlock)
            #    dataString += '|'
            slist[-1] = '\n'
            #dataString = dataString[:-1] + '\n'
            iLine = iLine+1
        dataString = u"".join(slist)
        #print dataString
        
        #print fileName
        progress.setValue(100);
        progress.close();
        if fileName:
            try:
                fileHandler = codecs.open(unicode(fileName),'w','utf8')
                fileHandler.write(dataString)
                fileHandler.close()
                QMessageBox.information(self, u'Speichern erfolgreich', 
                                                u'Der Inhalt der Datenbank wurde erfolgreich in die Datei ' + fileName + u' abgespeichert.', 
                                                'Ok', '', '', 0, -1)
    
            except:
                    QMessageBox.critical(self, u'Speichern fehlgeschlagen', 
                                                u'Der Inhalt der Datenbank konnte nicht in die Datei ' + fileName + u' gespeichert werden, bitte prüfen Sie die Zugriffsberechtigungen.', 
                                                'Ok', '', '', 0, -1)
                
        
            
    def exportJahrgang(self):
        if not self.dataSource == 'sql':
            QMessageBox.critical(self, u'Export fehlgeschlagen', 
                    u"Ohne Datenbankverbindung ist kein Export möglich!", 
                    'Ok', '', '', 0, -1)
            return False
        if not self.readPatientenFile() == True:
            return False
        jahrgangAuswahl = JahrgangAuswahl(self)
        index = jahrgangAuswahl.exec_()
        #print 'return',einstellungen.returnValue
        if jahrgangAuswahl.returnValue:
            jahrgang = jahrgangAuswahl.returnValue
        else:
            return False
        fileName = self.getSaveFileName()
        dataString = ''
        progress = QProgressDialog("Exportiere...", "Abbrechen", 0, 100); 
        progress.setWindowTitle('Jahrgangs-Export');
        progress.setMinimumDuration(0)
        progress.setWindowModality(Qt.WindowModal);
        progress.show()
        progress.setValue(10);
        dataList = db_helperlib.getJahrgangsExport(self.behandler_nr, jahrgang)

        
        progress.setValue(80);
        iLine = 0.0
        nLine = len(dataList)
        slist = []
        for dataLine in dataList:
            if progress.wasCanceled() == True:
                 return False
            progress.setValue(80+ iLine/nLine*20);

            slist.extend([sitem for sublist in [[self.dataBlock2dataString(dataBlock),'|'] for dataBlock in self.convertToDataDict(dataLine[1], validLine = dataLine[2])] for sitem in sublist])
            slist[-1] = '\n'

            iLine = iLine+1
        dataString = u"".join(slist)

        progress.setValue(100);
        progress.close();
        #print dataString
        
        #print fileName
        if fileName:
            try:
                fileHandler = codecs.open(unicode(fileName),'w','utf8')
                fileHandler.write(dataString)
                fileHandler.close()
                QMessageBox.information(self, u'Speichern erfolgreich', 
                                                u'Alle Daten des Jahrgangs ' + jahrgang + u' wurden erfolgreich in die Datei ' + fileName + u' abgespeichert.', 
                                                'Ok', '', '', 0, -1)
    
            except:
                    QMessageBox.critical(self, u'Speichern fehlgeschlagen', 
                                                u'Der Inhalt der Datenbank konnte nicht in die Datei ' + fileName + u' gespeichert werden, bitte prüfen Sie die Zugriffsberechtigungen.', 
                                                'Ok', '', '', 0, -1)
    
    def importFile(self):
        if not self.dataSource == 'sql':
            QMessageBox.critical(self, u'Import fehlgeschlagen', 
                    u"Ohne Datenbankverbindung ist kein Import möglich!", 
                    'Ok', '', '', 0, -1)
            return False
        if not self.readPatientenFile():
            return False

        if not self.questionSaveChanges():
            return False
        self.closeActiveWidget()
        if self.activePatient:
            db_helperlib.releaseLock(behandler_nr=self.behandler_nr, patienten_nr=self.activePatient)
        self.dataDict ={} 
        self.activePatient = None
        self.dataChanged = False
        
        fileNames = self.getLoadFileNames()
        if not fileNames:
            return False
        #print fileNames
        successList = []
        failList = []
        overwriteAll = False
        for fileName in fileNames:
            #print fileName
            if os.path.isfile(unicode(fileName)):
                fileHandler = codecs.open(unicode(fileName),'r','utf8')
            else:
                continue
            try:
                fileData = fileHandler.readlines()
            except UnicodeDecodeError:
                QMessageBox.information(self, u'Laden Fehlgeschlagen', 
                                            u'UnicodeDecodeError: Die Datei ' + fileName + u' hat ein falsches Zeichenformat!'
                                            + u'\x0AEs können nur Dateien im UTF-8 Format geladen werden!', 
                                            'Ok', '', '', 0, -1)
                failList.append(fileName)
                continue
            if len(fileData) == 0:
                QMessageBox.information(self, u'Laden Fehlgeschlagen', 
                                            u'In der Datei ' + fileName + u' wurden keine Daten gefunden!', 
                                            'Ok', '', '', 0, -1)
                failList.append(fileName)
                continue

            fileHandler.close()
            iLine = 0
            fileDict = {}
            # zeile für zeile durch das file gehen und alle indexes mit derselben pat-nr aneinanderhängen

            for line in fileData:
                #print line
                linedata = db_helperlib.strip_control_characters(line.strip()).split('|')
                #print linedata

                if len(linedata) < 5:
                    continue
                patnr = linedata[1].strip()
                behnr = linedata[3].strip()
                if not fileDict.has_key(patnr):
                    #print linedata[1]
                    fileDict[patnr] = {}
                if not fileDict[patnr].has_key(behnr):
                    #print linedata[3]
                    fileDict[patnr][behnr] = u''
                else:
                    fileDict[patnr][behnr] += u'|'
                fileDict[patnr][behnr] += line.strip()

            fileDataNew = []
            for behandlerkey in fileDict.keys():
                for patientenkey in fileDict[behandlerkey].keys():
                    fileDataNew.append(fileDict[behandlerkey][patientenkey].strip())
            
            #print 'fileDataNew', len(fileDataNew), fileDataNew
            # dann wieder datastring erzeugen und durch die folgenden zeilen schicken

            progress = QProgressDialog("Importiere...", "Abbrechen", 0, len(fileDataNew));
            progress.setWindowTitle('Datei-Import');
            progress.setWindowModality(Qt.WindowModal);
        

            for line in fileDataNew:
                if progress.wasCanceled() == True:
                     break
                progress.setValue(iLine);
                try:
                #print line

                    self.dataDict = self.convertToDataDict(line)

                except:
                    QMessageBox.information(self, u'Laden Fehlgeschlagen', 
                                                u'Die Zeile ' + str(iLine) + u' in Datei ' + fileName + u' hat ein falsches Zeichenformat!', 
                                                'Ok', '', '', 0, -1)
                    #print [line]
                    failList.append(fileName)
                    continue
                    
                #print self.dataDict
                patienten_nr = self.dataDict[0]['patienten_nr']
                self.activePatient = patienten_nr
                self.behandler_nr = self.dataDict[0]['behandler_nr']
                self.sub_behandler_nr = self.dataDict[0]['sub_behandler_nr']
                if not self.patientenDict.has_key(patienten_nr):
                    # Wenn ein Datenfile geladen wird, das noch keinen Eintrag im patientenDict hat, jetzt diesen anlegen
                    self.patientenDict[patienten_nr]=(QString(''),QString(''))
                elif self.patientenDict.has_key(patienten_nr) and overwriteAll == False:
                    answer = QMessageBox.question(self, u'Datensatz überschreiben?', 
                        u'Ein Datensatz mit der Patientennummer ' + patienten_nr +  u' ist bereits vorhanden.\x0ASoll dieser und alle weiteren überschrieben werden?', 
                        'Ja, Alle', u'Überspringen', '', 0, -1)
                    if not answer == 0: 
                        failList.append(fileName)
                        continue
                    overwriteAll = True
                # alle header der Data-Blöcke aktualisieren
                if len(self.dataDict) > 0:  
                    dataBlock = self.dataDict[0]
                    for x in self.dataDict:
                        x['behandler_nr'] = self.behandler_nr
                        x['sub_behandler_nr'] = self.sub_behandler_nr
                        x['patienten_nr'] = patienten_nr
                        
                
                #print patienten_nr
                
                lock = db_helperlib.getLock(behandler_nr=self.behandler_nr, patienten_nr=patienten_nr)
                #print 'lock:',lock
                if lock == False:
                    QMessageBox.question(self, u'Import fehlgeschlagen', 
                                         u'Ein anderer Benutzer hat einen Patienten mit der Nummer ' + patienten_nr + u'geöffnet!'
                                         + u'\x0ADatensatz überspringen oder gesamten Import abbrechen?', 
                                          u'Überspringen', u'Abbrechen', '', 0, -1)
                    failList.append(fileName)
                    if not answer == 0:
                        self.activePatient = None
                        self.dataDict ={} 
                        return False
                    else:
                        continue
                #print 'save start'
                if self.saveToDatabase(vorname=self.patientenDict[patienten_nr][0], nachname=self.patientenDict[patienten_nr][1], importMode = True):
                    #print 'save end'
                    #QMessageBox.information(self, u'Speichern erfolgreich', 
                    #                            u'Die Daten des Patienten mit der Nummer ' + patienten_nr
                    #                            + u'\x0Awurden erfolgreich in die Datenbank geschrieben.', 
                    #                            'Ok', '', '', 0, -1)
        
                    successList.append(fileName)
                else:
                    #QMessageBox.critical(self, u'Speichern fehlgeschlagen', 
                    #                            u'Speichern des Patienten mit der Nummer ' + patienten_nr
                    #                            + u'\x0A in die Datenbank ist fehlgeschlagen.', 
                    #                            'Ok', '', '', 0, -1)
                    failList.append(fileName)
                #db_helperlib.releaseLock(behandler_nr=self.behandler_nr, patienten_nr=patienten_nr)
                iLine = iLine + 1
        #print 'fail:', failList
        #print 'success:', successList
        if self.readPatientenFile():
            return False
        self.activePatient = None                     
        self.dataDict ={} 
        return True
        
         

    def getDateInput(self, item):
        return item.date().toString('dd.MM.yyyy')

    def setDateInput(self, item, value):
        item.setDate(QDate.fromString(value, 'dd.MM.yyyy'))
            
    def getLineInput(self, item):
        return item.displayText()
        
    def setLineInput(self, item, value):
        if value == None:
            value = ''
        item.setText(value)
        
    def getTableData(self, item, key):
        nRows = item.model().rowCount()
        nColumns = item.model().columnCount()
        valueArray = [QString('') for i in range(nColumns)]
        itemData = QString('')
        currentRow = 0
        for iRow in range(nRows):
            currentValueArray = valueArray
            for iColumn in range(nColumns):
                cellItem = item.model().item(currentRow, iColumn)
                #print currentRow
                if not cellItem or not cellItem.text():
                    #item.model().removeRows(currentRow,1)
                    currentValueArray = valueArray
                    break
                #print cellItem.text().toAscii()
                currentValueArray[iColumn] += cellItem.text().trimmed() + ','
            if currentValueArray:
                valueArray = currentValueArray
            currentRow = currentRow + 1
        
        #print key, valueArray
        if key == 'psychische_diagnose' or key == 'somatische_diagnose':
            itemData = [x[:-1] for x in valueArray[1:]]
            #itemData = string.join([x[:-1] for x in valueArray[1:]],'|')
        else:
            itemData = [x[:-1] for x in valueArray]
            #itemData = string.join([x[:-1] for x in valueArray],'|')
        #print itemData
        
        return itemData
        
        
    def setTableData(self, item, dataString, key):
        nCurrentRows = item.model().rowCount()
        item.model().removeRows(0,nCurrentRows)
        nCurrentRows = item.model().rowCount()
        #print key,dataString
        if type(dataString) == ListType:
            store = []
            for iDataList in dataString:
                store.append(iDataList.split(','))
            #print store
            #print len(store[0]), len(store[1])
            while len(store[1]) < len(store[0]):
                store[1].append(u'')
            dataArray = [[x[iData].trimmed() for x in store] for iData in range(len(store[0]))]
            #print 'dataArray',dataArray
        else:
            dataArray = dataString.split(',')
                
        for data in dataArray:
            if key == 'psychische_diagnose':
                #print 'data',data
                self.ActiveWidget.addPsychischeDiagnose(data[0], data[1])
            elif key == 'somatische_diagnose':
                self.ActiveWidget.addSomatischeDiagnose(data[0], data[1])
            else:
                print 'not yet implemented!'
                #item.model().insertRow(nCurrentRows)
                #item.model().setData(item.model().index(nCurrentRows, 0), QVariant(str(data)))

        
    def getRadio(self, item):
        dataString = ''
        for button in item.buttons():
            if button.isChecked():
                #print button.objectName()
                dataString += button.objectName().split('_')[-1]
                dataString += ','
        dataString = dataString[:-1]
        #print 'getRadioData:', dataString
        return dataString
    
    def setRadio(self, item, dataString):
        for data in dataString.split(','):
            value = int(data)
            for button in item.buttons():
                if int(button.objectName().split('_')[-1]) == value:
                    button.setChecked(True)
                    
        
    def getConfigList(self):
        if os.path.isfile('config.txt'):
            configFile = codecs.open('config.txt','r','utf8')
            configList = []
            if configFile:
                for line in configFile:
                    configList.append(line.strip())
            return configList
        else:
            configList = ['',
                        '9999999999',
                        'C:\Dokumente und Einstellungen\XPMUser\workspace\bado-gui\trunk\src\Patientenliste\Patientenliste.txt',
                        'C:\Dokumente und Einstellungen\XPMUser\workspace\bado-gui\trunk\src\Patientendaten',
                        'filesystem',
                        'localhost',
                        '5432',
                        'badoV4']
            
    def setPreferences(self, init = False):
        if not self.questionSaveChanges():
            return False
        self.closeActiveWidget()
        if self.activePatient and self.dataSource == 'sql':
            if self.askDbPassword():
                db_helperlib.releaseLock(behandler_nr=self.behandler_nr, patienten_nr=self.activePatient)
        if init == False:
            self.writePatientenFile()
        configList = self.getConfigList()
        #print 'configList',configList
        einstellungen = Einstellungen(configList, self)
        index = einstellungen.exec_()
        #print 'return',einstellungen.returnValue
        if einstellungen.returnValue:
            self.behandler_nr = einstellungen.returnValue[0]
            self.sub_behandler_nr = einstellungen.returnValue[1]
            self.patientendatei_pfad = os.path.abspath(unicode(einstellungen.returnValue[2]))
            self.daten_pfad = os.path.abspath(unicode(einstellungen.returnValue[3]))
            self.dataSource = einstellungen.returnValue[4]
            self.dsn = [einstellungen.returnValue[5], einstellungen.returnValue[6], einstellungen.returnValue[7]]
            configFile = codecs.open('config.txt','w','utf8')
            output = ''
            for line in einstellungen.returnValue:
                output += line + '\r\n'
            output = output[:-2]
            #print output
            configFile.writelines(unicode(output))
            configFile.close()
            if self.connectedToDb == True and self.dataSource == 'sql':
                db_helperlib.disconnectFromDb()
                self.connectedToDb = False
                #print 'ask', self.connectedToDb
                self.askDbPassword()
                #print 'ask', self.connectedToDb
            elif self.connectedToDb == True and not self.dataSource == 'sql':
                db_helperlib.disconnectFromDb()
                self.connectedToDb = False
            elif self.connectedToDb == False and self.dataSource == 'sql':
                self.askDbPassword()
        #print self.connectedToDb
        return True

        
class Einstellungen(QDialog):
    def __init__(self, configList, parent = None):
        QDialog.__init__(self, parent)
        self.configList = configList
        self.setParent(parent)
        self.ui = Ui_einstellungen()
        self.ui.setupUi(self)
        self.returnValue = ''
        self.setAttribute(Qt.WA_DeleteOnClose)
        #print configList

        item = self.findChild(QLineEdit,'behandler_nr')
        if self.configList and self.configList[0]:
            item.setText(self.configList[0])
            
        item = self.findChild(QLineEdit,'sub_behandler_nr')
        if self.configList and len(self.configList)>1 and self.configList[1]:
            item.setText(self.configList[1])
        else:
            item.setText('9999999999')
            
        item = self.findChild(QLineEdit,'patientendatei_pfad')
        if self.configList and len(self.configList)>2 and self.configList[2]:
            item.setText(os.path.abspath(unicode(self.configList[2])))
        else:
            item.setText(os.path.abspath(os.path.normcase(unicode('Patientenliste/Patientenliste.txt'))))
            self.patientendatei_pfad = os.path.abspath(os.path.normcase(unicode('Patientenliste/Patientenliste.txt')))
            
        item = self.findChild(QLineEdit,'daten_pfad')
        if self.configList and len(self.configList)>3 and self.configList[3]:
            self.daten_pfad = self.configList[3]
            item.setText(os.path.abspath(unicode(self.configList[3])))
        else:
            item.setText(os.path.abspath('Patientendaten'))
            self.daten_pfad = os.path.abspath('Patientendaten')
            
        buttonfile = self.findChild(QRadioButton,'filesystem')
        buttonsql = self.findChild(QRadioButton,'sql')
        if self.configList and len(self.configList)>4 and self.configList[4]:
            if self.configList[4] == 'filesystem':
                buttonfile.setChecked(True)
            elif self.configList[4] == 'sql':
                buttonsql.setChecked(True)
        else:
            buttonsql.setChecked(True)
            
        item = self.findChild(QLineEdit,'dbhostname')
        if self.configList and len(self.configList)>5 and self.configList[5]:
            item.setText(self.configList[5])
        else:
            item.setText('localhost')
        item = self.findChild(QLineEdit,'dbport')
        if self.configList and len(self.configList)>6 and self.configList[6]:
            item.setText(self.configList[6])
        else:
            item.setText('5432')
        item = self.findChild(QLineEdit,'dbname')
        if self.configList and len(self.configList)>7 and self.configList[7]:
            item.setText(self.configList[7])
        else:
            item.setText('badoV4')
    
    def closeNow(self):
        self.setParent(None)
        self.close()
        
    def reject(self):
        self.updateItemValues()
        failFlag_0 = (not self.configList or not self.configList[0]) and not self.returnValue[0]
        failFlag_1 = (not self.configList or not self.configList[1]) and not self.returnValue[1]
        failFlag_2 = (not self.configList or not self.configList[2]) and not self.returnValue[2]
        failFlag_3 = (not self.configList or not self.configList[3]) and not self.returnValue[3]
        failFlag_4 = (not self.configList or not self.configList[4]) and not self.returnValue[4]
        failFlag_5 = (not self.configList or not self.configList[5]) and not self.returnValue[5]
        failFlag_6 = (not self.configList or not self.configList[6]) and not self.returnValue[6]
        failFlag_7 = (not self.configList or not self.configList[7]) and not self.returnValue[7]
        #print failFlag_0, failFlag_1, failFlag_2, failFlag_3
        if failFlag_0 or failFlag_1 or failFlag_2 or failFlag_3 or failFlag_4 or failFlag_5 or failFlag_6 or failFlag_7:
            QMessageBox.information(self, u'Eingabe unvollständig', 
                        u'Bitte füllen Sie alle Felder aus!', 
                        'Ok', '', '', 0, -1)
            return
        self.returnValue = ''
        self.closeNow()
        
    def accept(self):
        self.updateItemValues()
        if not self.returnValue[0] or not self.returnValue[1] or not self.returnValue[2] or not self.returnValue[3] or not self.returnValue[4] or not self.returnValue[5] or not self.returnValue[6] or not self.returnValue[7]:
            QMessageBox.information(self, u'Eingabe unvollständig', 
                        u'Bitte füllen Sie alle Felder aus!', 
                        'Ok', '', '', 0, -1)
            return
        #print self.returnValue
        self.closeNow()
        
    def updateItemValues(self):
        item = self.findChild(QLineEdit,'behandler_nr')
        behandler_nr = item.displayText()
        
        item = self.findChild(QLineEdit,'sub_behandler_nr')
        sub_behandler_nr = item.displayText()
        item = self.findChild(QLineEdit,'patientendatei_pfad')
        patientendatei_pfad = item.displayText()
        item = self.findChild(QLineEdit,'daten_pfad')
        daten_pfad = item.displayText()
        
        sourceGroup = self.findChild(QButtonGroup,'dataSource')
        checkedButton = sourceGroup.button(sourceGroup.checkedId())
        if checkedButton.objectName() == 'sql':
            datasource = 'sql'
        else:
            datasource = 'filesystem'
                 
        item = self.findChild(QLineEdit,'dbhostname')
        dbhostname = item.displayText()
        item = self.findChild(QLineEdit,'dbport')
        dbport = item.displayText()
        item = self.findChild(QLineEdit,'dbname')
        dbname = item.displayText()
        self.returnValue = [behandler_nr, sub_behandler_nr, patientendatei_pfad, daten_pfad, datasource, dbhostname, dbport, dbname]
        #print self.returnValue
        
    def browseList(self):
        item = self.findChild(QLineEdit,'patientendatei_pfad')
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.AnyFile)
        dialog.setLabelText(QFileDialog.Accept, 'Auswählen')
        dialog.setLabelText(QFileDialog.Reject, 'Abbrechen')
        dialog.setLabelText(QFileDialog.LookIn, 'Verzeichnis')
        dialog.setLabelText(QFileDialog.FileName, 'Dateiname')
        dialog.setLabelText(QFileDialog.FileType, 'Dateityp')
        dialog.setWindowTitle(u'Datei für Patientenliste Auswählen')
        dialog.setConfirmOverwrite(False)
        if (dialog.exec_()):
            fileName = dialog.selectedFiles()
            item.setText(os.path.normpath(unicode(fileName[0])))
            
     
    def browseData(self):
        item = self.findChild(QLineEdit,'daten_pfad')
        #fileName = QFileDialog.getExistingDirectory(self, 'Verzeichnis Auswählen', self.daten_pfad, QFileDialog.ShowDirsOnly | QFileDialog.DontResolveSymlinks | QFileDialog.DontUseNativeDialog).toAscii()
        fileName = QFileDialog.getExistingDirectory(self, 'Verzeichnis Auswählen', self.daten_pfad, QFileDialog.ShowDirsOnly | QFileDialog.DontResolveSymlinks | QFileDialog.DontUseNativeDialog)
        if fileName:
            fileName
            item.setText(os.path.normpath(unicode(fileName)))
            
class JahrgangAuswahl(QDialog):
    def __init__(self, parent = None):
        QDialog.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_jahrgang()
        self.ui.setupUi(self)
        self.returnValue = ''
        self.setAttribute(Qt.WA_DeleteOnClose)

        self.ui.jahrgang_date.setDate(QDate.currentDate())
 
    
    def closeNow(self):
        self.setParent(None)
        self.close()
        
    def reject(self):
        self.returnValue = ''
        self.closeNow()
        
    def accept(self):
        self.returnValue = self.ui.jahrgang_date.date().toString('yyyy')
        if not self.returnValue:
            QMessageBox.information(self, u'Eingabe unvollständig', 
                        u'Bitte geben Sie einen Jahrgang zum Export ein!', 
                        'Ok', '', '', 0, -1)
            return
        #print self.returnValue
        self.closeNow()
        
class AuthDialog(QDialog):
    def __init__(self, parent = None):
        QDialog.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_auth()
        self.ui.setupUi(self)
        self.returnValue = []
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.ui.username.setFocus()
 
    def closeEvent(self, event):
        event.accept()
    
    def closeNow(self):
        self.setParent(None)
        self.close()
        
    def reject(self):
        self.returnValue = []
        self.closeNow()
        
    def accept(self):
        self.returnValue =[]
        self.returnValue.append(self.ui.username.text().toUtf8())
        #print hashlib.md5('test').hexdigest()
        #print self.ui.password.text()
        #print hashlib.md5(self.ui.password.text().toUtf8()).hexdigest()
        self.returnValue.append(self.ui.password.text().toUtf8())
        #print self.returnValue
        if len(self.returnValue[0]) == 0:
            QMessageBox.information(self, u'Eingabe unvollständig', 
                        u'Bitte geben Sie einen Benutzernamen ein!', 
                        'Ok', '', '', 0, -1)
            return
        #print self.returnValue
        self.closeNow()
 

        
class AuswahlTest(QWidget):
    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_auswahlTest()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)
        rx = QRegExp("[\w\d+\-#\!]*")
        self.ui.patienten_nr.setValidator(QRegExpValidator(rx, self.ui.patienten_nr))
        rx = QRegExp("\w*")
        self.ui.vorname.setValidator(QRegExpValidator(rx, self.ui.vorname))
        self.ui.nachname.setValidator(QRegExpValidator(rx, self.ui.nachname))
    
    def closeNow(self):
        self.setParent(None)
        self.close()

    def acceptChoice(self):
        pass

    def cancelChoice(self):
        pass
        
    def deleteIsrItem(self):
        pass
    
    def deleteMiniIcfItem(self):
        pass
    
    def deleteScl90Item(self):
        pass
            
class AuswahlTherapeut(QWidget):
    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_auswahlTherapeut()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)
        rx = QRegExp("[\w\d+\-#\!]*")
        self.ui.patienten_nr.setValidator(QRegExpValidator(rx, self.ui.patienten_nr))
        self.ui.sub_behandler_nr.setValidator(QRegExpValidator(rx, self.ui.sub_behandler_nr))
        rx = QRegExp("\w*")
        self.ui.vorname.setValidator(QRegExpValidator(rx, self.ui.vorname))
        self.ui.nachname.setValidator(QRegExpValidator(rx, self.ui.nachname))
    
    def closeNow(self):
        self.setParent(None)
        self.close()

    def acceptChoice(self):
        pass

    def cancelChoice(self):
        pass
        
    def deleteIsrItem(self):
        pass
    
    def deleteMiniIcfItem(self):
        pass
    
    def deleteScl90Item(self):
        pass
    
class AuswahlIsrTherapeut(QWidget):
    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_auswahlIsrTherapeut()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)
        rx = QRegExp("[\w\d+\-#\!]*")
        self.ui.patienten_nr.setValidator(QRegExpValidator(rx, self.ui.patienten_nr))
        self.ui.sub_behandler_nr.setValidator(QRegExpValidator(rx, self.ui.sub_behandler_nr))
        rx = QRegExp("\w*")
        self.ui.vorname.setValidator(QRegExpValidator(rx, self.ui.vorname))
        self.ui.nachname.setValidator(QRegExpValidator(rx, self.ui.nachname))
    
    def closeNow(self):
        self.setParent(None)
        self.close()

    def acceptChoice(self):
        pass

    def cancelChoice(self):
        pass
        
    def deleteIsrItem(self):
        pass
    
    def deleteMiniIcfItem(self):
        pass
    
    def deleteScl90Item(self):
        pass
    
        
class AuswahlPatient(QWidget):
    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_auswahlPatient()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)
        rx = QRegExp("[\w\d+\-#\!]*")
        self.ui.patienten_nr.setValidator(QRegExpValidator(rx, self.ui.patienten_nr))
        self.ui.sub_behandler_nr.setValidator(QRegExpValidator(rx, self.ui.sub_behandler_nr))
        rx = QRegExp("\w*")
        self.ui.vorname.setValidator(QRegExpValidator(rx, self.ui.vorname))
        self.ui.nachname.setValidator(QRegExpValidator(rx, self.ui.nachname))
    
    def closeNow(self):
        self.setParent(None)
        self.close()

    def acceptChoice(self):
        pass

    def cancelChoice(self):
        pass
        
    def deleteIsrItem(self):
        pass
    
    def deleteMiniIcfItem(self):
        pass
    
    def deleteScl90Item(self):
        pass

class AuswahlIsrPatient(QWidget):
    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_auswahlIsrPatient()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)
        rx = QRegExp("[\w\d+\-#\!]*")
        self.ui.patienten_nr.setValidator(QRegExpValidator(rx, self.ui.patienten_nr))
        self.ui.sub_behandler_nr.setValidator(QRegExpValidator(rx, self.ui.sub_behandler_nr))
        rx = QRegExp("\w*")
        self.ui.vorname.setValidator(QRegExpValidator(rx, self.ui.vorname))
        self.ui.nachname.setValidator(QRegExpValidator(rx, self.ui.nachname))
    
    def closeNow(self):
        self.setParent(None)
        self.close()

    def acceptChoice(self):
        pass

    def cancelChoice(self):
        pass
        
    def deleteIsrItem(self):
        pass
    
    def deleteMiniIcfItem(self):
        pass
    
    def deleteScl90Item(self):
        pass

class AufnahmePatient(QWidget):
    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_aufnahme_patient()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)
        
        self.ui.sub_behandler_nr.setVisible(False)
        self.ui.behandler_nr.setVisible(False)
        self.ui.behandlungsempfehlung.setExclusive(False)
        

        # max 12
        rx12 = QRegExp("[0-9]|1[0-2]")
        self.ui.anzahl_kinder.setValidator(QRegExpValidator(rx12, self.ui.anzahl_kinder))
        # max. 156
        rx156 = QRegExp("[0-9]|[0-9][0-9]|1[0-4][0-9]|15[0-6]|999")
        self.ui.au_aufnahme.setValidator(QRegExpValidator(rx156, self.ui.au_aufnahme))
        # max. 52
        rx52 = QRegExp("[0-9]|[0-4][0-9]|5[0-2]|999")
        self.ui.au_gesamt.setValidator(QRegExpValidator(rx52, self.ui.au_gesamt))
        # max. 20
        rx20 = QRegExp("[0-9]|[0-1][0-9]|20|999")
        self.ui.stat_vorbeh_anzahl.setValidator(QRegExpValidator(rx20, self.ui.stat_vorbeh_anzahl))
        self.ui.teilstat_vorbeh_anzahl.setValidator(QRegExpValidator(rx20, self.ui.teilstat_vorbeh_anzahl))
        self.ui.amb_vorbeh_anzahl.setValidator(QRegExpValidator(rx20, self.ui.amb_vorbeh_anzahl))
        # max. 48
        rx48 = QRegExp("[0-9]|[0-3][0-9]|4[0-8]|999")
        self.ui.stat_vorbeh_dauer.setValidator(QRegExpValidator(rx48, self.ui.stat_vorbeh_dauer))
        self.ui.teilstat_vorbeh_dauer.setValidator(QRegExpValidator(rx48, self.ui.teilstat_vorbeh_dauer))
        
        self.nationListData = [[x[0], x[1]] for x in db['nation']]
        self.nationIDs = [x[0] for x in db['nation']]
        self.nationIDslower = [x[0] for x in db['nation']]
        self.nationIDslower.extend(x[0].lower() for x in db['nation'])
        self.nationIDs.sort()
        completer = QCompleter(self.nationIDs)
        completer.setCaseSensitivity(Qt.CaseInsensitive)
        completer.setModelSorting(0)
        self.ui.nation.setCompleter(completer)
        rx = QRegExp('|'.join(self.nationIDslower))
        self.ui.nation.setValidator(QRegExpValidator(rx, self.ui.nation))
        
    def closeNow(self):
        self.setParent(None)
        self.close()
        
    def nextTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()+1)
        
    def previousTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()-1)
        
    def nationChanged(self):
        currentNation = self.ui.nation.displayText()
        self.ui.nation.setText(currentNation.toUpper())

        
        
    def selectNation(self):
        header = ['ID', 'Name']
        listenauswahl = Listenauswahl(self.nationListData, header, parent = self)
        index = listenauswahl.exec_()
        if listenauswahl.returnValue:
            item = self.findChild(QLineEdit,'nation')
            item.setText(listenauswahl.returnValue)


class AufnahmeTherapeut(QWidget):
    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_aufnahme_therapeut()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.ui.aufnahmedatum.setDate(QDate.currentDate())
        # line-inputs für Zahlen
        rx = QRegExp("[0-9]|[1-2][0-2]|999")
        self.ui.suizidversuch_anzahl.setValidator(QRegExpValidator(rx, self.ui.suizidversuch_anzahl))
        
        #min = check['suizidversuch_anzahl']['min']
        #max = check['suizidversuch_anzahl']['max']
        #self.ui.suizidversuch_anzahl.setValidator(QIntValidator(min, max, self.ui.suizidversuch_anzahl))
        self.diagnoseListePsychisch = [[x[0], x[1]] for x in db['diagnose'] if x[2] == True]
        self.diagnoseListeSomatisch = [[x[0], x[1]] for x in db['diagnose'] if x[3] == True]
        self.icd10CodesPsychisch = [x[0] for x in db['diagnose'] if x[2] == True]
        self.icd10CodesSomatisch = [x[0] for x in db['diagnose'] if x[3] == True]
        self.icd10Sicherheit = [x[0] for x in db['sicher']]
        self.icd10Sicherheit.append('999')
        #print self.icd10Sicherheit
        # Table model für psychische Diganose
        self.psychische_diagnose_tm = QStandardItemModel(0, 3, self)
        self.psychische_diagnose_tm.setHeaderData(0, Qt.Horizontal, QVariant('Diagnose'))
        self.psychische_diagnose_tm.setHeaderData(1, Qt.Horizontal, QVariant('ICD-10-Code'))
        self.psychische_diagnose_tm.setHeaderData(2, Qt.Horizontal, QVariant('Sicherheit'))
        psychische_diagnose_tv = self.ui.psychische_diagnose
        psychische_diagnose_tv.setModel(self.psychische_diagnose_tm)
        psychische_diagnose_tv.verticalHeader().setVisible(False)
        psychische_diagnose_tv.horizontalHeader().setResizeMode(QHeaderView.Stretch)


        # Table model für somatische Diganose
        self.somatische_diagnose_tm = QStandardItemModel(0, 3, self)
        self.somatische_diagnose_tm.setHeaderData(0, Qt.Horizontal, QVariant('Diagnose'))
        self.somatische_diagnose_tm.setHeaderData(1, Qt.Horizontal, QVariant('ICD-10-Code'))
        self.somatische_diagnose_tm.setHeaderData(2, Qt.Horizontal, QVariant('Sicherheit'))
        somatische_diagnose_tv = self.ui.somatische_diagnose
        somatische_diagnose_tv.setModel(self.somatische_diagnose_tm)
        somatische_diagnose_tv.verticalHeader().setVisible(False)
        somatische_diagnose_tv.horizontalHeader().setResizeMode(QHeaderView.Stretch)

        
        if self.psychische_diagnose_tm.rowCount() == 0:
            self.addPsychischeDiagnose()
        
        if self.somatische_diagnose_tm.rowCount() == 0:
            self.addSomatischeDiagnose('99999')
        
        #print self.psychische_diagnose_tm.item(0,1)
            
        QObject.connect(self.psychische_diagnose_tm, SIGNAL("dataChanged(QModelIndex, QModelIndex)"), self.psychischeDiagnoseChanged)
        QObject.connect(self.somatische_diagnose_tm, SIGNAL("dataChanged(QModelIndex, QModelIndex)"), self.somatischeDiagnoseChanged)

    def psychischeDiagnoseChanged(self, index1, index2):
        currentValue = self.psychische_diagnose_tm.data(index1).toString()
        # Diagnosen
        if index1.column() == 1 and currentValue:
            
            #print currentValue, currentValue in self.icd10CodesPsychisch
            if not currentValue in self.icd10CodesPsychisch:
                
                QMessageBox.information(self, 'Diagnose unbekannt', 
                            'Fehlerhafte Diagnose-Eingabe: ' + currentValue, 
                            'Ok', '', '', 0, -1)
                self.psychische_diagnose_tm.setData(index1,QVariant(QString('')))
        # Sicherheit
        if index1.column() == 2 and currentValue:
            
            #print currentValue, currentValue in self.icd10CodesPsychisch
            if not currentValue in ['1','2','3','4','999']:
                
                QMessageBox.information(self, 'Sicherheit unbekannt', 
                            'Fehlerhafte Sicherheit-Eingabe: ' + currentValue, 
                            'Ok', '', '', 0, -1)
                self.psychische_diagnose_tm.setData(index1,QVariant(QString('')))
                
    def somatischeDiagnoseChanged(self, index1, index2):
        currentValue = self.somatische_diagnose_tm.data(index1).toString()
        # Diagnosen
        if index1.column() == 1 and currentValue:
            
            #print currentValue, currentValue in self.icd10CodesPsychisch
            if not currentValue in self.icd10CodesSomatisch and not currentValue in ['99999']:
                
                QMessageBox.information(self, 'Diagnose unbekannt', 
                            'Fehlerhafte Diagnose-Eingabe: ' + currentValue, 
                            'Ok', '', '', 0, -1)
                self.somatische_diagnose_tm.setData(index1,QVariant(QString('')))
        # Sicherheit
        if index1.column() == 2 and currentValue:
            
            #print currentValue, currentValue in self.icd10CodesPsychisch
            if not currentValue in ['1','2','3','4','999']:
                
                QMessageBox.information(self, 'Sicherheit unbekannt', 
                            'Fehlerhafte Sicherheit-Eingabe: ' + currentValue, 
                            'Ok', '', '', 0, -1)
                self.somatische_diagnose_tm.setData(index1,QVariant(QString('')))
        
        
    def closeNow(self):
        self.setParent(None)
        self.close()

    def nextTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()+1)
        
    def previousTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()-1)
        
    def addPsychischeDiagnose(self, icd10 = None, sicherheit = None):
        row = self.psychische_diagnose_tm.rowCount()
        currentDiag = self.psychische_diagnose_tm.data(self.psychische_diagnose_tm.index(row-1,1)).toString()
        if icd10 and not currentDiag:
            if row == 0:
                self.psychische_diagnose_tm.insertRow(row)
            else:
                row = row-1
        else:
            self.psychische_diagnose_tm.insertRow(row)

        if row == 0:
            diganoseText = 'Hauptdiagnose'
        else:
            diganoseText = 'Diagnose ' + str(row + 1)
        self.psychische_diagnose_tm.setData(self.psychische_diagnose_tm.index(row, 0), QVariant(diganoseText))
        if icd10:
            self.psychische_diagnose_tm.setData(self.psychische_diagnose_tm.index(row, 1), QVariant(icd10))
        if sicherheit:
            self.psychische_diagnose_tm.setData(self.psychische_diagnose_tm.index(row, 2), QVariant(sicherheit))
        else:
            self.psychische_diagnose_tm.setData(self.psychische_diagnose_tm.index(row, 2), QVariant('999'))
        self.psychische_diagnose_tm.item(int(row),0).setEditable(False)
        

        
        
    def addPsychischeDiagnoseFromList(self):
        header = ['ICD-10-Code', 'Beschreibung']
        diagnoseauswahl = Listenauswahl(self.diagnoseListePsychisch, header, headerSize = [120, 645], parent = self)
        index = diagnoseauswahl.exec_()
        if diagnoseauswahl.returnValue:
            self.addPsychischeDiagnose(diagnoseauswahl.returnValue)
        
        
    def addDiagnoseId(self, row, column):
        diagnoseText = self.diagnoseauswahl.ui.tableView.item(row,column).text()
        #print diagnoseText
    
    def removePsychischeDiagnose(self):
        row = self.psychische_diagnose_tm.rowCount()
        self.psychische_diagnose_tm.removeRows(row-1,1)
        
    def addSomatischeDiagnose(self, icd10 = None, sicherheit = None):
        row = self.somatische_diagnose_tm.rowCount()
        currentDiag = self.somatische_diagnose_tm.data(self.somatische_diagnose_tm.index(row-1,1)).toString()
        if icd10 and (not currentDiag or currentDiag == '99999'):
            if row == 0:
                self.somatische_diagnose_tm.insertRow(row)
            else:
                row = row-1
        else:
            self.somatische_diagnose_tm.insertRow(row)
        

        diganoseText = 'Diagnose ' + str(row + 1)
        self.somatische_diagnose_tm.setData(self.somatische_diagnose_tm.index(row, 0), QVariant(diganoseText))
        if icd10:
            self.somatische_diagnose_tm.setData(self.somatische_diagnose_tm.index(row, 1), QVariant(icd10))
        if sicherheit:
            self.somatische_diagnose_tm.setData(self.somatische_diagnose_tm.index(row, 2), QVariant(sicherheit))
        else:
            self.somatische_diagnose_tm.setData(self.somatische_diagnose_tm.index(row, 2), QVariant('999'))
        
        self.somatische_diagnose_tm.item(int(row),0).setEditable(False)
        
    def addSomatischeDiagnoseFromList(self):
        
        header = ['ICD-10-Code', 'Beschreibung']
        diagnoseauswahl = Listenauswahl(self.diagnoseListeSomatisch, header, headerSize = [120, 645], parent = self)
        index = diagnoseauswahl.exec_()
        if diagnoseauswahl.returnValue:
            self.addSomatischeDiagnose(diagnoseauswahl.returnValue)
        
    def removeSomatischeDiagnose(self):
        row = self.somatische_diagnose_tm.rowCount()
        self.somatische_diagnose_tm.removeRows(row-1,1)
        
        
class EntlassungPatient(QWidget):
    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_entlassung_patient()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.ui.sub_behandler_nr.setVisible(False)
        self.ui.behandler_nr.setVisible(False)
        
    def closeNow(self):
        self.setParent(None)
        self.close()
        
    def nextTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()+1)
        
    def previousTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()-1)
        
class EntlassungTherapeut(QWidget):
    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_entlassung_therapeut()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.ui.entlassungsdatum.setDate(QDate.currentDate())
        #min = check['behandlungsdauer']['min']
        #max = check['behandlungsdauer']['max']
        #max 730
        rx730 = QRegExp("[1-9]|[1-9][0-9]|[1-6][0-9][0-9]|7[0-2][0-9]|730|999")
        self.ui.behandlungsdauer.setValidator(QRegExpValidator(rx730, self.ui.behandlungsdauer))
        #self.ui.behandlungsdauer.setValidator(QIntValidator(min, max, self.ui.behandlungsdauer))
        rx999 = QRegExp("[0-9][0-9][0-9]")
        self.ui.anzahl_sitzungen.setValidator(QRegExpValidator(rx999, self.ui.anzahl_sitzungen))
        self.ui.vev_k.setValidator(QRegExpValidator(rx999, self.ui.vev_k))
        # max. 156
        #rx156 = QRegExp("[0-9]|[0-9][0-9]|1[0-4][0-9]|15[0-6]|999")
        #self.ui.au_aufnahme.setValidator(QRegExpValidator(rx156, self.ui.au_aufnahme))
        
    def closeNow(self):
        self.setParent(None)
        self.close()
        
    def nextTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()+1)
        
    def previousTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()-1)
        
class Isr(QWidget):
    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_isr()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.ui.sub_behandler_nr.setVisible(False)
        self.ui.behandler_nr.setVisible(False)
        self.ui.isr_datum.setDate(QDate.currentDate())
        
    def closeNow(self):
        self.setParent(None)
        self.close()
        
    def nextTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()+1)
        
    def previousTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()-1)

class Isr_grafik(QWidget):
    def __init__(self, parent, isr_values, itemDict):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_isr_grafik()
        self.ui.setupUi(self)
        self.isr_values = isr_values
        self.itemDict = itemDict
        QObject.connect(self.ui.printButtonSW, SIGNAL("clicked()"),self.print_isr_sw)
        QObject.connect(self.ui.printButton, SIGNAL("clicked()"),self.print_isr_color)
        self.checkBoxes = []
        for iCheckBox in range(len(self.isr_values)):
            showTest = QCheckBox(self)
            showTest.setGeometry(QRect(890, 10+40*iCheckBox, 121, 21))
            showTest.setAcceptDrops(True)
            showTest.setText(self.isr_values[iCheckBox]['isr_datum'])
            showTest.setObjectName("showTest%s" % iCheckBox) 
            self.checkBoxes.append(showTest)
            QObject.connect(self.checkBoxes[iCheckBox], SIGNAL("clicked()"),self.plotTestList)
        self.checkBoxes[0].setCheckState(2)

        self.setAttribute(Qt.WA_DeleteOnClose)

        isr_scene = QGraphicsScene()
        self.render_scene(isr_scene,'color')
        self.ui.graphicsView.setScene(isr_scene)
        
        #self.painter = QPainter(self.printer)
            
        
    def closeNow(self):
        self.setParent(None)
        self.close()
    
    def print_isr_color(self):
        printer=QPrinter()
        dialog = QPrintDialog(printer);
        if dialog.exec_() == QDialog.Accepted:
            isr_scene_print = QGraphicsScene()
            self.render_scene(isr_scene_print,'color')
            painter = QPainter(printer)
            resoultion = printer.resolution()
            isr_scene_print.render(painter, target = QRectF(resoultion, resoultion, printer.width()-resoultion*1.5, printer.height()-resoultion*2))
            painter.end()

    def print_isr_sw(self):
        printer=QPrinter()
        dialog = QPrintDialog(printer);
        if dialog.exec_() == QDialog.Accepted:
            isr_scene_print = QGraphicsScene()
            self.render_scene(isr_scene_print,'sw')
            painter = QPainter(printer)
            resoultion = printer.resolution()
            isr_scene_print.render(painter, target = QRectF(resoultion, resoultion, printer.width()-resoultion*1.5, printer.height()-resoultion*2))
            painter.end()

    def plotTestList(self):
        isr_scene = QGraphicsScene()
        self.render_scene(isr_scene,'color')
        self.ui.graphicsView.setScene(isr_scene)
        


    def render_scene(self, scene, style):
        isr_norm = qualiconfV4.isr_norm
        if style == 'sw':
            isr_color = [(0, 0, 0),(0,0,0),(0,0,0),(0,0,0),(0, 0, 0)] 
            brushstyle = [Qt.Dense7Pattern, Qt.Dense6Pattern, Qt.BDiagPattern, Qt.FDiagPattern, Qt.DiagCrossPattern]
        if style == 'color':
            isr_color = qualiconfV4.isrcolor
            brushstyle = [Qt.SolidPattern,Qt.SolidPattern,Qt.SolidPattern,Qt.SolidPattern,Qt.SolidPattern]
        
        beschreibung = {'depression'    :u'ISR Depressionsscore',
                        'angst'         :u'ISR Angstscore',
                        'zwang'         :u'ISR Zwangscore',
                        'soma'          :u'ISR Somatisierungscore',
                        u'essstörung'    :u'ISR Essstörungscore',
                        'gesamt'        :u'ISR Gesamtscore',
                        'isr_d04'       :u'ISR (Z) Konzentrationsstörungen',
                        'isr_d10'       :u'ISR (Z) Suizidalität',
                        'isr_d11'       :u'ISR (Z) Schlafprobleme',
                        'isr_d12'       :u'ISR (Z) Appetitlosigkeit',
                        'isr_w01'       :u'ISR (Z) Vergesslichkeit',
                        'isr_w02'       :u'ISR (Z) Flashbacks',
                        'isr_w03'       :u'ISR (Z) Anpassungsstörung',
                        'isr_w05'       :u'ISR (Z) Depersonalisierung',
                        'isr_w06'       :u'ISR (Z) Derealisation',
                        'isr_w07'       :u'ISR (Z) Sexuelle Funktionsstörung',
                        'isr_w08'       :u'ISR (Z) Persönlichkeitsveränderung',
                        'isr_w09'       :u'ISR (Z) Sexualität',
}

        balkenstartx = 350.0
        balkenstarty = 120.0
        balkendeltay = 30
        balkenheigth = 18
        brushwidth = 5.0
        fontsize = 12
        text = scene.addText(QString(unicode('ISR Testauswertung Patient Nr. ' 
                + self.itemDict['patienten_nr'] + ', '+ self.itemDict['vorname'] + ' ' 
                + self.itemDict['nachname'])))
        text.setFont(QFont('Helvetica', pointSize = fontsize+4, weight = 100))    
        text.setPos(50,50)
        catnr = 0
        for cat in ['depression','angst','zwang','soma',u'essstörung']+self.itemDict['zusatz']+['gesamt'] :
            text3 = scene.addText(QString(beschreibung[cat]))
            text3.setFont(QFont('Helvetica', pointSize = fontsize, weight = 25))
            text3.setPos(50,balkenstarty-5+catnr*balkendeltay)
            for item in isr_norm[cat]:
                item=(item[0],min(item[1],4.0+brushwidth/100),item[2],item[3])
                scene.addPolygon(QPolygonF(QRectF(balkenstartx + item[0]*100,balkenstarty+catnr*balkendeltay,
                                                  (item[1]-item[0])*100,balkenheigth)), 
                                 QPen(), 
                                 QBrush(QColor(isr_color[item[3]][0]*255,isr_color[item[3]][1]*255,
                                               isr_color[item[3]][2]*255), style = brushstyle[item[3]]))
            catnr = catnr + 1

        linestyles = [Qt.SolidLine, Qt.DashLine, Qt.DotLine, Qt.DashDotLine, Qt.SolidLine, Qt.DashLine, Qt.DotLine, Qt.DashDotLine, Qt.SolidLine, Qt.DashLine, Qt.DotLine, Qt.DashDotLine, Qt.SolidLine, Qt.DashLine, Qt.DotLine, Qt.DashDotLine]
        linecolors = [[0,0,0], [80,80,80], [120,120,120], [160,160,160], [100,100,100], [140,140,140],[60,60,60], [20,20,20], [60,60,60], [0,0,0], [100,100,100], [0,0,0], [140,140,140], [20,20,20],[60,60,60], [100,100,100]]
        iBlock = 0
        nBlocks = len(self.isr_values)
        for icheckBox in range(len(self.checkBoxes)):
            if not self.checkBoxes[icheckBox].isChecked():
                continue
            dataBlock = self.isr_values[icheckBox]
            if iBlock == 16:
                break
            catnr = 0
            lastline = None
            for cat in ['depression','angst','zwang','soma','essstörung']+self.itemDict['zusatz']+['gesamt'] :

                if iBlock == 0:
                    text2 = scene.addText(QString(self.isr_values[icheckBox][cat]['finalScoreText']))
                    text2.setFont(QFont('Times', pointSize = fontsize, weight = 25))
                    text2.setPos(balkenstartx+410+30*iBlock, balkenstarty-5+catnr*balkendeltay)
                    text2.setDefaultTextColor(QColor(linecolors[iBlock][0],linecolors[iBlock][1],linecolors[iBlock][2]))

                if self.isr_values[icheckBox][cat].has_key('finalScore') and not self.isr_values[icheckBox][cat]['finalScore'] == None:
                    x1 = balkenstartx + self.isr_values[icheckBox][cat]['finalScore']*100 + brushwidth/2
                    y1 = balkenstarty-2+catnr*balkendeltay
                    x2 = balkenstartx + self.isr_values[icheckBox][cat]['finalScore']*100 + brushwidth/2
                    y2 = balkenstarty+balkenheigth+2+catnr*balkendeltay
                    line = scene.addLine(x1,y1,x2,y2,QPen(QBrush(QColor(linecolors[iBlock][0],linecolors[iBlock][1],linecolors[iBlock][2])),brushwidth))
                    line.setZValue(1000-10*iBlock)
                    if not lastline == None:
                        line = scene.addLine((lastline[0]+lastline[2])/2,(lastline[1]+lastline[3])/2,
                                             (x1+x2)/2,(y1+y2)/2,
                                              QPen(QBrush(QColor(linecolors[iBlock][0],linecolors[iBlock][1],linecolors[iBlock][2])),3,style=linestyles[iBlock]))
                        line.setZValue(999-10*iBlock)
                    lastline = (x1,y1,x2,y2)
                catnr = catnr + 1
            line = scene.addLine(630,balkenstarty+fontsize+(catnr+iBlock)*balkendeltay,
                          700,balkenstarty+fontsize+(catnr+iBlock)*balkendeltay,
                          QPen(QBrush(QColor(linecolors[iBlock][0],linecolors[iBlock][1],linecolors[iBlock][2])),brushwidth,style=linestyles[iBlock]))
            line.setZValue(999-10*iBlock)
            
            text = scene.addText(QString(unicode(self.isr_values[icheckBox]['isr_datum'])))
            text.setFont(QFont('Helvetica', pointSize = fontsize, weight = 100))
            text.setPos(720,balkenstarty+(catnr+iBlock)*balkendeltay)
            text.setDefaultTextColor(QColor(linecolors[iBlock][0],linecolors[iBlock][1],linecolors[iBlock][2]))
            iBlock = iBlock + 1
                    
                
                
        text2 = scene.addText(QString(u'Legende:'))
        text2.setFont(QFont('Times', pointSize = fontsize+1, weight = 50))
        text2.setPos(50,balkenstarty-5+catnr*balkendeltay+80)
        scene.addPolygon(QPolygonF(QRectF(50,balkenstarty+catnr*balkendeltay+80+balkendeltay,40,balkenheigth)), 
                                       QPen(), 
                                       QBrush(QColor(isr_color[0][0]*255,isr_color[0][1]*255,isr_color[0][2]*255), style = brushstyle[0]))
        text2 = scene.addText(QString(u'keine Symptombelastung'))
        text2.setFont(QFont('Times', pointSize = fontsize, weight = 25))
        text2.setPos(100,balkenstarty-5+catnr*balkendeltay+80+balkendeltay)
        scene.addPolygon(QPolygonF(QRectF(50,balkenstarty+catnr*balkendeltay+80+2*balkendeltay,40,balkenheigth)), 
                                       QPen(), 
                                       QBrush(QColor(isr_color[1][0]*255,isr_color[1][1]*255,isr_color[1][2]*255), style = brushstyle[1]))
        text2 = scene.addText(QString(u'potentielle Symptombelastung'))
        text2.setFont(QFont('Times', pointSize = fontsize, weight = 25))
        text2.setPos(100,balkenstarty-5+catnr*balkendeltay+80+2*balkendeltay)
        scene.addPolygon(QPolygonF(QRectF(50,balkenstarty+catnr*balkendeltay+80+3*balkendeltay,40,balkenheigth)), 
                                       QPen(), 
                                       QBrush(QColor(isr_color[2][0]*255,isr_color[2][1]*255,isr_color[2][2]*255), style = brushstyle[2]))
        text2 = scene.addText(QString(u'geringe Symptombelastung'))
        text2.setFont(QFont('Times', pointSize = fontsize, weight = 25))
        text2.setPos(100,balkenstarty-5+catnr*balkendeltay+80+3*balkendeltay)
        scene.addPolygon(QPolygonF(QRectF(50,balkenstarty+catnr*balkendeltay+80+4*balkendeltay,40,balkenheigth)), 
                                       QPen(), 
                                       QBrush(QColor(isr_color[3][0]*255,isr_color[3][1]*255,isr_color[3][2]*255), style = brushstyle[3]))
        text2 = scene.addText(QString(u'mittlere Symptombelastung'))
        text2.setFont(QFont('Times', pointSize = fontsize, weight = 25))
        text2.setPos(100,balkenstarty-5+catnr*balkendeltay+80+4*balkendeltay)
        scene.addPolygon(QPolygonF(QRectF(50,balkenstarty+catnr*balkendeltay+80+5*balkendeltay,40,balkenheigth)), 
                                       QPen(), 
                                       QBrush(QColor(isr_color[4][0]*255,isr_color[4][1]*255,isr_color[4][2]*255), style = brushstyle[4]))
        text2 = scene.addText(QString(u'schwere Symptombelastung'))
        text2.setFont(QFont('Times', pointSize = fontsize, weight = 25))
        text2.setPos(100,balkenstarty-5+catnr*balkendeltay+80+5*balkendeltay)
        text2 = scene.addText(QString(u'Items mit der Bezeichnung (Z) sind ISR-Zusatzitems, dabei gelten Werte über Null als auffällig.'))
        text2.setFont(QFont('Times', pointSize = fontsize, weight = 25))
        text2.setPos(50,balkenstarty-5+catnr*balkendeltay+80+6*balkendeltay)




class MiniIcf(QWidget):
    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_mini_icf()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.ui.mini_icf_gesamt.setVisible(False)
        self.ui.mini_icf_datum.setDate(QDate.currentDate())
        
    def closeNow(self):
        self.setParent(None)
        self.close()
        
    def nextTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()+1)
        
    def previousTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()-1)
        
    def setMiniIcfGesamt(self):
        score = 0.0
        count = 0.0
        finalScore = None
        for iItem in range(1,14):
            #print iItem
            if iItem < 10:
                itemName = 'mini_icf_0' + str(iItem)
            else:
                itemName = 'mini_icf_' + str(iItem)
            #print itemName
            item = self.findChild(QButtonGroup,itemName)
            self.getRadio(item)
            # for type in [QGridLayout,QVBoxLayout, QFormLayout, QHBoxLayout]:
                # item = self.findChild(type,itemName)
                # if item:
                    # print item
                    # self.getRadio(item)
                    # break
            value = self.getRadio(item)
            if value:
                count = count + 1
                score = score + float(int(value))
        if count > 0:
            finalScore = score / count
        else:
            finalScore = 0
        #print score, count, finalScore
        self.ui.mini_icf_gesamt.setText(str(finalScore))
        
    def getRadio(self, item):
        dataString = ''
        for button in item.buttons():
            if button.isChecked():
                #print button.objectName()
                dataString += button.objectName().split('_')[-1]
                dataString += ','
        dataString = dataString[:-1]
        #print 'getRadioData:', dataString
        return dataString
        
class Scl90(QWidget):
    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_scl90()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)
        # 0-4 double
        rx = QRegExp("[0-3]\.[0-9][0-9]|4\.00")
        self.ui.scl90_somatisierung.setValidator(QRegExpValidator(rx, self.ui.scl90_somatisierung))
        self.ui.scl90_zwanghaftigkeit.setValidator(QRegExpValidator(rx, self.ui.scl90_zwanghaftigkeit))
        self.ui.scl90_sozialkontakt.setValidator(QRegExpValidator(rx, self.ui.scl90_sozialkontakt))
        self.ui.scl90_depressivitaet.setValidator(QRegExpValidator(rx, self.ui.scl90_depressivitaet))
        self.ui.scl90_aengstlichkeit.setValidator(QRegExpValidator(rx, self.ui.scl90_aengstlichkeit))
        self.ui.scl90_aggressivitaet.setValidator(QRegExpValidator(rx, self.ui.scl90_aggressivitaet))
        self.ui.scl90_phobische_angst.setValidator(QRegExpValidator(rx, self.ui.scl90_phobische_angst))
        self.ui.scl90_paranoides_denken.setValidator(QRegExpValidator(rx, self.ui.scl90_paranoides_denken))
        self.ui.scl90_psychotizismus.setValidator(QRegExpValidator(rx, self.ui.scl90_psychotizismus))
        self.ui.scl90_gsi.setValidator(QRegExpValidator(rx, self.ui.scl90_gsi))
        self.ui.scl90_datum.setDate(QDate.currentDate())
        
    def closeNow(self):
        self.setParent(None)
        self.close()
        
    def nextTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()+1)
        
    def previousTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()-1)

class KtlKrankenhaus(QWidget):
    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_ktl_krankenhaus()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)
        rx = QRegExp("[0-9][0-9][0-9][0-9][0-9]")
        self.ui.visiten.setValidator(QRegExpValidator(rx, self.ui.visiten))
        self.ui.kontakte_kotherapeutisch.setValidator(QRegExpValidator(rx, self.ui.kontakte_kotherapeutisch))
        self.ui.besprechung_patientenbezogen.setValidator(QRegExpValidator(rx, self.ui.besprechung_patientenbezogen))
        self.ui.gruppe_tiefenpsychologisch_bis10.setValidator(QRegExpValidator(rx, self.ui.gruppe_tiefenpsychologisch_bis10))
        self.ui.gruppe_tiefenpsychologisch_ab11.setValidator(QRegExpValidator(rx, self.ui.gruppe_tiefenpsychologisch_ab11))
        self.ui.gruppe_verhaltenstherapeutisch_bis10.setValidator(QRegExpValidator(rx, self.ui.gruppe_verhaltenstherapeutisch_bis10))
        self.ui.gruppe_verhaltenstherapeutisch_ab11.setValidator(QRegExpValidator(rx, self.ui.gruppe_verhaltenstherapeutisch_ab11))
        self.ui.gruppe_andere_verbale_bis10.setValidator(QRegExpValidator(rx, self.ui.gruppe_andere_verbale_bis10))
        self.ui.gruppe_andere_verbale_ab11.setValidator(QRegExpValidator(rx, self.ui.gruppe_andere_verbale_ab11))
        self.ui.gruppe_kunst.setValidator(QRegExpValidator(rx, self.ui.gruppe_kunst))
        self.ui.gruppe_musik.setValidator(QRegExpValidator(rx, self.ui.gruppe_musik))
        self.ui.gruppe_koerper.setValidator(QRegExpValidator(rx, self.ui.gruppe_koerper))
        self.ui.gruppe_soziale_interaktion.setValidator(QRegExpValidator(rx, self.ui.gruppe_soziale_interaktion))
        self.ui.gruppe_entspannung.setValidator(QRegExpValidator(rx, self.ui.gruppe_entspannung))
        self.ui.gruppe_meditation.setValidator(QRegExpValidator(rx, self.ui.gruppe_meditation))
        self.ui.gruppe_themenzentriert.setValidator(QRegExpValidator(rx, self.ui.gruppe_themenzentriert))
        self.ui.gruppe_indikation.setValidator(QRegExpValidator(rx, self.ui.gruppe_indikation))
        self.ui.gruppe_andere.setValidator(QRegExpValidator(rx, self.ui.gruppe_andere))
        self.ui.gruppe_milieu_versammlung.setValidator(QRegExpValidator(rx, self.ui.gruppe_milieu_versammlung))
        self.ui.gruppe_milieu_themenzentriert.setValidator(QRegExpValidator(rx, self.ui.gruppe_milieu_themenzentriert))
        self.ui.gruppe_milieu_andere.setValidator(QRegExpValidator(rx, self.ui.gruppe_milieu_andere))
        self.ui.einzel_tiefenpsychologisch.setValidator(QRegExpValidator(rx, self.ui.einzel_tiefenpsychologisch))
        self.ui.einzel_verhaltenstherapeutisch.setValidator(QRegExpValidator(rx, self.ui.einzel_verhaltenstherapeutisch))
        self.ui.einzel_andere_verbale.setValidator(QRegExpValidator(rx, self.ui.einzel_andere_verbale))
        self.ui.einzel_paar.setValidator(QRegExpValidator(rx, self.ui.einzel_paar))
        self.ui.einzel_kunst.setValidator(QRegExpValidator(rx, self.ui.einzel_kunst))
        self.ui.einzel_musik.setValidator(QRegExpValidator(rx, self.ui.einzel_musik))
        self.ui.einzel_koerper.setValidator(QRegExpValidator(rx, self.ui.einzel_koerper))
        self.ui.einzel_entspannung.setValidator(QRegExpValidator(rx, self.ui.einzel_entspannung))
        self.ui.einzel_meditation.setValidator(QRegExpValidator(rx, self.ui.einzel_meditation))
        self.ui.einzel_themenzentriert.setValidator(QRegExpValidator(rx, self.ui.einzel_themenzentriert))
        self.ui.einzel_andere_sonstige.setValidator(QRegExpValidator(rx, self.ui.einzel_andere_sonstige))
        self.ui.einzel_milieu_sozio.setValidator(QRegExpValidator(rx, self.ui.einzel_milieu_sozio))
        self.ui.einzel_milieu_andere.setValidator(QRegExpValidator(rx, self.ui.einzel_milieu_andere))
        self.ui.gruppe_soma.setValidator(QRegExpValidator(rx, self.ui.gruppe_soma))
        self.ui.einzel_soma.setValidator(QRegExpValidator(rx, self.ui.einzel_soma))
        self.ui.balneotherapie.setValidator(QRegExpValidator(rx, self.ui.balneotherapie))

        
    def closeNow(self):
        self.setParent(None)
        self.close()
        
    def nextTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()+1)
        
    def previousTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()-1)
        
class KtlReha(QWidget):
    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_ktl_reha()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)
        rx = QRegExp("[0-9][0-9][0-9][0-9][0-9]")
        self.ui.visiten.setValidator(QRegExpValidator(rx, self.ui.visiten))
        self.ui.kontakte_kotherapeutisch.setValidator(QRegExpValidator(rx, self.ui.kontakte_kotherapeutisch))
        self.ui.besprechung_patientenbezogen.setValidator(QRegExpValidator(rx, self.ui.besprechung_patientenbezogen))
        self.ui.gruppe_tiefenpsychologisch_bis12.setValidator(QRegExpValidator(rx, self.ui.gruppe_tiefenpsychologisch_bis12))
        self.ui.gruppe_tiefenpsychologisch_ab13.setValidator(QRegExpValidator(rx, self.ui.gruppe_tiefenpsychologisch_ab13))
        self.ui.gruppe_verhaltenstherapeutisch_bis12.setValidator(QRegExpValidator(rx, self.ui.gruppe_verhaltenstherapeutisch_bis12))
        self.ui.gruppe_verhaltenstherapeutisch_ab13.setValidator(QRegExpValidator(rx, self.ui.gruppe_verhaltenstherapeutisch_ab13))
        self.ui.gruppe_andere_verbale_bis12.setValidator(QRegExpValidator(rx, self.ui.gruppe_andere_verbale_bis12))
        self.ui.gruppe_andere_verbale_ab13.setValidator(QRegExpValidator(rx, self.ui.gruppe_andere_verbale_ab13))
        self.ui.gruppe_kunst.setValidator(QRegExpValidator(rx, self.ui.gruppe_kunst))
        self.ui.gruppe_musik.setValidator(QRegExpValidator(rx, self.ui.gruppe_musik))
        self.ui.gruppe_koerper.setValidator(QRegExpValidator(rx, self.ui.gruppe_koerper))
        self.ui.gruppe_soziale_interaktion.setValidator(QRegExpValidator(rx, self.ui.gruppe_soziale_interaktion))
        self.ui.gruppe_entspannung.setValidator(QRegExpValidator(rx, self.ui.gruppe_entspannung))
        self.ui.gruppe_meditation.setValidator(QRegExpValidator(rx, self.ui.gruppe_meditation))
        self.ui.gruppe_themenzentriert.setValidator(QRegExpValidator(rx, self.ui.gruppe_themenzentriert))
        self.ui.gruppe_indikation.setValidator(QRegExpValidator(rx, self.ui.gruppe_indikation))
        self.ui.gruppe_andere.setValidator(QRegExpValidator(rx, self.ui.gruppe_andere))
        self.ui.gruppe_milieu_versammlung.setValidator(QRegExpValidator(rx, self.ui.gruppe_milieu_versammlung))
        self.ui.gruppe_milieu_themenzentriert.setValidator(QRegExpValidator(rx, self.ui.gruppe_milieu_themenzentriert))
        self.ui.gruppe_milieu_andere.setValidator(QRegExpValidator(rx, self.ui.gruppe_milieu_andere))
        self.ui.einzel_tiefenpsychologisch.setValidator(QRegExpValidator(rx, self.ui.einzel_tiefenpsychologisch))
        self.ui.einzel_verhaltenstherapeutisch.setValidator(QRegExpValidator(rx, self.ui.einzel_verhaltenstherapeutisch))
        self.ui.einzel_andere_verbale.setValidator(QRegExpValidator(rx, self.ui.einzel_andere_verbale))
        self.ui.einzel_paar.setValidator(QRegExpValidator(rx, self.ui.einzel_paar))
        self.ui.einzel_kunst.setValidator(QRegExpValidator(rx, self.ui.einzel_kunst))
        self.ui.einzel_musik.setValidator(QRegExpValidator(rx, self.ui.einzel_musik))
        self.ui.einzel_koerper.setValidator(QRegExpValidator(rx, self.ui.einzel_koerper))
        self.ui.einzel_entspannung.setValidator(QRegExpValidator(rx, self.ui.einzel_entspannung))
        self.ui.einzel_meditation.setValidator(QRegExpValidator(rx, self.ui.einzel_meditation))
        self.ui.einzel_themenzentriert.setValidator(QRegExpValidator(rx, self.ui.einzel_themenzentriert))
        self.ui.einzel_andere_sonstige.setValidator(QRegExpValidator(rx, self.ui.einzel_andere_sonstige))
        self.ui.einzel_milieu_sozio.setValidator(QRegExpValidator(rx, self.ui.einzel_milieu_sozio))
        self.ui.einzel_milieu_andere.setValidator(QRegExpValidator(rx, self.ui.einzel_milieu_andere))
        self.ui.gruppe_soma.setValidator(QRegExpValidator(rx, self.ui.gruppe_soma))
        self.ui.einzel_soma.setValidator(QRegExpValidator(rx, self.ui.einzel_soma))
        self.ui.balneotherapie.setValidator(QRegExpValidator(rx, self.ui.balneotherapie))
        
    def closeNow(self):
        self.setParent(None)
        self.close()
        
    def nextTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()+1)
        
    def previousTab(self):
        self.ui.mainTabWidget.setCurrentIndex(self.ui.mainTabWidget.currentIndex()-1)


class TableModel(QAbstractTableModel): 
    def __init__(self, datain, headerdata, parent=None, *args): 
        QAbstractTableModel.__init__(self, parent, *args) 
        self.arraydata = datain 
        self.headerdata = headerdata
        
    def rowCount(self, parent): 
        return len(self.arraydata) 
 
    def columnCount(self, parent): 
        return len(self.headerdata) 
        
    def headerData(self, col, orientation, role):
        if orientation == Qt.Horizontal and role == Qt.DisplayRole:
            return QVariant(self.headerdata[col])
        return QVariant()
        
    def data(self, index, role, column = None): 
        if not index.isValid(): 
            return QVariant() 
        elif role != Qt.DisplayRole: 
            return QVariant() 
        if not column == None:
            return QVariant(self.arraydata[index.row()][column])
        else:
            return QVariant(self.arraydata[index.row()][index.column()])
            
            
    def insertRows(self, row, rowData, parent = QModelIndex()):
        if not type(rowData[0]) == ListType:
            return QVariant()
        self.beginInsertRows(parent, row, row+len(rowData)-1)
        self.arraydata.extend(rowData)
        self.endInsertRows()
        
    def removeRows(self, row, count, parent = QModelIndex()):
        self.beginRemoveRows(parent, row, row+count-1)
        del self.arraydata[row:row+count-1]
        self.endRemoveRows()
        
    def replaceData(self, rowData, parent = QModelIndex()):
        #print self.arraydata
        self.beginRemoveRows(parent, 0, self.rowCount(parent)-1)
        self.arraydata = []
        #print self.arraydata
        self.endRemoveRows()
        self.beginInsertRows(parent, 0, len(rowData)-1)
        self.arraydata.extend(rowData)
        self.endInsertRows()
        #print self.arraydata
        


class Listenauswahl(QDialog): 
    def __init__(self, listData, header, headerSize = None, parent=None): 
        QDialog.__init__(self, parent)
        self.setParent(parent)
        self.ui = Ui_Listenauswahl()
        self.ui.setupUi(self)
        
        self.proxyModel = QSortFilterProxyModel()
        
        
        #self.sourceView = self.ui.sourceView
        #self.sourceView.setAlternatingRowColors(True)
        #print listData
        self.model = TableModel(listData, header, self)
        
        self.proxyView = self.ui.proxyView
        self.proxyView.setModel(self.proxyModel)
        self.proxyView.verticalHeader().setVisible(False)
        self.proxyView.setAlternatingRowColors(True)
        
        
        for iHeaderItem in range(len(header)):
            self.ui.filterColumnComboBox.addItem(header[iHeaderItem])

        self.returnValue = ''
        
        self.connect(self.ui.filterPatternLineEdit,
                SIGNAL('textChanged(const QString &)'),
                self.filterRegExpChanged)
        self.connect(self.ui.filterSyntaxComboBox,
                SIGNAL('currentIndexChanged(int)'),
                self.filterRegExpChanged)
        self.connect(self.ui.filterColumnComboBox,
                SIGNAL('currentIndexChanged(int)'),
                self.filterColumnChanged)
        self.connect(self.ui.filterCaseSensitivityCheckBox,
                SIGNAL('toggled(bool)'),
                self.filterRegExpChanged)
        self.connect(self.ui.sortCaseSensitivityCheckBox,
                SIGNAL('toggled(bool)'),
                self.sortChanged)
                
        
        self.ui.filterColumnComboBox.setCurrentIndex(1)
                
        self.proxyModel.setSourceModel(self.model)
        
        if headerSize:
            for iHeaderItem in range(len(headerSize)):
                #print headerSize[iHeaderItem]
                self.proxyView.setColumnWidth(iHeaderItem,headerSize[iHeaderItem])
        else:
            self.proxyView.horizontalHeader().setResizeMode(QHeaderView.Stretch)
            
        self.proxyModel.setDynamicSortFilter(True)
        
        self.proxyView.sortByColumn(0, Qt.AscendingOrder)
        self.proxyView.setSortingEnabled(True)
        
        #print Qt.KeyboardModifiers(Qt.NoModifier)
        #print Qt.NoModifier
        
        #self.ui.filterPatternLineEdit.mousePressEvent(QMouseEvent(QEvent.MouseButtonPress, QPoint(5,5), Qt.LeftButton, Qt.LeftButton, Qt.KeyboardModifiers(Qt.NoModifier)))

        
        
    def filterRegExpChanged(self):
        syntax_nr, _ = self.ui.filterSyntaxComboBox.itemData(self.ui.filterSyntaxComboBox.currentIndex()).toInt()
        syntax = QRegExp.PatternSyntax(syntax_nr)

        if self.ui.filterCaseSensitivityCheckBox.isChecked():
            caseSensitivity = Qt.CaseSensitive
        else:
            caseSensitivity = Qt.CaseInsensitive

        regExp = QRegExp(self.ui.filterPatternLineEdit.text(), caseSensitivity, syntax)
        self.proxyModel.setFilterRegExp(regExp)
        self.proxyView.scrollToTop()


    def filterColumnChanged(self):
        self.proxyModel.setFilterKeyColumn(self.ui.filterColumnComboBox.currentIndex())

    def sortChanged(self):
        if self.ui.sortCaseSensitivityCheckBox.isChecked():
            caseSensitivity = Qt.CaseSensitive
        else:
            caseSensitivity = Qt.CaseInsensitive

        self.proxyModel.setSortCaseSensitivity(caseSensitivity)
        
        

        
    def closeNow(self):
        self.setParent(None)
        self.close()
        
    def accept(self, index = None):
        if not index:
            index = self.proxyView.currentIndex()
        if index:
            sourceIndex = self.proxyModel.mapToSource(index)
            self.returnValue = self.model.data(sourceIndex, Qt.DisplayRole, column = 0).toString()
        else:
            return
            
        self.close()
        
class AuthError(Exception):
     def __init__(self, value=''):
         self.value = value
     def __str__(self):
         return repr(self.value)

class UserAdmin(QDialog): 
    def __init__(self, parent = None, auth =[]):
        QDialog.__init__(self, parent)
        self.setParent(parent)
        self.auth = auth
        self.ui = Ui_userAdmin()
        self.ui.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose)

        self.ui.proxyView.setSelectionBehavior(QAbstractItemView.SelectRows)
        self.listData = []
        self.listData = db_helperlib.getUserListe()

        header = ['Username', 'Superuser', 'Passwort-Hash']

        self.proxyModel = QSortFilterProxyModel()
        
        #print listData
        self.model = TableModel(self.listData, header, self)
        
        self.proxyView = self.ui.proxyView
        self.proxyView.setModel(self.proxyModel)
        self.proxyView.verticalHeader().setVisible(False)
        self.proxyView.setAlternatingRowColors(True)
        
        
        for iHeaderItem in range(len(header)):
            self.ui.filterColumnComboBox.addItem(header[iHeaderItem])

        self.returnValue = ''
        
        self.connect(self.ui.filterPatternLineEdit,
                SIGNAL('textChanged(const QString &)'),
                self.filterRegExpChanged)
        self.connect(self.ui.filterSyntaxComboBox,
                SIGNAL('currentIndexChanged(int)'),
                self.filterRegExpChanged)
        self.connect(self.ui.filterColumnComboBox,
                SIGNAL('currentIndexChanged(int)'),
                self.filterColumnChanged)
        self.connect(self.ui.filterCaseSensitivityCheckBox,
                SIGNAL('toggled(bool)'),
                self.filterRegExpChanged)
        self.connect(self.ui.sortCaseSensitivityCheckBox,
                SIGNAL('toggled(bool)'),
                self.sortChanged)
                
        
        self.ui.filterColumnComboBox.setCurrentIndex(0)
                
        self.proxyModel.setSourceModel(self.model)

        self.proxyView.horizontalHeader().setResizeMode(QHeaderView.Stretch)
            
        self.proxyModel.setDynamicSortFilter(True)
        
        self.proxyView.sortByColumn(0, Qt.AscendingOrder)
        self.proxyView.setSortingEnabled(True)
        self.ui.proxyView.setFocus()
        
        
        
    def filterRegExpChanged(self):
        syntax_nr, _ = self.ui.filterSyntaxComboBox.itemData(self.ui.filterSyntaxComboBox.currentIndex()).toInt()
        syntax = QRegExp.PatternSyntax(syntax_nr)

        if self.ui.filterCaseSensitivityCheckBox.isChecked():
            caseSensitivity = Qt.CaseSensitive
        else:
            caseSensitivity = Qt.CaseInsensitive

        regExp = QRegExp(self.ui.filterPatternLineEdit.text(), caseSensitivity, syntax)
        self.proxyModel.setFilterRegExp(regExp)
        self.proxyView.scrollToTop()


    def filterColumnChanged(self):
        self.proxyModel.setFilterKeyColumn(self.ui.filterColumnComboBox.currentIndex())

    def sortChanged(self):
        if self.ui.sortCaseSensitivityCheckBox.isChecked():
            caseSensitivity = Qt.CaseSensitive
        else:
            caseSensitivity = Qt.CaseInsensitive

        self.proxyModel.setSortCaseSensitivity(caseSensitivity)
        

#        
    def addUser(self, index = None):
        authDialog = AuthDialog(self)
        authDialog.setWindowTitle(u'Neuer Benutzer')
        index = authDialog.exec_()
        #print 'return',einstellungen.returnValue
        if authDialog.returnValue:
            ret = authDialog.returnValue
            if len(self.model.match(self.model.index(0,0),Qt.DisplayRole,QVariant(ret[0]), flags = Qt.MatchExactly)) > 0:
                QMessageBox.critical(self, u'Anlegen verweigert', 
                            u"Es existiert bereits ein Benutzer mit diesem Login!", 
                            'Ok', '', '', 0, -1)
                return
            ret[1] = 'md5' + hashlib.md5(ret[1] + ret[0]).hexdigest()
            #print 'AUTH:', ret 
            #print 'md5' + hashlib.md5('test' + 'bado-gui').hexdigest()
            db_helperlib.insertUser(ret[0], ret[1])
        else:
            return
            #QApplication.instance().quit()
        self.listData = db_helperlib.getUserListe()
        self.model.replaceData(self.listData)

    def deleteUser(self, index = None):
        if not index:
            index = self.proxyView.currentIndex()
        if index:
            sourceIndex = self.proxyModel.mapToSource(index)
            selectedUser = self.model.data(sourceIndex, Qt.DisplayRole, column = 0).toString()
        if not selectedUser:
            return
        elif selectedUser == 'postgres':
            QMessageBox.critical(self, u'Löschen verweigert', 
                            u"Der Benutzer 'postgres' darf nicht gelöscht werden!", 
                            'Ok', '', '', 0, -1)
            return
        elif selectedUser == self.auth[0]:
            QMessageBox.critical(self, u'Löschen verweigert', 
                            u"Der aktive Benutzer darf nicht gelöscht werden!", 
                            'Ok', '', '', 0, -1)
            return
        else:
            answer = QMessageBox.question(self, u'Benutzer löschen?', 
                                                    u"Soll der Benutzer '%s' wirklich gelöscht werden?" % selectedUser, 
                                                    'Ja', 'Nein', '', 0, -1)
            if answer == 0:
                db_helperlib.deleteUser(selectedUser)
                self.listData = db_helperlib.getUserListe()
                self.model.replaceData(self.listData) 
            else:
                return
       

    def changePassword(self, index = None):
        if not index:
            index = self.proxyView.currentIndex()
        if index:
            sourceIndex = self.proxyModel.mapToSource(index)
            selectedUser = self.model.data(sourceIndex, Qt.DisplayRole, column = 0).toString()
        if not selectedUser:
            return

        authDialog = AuthDialog(self)
        authDialog.setWindowTitle(u'Passwort ändern')
        authDialog.ui.username.setText(selectedUser)
        authDialog.ui.username.setReadOnly(True)
        authDialog.ui.password.setFocus()
        index = authDialog.exec_()
        #print 'return',einstellungen.returnValue
        if authDialog.returnValue:
            ret = authDialog.returnValue
            ret[1] = 'md5' + hashlib.md5(ret[1] + ret[0]).hexdigest()
            #print 'AUTH:', ret 
            #print 'md5' + hashlib.md5('test' + 'bado-gui').hexdigest()
            db_helperlib.changePassword(selectedUser, ret[1])
        self.listData = db_helperlib.getUserListe()
        self.model.replaceData(self.listData) 
            
    def toggleSuperUser(self, index = None):
        if not index:
            index = self.proxyView.currentIndex()
        if index:
            sourceIndex = self.proxyModel.mapToSource(index)
            selectedUser = self.model.data(sourceIndex, Qt.DisplayRole, column = 0).toString()
        if not selectedUser:
            return
        elif selectedUser == 'postgres':
            QMessageBox.critical(self, u'Verändern verweigert', 
                            u"Der Benutzer 'postgres' darf nicht geändert werden!", 
                            'Ok', '', '', 0, -1)
            return
        elif selectedUser == self.auth[0]:
            QMessageBox.critical(self, u'Verändern verweigert', 
                            u"Der aktive Benutzer darf nicht geändert werden!", 
                            'Ok', '', '', 0, -1)
            return
        db_helperlib.toggleSuperUser(selectedUser)
        self.listData = db_helperlib.getUserListe()
        self.model.replaceData(self.listData) 
        
class AuthUserAdmin(QDialog):
    def __init__(self, parent = None):
        QDialog.__init__(self, parent)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.setParent(parent)
        self.ui = Ui_auth_createdb()
        self.ui.setupUi(self)
        self.returnValue = []
        #self.setAttribute(Qt.WA_DeleteOnClose)
        self.setWindowTitle('Authentifizierung')
        self.ui.hostname.setText('localhost')
        self.ui.port.setText('5432')
        self.ui.username.setFocus()
       
    def reject(self):
        self.close()
        
        QApplication.instance().quit()
        
          
    def accept(self):
        self.returnValue.append(self.ui.username.text().toUtf8())
        self.returnValue.append(self.ui.password.text().toUtf8())
        port = self.ui.port.text()
        hostname = self.ui.hostname.text()
        if not db_helperlib.connectToDb(dbname='badoV4', user=self.returnValue[0], host=hostname, port=port, password=self.returnValue[1]):
            QMessageBox.critical(None, u'Anmeldung fehlgeschlagen', 
                        u"Es konnte keine Verbindung mit dem Server hergestellt werden!"
                        + u"\x0ASind alle Eingaben korrekt?", 
                        'Ok', '', '', 0, -1)
            self.returnValue = []
            return
        try: 
            db_helperlib.checkSuperUser(self.returnValue[0])
        except:
            QMessageBox.critical(None, u'Authentifizierung fehlgeschlagen', 
                        u"Der Benutzer %s hat keine Superuser-Rechte!" % self.returnValue[0], 
                        'Ok', '', '', 0, -1)
            self.returnValue = []
            return
            
        self.close()
        QApplication.instance().quit()

class AuthCreateDb(QDialog):
    def __init__(self, parent = None):
        QDialog.__init__(self, parent)
        self.setAttribute(Qt.WA_DeleteOnClose)
        self.setParent(parent)
        self.ui = Ui_auth_createdb()
        self.ui.setupUi(self)
        self.returnValue = []
        #self.setAttribute(Qt.WA_DeleteOnClose)
        self.setWindowTitle('Authentifizierung')
        self.ui.hostname.setText('localhost')
        self.ui.port.setText('5432')
        self.ui.username.setText('postgres')
        self.ui.password.setFocus()
       
    def reject(self):
        self.close()
        QApplication.instance().quit()
        #raise AuthError
          
    def accept(self):
        self.returnValue.append(self.ui.username.text().toUtf8())
        self.returnValue.append(self.ui.password.text().toUtf8())
        port = self.ui.port.text()
        hostname = self.ui.hostname.text()
        if not db_helperlib.connectToDb(dbname='postgres', user=self.returnValue[0], host=hostname, port=port, password=self.returnValue[1]):
            QMessageBox.critical(None, u'Authentifizierung fehlgeschlagen', 
                        u"Es konnte keine Verbindung mit dem Server hergestellt werden!" 
                        + u"\x0ASind alle Eingaben korrekt?", 
                        'Ok', '', '', 0, -1)
            return
        try: 
            db_helperlib.checkSuperUser(self.returnValue[0])
        except:
            QMessageBox.critical(None, u'Authentifizierung fehlgeschlagen', 
                        u"Der Benutzer %s hat keine Superuser-Rechte!" % self.returnValue[0], 
                        'Ok', '', '', 0, -1)
            return
            
        db_helperlib.dropDb('badoV4')
        db_helperlib.createDb('badoV4')
        db_helperlib.disconnectFromDb()
        #print 'badoV4', 'postgres', 'localhost', '5432', auth[1]
        db_helperlib.connectToDb(dbname='badoV4', user='postgres', host='localhost', port='5432', password=self.returnValue[1])
        
        fileHandler = codecs.open(os.path.abspath(os.path.normcase(unicode('db/tables.sql'))),'r','utf8')
        query = fileHandler.read()
        #print query
        db_helperlib.query_execute(query)
        
        fileHandler = codecs.open(os.path.abspath(os.path.normcase(unicode('db/functions.sql'))),'r','utf8')
        query = fileHandler.read()
        #print query
        db_helperlib.query_execute(query)
        fileHandler = codecs.open(os.path.abspath(os.path.normcase(unicode('db/inserts.sql'))),'r','utf8')
        query = fileHandler.read()
        #print query
        db_helperlib.query_execute(query)
        fileHandler = codecs.open(os.path.abspath(os.path.normcase(unicode('db/views.sql'))),'r','utf8')
        query = fileHandler.read()
        #print query
        db_helperlib.query_execute(query)
        fileHandler = codecs.open(os.path.abspath(os.path.normcase(unicode('db/privileges.sql'))),'r','utf8')
        query = fileHandler.read()
        #print query
        db_helperlib.query_execute(query)
        db_helperlib.disconnectFromDb()
        self.close()    
        QApplication.instance().quit()