
BEGIN;
DROP TABLE IF EXISTS isr_depressionscore;
COMMIT;
BEGIN;
    SELECT
        d.id, d2.eintrag_id, 
        ( CASE WHEN w01.valid = 1 THEN w01.typ ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.typ ELSE 0 END + 
          CASE WHEN w03.valid = 1 THEN w03.typ ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.typ ELSE 0 END) /
          CAST ( CASE WHEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.valid ELSE 0 END) <> 0
            THEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.valid ELSE 0 END)
            ELSE 1 END AS REAL ) AS score,
        w01.valid > -10 OR w02.valid > -10 OR w03.valid > -10  OR w04.valid > -10 AS valid
    INTO isr_depressionscore
    FROM datensatz_view d 
         LEFT OUTER JOIN isr_datensatz d2 ON d.id = d2.id 
         LEFT OUTER JOIN isr_d01 w01 ON d2.eintrag_id = w01.eintrag_id
         LEFT OUTER JOIN isr_d02 w02 ON d2.eintrag_id = w02.eintrag_id
         LEFT OUTER JOIN isr_d03 w03 ON d2.eintrag_id = w03.eintrag_id
         LEFT OUTER JOIN isr_d05 w04 ON d2.eintrag_id = w04.eintrag_id
    WHERE   
        d.valid AND d2.valid > 0
    ;
CREATE INDEX isr_depressionscore_id ON isr_depressionscore(id);
COMMIT;

BEGIN;
DROP TABLE IF EXISTS isr_depr_schweregrad;
COMMIT;
BEGIN;
    SELECT d.id, d2.eintrag_id,
        i.score AS score,
        1 + INT4(i.score >= 0.75) + INT4(i.score >= 1) + INT4(i.score >= 2) + INT4(i.score >= 3) AS grad,
        i.valid AS valid
    INTO isr_depr_schweregrad
    FROM datensatz_view d
        LEFT OUTER JOIN isr_datensatz d2 ON d.id = d2.id
        LEFT OUTER JOIN isr_depressionscore i ON d2.eintrag_id = i.eintrag_id
    WHERE d.valid AND d2.valid > 0;
CREATE INDEX isr_depr_schweregrad_id ON isr_depr_schweregrad(id);
COMMIT;

 

BEGIN;
DROP TABLE IF EXISTS isr_angstscore;
COMMIT;
BEGIN;
    SELECT
        d.id, d2.eintrag_id,
        ( CASE WHEN w01.valid = 1 THEN w01.typ ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.typ ELSE 0 END +
          CASE WHEN w03.valid = 1 THEN w03.typ ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.typ ELSE 0 END) /
          CAST ( CASE WHEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.valid ELSE 0 END) <> 0
            THEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.valid ELSE 0 END)
            ELSE 1 END AS REAL ) AS score,
        w01.valid > -10 OR w02.valid > -10 OR w03.valid > -10  OR w04.valid > -10 AS valid
    INTO isr_angstscore
    FROM datensatz_view d 
        LEFT OUTER JOIN isr_datensatz d2  ON d.id = d2.id
        LEFT OUTER JOIN isr_a01 w01       ON d2.eintrag_id = w01.eintrag_id  
        LEFT OUTER JOIN isr_a02 w02       ON d2.eintrag_id = w02.eintrag_id
        LEFT OUTER JOIN isr_a03 w03       ON d2.eintrag_id = w03.eintrag_id
        LEFT OUTER JOIN isr_a04 w04       ON d2.eintrag_id = w04.eintrag_id
    WHERE  d.valid 
        AND d2.valid > 0;
CREATE INDEX isr_angstscore_id ON isr_angstscore(id);
COMMIT;

BEGIN;
DROP TABLE IF EXISTS isr_angst_schweregrad;
COMMIT;
BEGIN;
    SELECT d.id, d2.eintrag_id,
        i.score AS score,
        1 + INT4(i.score >= 0.75) + INT4(i.score >= 1) + INT4(i.score >= 2) + INT4(i.score >= 3) AS grad,
        i.valid AS valid
    INTO isr_angst_schweregrad
    FROM datensatz_view d
        LEFT OUTER JOIN isr_angstscore i ON d.id = i.id 
        LEFT OUTER JOIN isr_datensatz d2 ON i.eintrag_id = d2.eintrag_id
    WHERE d.valid AND d2.valid > 0;
CREATE INDEX isr_angst_schweregrad_id ON isr_angst_schweregrad(id);
COMMIT;



BEGIN;
DROP TABLE IF EXISTS isr_zwangscore;
COMMIT;
BEGIN;
    SELECT
        d.id, d2.eintrag_id,
        ( CASE WHEN w01.valid = 1 THEN w01.typ ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.typ ELSE 0 END +
          CASE WHEN w03.valid = 1 THEN w03.typ ELSE 0 END) /
          CAST ( CASE WHEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END) <> 0
            THEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END)
            ELSE 1 END AS REAL ) AS score,
        w01.valid > -10 OR w02.valid > -10 OR w03.valid > -10 AS valid
    INTO isr_zwangscore
    FROM datensatz_view d 
        LEFT OUTER JOIN isr_datensatz d2   ON d.id = d2.id
        LEFT OUTER JOIN isr_z01 w01        ON d2.eintrag_id = w01.eintrag_id 
        LEFT OUTER JOIN isr_z02 w02        ON d2.eintrag_id = w02.eintrag_id
        LEFT OUTER JOIN isr_z03 w03        ON d2.eintrag_id = w03.eintrag_id
    WHERE d.valid
        AND d2.valid > 0;
CREATE INDEX isr_zwangscore_id ON isr_zwangscore(id);
COMMIT;


BEGIN;
DROP TABLE IF EXISTS isr_zwang_schweregrad;
COMMIT;
BEGIN;
    SELECT d.id, d2.eintrag_id,
        i.score AS score,
        1 + INT4(i.score >= 0.65) + INT4(i.score >= 1) + INT4(i.score >= 2) + INT4(i.score >= 3) AS grad,
        i.valid AS valid
    INTO isr_zwang_schweregrad
    FROM datensatz_view d
        LEFT OUTER JOIN isr_datensatz d2 ON d2.id = d.id
        LEFT OUTER JOIN isr_zwangscore i ON i.eintrag_id = d2.eintrag_id 
    WHERE d.valid AND d2.valid > 0;
CREATE INDEX isr_zwang_schweregrad_id ON isr_zwang_schweregrad(id);
COMMIT;


BEGIN;
DROP TABLE IF EXISTS isr_somatisierungscore;
COMMIT;
BEGIN;
    SELECT
        d.id, d2.eintrag_id,
        ( CASE WHEN w01.valid = 1 THEN w01.typ ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.typ ELSE 0 END +
          CASE WHEN w03.valid = 1 THEN w03.typ ELSE 0 END) /
          CAST ( CASE WHEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END) <> 0
            THEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END)
            ELSE 1 END AS REAL ) AS score,
        w01.valid > -10 OR w02.valid > -10 OR w03.valid > -10 AS valid
    INTO isr_somatisierungscore
    FROM datensatz_view d 
        LEFT OUTER JOIN isr_datensatz d2  ON d.id = d2.id
        LEFT OUTER JOIN isr_s01 w01       ON d2.eintrag_id = w01.eintrag_id 
        LEFT OUTER JOIN isr_s02 w02       ON d2.eintrag_id = w02.eintrag_id
        LEFT OUTER JOIN isr_s03 w03       ON d2.eintrag_id = w03.eintrag_id
    WHERE d.valid
        AND d2.valid > 0;
CREATE INDEX isr_somatisierungscore_id ON isr_somatisierungscore(id);
COMMIT;


BEGIN;
DROP TABLE IF EXISTS isr_soma_schweregrad;
COMMIT;
BEGIN;
    SELECT d.id, d2.eintrag_id,
        i.score AS score,
        1 + INT4(i.score >= 0.32) + INT4(i.score >= 0.75) + INT4(i.score >= 1.25) + INT4(i.score >= 2.65) AS grad,
        i.valid AS valid
    INTO isr_soma_schweregrad
    FROM datensatz_view d
        LEFT OUTER JOIN isr_datensatz d2         ON d.id = d2.id
        LEFT OUTER JOIN isr_somatisierungscore i ON i.eintrag_id = d2.eintrag_id 
    WHERE d.valid AND d2.valid > 0;
CREATE INDEX isr_soma_schweregrad_id ON isr_soma_schweregrad(id);
COMMIT;


BEGIN;
DROP TABLE IF EXISTS isr_essstoerungscore;
COMMIT;
BEGIN;
    SELECT
        d.id, d2.eintrag_id,
        ( CASE WHEN w01.valid = 1 THEN w01.typ ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.typ ELSE 0 END +
          CASE WHEN w03.valid = 1 THEN w03.typ ELSE 0 END) /
          CAST ( CASE WHEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END) <> 0
            THEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END)
            ELSE 1 END AS REAL ) AS score,
        w01.valid > -10 OR w02.valid > -10 OR w03.valid > -10 AS valid
    INTO isr_essstoerungscore
    FROM datensatz_view d 
        LEFT OUTER JOIN isr_datensatz d2   ON d.id = d2.id
        LEFT OUTER JOIN isr_e01 w01        ON d2.eintrag_id = w01.eintrag_id 
        LEFT OUTER JOIN isr_e02 w02        ON d2.eintrag_id = w02.eintrag_id
        LEFT OUTER JOIN isr_e03 w03        ON d2.eintrag_id = w03.eintrag_id
    WHERE d.valid
        AND d2.valid > 0;
CREATE INDEX isr_essstoerungscore_id ON isr_essstoerungscore(id);
COMMIT;

BEGIN;
DROP TABLE IF EXISTS isr_ess_schweregrad;
COMMIT;
BEGIN;
    SELECT d.id, d2.eintrag_id,
        i.score AS score,
        1 + INT4(i.score >= 0.32) + INT4(i.score >= 0.65) + INT4(i.score >= 1.5) + INT4(i.score >= 2.75) AS grad,
        i.valid AS valid
    INTO isr_ess_schweregrad
    FROM datensatz_view d
        LEFT OUTER JOIN isr_datensatz d2       ON d.id = d2.id
        LEFT OUTER JOIN isr_essstoerungscore i ON i.eintrag_id = d2.eintrag_id 
    WHERE d.valid AND d2.valid > 0;
CREATE INDEX isr_ess_schweregrad_id ON isr_ess_schweregrad(id);
COMMIT;



BEGIN;
DROP TABLE IF EXISTS isr_zusatzscore;
COMMIT;
BEGIN;
    SELECT
        d.id,  d2.eintrag_id,
        ( CASE WHEN w01.valid = 1 THEN w01.typ ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.typ ELSE 0 END +
          CASE WHEN w03.valid = 1 THEN w03.typ ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.typ ELSE 0 END +
          CASE WHEN w05.valid = 1 THEN w05.typ ELSE 0 END + CASE WHEN w06.valid = 1 THEN w06.typ ELSE 0 END +
          CASE WHEN w07.valid = 1 THEN w07.typ ELSE 0 END + CASE WHEN w08.valid = 1 THEN w08.typ ELSE 0 END +
          CASE WHEN w09.valid = 1 THEN w09.typ ELSE 0 END + CASE WHEN w10.valid = 1 THEN w10.typ ELSE 0 END +
          CASE WHEN w11.valid = 1 THEN w11.typ ELSE 0 END + CASE WHEN w12.valid = 1 THEN w12.typ ELSE 0 END) /
          CAST ( CASE WHEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.valid ELSE 0 END +
            CASE WHEN w05.valid = 1 THEN w05.valid ELSE 0 END + CASE WHEN w06.valid = 1 THEN w06.valid ELSE 0 END +
            CASE WHEN w07.valid = 1 THEN w07.valid ELSE 0 END + CASE WHEN w08.valid = 1 THEN w08.valid ELSE 0 END +
            CASE WHEN w09.valid = 1 THEN w09.valid ELSE 0 END + CASE WHEN w10.valid = 1 THEN w10.valid ELSE 0 END +
            CASE WHEN w11.valid = 1 THEN w11.valid ELSE 0 END + CASE WHEN w12.valid = 1 THEN w12.valid ELSE 0 END ) <> 0
            THEN
          ( CASE WHEN w01.valid = 1 THEN w01.valid ELSE 0 END + CASE WHEN w02.valid = 1 THEN w02.valid ELSE 0 END +
            CASE WHEN w03.valid = 1 THEN w03.valid ELSE 0 END + CASE WHEN w04.valid = 1 THEN w04.valid ELSE 0 END +
            CASE WHEN w05.valid = 1 THEN w05.valid ELSE 0 END + CASE WHEN w06.valid = 1 THEN w06.valid ELSE 0 END +
            CASE WHEN w07.valid = 1 THEN w07.valid ELSE 0 END + CASE WHEN w08.valid = 1 THEN w08.valid ELSE 0 END +
            CASE WHEN w09.valid = 1 THEN w09.valid ELSE 0 END + CASE WHEN w10.valid = 1 THEN w10.valid ELSE 0 END +
            CASE WHEN w11.valid = 1 THEN w11.valid ELSE 0 END + CASE WHEN w12.valid = 1 THEN w12.valid ELSE 0 END )
            ELSE 1 END AS REAL ) AS score,
        w01.valid > -10 OR w02.valid > -10 OR w03.valid > -10 OR w04.valid > -10 OR 
        w05.valid > -10 OR w06.valid > -10 OR w07.valid > -10 OR w08.valid > -10 OR 
        w09.valid > -10 OR w10.valid > -10 OR w11.valid > -10 OR w12.valid > -10 AS valid 
    INTO isr_zusatzscore
    FROM datensatz_view d 
        LEFT OUTER JOIN isr_datensatz d2 ON d.id = d2.id
        LEFT OUTER JOIN isr_d04 w01      ON d2.eintrag_id = w01.eintrag_id 
        LEFT OUTER JOIN isr_d10 w02      ON d2.eintrag_id = w02.eintrag_id  
        LEFT OUTER JOIN isr_d11 w03      ON d2.eintrag_id = w03.eintrag_id  
        LEFT OUTER JOIN isr_d12 w04      ON d2.eintrag_id = w04.eintrag_id  
        LEFT OUTER JOIN isr_w01 w05      ON d2.eintrag_id = w05.eintrag_id  
        LEFT OUTER JOIN isr_w02 w06      ON d2.eintrag_id = w06.eintrag_id 
        LEFT OUTER JOIN isr_w03 w07      ON d2.eintrag_id = w07.eintrag_id  
        LEFT OUTER JOIN isr_w05 w08      ON d2.eintrag_id = w08.eintrag_id  
        LEFT OUTER JOIN isr_w06 w09      ON d2.eintrag_id = w09.eintrag_id  
        LEFT OUTER JOIN isr_w07 w10      ON d2.eintrag_id = w10.eintrag_id  
        LEFT OUTER JOIN isr_w08 w11      ON d2.eintrag_id = w11.eintrag_id  
        LEFT OUTER JOIN isr_w09 w12      ON d2.eintrag_id = w12.eintrag_id  
    WHERE 
        d.valid
        AND d2.valid > 0;
CREATE INDEX isr_zusatzscore_id ON isr_zusatzscore(id);
COMMIT;


BEGIN;
DROP TABLE IF EXISTS isr_gesamtscore;
COMMIT;
BEGIN;
    SELECT
        d.id,  d2.eintrag_id,
        ( CASE WHEN w01.valid THEN w01.score ELSE 0 END + CASE WHEN w02.valid THEN w02.score ELSE 0 END +
          CASE WHEN w03.valid THEN w03.score ELSE 0 END + CASE WHEN w04.valid THEN w04.score ELSE 0 END +
          CASE WHEN w05.valid THEN w05.score ELSE 0 END + CASE WHEN w06.valid THEN w06.score*2 ELSE 0 END ) /
          CAST ( CASE WHEN
          ( CASE WHEN w01.valid THEN 1 ELSE 0 END + CASE WHEN w02.valid THEN 1 ELSE 0 END +
            CASE WHEN w03.valid THEN 1 ELSE 0 END + CASE WHEN w04.valid THEN 1 ELSE 0 END +
            CASE WHEN w05.valid THEN 1 ELSE 0 END + CASE WHEN w06.valid THEN 1 ELSE 0 END ) <> 0
            THEN
          ( CASE WHEN w01.valid THEN 1 ELSE 0 END + CASE WHEN w02.valid THEN 1 ELSE 0 END +
            CASE WHEN w03.valid THEN 1 ELSE 0 END + CASE WHEN w04.valid THEN 1 ELSE 0 END +
            CASE WHEN w05.valid THEN 1 ELSE 0 END + CASE WHEN w06.valid THEN 2 ELSE 0 END )
            ELSE 1 END AS REAL ) AS score,
        w01.valid OR w02.valid OR w03.valid OR w04.valid OR 
        w05.valid OR w06.valid AS valid 
    INTO isr_gesamtscore
    FROM datensatz_view d 
        LEFT OUTER JOIN isr_datensatz d2            ON d.id = d2.id
        LEFT OUTER JOIN isr_depressionscore w01     ON d2.eintrag_id = w01.eintrag_id                       
        LEFT OUTER JOIN isr_angstscore w02          ON d2.eintrag_id = w02.eintrag_id                  
        LEFT OUTER JOIN isr_zwangscore w03          ON d2.eintrag_id = w03.eintrag_id                  
        LEFT OUTER JOIN isr_somatisierungscore w04  ON d2.eintrag_id = w04.eintrag_id                          
        LEFT OUTER JOIN isr_essstoerungscore w05    ON d2.eintrag_id = w05.eintrag_id                        
        LEFT OUTER JOIN isr_zusatzscore w06         ON d2.eintrag_id = w06.eintrag_id                   
    WHERE 
        d.valid
        AND d2.valid > 0;
CREATE INDEX isr_gesamtscore_id ON isr_gesamtscore(id);
COMMIT;

BEGIN;
DROP TABLE IF EXISTS isr_gesamt_schweregrad;
COMMIT;
BEGIN;
    SELECT d.id, d2.eintrag_id,
        i.score AS score,
        1 + INT4(i.score >= 0.5)+ INT4(i.score >= 0.6) + INT4(i.score >= 0.9) + INT4(i.score >= 1.7) AS grad,
        i.valid AS valid
    INTO isr_gesamt_schweregrad
    FROM datensatz_view d
        LEFT OUTER JOIN isr_datensatz d2  ON d.id = d2.id
        LEFT OUTER JOIN isr_gesamtscore i ON i.eintrag_id = d2.eintrag_id
    WHERE d.valid AND d2.valid > 0;
CREATE INDEX isr_gesamt_schweregrad_id ON isr_gesamt_schweregrad(id);
COMMIT;


BEGIN;
DROP TABLE IF EXISTS gaf_schweregrad;
COMMIT;
BEGIN;
    SELECT d.id,
        i.typ,
        1 + INT4(i.typ < 8) + INT4(i.typ < 7) + INT4(i.typ < 6) + INT4(i.typ < 5 AND i.typ > 0)AS grad,
        i.valid AS valid
    INTO gaf_schweregrad
    FROM datensatz_view d
        LEFT OUTER JOIN gaf_a i ON i.id = d.id
    WHERE d.valid AND i.valid > 0;
CREATE INDEX gaf_schweregrad_id ON gaf_schweregrad(id);
COMMIT;



DROP VIEW IF EXISTS index1 CASCADE;

CREATE VIEW index1

AS

WITH psycat AS (
SELECT
p.id,
coalesce(array_to_string(array_agg(t.key ORDER BY p.seq_nr),',','')::text,'') AS diag,
coalesce(array_to_string(array_agg(p.sicher::text ORDER BY p.seq_nr),',','')::text,'') AS sicher
FROM
psychische_diagnose p
JOIN diagnose_typ t ON p.typ = t.id

GROUP BY p.id),




somacat AS (
SELECT
p.id,
coalesce(array_to_string(array_agg(t.key ORDER BY p.seq_nr),',','')::text,'') AS diag,
coalesce(array_to_string(array_agg(p.sicher::text ORDER BY p.seq_nr),',','')::text,'') AS sicher
FROM
somatische_diagnose p
JOIN diagnose_typ t ON p.typ = t.id

GROUP BY p.id ORDER BY p.id)


SELECT
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[      
coalesce(1::text,''),
coalesce(d.behandler_nr::text,'')        ,
coalesce(d.sub_behandler_nr::text,'')    ,
coalesce(d.patienten_nr::text,'')       ,
coalesce(n1.typ::text,'')                ,
coalesce(to_char(n2.datum ,'DD.MM.YYYY')::text,'')             ,
coalesce(n3.typ::text,'')                ,
coalesce(n4.typ::text,'')                ,
coalesce(n5.typ::text,'')                ,
coalesce(n6.typ::text,'')                ,
coalesce(n7.typ::text,'')                ,
coalesce(n8.typ::text,'')                ,
coalesce(n9.anzahl::text,'')             ,
coalesce(n10.typ::text,'')               ,
coalesce(n11.typ::text,'')               ,
coalesce(n12.typ::text,'')               ,
coalesce(n13.typ::text,'')               ,
coalesce(n14.diag::text,'')              ,
coalesce(n14.sicher::text,'')              ,
coalesce(n16.diag::text,'')              ,
coalesce(n16.sicher::text,'')              ,
coalesce(n18.typ::text,'')               ,
coalesce(n19.typ::text,'')               
],'|') AS index1
FROM

datensatz d                         
LEFT JOIN versorgungsbereich             n1 ON n1.id=d.id
LEFT JOIN aufnahmedatum                  n2 ON n2.id=d.id
LEFT JOIN kostentraeger                  n3 ON n3.id=d.id
LEFT JOIN abrechnungsart                 n4 ON n4.id=d.id
LEFT JOIN einweiser                      n5 ON n5.id=d.id
LEFT JOIN barriere                       n6 ON n6.id=d.id
LEFT JOIN rentenbegehren                 n7 ON n7.id=d.id
LEFT JOIN suizidversuch                  n8 ON n8.id=d.id
LEFT JOIN suizidversuch_anzahl           n9 ON n9.id=d.id
LEFT JOIN motivation                     n10 ON n10.id=d.id
LEFT JOIN anamnese_gesamt                n11 ON n11.id=d.id
LEFT JOIN anamnese_aktuell               n12 ON n12.id=d.id
LEFT JOIN hauptdiagnose                  n13 ON n13.id=d.id
LEFT JOIN psycat                         n14 ON n14.id=d.id
LEFT JOIN somacat                        n16 ON n16.id=d.id
LEFT JOIN gaf_a                          n18 ON n18.id=d.id
LEFT JOIN garf_a                         n19 ON n19.id=d.id

WHERE

(n1.typ    IS NOT NULL OR
n2.datum   IS NOT NULL OR
n3.typ     IS NOT NULL OR
n4.typ     IS NOT NULL OR
n5.typ     IS NOT NULL OR
n6.typ     IS NOT NULL OR
n7.typ     IS NOT NULL OR
n8.typ     IS NOT NULL OR
n9.anzahl  IS NOT NULL OR
n10.typ    IS NOT NULL OR
n11.typ    IS NOT NULL OR
n12.typ    IS NOT NULL OR
n13.typ    IS NOT NULL OR
n14.diag   IS NOT NULL OR
n14.sicher IS NOT NULL OR
n16.diag   IS NOT NULL OR
n16.sicher IS NOT NULL OR
n18.typ    IS NOT NULL OR
n19.typ    IS NOT NULL) ORDER BY d.id;


DROP VIEW IF EXISTS index1_v CASCADE;

CREATE VIEW index1_v

AS

WITH psycat AS (
SELECT
p.id,
coalesce(array_to_string(array_agg(t.key ORDER BY p.seq_nr),',','')::text,'') AS diag,
coalesce(array_to_string(array_agg(p.sicher::text ORDER BY p.seq_nr),',','')::text,'') AS sicher,
coalesce(array_to_string(array_agg(p.valid::text ORDER BY p.seq_nr),',','')::text,'') AS valid
FROM
psychische_diagnose p
JOIN diagnose_typ t ON p.typ = t.id

GROUP BY p.id ORDER BY p.id),




somacat AS (
SELECT
p.id,
coalesce(array_to_string(array_agg(t.key ORDER BY p.seq_nr),',','')::text,'') AS diag,
coalesce(array_to_string(array_agg(p.sicher::text ORDER BY p.seq_nr),',','')::text,'') AS sicher,
coalesce(array_to_string(array_agg(p.valid::text ORDER BY p.seq_nr),',','')::text,'') AS valid
FROM
somatische_diagnose p
JOIN diagnose_typ t ON p.typ = t.id

GROUP BY p.id ORDER BY p.id)




SELECT
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[      
coalesce(1::text,''),
coalesce(1::text,'')        ,
coalesce(1::text,'')    ,
coalesce(1::text,'')       ,
coalesce(n1.valid::text,'')                ,
coalesce(n2.valid::text,'')             ,
coalesce(n3.valid::text,'')                ,
coalesce(n4.valid::text,'')                ,
coalesce(n5.valid::text,'')                ,
coalesce(n6.valid::text,'')                ,
coalesce(n7.valid::text,'')                ,
coalesce(n8.valid::text,'')                ,
coalesce(n9.valid::text,'')             ,
coalesce(n10.valid::text,'')               ,
coalesce(n11.valid::text,'')               ,
coalesce(n12.valid::text,'')               ,
coalesce(n13.valid::text,'')               ,
coalesce(n14.valid::text,'')              ,
coalesce(n14.valid::text,'')              ,
coalesce(n16.valid::text,'')              ,
coalesce(n16.valid::text,'')              ,
coalesce(n18.valid::text,'')               ,
coalesce(n19.valid::text,'')               
],'|') AS index1
FROM

datensatz d                         
LEFT JOIN versorgungsbereich             n1 ON n1.id=d.id
LEFT JOIN aufnahmedatum                  n2 ON n2.id=d.id
LEFT JOIN kostentraeger                  n3 ON n3.id=d.id
LEFT JOIN abrechnungsart                 n4 ON n4.id=d.id
LEFT JOIN einweiser                      n5 ON n5.id=d.id
LEFT JOIN barriere                       n6 ON n6.id=d.id
LEFT JOIN rentenbegehren                 n7 ON n7.id=d.id
LEFT JOIN suizidversuch                  n8 ON n8.id=d.id
LEFT JOIN suizidversuch_anzahl           n9 ON n9.id=d.id
LEFT JOIN motivation                     n10 ON n10.id=d.id
LEFT JOIN anamnese_gesamt                n11 ON n11.id=d.id
LEFT JOIN anamnese_aktuell               n12 ON n12.id=d.id
LEFT JOIN hauptdiagnose                  n13 ON n13.id=d.id
LEFT JOIN psycat                         n14 ON n14.id=d.id
LEFT JOIN somacat                        n16 ON n16.id=d.id
LEFT JOIN gaf_a                          n18 ON n18.id=d.id
LEFT JOIN garf_a                         n19 ON n19.id=d.id

WHERE

(n1.typ    IS NOT NULL OR
n2.datum   IS NOT NULL OR
n3.typ     IS NOT NULL OR
n4.typ     IS NOT NULL OR
n5.typ     IS NOT NULL OR
n6.typ     IS NOT NULL OR
n7.typ     IS NOT NULL OR
n8.typ     IS NOT NULL OR
n9.anzahl  IS NOT NULL OR
n10.typ    IS NOT NULL OR
n11.typ    IS NOT NULL OR
n12.typ    IS NOT NULL OR
n13.typ    IS NOT NULL OR
n14.diag   IS NOT NULL OR
n14.sicher IS NOT NULL OR
n16.diag   IS NOT NULL OR
n16.sicher IS NOT NULL OR
n18.typ    IS NOT NULL OR
n19.typ    IS NOT NULL) ORDER BY d.id;



DROP VIEW IF EXISTS index2;

CREATE VIEW index2

AS

WITH behandcat AS (
SELECT
b.id,
coalesce(array_to_string(array_agg(b.typ::text),',','')::text,'') AS typ
FROM
behandlungsempfehlung b

GROUP BY b.id ORDER BY b.id),

nationkey AS (
SELECT 
nation.id, 
coalesce(nation_typ.key::text,'') AS key, 
coalesce(nation.valid::text,'') AS valid
FROM
nation 
LEFT JOIN nation_typ ON nation.typ = nation_typ.id ORDER BY nation.id)


SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(2::text,''),
coalesce(d.behandler_nr::text,''),
coalesce(d.sub_behandler_nr::text,''),
coalesce(d.patienten_nr::text,''),
coalesce(n1.typ::text,''),
coalesce(n2.typ::text,''),
coalesce(to_char(n3.datum ,'DD.MM.YYYY')::text,''), 
coalesce(n4.key::text,''),
coalesce(n5.typ::text,''),
coalesce(n6.typ::text,''),
coalesce(n7.typ::text,''),
coalesce(n8.anzahl::text,''),
coalesce(n9.typ::text,''),
coalesce(n10.typ::text,''),
coalesce(n11.typ::text,''),
coalesce(n12.typ::text,''),
coalesce(n13.typ::text,''),
coalesce(weeks(n14.dauer)::text,''),
coalesce(weeks(n15.dauer) ::text,''),
coalesce(n16.typ          ::text,''),
coalesce(n17.anzahl       ::text,''),
coalesce(weeks(n18.dauer) ::text,''),
coalesce(n19.anzahl       ::text,''),
coalesce(weeks(n20.dauer) ::text,''),
coalesce(n21.anzahl       ::text,''),
coalesce(n22.typ          ::text,''),
coalesce(n23.typ          ::text,''),
coalesce(n24.typ          ::text,'')
],'|') AS index2

FROM

datensatz d                         
LEFT JOIN  behandcat                n1 ON n1.id=d.id
LEFT JOIN  geschlecht               n2 ON n2.id=d.id
LEFT JOIN  geburtsdatum             n3 ON n3.id=d.id
LEFT JOIN  nationkey                n4 ON n4.id=d.id
LEFT JOIN  haushalt                 n5 ON n5.id=d.id
LEFT JOIN  partnersituation         n6 ON n6.id=d.id
LEFT JOIN  familienstand            n7 ON n7.id=d.id
LEFT JOIN  anzahl_kinder            n8 ON n8.id=d.id
LEFT JOIN  schulabschluss           n9 ON n9.id=d.id
LEFT JOIN  berufsabschluss          n10 ON n10.id=d.id
LEFT JOIN  berufstaetigkeit         n11 ON n11.id=d.id
LEFT JOIN  erwerbstaetigkeit        n12 ON n12.id=d.id
LEFT JOIN  haupteinkommen           n13 ON n13.id=d.id
LEFT JOIN  au_aufnahme              n14 ON n14.id=d.id
LEFT JOIN  au_gesamt                n15 ON n15.id=d.id
LEFT JOIN  rentenverfahren          n16 ON n16.id=d.id
LEFT JOIN  stat_vorbeh_anzahl       n17 ON n17.id=d.id
LEFT JOIN  stat_vorbeh_dauer        n18 ON n18.id=d.id
LEFT JOIN  teilstat_vorbeh_anzahl   n19 ON n19.id=d.id
LEFT JOIN  teilstat_vorbeh_dauer    n20 ON n20.id=d.id
LEFT JOIN  amb_vorbeh_anzahl        n21 ON n21.id=d.id
LEFT JOIN  amb_vorbeh_dauer         n22 ON n22.id=d.id
LEFT JOIN  amb_vorbeh_aufnahme      n23 ON n23.id=d.id
LEFT JOIN  pharma_aufnahme          n24 ON n24.id=d.id

WHERE

(n1.typ IS NOT NULL OR
n2.typ IS NOT NULL OR
n3.datum IS NOT NULL OR
n4.key IS NOT NULL OR
n5.typ IS NOT NULL OR
n6.typ IS NOT NULL OR
n7.typ IS NOT NULL OR
n8.anzahl IS NOT NULL OR
n9.typ  IS NOT NULL OR
n10.typ IS NOT NULL OR
n11.typ IS NOT NULL OR
n12.typ IS NOT NULL OR
n13.typ IS NOT NULL OR
weeks(n14.dauer) IS NOT NULL OR
weeks(n15.dauer) IS NOT NULL OR
n16.typ          IS NOT NULL OR
n17.anzahl       IS NOT NULL OR
weeks(n18.dauer) IS NOT NULL OR
n19.anzahl       IS NOT NULL OR
weeks(n20.dauer) IS NOT NULL OR
n21.anzahl       IS NOT NULL OR
n22.typ          IS NOT NULL OR
n23.typ          IS NOT NULL OR
n24.typ          IS NOT NULL) ORDER BY d.id;


DROP VIEW IF EXISTS index2_v;

CREATE VIEW index2_v

AS

WITH behandcat AS (
SELECT
b.id,
coalesce(array_to_string(array_agg(b.typ::text),',','')::text,'') AS typ,
coalesce(array_to_string(array_agg(b.valid::text),',','')::text,'') AS valid
FROM
behandlungsempfehlung b

GROUP BY b.id ORDER BY b.id),

nationkey AS (
SELECT 
nation.id, 
coalesce(nation_typ.key::text,'') AS key,
coalesce(nation.valid::text,'') AS valid
FROM
nation 
LEFT JOIN nation_typ ON nation.typ = nation_typ.id  ORDER BY nation.id)

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(2::text,''),
coalesce(1::text,''),
coalesce(1::text,''),
coalesce(1::text,''),
coalesce(n1.valid::text,''),
coalesce(n2.valid::text,''),
coalesce(n3.valid::text,''), 
coalesce(n4.valid::text,''),
coalesce(n5.valid::text,''),
coalesce(n6.valid::text,''),
coalesce(n7.valid::text,''),
coalesce(n8.valid::text,''),
coalesce(n9.valid::text,''),
coalesce(n10.valid::text,''),
coalesce(n11.valid::text,''),
coalesce(n12.valid::text,''),
coalesce(n13.valid::text,''),
coalesce(n14.valid::text,''),
coalesce(n15.valid ::text,''),
coalesce(n16.valid          ::text,''),
coalesce(n17.valid       ::text,''),
coalesce(n18.valid ::text,''),
coalesce(n19.valid       ::text,''),
coalesce(n20.valid ::text,''),
coalesce(n21.valid       ::text,''),
coalesce(n22.valid          ::text,''),
coalesce(n23.valid          ::text,''),
coalesce(n24.valid          ::text,'')
],'|') AS index2

FROM

datensatz d                         
LEFT JOIN  behandcat                n1 ON n1.id=d.id
LEFT JOIN  geschlecht               n2 ON n2.id=d.id
LEFT JOIN  geburtsdatum             n3 ON n3.id=d.id
LEFT JOIN  nationkey                n4 ON n4.id=d.id
LEFT JOIN  haushalt                 n5 ON n5.id=d.id
LEFT JOIN  partnersituation         n6 ON n6.id=d.id
LEFT JOIN  familienstand            n7 ON n7.id=d.id
LEFT JOIN  anzahl_kinder            n8 ON n8.id=d.id
LEFT JOIN  schulabschluss           n9 ON n9.id=d.id
LEFT JOIN  berufsabschluss          n10 ON n10.id=d.id
LEFT JOIN  berufstaetigkeit         n11 ON n11.id=d.id
LEFT JOIN  erwerbstaetigkeit        n12 ON n12.id=d.id
LEFT JOIN  haupteinkommen           n13 ON n13.id=d.id
LEFT JOIN  au_aufnahme              n14 ON n14.id=d.id
LEFT JOIN  au_gesamt                n15 ON n15.id=d.id
LEFT JOIN  rentenverfahren          n16 ON n16.id=d.id
LEFT JOIN  stat_vorbeh_anzahl       n17 ON n17.id=d.id
LEFT JOIN  stat_vorbeh_dauer        n18 ON n18.id=d.id
LEFT JOIN  teilstat_vorbeh_anzahl   n19 ON n19.id=d.id
LEFT JOIN  teilstat_vorbeh_dauer    n20 ON n20.id=d.id
LEFT JOIN  amb_vorbeh_anzahl        n21 ON n21.id=d.id
LEFT JOIN  amb_vorbeh_dauer         n22 ON n22.id=d.id
LEFT JOIN  amb_vorbeh_aufnahme      n23 ON n23.id=d.id
LEFT JOIN  pharma_aufnahme          n24 ON n24.id=d.id

WHERE

(n1.typ IS NOT NULL OR
n2.typ IS NOT NULL OR
n3.datum IS NOT NULL OR
n4.key IS NOT NULL OR
n5.typ IS NOT NULL OR
n6.typ IS NOT NULL OR
n7.typ IS NOT NULL OR
n8.anzahl IS NOT NULL OR
n9.typ  IS NOT NULL OR
n10.typ IS NOT NULL OR
n11.typ IS NOT NULL OR
n12.typ IS NOT NULL OR
n13.typ IS NOT NULL OR
weeks(n14.dauer) IS NOT NULL OR
weeks(n15.dauer) IS NOT NULL OR
n16.typ          IS NOT NULL OR
n17.anzahl       IS NOT NULL OR
weeks(n18.dauer) IS NOT NULL OR
n19.anzahl       IS NOT NULL OR
weeks(n20.dauer) IS NOT NULL OR
n21.anzahl       IS NOT NULL OR
n22.typ          IS NOT NULL OR
n23.typ          IS NOT NULL OR
n24.typ          IS NOT NULL) ORDER BY d.id;



DROP VIEW IF EXISTS index3;

CREATE VIEW index3

AS

WITH weitercat AS (
SELECT
b.id,
array_to_string(array_agg(b.typ::text),',','') AS typ
FROM
weiterbehandlung b

GROUP BY b.id ORDER BY b.id)


SELECT
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(3                     ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(to_char(n1.datum ,'DD.MM.YYYY')::text,''),               
coalesce(days(n2.dauer)        ::text,''),     
coalesce(n3.anzahl             ::text,''),
coalesce(n4.typ                ::text,''),
coalesce(n5.typ                ::text,''),
coalesce(n6.typ                ::text,''),
coalesce(n7.typ                ::text,''),
coalesce(n8.typ                ::text,''),
coalesce(n9.typ                ::text,''),
coalesce(n10.typ               ::text,''),
coalesce(n11.anzahl            ::text,''),
coalesce(n12.typ               ::text,''),
coalesce(n13.typ               ::text,''),
coalesce(n14.typ               ::text,''),
coalesce(n15.typ               ::text,''),
coalesce(n16.typ               ::text,'')
],'|') AS index3

FROM

datensatz d                         
LEFT JOIN entlassungsdatum                n1 ON n1.id=d.id
LEFT JOIN behandlungsdauer                n2 ON n2.id=d.id
LEFT JOIN anzahl_sitzungen                n3 ON n3.id=d.id
LEFT JOIN beendigungsart                  n4 ON n4.id=d.id
LEFT JOIN af_entlassung                   n5 ON n5.id=d.id
LEFT JOIN alltagspflichten_therapeut      n6 ON n6.id=d.id
LEFT JOIN aenderung_koerperlich_therapeut n7 ON n7.id=d.id
LEFT JOIN aenderung_psychisch_therapeut   n8 ON n8.id=d.id
LEFT JOIN gaf_e                           n9 ON n9.id=d.id
LEFT JOIN garf_e                          n10 ON n10.id=d.id
LEFT JOIN vev_k                           n11 ON n11.id=d.id
LEFT JOIN medikation_antidepressiva       n12 ON n12.id=d.id
LEFT JOIN medikation_anxiolytika          n13 ON n13.id=d.id
LEFT JOIN medikation_neuroleptika         n14 ON n14.id=d.id
LEFT JOIN medikation_analgetika           n15 ON n15.id=d.id
LEFT JOIN weitercat                       n16 ON n16.id=d.id

WHERE

(n1.datum             IS NOT NULL OR                
days(n2.dauer)        IS NOT NULL OR     
n3.anzahl             IS NOT NULL OR
n4.typ                IS NOT NULL OR
n5.typ                IS NOT NULL OR
n6.typ                IS NOT NULL OR
n7.typ                IS NOT NULL OR
n8.typ                IS NOT NULL OR
n9.typ                IS NOT NULL OR
n10.typ               IS NOT NULL OR
n11.anzahl            IS NOT NULL OR
n12.typ               IS NOT NULL OR
n13.typ               IS NOT NULL OR
n14.typ               IS NOT NULL OR
n15.typ               IS NOT NULL OR
n16.typ               IS NOT NULL) ORDER BY d.id;



DROP VIEW IF EXISTS index3_v;

CREATE VIEW index3_v

AS

WITH weitercat AS (
SELECT
b.id,
array_to_string(array_agg(b.typ::text),',','') AS typ,
array_to_string(array_agg(b.valid::text),',','') AS valid
FROM
weiterbehandlung b

GROUP BY b.id ORDER BY b.id)


SELECT
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(3                     ::text,''),
coalesce(1        ::text,''),
coalesce(1    ::text,''),
coalesce(1        ::text,''),
coalesce(n1.valid::text,''),               
coalesce(n2.valid        ::text,''),     
coalesce(n3.valid             ::text,''),
coalesce(n4.valid             ::text,''),
coalesce(n5.valid             ::text,''),
coalesce(n6.valid             ::text,''),
coalesce(n7.valid             ::text,''),
coalesce(n8.valid             ::text,''),
coalesce(n9.valid             ::text,''),
coalesce(n10.valid            ::text,''),
coalesce(n11.valid            ::text,''),
coalesce(n12.valid            ::text,''),
coalesce(n13.valid            ::text,''),
coalesce(n14.valid            ::text,''),
coalesce(n15.valid            ::text,''),
coalesce(n16.valid            ::text,'')
],'|') AS index3

FROM

datensatz d                         
LEFT JOIN entlassungsdatum                n1 ON n1.id=d.id
LEFT JOIN behandlungsdauer                n2 ON n2.id=d.id
LEFT JOIN anzahl_sitzungen                n3 ON n3.id=d.id
LEFT JOIN beendigungsart                  n4 ON n4.id=d.id
LEFT JOIN af_entlassung                   n5 ON n5.id=d.id
LEFT JOIN alltagspflichten_therapeut      n6 ON n6.id=d.id
LEFT JOIN aenderung_koerperlich_therapeut n7 ON n7.id=d.id
LEFT JOIN aenderung_psychisch_therapeut   n8 ON n8.id=d.id
LEFT JOIN gaf_e                           n9 ON n9.id=d.id
LEFT JOIN garf_e                          n10 ON n10.id=d.id
LEFT JOIN vev_k                           n11 ON n11.id=d.id
LEFT JOIN medikation_antidepressiva       n12 ON n12.id=d.id
LEFT JOIN medikation_anxiolytika          n13 ON n13.id=d.id
LEFT JOIN medikation_neuroleptika         n14 ON n14.id=d.id
LEFT JOIN medikation_analgetika           n15 ON n15.id=d.id
LEFT JOIN weitercat                       n16 ON n16.id=d.id

WHERE

(n1.datum             IS NOT NULL OR                
days(n2.dauer)        IS NOT NULL OR     
n3.anzahl             IS NOT NULL OR
n4.typ                IS NOT NULL OR
n5.typ                IS NOT NULL OR
n6.typ                IS NOT NULL OR
n7.typ                IS NOT NULL OR
n8.typ                IS NOT NULL OR
n9.typ                IS NOT NULL OR
n10.typ               IS NOT NULL OR
n11.anzahl            IS NOT NULL OR
n12.typ               IS NOT NULL OR
n13.typ               IS NOT NULL OR
n14.typ               IS NOT NULL OR
n15.typ               IS NOT NULL OR
n16.typ               IS NOT NULL) ORDER BY d.id;



DROP VIEW IF EXISTS index4;

CREATE VIEW index4

AS


SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(4                     ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(n1.typ                ::text,''),
coalesce(n2.typ                ::text,''),
coalesce(n3.typ                ::text,''),
coalesce(n4.typ                ::text,''),
coalesce(n5.typ                ::text,''),
coalesce(n6.typ                ::text,''),
coalesce(n7.typ                ::text,''),
coalesce(n8.typ                ::text,''),
coalesce(n9.typ                ::text,''),
coalesce(n10.typ               ::text,''),
coalesce(n11.typ               ::text,''),
coalesce(n12.typ               ::text,''),
coalesce(n13.typ               ::text,''),
coalesce(n14.typ               ::text,''),
coalesce(n15.typ               ::text,''),
coalesce(n16.typ               ::text,''),
coalesce(n17.typ               ::text,''),
coalesce(n18.typ               ::text,''),
coalesce(n19.typ               ::text,''),
coalesce(n20.typ               ::text,'')
],'|') AS index4

FROM

datensatz d                         
LEFT JOIN alltagspflichten_patient             n1 ON n1.id=d.id
LEFT JOIN zuf_1                                n2 ON n2.id=d.id
LEFT JOIN zuf_2                                n3 ON n3.id=d.id
LEFT JOIN zuf_3                                n4 ON n4.id=d.id
LEFT JOIN zuf_4                                n5 ON n5.id=d.id
LEFT JOIN zuf_5                                n6 ON n6.id=d.id
LEFT JOIN zuf_6                                n7 ON n7.id=d.id
LEFT JOIN zuf_7                                n8 ON n8.id=d.id
LEFT JOIN zuf_8                                n9 ON n9.id=d.id
LEFT JOIN aenderung_koerperlich_patient        n10 ON n10.id=d.id
LEFT JOIN aenderung_psychisch_patient          n11 ON n11.id=d.id
LEFT JOIN aenderung_selbstwerterleben          n12 ON n12.id=d.id
LEFT JOIN aenderung_sozial                     n13 ON n13.id=d.id
LEFT JOIN aenderung_privat                     n14 ON n14.id=d.id
LEFT JOIN aenderung_beruflich                  n15 ON n15.id=d.id
LEFT JOIN aenderung_eigenaktivitaet            n16 ON n16.id=d.id
LEFT JOIN aenderung_krankheitsverstaendnis     n17 ON n17.id=d.id
LEFT JOIN aenderung_zukunft                    n18 ON n18.id=d.id
LEFT JOIN aenderung_befinden                   n19 ON n19.id=d.id
LEFT JOIN aenderung_alltag                      n20 ON n20.id=d.id

WHERE

(n1.typ              IS NOT NULL OR
n2.typ              IS NOT NULL OR
n3.typ              IS NOT NULL OR
n4.typ              IS NOT NULL OR
n5.typ              IS NOT NULL OR
n6.typ              IS NOT NULL OR
n7.typ              IS NOT NULL OR
n8.typ              IS NOT NULL OR
n9.typ              IS NOT NULL OR
n10.typ             IS NOT NULL OR
n11.typ             IS NOT NULL OR
n12.typ             IS NOT NULL OR
n13.typ             IS NOT NULL OR
n14.typ             IS NOT NULL OR
n15.typ             IS NOT NULL OR
n16.typ             IS NOT NULL OR
n17.typ             IS NOT NULL OR
n18.typ             IS NOT NULL OR
n19.typ             IS NOT NULL OR
n20.typ             IS NOT NULL) ORDER BY d.id;



DROP VIEW IF EXISTS index4_v;

CREATE VIEW index4_v

AS


SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(4                     ::text,''),
coalesce(1        ::text,''),
coalesce(1    ::text,''),
coalesce(1       ::text,''),
coalesce(n1.valid                ::text,''),
coalesce(n2.valid                ::text,''),
coalesce(n3.valid                ::text,''),
coalesce(n4.valid                ::text,''),
coalesce(n5.valid                ::text,''),
coalesce(n6.valid                ::text,''),
coalesce(n7.valid                ::text,''),
coalesce(n8.valid                ::text,''),
coalesce(n9.valid                ::text,''),
coalesce(n10.valid               ::text,''),
coalesce(n11.valid               ::text,''),
coalesce(n12.valid               ::text,''),
coalesce(n13.valid               ::text,''),
coalesce(n14.valid               ::text,''),
coalesce(n15.valid               ::text,''),
coalesce(n16.valid               ::text,''),
coalesce(n17.valid               ::text,''),
coalesce(n18.valid               ::text,''),
coalesce(n19.valid               ::text,''),
coalesce(n20.valid               ::text,'')
],'|') AS index4

FROM

datensatz d                         
LEFT JOIN alltagspflichten_patient             n1 ON n1.id=d.id
LEFT JOIN zuf_1                                n2 ON n2.id=d.id
LEFT JOIN zuf_2                                n3 ON n3.id=d.id
LEFT JOIN zuf_3                                n4 ON n4.id=d.id
LEFT JOIN zuf_4                                n5 ON n5.id=d.id
LEFT JOIN zuf_5                                n6 ON n6.id=d.id
LEFT JOIN zuf_6                                n7 ON n7.id=d.id
LEFT JOIN zuf_7                                n8 ON n8.id=d.id
LEFT JOIN zuf_8                                n9 ON n9.id=d.id
LEFT JOIN aenderung_koerperlich_patient        n10 ON n10.id=d.id
LEFT JOIN aenderung_psychisch_patient          n11 ON n11.id=d.id
LEFT JOIN aenderung_selbstwerterleben          n12 ON n12.id=d.id
LEFT JOIN aenderung_sozial                     n13 ON n13.id=d.id
LEFT JOIN aenderung_privat                     n14 ON n14.id=d.id
LEFT JOIN aenderung_beruflich                  n15 ON n15.id=d.id
LEFT JOIN aenderung_eigenaktivitaet            n16 ON n16.id=d.id
LEFT JOIN aenderung_krankheitsverstaendnis     n17 ON n17.id=d.id
LEFT JOIN aenderung_zukunft                    n18 ON n18.id=d.id
LEFT JOIN aenderung_befinden                   n19 ON n19.id=d.id
LEFT JOIN aenderung_alltag                      n20 ON n20.id=d.id

WHERE

(n1.typ              IS NOT NULL OR
n2.typ              IS NOT NULL OR
n3.typ              IS NOT NULL OR
n4.typ              IS NOT NULL OR
n5.typ              IS NOT NULL OR
n6.typ              IS NOT NULL OR
n7.typ              IS NOT NULL OR
n8.typ              IS NOT NULL OR
n9.typ              IS NOT NULL OR
n10.typ             IS NOT NULL OR
n11.typ             IS NOT NULL OR
n12.typ             IS NOT NULL OR
n13.typ             IS NOT NULL OR
n14.typ             IS NOT NULL OR
n15.typ             IS NOT NULL OR
n16.typ             IS NOT NULL OR
n17.typ             IS NOT NULL OR
n18.typ             IS NOT NULL OR
n19.typ             IS NOT NULL OR
n20.typ             IS NOT NULL) ORDER BY d.id;



DROP VIEW IF EXISTS index5;

CREATE VIEW index5

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array_agg(array_to_string(array[ 
coalesce(5                     ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(to_char(id.datum ,'DD.MM.YYYY') ::text,''),
coalesce(n2.typ                ::text,''),
coalesce(n3.typ                ::text,''),
coalesce(n4.typ                ::text,''),
coalesce(n5.typ                ::text,''),
coalesce(n6.typ                ::text,''),
coalesce(n7.typ                ::text,''),
coalesce(n8.typ                ::text,''),
coalesce(n9.typ                ::text,''),
coalesce(n10.typ               ::text,''),
coalesce(n11.typ               ::text,''),
coalesce(n12.typ               ::text,''),
coalesce(n13.typ               ::text,''),
coalesce(n14.typ               ::text,''),
coalesce(n15.typ               ::text,''),
coalesce(n16.typ               ::text,''),
coalesce(n17.typ               ::text,''),
coalesce(n18.typ               ::text,''),
coalesce(n19.typ               ::text,''),
coalesce(n20.typ               ::text,''),
coalesce(n21.typ               ::text,''),
coalesce(n22.typ               ::text,''),
coalesce(n23.typ               ::text,''),
coalesce(n24.typ               ::text,''),
coalesce(n25.typ               ::text,''),
coalesce(n26.typ               ::text,''),
coalesce(n27.typ               ::text,''),
coalesce(n28.typ               ::text,''),
coalesce(n29.typ               ::text,''),
coalesce(n30.typ               ::text,'')
],'|')),'|') AS index5

FROM

datensatz d                         
LEFT JOIN isr_datensatz id ON id.id = d.id
LEFT JOIN isr_d01   n2 ON n2.eintrag_id=id.eintrag_id
LEFT JOIN isr_d02   n3 ON n3.eintrag_id=id.eintrag_id
LEFT JOIN isr_d03   n4 ON n4.eintrag_id=id.eintrag_id
LEFT JOIN isr_d05   n5 ON n5.eintrag_id=id.eintrag_id
LEFT JOIN isr_a01   n6 ON n6.eintrag_id=id.eintrag_id
LEFT JOIN isr_a02   n7 ON n7.eintrag_id=id.eintrag_id
LEFT JOIN isr_a03   n8 ON n8.eintrag_id=id.eintrag_id
LEFT JOIN isr_a04   n9 ON n9.eintrag_id=id.eintrag_id
LEFT JOIN isr_z01   n10 ON n10.eintrag_id=id.eintrag_id
LEFT JOIN isr_z02   n11 ON n11.eintrag_id=id.eintrag_id
LEFT JOIN isr_z03   n12 ON n12.eintrag_id=id.eintrag_id
LEFT JOIN isr_s01   n13 ON n13.eintrag_id=id.eintrag_id
LEFT JOIN isr_s02   n14 ON n14.eintrag_id=id.eintrag_id
LEFT JOIN isr_s03   n15 ON n15.eintrag_id=id.eintrag_id
LEFT JOIN isr_e01   n16 ON n16.eintrag_id=id.eintrag_id
LEFT JOIN isr_e02   n17 ON n17.eintrag_id=id.eintrag_id
LEFT JOIN isr_e03   n18 ON n18.eintrag_id=id.eintrag_id
LEFT JOIN isr_d04   n19 ON n19.eintrag_id=id.eintrag_id
LEFT JOIN isr_d10   n20 ON n20.eintrag_id=id.eintrag_id
LEFT JOIN isr_d11   n21 ON n21.eintrag_id=id.eintrag_id
LEFT JOIN isr_d12   n22 ON n22.eintrag_id=id.eintrag_id
LEFT JOIN isr_w01   n23 ON n23.eintrag_id=id.eintrag_id
LEFT JOIN isr_w02   n24 ON n24.eintrag_id=id.eintrag_id
LEFT JOIN isr_w03   n25 ON n25.eintrag_id=id.eintrag_id
LEFT JOIN isr_w05   n26 ON n26.eintrag_id=id.eintrag_id
LEFT JOIN isr_w06   n27 ON n27.eintrag_id=id.eintrag_id
LEFT JOIN isr_w07   n28 ON n28.eintrag_id=id.eintrag_id
LEFT JOIN isr_w08   n29 ON n29.eintrag_id=id.eintrag_id
LEFT JOIN isr_w09    n30 ON n30.eintrag_id=id.eintrag_id

WHERE

(id.datum               IS NOT NULL OR
n2.typ                 IS NOT NULL OR
n3.typ                 IS NOT NULL OR
n4.typ                 IS NOT NULL OR
n5.typ                 IS NOT NULL OR
n6.typ                 IS NOT NULL OR
n7.typ                 IS NOT NULL OR
n8.typ                 IS NOT NULL OR
n9.typ                 IS NOT NULL OR
n10.typ                IS NOT NULL OR
n11.typ                IS NOT NULL OR
n12.typ                IS NOT NULL OR
n13.typ                IS NOT NULL OR
n14.typ                IS NOT NULL OR
n15.typ                IS NOT NULL OR
n16.typ                IS NOT NULL OR
n17.typ                IS NOT NULL OR
n18.typ                IS NOT NULL OR
n19.typ                IS NOT NULL OR
n20.typ                IS NOT NULL OR
n21.typ                IS NOT NULL OR
n22.typ                IS NOT NULL OR
n23.typ                IS NOT NULL OR
n24.typ                IS NOT NULL OR
n25.typ                IS NOT NULL OR
n26.typ                IS NOT NULL OR
n27.typ                IS NOT NULL OR
n28.typ                IS NOT NULL OR
n29.typ                IS NOT NULL OR
n30.typ                IS NOT NULL)

GROUP BY d.id, d.behandler_nr, d.patienten_nr ORDER BY d.id;

DROP VIEW IF EXISTS index5_v;

CREATE VIEW index5_v

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array_agg(array_to_string(array[ 
coalesce(5                     ::text,''),
coalesce(1        ::text,''),
coalesce(1    ::text,''),
coalesce(1        ::text,''),
coalesce(id.valid ::text,''),
coalesce(n2.valid                ::text,''),
coalesce(n3.valid                ::text,''),
coalesce(n4.valid                ::text,''),
coalesce(n5.valid                ::text,''),
coalesce(n6.valid                ::text,''),
coalesce(n7.valid                ::text,''),
coalesce(n8.valid                ::text,''),
coalesce(n9.valid                ::text,''),
coalesce(n10.valid               ::text,''),
coalesce(n11.valid               ::text,''),
coalesce(n12.valid               ::text,''),
coalesce(n13.valid               ::text,''),
coalesce(n14.valid               ::text,''),
coalesce(n15.valid               ::text,''),
coalesce(n16.valid               ::text,''),
coalesce(n17.valid               ::text,''),
coalesce(n18.valid               ::text,''),
coalesce(n19.valid               ::text,''),
coalesce(n20.valid               ::text,''),
coalesce(n21.valid               ::text,''),
coalesce(n22.valid               ::text,''),
coalesce(n23.valid               ::text,''),
coalesce(n24.valid               ::text,''),
coalesce(n25.valid               ::text,''),
coalesce(n26.valid               ::text,''),
coalesce(n27.valid               ::text,''),
coalesce(n28.valid               ::text,''),
coalesce(n29.valid               ::text,''),
coalesce(n30.valid               ::text,'')
],'|')),'|') AS index5

FROM

datensatz d                         
LEFT JOIN isr_datensatz id ON id.id = d.id
LEFT JOIN isr_d01   n2 ON n2.eintrag_id=id.eintrag_id
LEFT JOIN isr_d02   n3 ON n3.eintrag_id=id.eintrag_id
LEFT JOIN isr_d03   n4 ON n4.eintrag_id=id.eintrag_id
LEFT JOIN isr_d05   n5 ON n5.eintrag_id=id.eintrag_id
LEFT JOIN isr_a01   n6 ON n6.eintrag_id=id.eintrag_id
LEFT JOIN isr_a02   n7 ON n7.eintrag_id=id.eintrag_id
LEFT JOIN isr_a03   n8 ON n8.eintrag_id=id.eintrag_id
LEFT JOIN isr_a04   n9 ON n9.eintrag_id=id.eintrag_id
LEFT JOIN isr_z01   n10 ON n10.eintrag_id=id.eintrag_id
LEFT JOIN isr_z02   n11 ON n11.eintrag_id=id.eintrag_id
LEFT JOIN isr_z03   n12 ON n12.eintrag_id=id.eintrag_id
LEFT JOIN isr_s01   n13 ON n13.eintrag_id=id.eintrag_id
LEFT JOIN isr_s02   n14 ON n14.eintrag_id=id.eintrag_id
LEFT JOIN isr_s03   n15 ON n15.eintrag_id=id.eintrag_id
LEFT JOIN isr_e01   n16 ON n16.eintrag_id=id.eintrag_id
LEFT JOIN isr_e02   n17 ON n17.eintrag_id=id.eintrag_id
LEFT JOIN isr_e03   n18 ON n18.eintrag_id=id.eintrag_id
LEFT JOIN isr_d04   n19 ON n19.eintrag_id=id.eintrag_id
LEFT JOIN isr_d10   n20 ON n20.eintrag_id=id.eintrag_id
LEFT JOIN isr_d11   n21 ON n21.eintrag_id=id.eintrag_id
LEFT JOIN isr_d12   n22 ON n22.eintrag_id=id.eintrag_id
LEFT JOIN isr_w01   n23 ON n23.eintrag_id=id.eintrag_id
LEFT JOIN isr_w02   n24 ON n24.eintrag_id=id.eintrag_id
LEFT JOIN isr_w03   n25 ON n25.eintrag_id=id.eintrag_id
LEFT JOIN isr_w05   n26 ON n26.eintrag_id=id.eintrag_id
LEFT JOIN isr_w06   n27 ON n27.eintrag_id=id.eintrag_id
LEFT JOIN isr_w07   n28 ON n28.eintrag_id=id.eintrag_id
LEFT JOIN isr_w08   n29 ON n29.eintrag_id=id.eintrag_id
LEFT JOIN isr_w09    n30 ON n30.eintrag_id=id.eintrag_id

WHERE

(id.datum               IS NOT NULL OR
n2.typ                 IS NOT NULL OR
n3.typ                 IS NOT NULL OR
n4.typ                 IS NOT NULL OR
n5.typ                 IS NOT NULL OR
n6.typ                 IS NOT NULL OR
n7.typ                 IS NOT NULL OR
n8.typ                 IS NOT NULL OR
n9.typ                 IS NOT NULL OR
n10.typ                IS NOT NULL OR
n11.typ                IS NOT NULL OR
n12.typ                IS NOT NULL OR
n13.typ                IS NOT NULL OR
n14.typ                IS NOT NULL OR
n15.typ                IS NOT NULL OR
n16.typ                IS NOT NULL OR
n17.typ                IS NOT NULL OR
n18.typ                IS NOT NULL OR
n19.typ                IS NOT NULL OR
n20.typ                IS NOT NULL OR
n21.typ                IS NOT NULL OR
n22.typ                IS NOT NULL OR
n23.typ                IS NOT NULL OR
n24.typ                IS NOT NULL OR
n25.typ                IS NOT NULL OR
n26.typ                IS NOT NULL OR
n27.typ                IS NOT NULL OR
n28.typ                IS NOT NULL OR
n29.typ                IS NOT NULL OR
n30.typ                IS NOT NULL)

GROUP BY d.id, d.behandler_nr, d.patienten_nr ORDER BY d.id;


DROP VIEW IF EXISTS index6;

CREATE VIEW index6

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array_agg(array_to_string(array[ 
coalesce(6                     ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(to_char(id.datum ,'DD.MM.YYYY')::text,''), 
coalesce(n2.typ                ::text,''),
coalesce(n3.typ                ::text,''),
coalesce(n4.typ                ::text,''),
coalesce(n5.typ                ::text,''),
coalesce(n6.typ                ::text,''),
coalesce(n7.typ                ::text,''),
coalesce(n8.typ                ::text,''),
coalesce(n9.typ                ::text,''),
coalesce(n10.typ               ::text,''),
coalesce(n11.typ               ::text,''),
coalesce(n12.typ               ::text,''),
coalesce(n13.typ               ::text,''),
coalesce(n14.typ               ::text,''),
coalesce(n15.grad              ::text,'')
],'|')),'|') AS index6

FROM

datensatz d   
LEFT JOIN mini_icf_datensatz id ON id.id = d.id                     
LEFT JOIN mini_icf_01      n2 ON n2.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_02      n3 ON n3.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_03      n4 ON n4.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_04      n5 ON n5.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_05      n6 ON n6.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_06      n7 ON n7.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_07      n8 ON n8.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_08      n9 ON n9.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_09      n10 ON n10.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_10      n11 ON n11.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_11      n12 ON n12.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_12      n13 ON n13.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_13      n14 ON n14.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_gesamt  n15 ON n15.eintrag_id=id.eintrag_id

WHERE

(id.datum               IS NOT NULL OR
n2.typ                 IS NOT NULL OR
n3.typ                 IS NOT NULL OR
n4.typ                 IS NOT NULL OR
n5.typ                 IS NOT NULL OR
n6.typ                 IS NOT NULL OR
n7.typ                 IS NOT NULL OR
n8.typ                 IS NOT NULL OR
n9.typ                 IS NOT NULL OR
n10.typ                IS NOT NULL OR
n11.typ                IS NOT NULL OR
n12.typ                IS NOT NULL OR
n13.typ                IS NOT NULL OR
n14.typ                IS NOT NULL OR
n15.grad               IS NOT NULL)

GROUP BY d.id, d.behandler_nr, d.patienten_nr ORDER BY d.id;

DROP VIEW IF EXISTS index6_v;

CREATE VIEW index6_v

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array_agg(array_to_string(array[ 
coalesce(6                     ::text,''),
coalesce(1        ::text,''),
coalesce(1    ::text,''),
coalesce(1        ::text,''),
coalesce(id.valid ::text,''), 
coalesce(n2.valid                ::text,''),
coalesce(n3.valid                ::text,''),
coalesce(n4.valid                ::text,''),
coalesce(n5.valid                ::text,''),
coalesce(n6.valid                ::text,''),
coalesce(n7.valid                ::text,''),
coalesce(n8.valid                ::text,''),
coalesce(n9.valid                ::text,''),
coalesce(n10.valid              ::text,''),
coalesce(n11.valid              ::text,''),
coalesce(n12.valid              ::text,''),
coalesce(n13.valid              ::text,''),
coalesce(n14.valid              ::text,''),
coalesce(n15.valid              ::text,'')
],'|')),'|') AS index6

FROM

datensatz d   
LEFT JOIN mini_icf_datensatz id ON id.id = d.id                     
LEFT JOIN mini_icf_01      n2 ON n2.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_02      n3 ON n3.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_03      n4 ON n4.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_04      n5 ON n5.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_05      n6 ON n6.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_06      n7 ON n7.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_07      n8 ON n8.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_08      n9 ON n9.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_09      n10 ON n10.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_10      n11 ON n11.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_11      n12 ON n12.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_12      n13 ON n13.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_13      n14 ON n14.eintrag_id=id.eintrag_id
LEFT JOIN mini_icf_gesamt  n15 ON n15.eintrag_id=id.eintrag_id

WHERE

(id.datum               IS NOT NULL OR
n2.typ                 IS NOT NULL OR
n3.typ                 IS NOT NULL OR
n4.typ                 IS NOT NULL OR
n5.typ                 IS NOT NULL OR
n6.typ                 IS NOT NULL OR
n7.typ                 IS NOT NULL OR
n8.typ                 IS NOT NULL OR
n9.typ                 IS NOT NULL OR
n10.typ                IS NOT NULL OR
n11.typ                IS NOT NULL OR
n12.typ                IS NOT NULL OR
n13.typ                IS NOT NULL OR
n14.typ                IS NOT NULL OR
n15.grad               IS NOT NULL)

GROUP BY d.id, d.behandler_nr, d.patienten_nr ORDER BY d.id;

DROP VIEW IF EXISTS index7;

CREATE VIEW index7

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array_agg(array_to_string(array[ 
coalesce(7                     ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(to_char(id.datum ,'DD.MM.YYYY')::text,''),             
coalesce(n2.grad                ::text,''),
coalesce(n3.grad                ::text,''),
coalesce(n4.grad                ::text,''),
coalesce(n5.grad                ::text,''),
coalesce(n6.grad                ::text,''),
coalesce(n7.grad                ::text,''),
coalesce(n8.grad                ::text,''),
coalesce(n9.grad                ::text,''),
coalesce(n10.grad               ::text,''),
coalesce(n11.grad               ::text,'')
],'|')),'|') AS index7

FROM

datensatz d                         
LEFT JOIN scl90_datensatz id ON id.id = d.id 
LEFT JOIN scl90_somatisierung       n2 ON n2.eintrag_id=id.eintrag_id
LEFT JOIN scl90_zwanghaftigkeit     n3 ON n3.eintrag_id=id.eintrag_id
LEFT JOIN scl90_sozialkontakt       n4 ON n4.eintrag_id=id.eintrag_id
LEFT JOIN scl90_depressivitaet      n5 ON n5.eintrag_id=id.eintrag_id
LEFT JOIN scl90_aengstlichkeit      n6 ON n6.eintrag_id=id.eintrag_id
LEFT JOIN scl90_aggressivitaet      n7 ON n7.eintrag_id=id.eintrag_id
LEFT JOIN scl90_phobische_angst     n8 ON n8.eintrag_id=id.eintrag_id
LEFT JOIN scl90_paranoides_denken   n9 ON n9.eintrag_id=id.eintrag_id
LEFT JOIN scl90_psychotizismus      n10 ON n10.eintrag_id=id.eintrag_id
LEFT JOIN scl90_gsi                  n11 ON n11.eintrag_id=id.eintrag_id

WHERE

(id.datum                IS NOT NULL OR             
n2.grad                 IS NOT NULL OR
n3.grad                 IS NOT NULL OR
n4.grad                 IS NOT NULL OR
n5.grad                 IS NOT NULL OR
n6.grad                 IS NOT NULL OR
n7.grad                 IS NOT NULL OR
n8.grad                 IS NOT NULL OR
n9.grad                 IS NOT NULL OR
n10.grad                IS NOT NULL OR
n11.grad                IS NOT NULL)

GROUP BY d.id, d.behandler_nr, d.patienten_nr ORDER BY d.id;

DROP VIEW IF EXISTS index7_v;

CREATE VIEW index7_v

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array_agg(array_to_string(array[ 
coalesce(7                     ::text,''),
coalesce(1        ::text,''),
coalesce(1    ::text,''),
coalesce(1        ::text,''),
coalesce(id.valid ::text,''),             
coalesce(n2.valid                ::text,''),
coalesce(n3.valid                ::text,''),
coalesce(n4.valid                ::text,''),
coalesce(n5.valid                ::text,''),
coalesce(n6.valid                ::text,''),
coalesce(n7.valid                ::text,''),
coalesce(n8.valid                ::text,''),
coalesce(n9.valid                ::text,''),
coalesce(n10.valid               ::text,''),
coalesce(n11.valid               ::text,'')
],'|')),'|') AS index7

FROM

datensatz d                         
LEFT JOIN scl90_datensatz id ON id.id = d.id 
LEFT JOIN scl90_somatisierung       n2 ON n2.eintrag_id=id.eintrag_id
LEFT JOIN scl90_zwanghaftigkeit     n3 ON n3.eintrag_id=id.eintrag_id
LEFT JOIN scl90_sozialkontakt       n4 ON n4.eintrag_id=id.eintrag_id
LEFT JOIN scl90_depressivitaet      n5 ON n5.eintrag_id=id.eintrag_id
LEFT JOIN scl90_aengstlichkeit      n6 ON n6.eintrag_id=id.eintrag_id
LEFT JOIN scl90_aggressivitaet      n7 ON n7.eintrag_id=id.eintrag_id
LEFT JOIN scl90_phobische_angst     n8 ON n8.eintrag_id=id.eintrag_id
LEFT JOIN scl90_paranoides_denken   n9 ON n9.eintrag_id=id.eintrag_id
LEFT JOIN scl90_psychotizismus      n10 ON n10.eintrag_id=id.eintrag_id
LEFT JOIN scl90_gsi                  n11 ON n11.eintrag_id=id.eintrag_id

WHERE

(id.datum                IS NOT NULL OR             
n2.grad                 IS NOT NULL OR
n3.grad                 IS NOT NULL OR
n4.grad                 IS NOT NULL OR
n5.grad                 IS NOT NULL OR
n6.grad                 IS NOT NULL OR
n7.grad                 IS NOT NULL OR
n8.grad                 IS NOT NULL OR
n9.grad                 IS NOT NULL OR
n10.grad                IS NOT NULL OR
n11.grad                IS NOT NULL)

GROUP BY d.id, d.behandler_nr, d.patienten_nr ORDER BY d.id;

DROP VIEW IF EXISTS index8;

CREATE VIEW index8

AS


SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(8                     ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(minutesf(n1.dauer)    ::text,''),
coalesce(minutesf(n2.dauer)    ::text,''),
coalesce(minutesf(n3.dauer)    ::text,''),
coalesce(minutesf(n4.dauer)    ::text,''),
coalesce(minutesf(n5.dauer)    ::text,''),
coalesce(minutesf(n6.dauer)    ::text,''),
coalesce(minutesf(n7.dauer)    ::text,''),
coalesce(minutesf(n8.dauer)    ::text,''),
coalesce(minutesf(n9.dauer)    ::text,''),
coalesce(minutesf(n10.dauer)   ::text,''),
coalesce(minutesf(n11.dauer)   ::text,''),
coalesce(minutesf(n12.dauer)   ::text,''),
coalesce(minutesf(n13.dauer)   ::text,''),
coalesce(minutesf(n14.dauer)   ::text,''),
coalesce(minutesf(n15.dauer)   ::text,''),
coalesce(minutesf(n16.dauer)   ::text,''),
coalesce(minutesf(n17.dauer)   ::text,''),
coalesce(minutesf(n18.dauer)   ::text,''),
coalesce(minutesf(n19.dauer)   ::text,''),
coalesce(minutesf(n20.dauer)   ::text,''),
coalesce(minutesf(n21.dauer)   ::text,''),
coalesce(minutesf(n22.dauer)   ::text,''),
coalesce(minutesf(n23.dauer)   ::text,''),
coalesce(minutesf(n24.dauer)   ::text,''),
coalesce(minutesf(n25.dauer)   ::text,''),
coalesce(minutesf(n26.dauer)   ::text,''),
coalesce(minutesf(n27.dauer)   ::text,''),
coalesce(minutesf(n28.dauer)   ::text,''),
coalesce(minutesf(n29.dauer)   ::text,''),
coalesce(minutesf(n30.dauer)   ::text,''),
coalesce(minutesf(n31.dauer)   ::text,''),
coalesce(minutesf(n32.dauer)   ::text,''),
coalesce(minutesf(n33.dauer)   ::text,''),
coalesce(minutesf(n34.dauer)   ::text,''),
coalesce(minutesf(n35.dauer)   ::text,''),
coalesce(minutesf(n36.dauer)   ::text,''),
coalesce(minutesf(n37.dauer)   ::text,'')
],'|') AS index8


FROM

datensatz d                         
LEFT JOIN visiten                                n1 ON n1.id=d.id
LEFT JOIN kontakte_kotherapeutisch               n2 ON n2.id=d.id
LEFT JOIN besprechung_patientenbezogen           n3 ON n3.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_bis10       n4 ON n4.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_ab11        n5 ON n5.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_bis10   n6 ON n6.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_ab11    n7 ON n7.id=d.id
LEFT JOIN gruppe_andere_verbale_bis10            n8 ON n8.id=d.id
LEFT JOIN gruppe_andere_verbale_ab11             n9 ON n9.id=d.id
LEFT JOIN gruppe_kunst                           n10 ON n10.id=d.id
LEFT JOIN gruppe_musik                           n11 ON n11.id=d.id
LEFT JOIN gruppe_koerper                         n12 ON n12.id=d.id
LEFT JOIN gruppe_soziale_interaktion             n13 ON n13.id=d.id
LEFT JOIN gruppe_entspannung                     n14 ON n14.id=d.id
LEFT JOIN gruppe_meditation                      n15 ON n15.id=d.id
LEFT JOIN gruppe_themenzentriert                 n16 ON n16.id=d.id
LEFT JOIN gruppe_indikation                      n17 ON n17.id=d.id
LEFT JOIN gruppe_andere                          n18 ON n18.id=d.id
LEFT JOIN gruppe_milieu_versammlung              n19 ON n19.id=d.id
LEFT JOIN gruppe_milieu_themenzentriert          n20 ON n20.id=d.id
LEFT JOIN gruppe_milieu_andere                   n21 ON n21.id=d.id
LEFT JOIN einzel_tiefenpsychologisch             n22 ON n22.id=d.id
LEFT JOIN einzel_verhaltenstherapeutisch         n23 ON n23.id=d.id
LEFT JOIN einzel_andere_verbale                  n24 ON n24.id=d.id
LEFT JOIN einzel_paar                            n25 ON n25.id=d.id
LEFT JOIN einzel_kunst                           n26 ON n26.id=d.id
LEFT JOIN einzel_musik                           n27 ON n27.id=d.id
LEFT JOIN einzel_koerper                         n28 ON n28.id=d.id
LEFT JOIN einzel_entspannung                     n29 ON n29.id=d.id
LEFT JOIN einzel_meditation                      n30 ON n30.id=d.id
LEFT JOIN einzel_themenzentriert                 n31 ON n31.id=d.id
LEFT JOIN einzel_andere_sonstige                 n32 ON n32.id=d.id
LEFT JOIN einzel_milieu_sozio                    n33 ON n33.id=d.id
LEFT JOIN einzel_milieu_andere                   n34 ON n34.id=d.id
LEFT JOIN gruppe_soma                            n35 ON n35.id=d.id
LEFT JOIN einzel_soma                            n36 ON n36.id=d.id
LEFT JOIN balneotherapie                         n37 ON n37.id=d.id

WHERE

(n1.dauer  IS NOT NULL OR
n2.dauer  IS NOT NULL OR
n3.dauer  IS NOT NULL OR
n4.dauer  IS NOT NULL OR
n5.dauer  IS NOT NULL OR
n6.dauer  IS NOT NULL OR
n7.dauer  IS NOT NULL OR
n8.dauer  IS NOT NULL OR
n9.dauer  IS NOT NULL OR
n10.dauer IS NOT NULL OR
n11.dauer IS NOT NULL OR
n12.dauer IS NOT NULL OR
n13.dauer IS NOT NULL OR
n14.dauer IS NOT NULL OR
n15.dauer IS NOT NULL OR
n16.dauer IS NOT NULL OR
n17.dauer IS NOT NULL OR
n18.dauer IS NOT NULL OR
n19.dauer IS NOT NULL OR
n20.dauer IS NOT NULL OR
n21.dauer IS NOT NULL OR
n22.dauer IS NOT NULL OR
n23.dauer IS NOT NULL OR
n24.dauer IS NOT NULL OR
n25.dauer IS NOT NULL OR
n26.dauer IS NOT NULL OR
n27.dauer IS NOT NULL OR
n28.dauer IS NOT NULL OR
n29.dauer IS NOT NULL OR
n30.dauer IS NOT NULL OR
n31.dauer IS NOT NULL OR
n32.dauer IS NOT NULL OR
n33.dauer IS NOT NULL OR
n34.dauer IS NOT NULL OR
n35.dauer IS NOT NULL OR
n36.dauer IS NOT NULL OR
n37.dauer IS NOT NULL) AND
n4.valid IS NOT NULL ORDER BY d.id;

DROP VIEW IF EXISTS index8_v;

CREATE VIEW index8_v

AS


SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(8                     ::text,''),
coalesce(1        ::text,''),
coalesce(1    ::text,''),
coalesce(1        ::text,''),
coalesce(n1.valid   ::text,''),
coalesce(n2.valid   ::text,''),
coalesce(n3.valid   ::text,''),
coalesce(n4.valid   ::text,''),
coalesce(n5.valid   ::text,''),
coalesce(n6.valid   ::text,''),
coalesce(n7.valid   ::text,''),
coalesce(n8.valid   ::text,''),
coalesce(n9.valid   ::text,''),
coalesce(n10.valid   ::text,''),
coalesce(n11.valid   ::text,''),
coalesce(n12.valid   ::text,''),
coalesce(n13.valid   ::text,''),
coalesce(n14.valid   ::text,''),
coalesce(n15.valid   ::text,''),
coalesce(n16.valid   ::text,''),
coalesce(n17.valid   ::text,''),
coalesce(n18.valid   ::text,''),
coalesce(n19.valid   ::text,''),
coalesce(n20.valid   ::text,''),
coalesce(n21.valid   ::text,''),
coalesce(n22.valid   ::text,''),
coalesce(n23.valid   ::text,''),
coalesce(n24.valid   ::text,''),
coalesce(n25.valid   ::text,''),
coalesce(n26.valid   ::text,''),
coalesce(n27.valid   ::text,''),
coalesce(n28.valid   ::text,''),
coalesce(n29.valid   ::text,''),
coalesce(n30.valid   ::text,''),
coalesce(n31.valid   ::text,''),
coalesce(n32.valid   ::text,''),
coalesce(n33.valid   ::text,''),
coalesce(n34.valid   ::text,''),
coalesce(n35.valid   ::text,''),
coalesce(n36.valid   ::text,''),
coalesce(n37.valid   ::text,'')
],'|') AS index8


FROM

datensatz d                         
LEFT JOIN visiten                                n1 ON n1.id=d.id
LEFT JOIN kontakte_kotherapeutisch               n2 ON n2.id=d.id
LEFT JOIN besprechung_patientenbezogen           n3 ON n3.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_bis10       n4 ON n4.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_ab11        n5 ON n5.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_bis10   n6 ON n6.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_ab11    n7 ON n7.id=d.id
LEFT JOIN gruppe_andere_verbale_bis10            n8 ON n8.id=d.id
LEFT JOIN gruppe_andere_verbale_ab11             n9 ON n9.id=d.id
LEFT JOIN gruppe_kunst                           n10 ON n10.id=d.id
LEFT JOIN gruppe_musik                           n11 ON n11.id=d.id
LEFT JOIN gruppe_koerper                         n12 ON n12.id=d.id
LEFT JOIN gruppe_soziale_interaktion             n13 ON n13.id=d.id
LEFT JOIN gruppe_entspannung                     n14 ON n14.id=d.id
LEFT JOIN gruppe_meditation                      n15 ON n15.id=d.id
LEFT JOIN gruppe_themenzentriert                 n16 ON n16.id=d.id
LEFT JOIN gruppe_indikation                      n17 ON n17.id=d.id
LEFT JOIN gruppe_andere                          n18 ON n18.id=d.id
LEFT JOIN gruppe_milieu_versammlung              n19 ON n19.id=d.id
LEFT JOIN gruppe_milieu_themenzentriert          n20 ON n20.id=d.id
LEFT JOIN gruppe_milieu_andere                   n21 ON n21.id=d.id
LEFT JOIN einzel_tiefenpsychologisch             n22 ON n22.id=d.id
LEFT JOIN einzel_verhaltenstherapeutisch         n23 ON n23.id=d.id
LEFT JOIN einzel_andere_verbale                  n24 ON n24.id=d.id
LEFT JOIN einzel_paar                            n25 ON n25.id=d.id
LEFT JOIN einzel_kunst                           n26 ON n26.id=d.id
LEFT JOIN einzel_musik                           n27 ON n27.id=d.id
LEFT JOIN einzel_koerper                         n28 ON n28.id=d.id
LEFT JOIN einzel_entspannung                     n29 ON n29.id=d.id
LEFT JOIN einzel_meditation                      n30 ON n30.id=d.id
LEFT JOIN einzel_themenzentriert                 n31 ON n31.id=d.id
LEFT JOIN einzel_andere_sonstige                 n32 ON n32.id=d.id
LEFT JOIN einzel_milieu_sozio                    n33 ON n33.id=d.id
LEFT JOIN einzel_milieu_andere                   n34 ON n34.id=d.id
LEFT JOIN gruppe_soma                            n35 ON n35.id=d.id
LEFT JOIN einzel_soma                            n36 ON n36.id=d.id
LEFT JOIN balneotherapie                         n37 ON n37.id=d.id

WHERE

(n1.dauer  IS NOT NULL OR
n2.dauer  IS NOT NULL OR
n3.dauer  IS NOT NULL OR
n4.dauer  IS NOT NULL OR
n5.dauer  IS NOT NULL OR
n6.dauer  IS NOT NULL OR
n7.dauer  IS NOT NULL OR
n8.dauer  IS NOT NULL OR
n9.dauer  IS NOT NULL OR
n10.dauer IS NOT NULL OR
n11.dauer IS NOT NULL OR
n12.dauer IS NOT NULL OR
n13.dauer IS NOT NULL OR
n14.dauer IS NOT NULL OR
n15.dauer IS NOT NULL OR
n16.dauer IS NOT NULL OR
n17.dauer IS NOT NULL OR
n18.dauer IS NOT NULL OR
n19.dauer IS NOT NULL OR
n20.dauer IS NOT NULL OR
n21.dauer IS NOT NULL OR
n22.dauer IS NOT NULL OR
n23.dauer IS NOT NULL OR
n24.dauer IS NOT NULL OR
n25.dauer IS NOT NULL OR
n26.dauer IS NOT NULL OR
n27.dauer IS NOT NULL OR
n28.dauer IS NOT NULL OR
n29.dauer IS NOT NULL OR
n30.dauer IS NOT NULL OR
n31.dauer IS NOT NULL OR
n32.dauer IS NOT NULL OR
n33.dauer IS NOT NULL OR
n34.dauer IS NOT NULL OR
n35.dauer IS NOT NULL OR
n36.dauer IS NOT NULL OR
n37.dauer IS NOT NULL) AND
n4.valid IS NOT NULL ORDER BY d.id;




DROP VIEW IF EXISTS index9;

CREATE VIEW index9

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(9                     ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(minutesf(n1.dauer)    ::text,''),
coalesce(minutesf(n2.dauer)    ::text,''),
coalesce(minutesf(n3.dauer)    ::text,''),
coalesce(minutesf(n4.dauer)    ::text,''),
coalesce(minutesf(n5.dauer)    ::text,''),
coalesce(minutesf(n6.dauer)    ::text,''),
coalesce(minutesf(n7.dauer)    ::text,''),
coalesce(minutesf(n8.dauer)    ::text,''),
coalesce(minutesf(n9.dauer)    ::text,''),
coalesce(minutesf(n10.dauer)   ::text,''),
coalesce(minutesf(n11.dauer)   ::text,''),
coalesce(minutesf(n12.dauer)   ::text,''),
coalesce(minutesf(n13.dauer)   ::text,''),
coalesce(minutesf(n14.dauer)   ::text,''),
coalesce(minutesf(n15.dauer)   ::text,''),
coalesce(minutesf(n16.dauer)   ::text,''),
coalesce(minutesf(n17.dauer)   ::text,''),
coalesce(minutesf(n18.dauer)   ::text,''),
coalesce(minutesf(n19.dauer)   ::text,''),
coalesce(minutesf(n20.dauer)   ::text,''),
coalesce(minutesf(n21.dauer)   ::text,''),
coalesce(minutesf(n22.dauer)   ::text,''),
coalesce(minutesf(n23.dauer)   ::text,''),
coalesce(minutesf(n24.dauer)   ::text,''),
coalesce(minutesf(n25.dauer)   ::text,''),
coalesce(minutesf(n26.dauer)   ::text,''),
coalesce(minutesf(n27.dauer)   ::text,''),
coalesce(minutesf(n28.dauer)   ::text,''),
coalesce(minutesf(n29.dauer)   ::text,''),
coalesce(minutesf(n30.dauer)   ::text,''),
coalesce(minutesf(n31.dauer)   ::text,''),
coalesce(minutesf(n32.dauer)   ::text,''),
coalesce(minutesf(n33.dauer)   ::text,''),
coalesce(minutesf(n34.dauer)   ::text,''),
coalesce(minutesf(n35.dauer)   ::text,''),
coalesce(minutesf(n36.dauer)   ::text,''),
coalesce(minutesf(n37.dauer)   ::text,'')
],'|') AS index9


FROM

datensatz d                         
LEFT JOIN visiten                              n1 ON n1.id=d.id
LEFT JOIN kontakte_kotherapeutisch             n2 ON n2.id=d.id
LEFT JOIN besprechung_patientenbezogen         n3 ON n3.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_bis12     n4 ON n4.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_ab13      n5 ON n5.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_bis12 n6 ON n6.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_ab13  n7 ON n7.id=d.id
LEFT JOIN gruppe_andere_verbale_bis12          n8 ON n8.id=d.id
LEFT JOIN gruppe_andere_verbale_ab13           n9 ON n9.id=d.id
LEFT JOIN gruppe_kunst                         n10 ON n10.id=d.id
LEFT JOIN gruppe_musik                         n11 ON n11.id=d.id
LEFT JOIN gruppe_koerper                       n12 ON n12.id=d.id
LEFT JOIN gruppe_soziale_interaktion           n13 ON n13.id=d.id
LEFT JOIN gruppe_entspannung                   n14 ON n14.id=d.id
LEFT JOIN gruppe_meditation                    n15 ON n15.id=d.id
LEFT JOIN gruppe_themenzentriert               n16 ON n16.id=d.id
LEFT JOIN gruppe_indikation                    n17 ON n17.id=d.id
LEFT JOIN gruppe_andere                        n18 ON n18.id=d.id
LEFT JOIN gruppe_milieu_versammlung            n19 ON n19.id=d.id
LEFT JOIN gruppe_milieu_themenzentriert        n20 ON n20.id=d.id
LEFT JOIN gruppe_milieu_andere                 n21 ON n21.id=d.id
LEFT JOIN einzel_tiefenpsychologisch           n22 ON n22.id=d.id
LEFT JOIN einzel_verhaltenstherapeutisch       n23 ON n23.id=d.id
LEFT JOIN einzel_andere_verbale                n24 ON n24.id=d.id
LEFT JOIN einzel_paar                          n25 ON n25.id=d.id
LEFT JOIN einzel_kunst                         n26 ON n26.id=d.id
LEFT JOIN einzel_musik                         n27 ON n27.id=d.id
LEFT JOIN einzel_koerper                       n28 ON n28.id=d.id
LEFT JOIN einzel_entspannung                   n29 ON n29.id=d.id
LEFT JOIN einzel_meditation                    n30 ON n30.id=d.id
LEFT JOIN einzel_themenzentriert               n31 ON n31.id=d.id
LEFT JOIN einzel_andere_sonstige               n32 ON n32.id=d.id
LEFT JOIN einzel_milieu_sozio                  n33 ON n33.id=d.id
LEFT JOIN einzel_milieu_andere                 n34 ON n34.id=d.id
LEFT JOIN gruppe_soma                          n35 ON n35.id=d.id
LEFT JOIN einzel_soma                          n36 ON n36.id=d.id
LEFT JOIN balneotherapie                       n37 ON n37.id=d.id

WHERE

(n1.dauer  IS NOT NULL OR
n2.dauer  IS NOT NULL OR
n3.dauer  IS NOT NULL OR
n4.dauer  IS NOT NULL OR
n5.dauer  IS NOT NULL OR
n6.dauer  IS NOT NULL OR
n7.dauer  IS NOT NULL OR
n8.dauer  IS NOT NULL OR
n9.dauer  IS NOT NULL OR
n10.dauer IS NOT NULL OR
n11.dauer IS NOT NULL OR
n12.dauer IS NOT NULL OR
n13.dauer IS NOT NULL OR
n14.dauer IS NOT NULL OR
n15.dauer IS NOT NULL OR
n16.dauer IS NOT NULL OR
n17.dauer IS NOT NULL OR
n18.dauer IS NOT NULL OR
n19.dauer IS NOT NULL OR
n20.dauer IS NOT NULL OR
n21.dauer IS NOT NULL OR
n22.dauer IS NOT NULL OR
n23.dauer IS NOT NULL OR
n24.dauer IS NOT NULL OR
n25.dauer IS NOT NULL OR
n26.dauer IS NOT NULL OR
n27.dauer IS NOT NULL OR
n28.dauer IS NOT NULL OR
n29.dauer IS NOT NULL OR
n30.dauer IS NOT NULL OR
n31.dauer IS NOT NULL OR
n32.dauer IS NOT NULL OR
n33.dauer IS NOT NULL OR
n34.dauer IS NOT NULL OR
n35.dauer IS NOT NULL OR
n36.dauer IS NOT NULL OR
n37.dauer IS NOT NULL) AND
n4.valid IS NOT NULL ORDER BY d.id;

DROP VIEW IF EXISTS index9_v;

CREATE VIEW index9_v

AS

SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(9                     ::text,''),
coalesce(1        ::text,''),
coalesce(1    ::text,''),
coalesce(1        ::text,''),
coalesce(n1.valid    ::text,''),
coalesce(n2.valid    ::text,''),
coalesce(n3.valid    ::text,''),
coalesce(n4.valid    ::text,''),
coalesce(n5.valid    ::text,''),
coalesce(n6.valid    ::text,''),
coalesce(n7.valid    ::text,''),
coalesce(n8.valid    ::text,''),
coalesce(n9.valid    ::text,''),
coalesce(n10.valid   ::text,''),
coalesce(n11.valid   ::text,''),
coalesce(n12.valid   ::text,''),
coalesce(n13.valid   ::text,''),
coalesce(n14.valid   ::text,''),
coalesce(n15.valid   ::text,''),
coalesce(n16.valid   ::text,''),
coalesce(n17.valid   ::text,''),
coalesce(n18.valid   ::text,''),
coalesce(n19.valid   ::text,''),
coalesce(n20.valid   ::text,''),
coalesce(n21.valid   ::text,''),
coalesce(n22.valid   ::text,''),
coalesce(n23.valid   ::text,''),
coalesce(n24.valid   ::text,''),
coalesce(n25.valid   ::text,''),
coalesce(n26.valid   ::text,''),
coalesce(n27.valid   ::text,''),
coalesce(n28.valid   ::text,''),
coalesce(n29.valid   ::text,''),
coalesce(n30.valid   ::text,''),
coalesce(n31.valid   ::text,''),
coalesce(n32.valid   ::text,''),
coalesce(n33.valid   ::text,''),
coalesce(n34.valid   ::text,''),
coalesce(n35.valid   ::text,''),
coalesce(n36.valid   ::text,''),
coalesce(n37.valid   ::text,'')
],'|') AS index9


FROM

datensatz d                         
LEFT JOIN visiten                              n1 ON n1.id=d.id
LEFT JOIN kontakte_kotherapeutisch             n2 ON n2.id=d.id
LEFT JOIN besprechung_patientenbezogen         n3 ON n3.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_bis12     n4 ON n4.id=d.id
LEFT JOIN gruppe_tiefenpsychologisch_ab13      n5 ON n5.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_bis12 n6 ON n6.id=d.id
LEFT JOIN gruppe_verhaltenstherapeutisch_ab13  n7 ON n7.id=d.id
LEFT JOIN gruppe_andere_verbale_bis12          n8 ON n8.id=d.id
LEFT JOIN gruppe_andere_verbale_ab13           n9 ON n9.id=d.id
LEFT JOIN gruppe_kunst                         n10 ON n10.id=d.id
LEFT JOIN gruppe_musik                         n11 ON n11.id=d.id
LEFT JOIN gruppe_koerper                       n12 ON n12.id=d.id
LEFT JOIN gruppe_soziale_interaktion           n13 ON n13.id=d.id
LEFT JOIN gruppe_entspannung                   n14 ON n14.id=d.id
LEFT JOIN gruppe_meditation                    n15 ON n15.id=d.id
LEFT JOIN gruppe_themenzentriert               n16 ON n16.id=d.id
LEFT JOIN gruppe_indikation                    n17 ON n17.id=d.id
LEFT JOIN gruppe_andere                        n18 ON n18.id=d.id
LEFT JOIN gruppe_milieu_versammlung            n19 ON n19.id=d.id
LEFT JOIN gruppe_milieu_themenzentriert        n20 ON n20.id=d.id
LEFT JOIN gruppe_milieu_andere                 n21 ON n21.id=d.id
LEFT JOIN einzel_tiefenpsychologisch           n22 ON n22.id=d.id
LEFT JOIN einzel_verhaltenstherapeutisch       n23 ON n23.id=d.id
LEFT JOIN einzel_andere_verbale                n24 ON n24.id=d.id
LEFT JOIN einzel_paar                          n25 ON n25.id=d.id
LEFT JOIN einzel_kunst                         n26 ON n26.id=d.id
LEFT JOIN einzel_musik                         n27 ON n27.id=d.id
LEFT JOIN einzel_koerper                       n28 ON n28.id=d.id
LEFT JOIN einzel_entspannung                   n29 ON n29.id=d.id
LEFT JOIN einzel_meditation                    n30 ON n30.id=d.id
LEFT JOIN einzel_themenzentriert               n31 ON n31.id=d.id
LEFT JOIN einzel_andere_sonstige               n32 ON n32.id=d.id
LEFT JOIN einzel_milieu_sozio                  n33 ON n33.id=d.id
LEFT JOIN einzel_milieu_andere                 n34 ON n34.id=d.id
LEFT JOIN gruppe_soma                          n35 ON n35.id=d.id
LEFT JOIN einzel_soma                          n36 ON n36.id=d.id
LEFT JOIN balneotherapie                       n37 ON n37.id=d.id

WHERE

(n1.dauer  IS NOT NULL OR
n2.dauer  IS NOT NULL OR
n3.dauer  IS NOT NULL OR
n4.dauer  IS NOT NULL OR
n5.dauer  IS NOT NULL OR
n6.dauer  IS NOT NULL OR
n7.dauer  IS NOT NULL OR
n8.dauer  IS NOT NULL OR
n9.dauer  IS NOT NULL OR
n10.dauer IS NOT NULL OR
n11.dauer IS NOT NULL OR
n12.dauer IS NOT NULL OR
n13.dauer IS NOT NULL OR
n14.dauer IS NOT NULL OR
n15.dauer IS NOT NULL OR
n16.dauer IS NOT NULL OR
n17.dauer IS NOT NULL OR
n18.dauer IS NOT NULL OR
n19.dauer IS NOT NULL OR
n20.dauer IS NOT NULL OR
n21.dauer IS NOT NULL OR
n22.dauer IS NOT NULL OR
n23.dauer IS NOT NULL OR
n24.dauer IS NOT NULL OR
n25.dauer IS NOT NULL OR
n26.dauer IS NOT NULL OR
n27.dauer IS NOT NULL OR
n28.dauer IS NOT NULL OR
n29.dauer IS NOT NULL OR
n30.dauer IS NOT NULL OR
n31.dauer IS NOT NULL OR
n32.dauer IS NOT NULL OR
n33.dauer IS NOT NULL OR
n34.dauer IS NOT NULL OR
n35.dauer IS NOT NULL OR
n36.dauer IS NOT NULL OR
n37.dauer IS NOT NULL) AND
n4.valid IS NOT NULL ORDER BY d.id;

DROP VIEW IF EXISTS index10;

CREATE VIEW index10

AS

WITH ktlcat AS (
SELECT
p.id,
textcat_all(t.key||t2.key||lpad(text(p.anzahl),2,'0')) AS ktl
FROM
ktl2007 p,
ktl2007_typ t,
ktl2007_dauer_typ t2
WHERE p.typ=t.id AND p.ktl2007_dauer=t2.id
GROUP BY p.id ORDER BY p.id)


SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(10                    ::text,''),
coalesce(d.behandler_nr        ::text,''),
coalesce(d.sub_behandler_nr    ::text,''),
coalesce(d.patienten_nr        ::text,''),
coalesce(n1.ktl                ::text,'')
],'|') AS index10

FROM

datensatz d                         
LEFT JOIN ktlcat                         n1 ON n1.id=d.id

WHERE (n1.ktl IS NOT NULL) ORDER BY d.id;

DROP VIEW IF EXISTS index10_v;

CREATE VIEW index10_v

AS

WITH ktlcat AS (
SELECT
p.id,
p.valid AS ktl
FROM
ktl2007 p
GROUP BY p.id, p.valid ORDER BY p.id)


SELECT        
d.id, d.behandler_nr, d.patienten_nr,
array_to_string(array[ 
coalesce(10                    ::text,''),
coalesce(1       ::text,''),
coalesce(1    ::text,''),
coalesce(1        ::text,''),
coalesce(n1.ktl                ::text,'')
],'|') AS index10

FROM

datensatz d                         
LEFT JOIN ktlcat                         n1 ON n1.id=d.id

WHERE (n1.ktl IS NOT NULL) ORDER BY d.id;

DROP VIEW IF EXISTS index_all;

CREATE VIEW index_all

AS


SELECT d.id, d.behandler_nr, d.patienten_nr, 
	array_to_string(array[
	NULLIF(i1.index1,''),
	NULLIF(i2.index2,''),
	NULLIF(i3.index3,''),
	NULLIF(i4.index4,''),
	NULLIF(i5.index5,''),
	NULLIF(i6.index6,''),
	NULLIF(i7.index7,''),
	NULLIF(i8.index8,''),
	NULLIF(i9.index9,''),
	NULLIF(i10.index10,'')
	],'|') AS indexes
	FROM datensatz d
             LEFT JOIN index1 i1 ON d.id = i1.id
             LEFT JOIN index2 i2 ON d.id = i2.id
             LEFT JOIN index3 i3 ON d.id = i3.id
             LEFT JOIN index4 i4 ON d.id = i4.id
             LEFT JOIN index5 i5 ON d.id = i5.id
             LEFT JOIN index6 i6 ON d.id = i6.id
             LEFT JOIN index7 i7 ON d.id = i7.id
             LEFT JOIN index8 i8 ON d.id = i8.id
             LEFT JOIN index9 i9 ON d.id = i9.id
             LEFT JOIN index10 i10 ON d.id = i10.id ORDER BY d.id;
			 
DROP VIEW IF EXISTS index_all_v;

CREATE VIEW index_all_v

AS

SELECT d.id, d.behandler_nr, d.patienten_nr, 
	array_to_string(array[
	NULLIF(i1.index1,''),
	NULLIF(i2.index2,''),
	NULLIF(i3.index3,''),
	NULLIF(i4.index4,''),
	NULLIF(i5.index5,''),
	NULLIF(i6.index6,''),
	NULLIF(i7.index7,''),
	NULLIF(i8.index8,''),
	NULLIF(i9.index9,''),
	NULLIF(i10.index10,'')
	],'|') AS indexes_v
	FROM datensatz d
             LEFT JOIN index1_v i1 ON d.id = i1.id
             LEFT JOIN index2_v i2 ON d.id = i2.id
             LEFT JOIN index3_v i3 ON d.id = i3.id
             LEFT JOIN index4_v i4 ON d.id = i4.id
             LEFT JOIN index5_v i5 ON d.id = i5.id
             LEFT JOIN index6_v i6 ON d.id = i6.id
             LEFT JOIN index7_v i7 ON d.id = i7.id
             LEFT JOIN index8_v i8 ON d.id = i8.id
             LEFT JOIN index9_v i9 ON d.id = i9.id
             LEFT JOIN index10_v i10 ON d.id = i10.id ORDER BY d.id;
